/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dimension;

import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

final class CoalescingXMLFilter
implements XMLFilter,
ContentHandler,
LexicalHandler {
    private static final String URI_LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    private XMLReader parent;
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;
    private char[] buffer = new char[1024];
    private int bufferSize;

    CoalescingXMLFilter(XMLReader parent) {
        this.parent = parent;
    }

    @Override
    public void setParent(XMLReader parent) {
        this.parent = parent;
    }

    @Override
    public XMLReader getParent() {
        return this.parent;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.parent.setEntityResolver(resolver);
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.parent.getEntityResolver();
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.parent.setDTDHandler(handler);
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.parent.getDTDHandler();
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.parent.setErrorHandler(handler);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.parent.getErrorHandler();
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (URI_LEXICAL_HANDLER.equals(name)) {
            return this.lexicalHandler;
        }
        return this.parent.getProperty(name);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (URI_LEXICAL_HANDLER.equals(name)) {
            this.lexicalHandler = (LexicalHandler)value;
        } else {
            this.parent.setProperty(name, value);
        }
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.parent.getFeature(name);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.parent.setFeature(name, value);
    }

    private void setup() throws SAXException {
        this.parent.setContentHandler(this);
        this.parent.setProperty(URI_LEXICAL_HANDLER, this);
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        this.setup();
        this.parent.parse(input);
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.setup();
        this.parent.parse(systemId);
    }

    private void flushBuffer() throws SAXException {
        if (this.bufferSize > 0) {
            this.contentHandler.characters(this.buffer, 0, this.bufferSize);
        }
        this.bufferSize = 0;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.contentHandler.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.flushBuffer();
        this.contentHandler.endDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.flushBuffer();
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.flushBuffer();
        this.contentHandler.endPrefixMapping(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.flushBuffer();
        this.contentHandler.startElement(uri, localName, qName, atts);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.flushBuffer();
        this.contentHandler.endElement(uri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        int bufferCapacity;
        for (bufferCapacity = this.buffer.length; this.bufferSize + length > bufferCapacity; bufferCapacity *= 2) {
        }
        if (bufferCapacity != this.buffer.length) {
            char[] newBuffer = new char[bufferCapacity];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.bufferSize);
            this.buffer = newBuffer;
        }
        System.arraycopy(ch, start, this.buffer, this.bufferSize, length);
        this.bufferSize += length;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.flushBuffer();
        this.contentHandler.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.flushBuffer();
        this.contentHandler.processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.flushBuffer();
        this.contentHandler.skippedEntity(name);
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.flushBuffer();
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endDTD();
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.flushBuffer();
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(name);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        this.flushBuffer();
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(name);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        this.flushBuffer();
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        this.flushBuffer();
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.flushBuffer();
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(ch, start, length);
        }
    }
}

