/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dimension;

import java.util.ArrayList;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMMetaFactorySPI;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.testing.multiton.Instances;
import org.apache.axiom.testing.multiton.Multiton;
import org.apache.axiom.testutils.stax.XMLStreamReaderComparator;
import org.apache.axiom.testutils.suite.Dimension;
import org.apache.axiom.testutils.suite.MatrixTestCase;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.dimension.DOMBuilderFactory;
import org.apache.axiom.ts.dimension.SAXBuilderFactory;
import org.apache.axiom.ts.jaxp.dom.DOMImplementation;
import org.apache.axiom.ts.jaxp.sax.SAXImplementation;
import org.xml.sax.InputSource;

public abstract class BuilderFactory
extends Multiton
implements Dimension {
    public static final BuilderFactory PARSER = new BuilderFactory(){

        @Override
        public boolean isDeferredParsing() {
            return true;
        }

        @Override
        public void configureXMLStreamReaderComparator(XMLStreamReaderComparator comparator) {
        }

        public void addTestParameters(MatrixTestCase testCase) {
            testCase.addTestParameter("source", "parser");
        }

        @Override
        public OMXMLParserWrapper getBuilder(OMMetaFactory metaFactory, InputSource inputSource) throws Exception {
            return ((OMMetaFactorySPI)metaFactory).createOMBuilder(AxiomTestCase.TEST_PARSER_CONFIGURATION, inputSource);
        }
    };

    BuilderFactory() {
    }

    @Instances
    private static BuilderFactory[] instances() {
        ArrayList<BuilderFactory> instances = new ArrayList<BuilderFactory>();
        for (DOMImplementation implementation : BuilderFactory.getInstances(DOMImplementation.class)) {
            instances.add(new DOMBuilderFactory(implementation));
        }
        for (DOMImplementation implementation : BuilderFactory.getInstances(SAXImplementation.class)) {
            instances.add(new SAXBuilderFactory((SAXImplementation)implementation));
        }
        return instances.toArray(new BuilderFactory[instances.size()]);
    }

    public abstract boolean isDeferredParsing();

    public abstract void configureXMLStreamReaderComparator(XMLStreamReaderComparator var1);

    public abstract OMXMLParserWrapper getBuilder(OMMetaFactory var1, InputSource var2) throws Exception;
}

