/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaAnnotation;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaAnyAttribute;
import org.apache.ws.commons.schema.XmlSchemaAppInfo;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttributeGroup;
import org.apache.ws.commons.schema.XmlSchemaAttributeGroupRef;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaDocumentation;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaEnumerationFacet;
import org.apache.ws.commons.schema.XmlSchemaException;
import org.apache.ws.commons.schema.XmlSchemaFacet;
import org.apache.ws.commons.schema.XmlSchemaFractionDigitsFacet;
import org.apache.ws.commons.schema.XmlSchemaGroup;
import org.apache.ws.commons.schema.XmlSchemaGroupRef;
import org.apache.ws.commons.schema.XmlSchemaIdentityConstraint;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaKey;
import org.apache.ws.commons.schema.XmlSchemaKeyref;
import org.apache.ws.commons.schema.XmlSchemaLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaMaxExclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMaxInclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMaxLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaMinExclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMinInclusiveFacet;
import org.apache.ws.commons.schema.XmlSchemaMinLengthFacet;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaPatternFacet;
import org.apache.ws.commons.schema.XmlSchemaRedefine;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentExtension;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeUnion;
import org.apache.ws.commons.schema.XmlSchemaTotalDigitsFacet;
import org.apache.ws.commons.schema.XmlSchemaUnique;
import org.apache.ws.commons.schema.XmlSchemaWhiteSpaceFacet;
import org.apache.ws.commons.schema.XmlSchemaXPath;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlSchemaSerializer {
    private Hashtable schema_ns;
    static String xsdPrefix = "xs";
    public static final String xsdNamespace = "http://www.w3.org/2001/XMLSchema";
    ArrayList docs = new ArrayList();
    Element schemaElement;
    private static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";

    private XmlSchemaSerializer() {
        this.schema_ns = new Hashtable();
    }

    public static Document[] serializeSchema(XmlSchema schemaObj, boolean serializeIncluded) throws XmlSchemaSerializerException {
        return new XmlSchemaSerializer().serializeSchemaElement(schemaObj, serializeIncluded);
    }

    Document[] serializeSchemaElement(XmlSchema schemaObj, boolean serializeIncluded) throws XmlSchemaSerializerException {
        String finalDefault;
        String blockDefault;
        String formQualified;
        Element serializedSchema;
        Document serializedSchemaDocs;
        XmlSchemaObjectCollection items = schemaObj.getItems();
        try {
            DocumentBuilderFactory docFac = DocumentBuilderFactory.newInstance();
            docFac.setNamespaceAware(true);
            DocumentBuilder builder = docFac.newDocumentBuilder();
            serializedSchemaDocs = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new XmlSchemaException(e.getMessage());
        }
        this.schemaElement = serializedSchema = this.setupNamespaces(serializedSchemaDocs, schemaObj);
        if (schemaObj.syntacticalTargetNamespace != null) {
            serializedSchema.setAttribute("targetNamespace", schemaObj.syntacticalTargetNamespace);
            Object targetNS = this.schema_ns.get(schemaObj.syntacticalTargetNamespace);
            if (targetNS == null) {
                serializedSchema.setAttributeNS(XMLNS_NAMESPACE_URI, "xmlns", schemaObj.syntacticalTargetNamespace);
                String prefix = null;
                if (schemaObj.getNamespaceContext() != null) {
                    prefix = schemaObj.getNamespaceContext().getPrefix(schemaObj.syntacticalTargetNamespace);
                }
                if (prefix == null && schemaObj.parent != null && schemaObj.parent.getNamespaceContext() != null) {
                    prefix = schemaObj.parent.getNamespaceContext().getPrefix(schemaObj.syntacticalTargetNamespace);
                }
                if (prefix == null) {
                    prefix = "";
                }
                this.schema_ns.put(schemaObj.syntacticalTargetNamespace, prefix);
            }
        }
        if (schemaObj.attributeFormDefault != null && !(formQualified = schemaObj.attributeFormDefault.getValue()).equals("none")) {
            serializedSchema.setAttribute("attributeFormDefault", this.convertString(formQualified));
        }
        if (schemaObj.elementFormDefault != null && !(formQualified = schemaObj.elementFormDefault.getValue()).equals("none")) {
            serializedSchema.setAttribute("elementFormDefault", this.convertString(formQualified));
        }
        if (schemaObj.annotation != null) {
            Element annotation = this.serializeAnnotation(serializedSchemaDocs, schemaObj.annotation, schemaObj);
            serializedSchema.appendChild(annotation);
        }
        if (schemaObj.id != null) {
            serializedSchema.setAttribute("id", schemaObj.id);
        }
        if (schemaObj.blockDefault != null && !(blockDefault = schemaObj.blockDefault.getValue()).equals("none")) {
            blockDefault = this.convertString(blockDefault);
            serializedSchema.setAttribute("blockDefault", blockDefault);
        }
        if (schemaObj.finalDefault != null && !(finalDefault = schemaObj.finalDefault.getValue()).equals("none")) {
            finalDefault = this.convertString(finalDefault);
            serializedSchema.setAttribute("finalDefault", finalDefault);
        }
        if (schemaObj.version != null) {
            serializedSchema.setAttribute("version", schemaObj.version);
        }
        NamespacePrefixList ctx = schemaObj.getNamespaceContext();
        String[] prefixes = ctx.getDeclaredPrefixes();
        for (int i = 0; i < prefixes.length; ++i) {
            String prefix = prefixes[i];
            String uri = ctx.getNamespaceURI(prefix);
            if ("".equals(prefix)) continue;
            serializedSchema.setAttributeNS(XMLNS_NAMESPACE_URI, "xmlns:" + prefix, uri);
        }
        this.serializeSchemaChild(items, serializedSchema, serializedSchemaDocs, schemaObj, serializeIncluded);
        serializedSchemaDocs.appendChild(serializedSchema);
        this.docs.add(serializedSchemaDocs);
        Document[] serializedDocs = new Document[this.docs.size()];
        this.docs.toArray(serializedDocs);
        return serializedDocs;
    }

    private void serializeSchemaChild(XmlSchemaObjectCollection items, Element serializedSchema, Document serializedSchemaDocs, XmlSchema schemaObj, boolean serializeIncluded) throws XmlSchemaSerializerException {
        Element e;
        XmlSchemaObject obj;
        int i;
        int itemsLength = items.getCount();
        for (i = 0; i < itemsLength; ++i) {
            obj = items.getItem(i);
            if (obj instanceof XmlSchemaInclude) {
                e = this.serializeInclude(serializedSchemaDocs, (XmlSchemaInclude)obj, schemaObj, serializeIncluded);
                serializedSchema.appendChild(e);
                continue;
            }
            if (!(obj instanceof XmlSchemaImport)) continue;
            e = this.serializeImport(serializedSchemaDocs, (XmlSchemaImport)obj, schemaObj, serializeIncluded);
            serializedSchema.appendChild(e);
        }
        for (i = 0; i < itemsLength; ++i) {
            obj = items.getItem(i);
            if (obj instanceof XmlSchemaElement) {
                e = this.serializeElement(serializedSchemaDocs, (XmlSchemaElement)obj, schemaObj);
                serializedSchema.appendChild(e);
                continue;
            }
            if (obj instanceof XmlSchemaSimpleType) {
                e = this.serializeSimpleType(serializedSchemaDocs, (XmlSchemaSimpleType)obj, schemaObj);
                serializedSchema.appendChild(e);
                continue;
            }
            if (obj instanceof XmlSchemaComplexType) {
                e = this.serializeComplexType(serializedSchemaDocs, (XmlSchemaComplexType)obj, schemaObj);
                serializedSchema.appendChild(e);
                continue;
            }
            if (obj instanceof XmlSchemaGroup) {
                e = this.serializeGroup(serializedSchemaDocs, (XmlSchemaGroup)obj, schemaObj);
                serializedSchema.appendChild(e);
                continue;
            }
            if (obj instanceof XmlSchemaAttributeGroup) {
                e = this.serializeAttributeGroup(serializedSchemaDocs, (XmlSchemaAttributeGroup)obj, schemaObj);
                serializedSchema.appendChild(e);
                continue;
            }
            if (obj instanceof XmlSchemaAttribute) {
                e = this.serializeAttribute(serializedSchemaDocs, (XmlSchemaAttribute)obj, schemaObj);
                serializedSchema.appendChild(e);
                continue;
            }
            if (!(obj instanceof XmlSchemaRedefine)) continue;
            e = this.serializeRedefine(serializedSchemaDocs, (XmlSchemaRedefine)obj, schemaObj);
            serializedSchema.appendChild(e);
        }
    }

    private Element setupNamespaces(Document schemaDocs, XmlSchema schemaObj) {
        NamespacePrefixList ctx = schemaObj.getNamespaceContext();
        schemaObj.schema_ns_prefix = xsdPrefix = ctx.getPrefix(xsdNamespace);
        if (xsdPrefix == null) {
            xsdPrefix = "";
            schemaObj.schema_ns_prefix = "";
        }
        String[] prefixes = ctx.getDeclaredPrefixes();
        for (int i = 0; i < prefixes.length; ++i) {
            String prefix = prefixes[i];
            String uri = ctx.getNamespaceURI(prefix);
            this.schema_ns.put(uri, prefix);
        }
        if (this.schema_ns.get(xsdNamespace) == null) {
            this.schema_ns.put(xsdNamespace, xsdPrefix);
            schemaObj.schema_ns_prefix = xsdPrefix;
        }
        Element schemaEl = this.createNewElement(schemaDocs, "schema", schemaObj.schema_ns_prefix, xsdNamespace);
        Iterator entries = this.schema_ns.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            value = value.length() > 0 ? "xmlns:" + value : "xmlns";
            schemaEl.setAttributeNS(XMLNS_NAMESPACE_URI, value, key);
        }
        return schemaEl;
    }

    Element serializeInclude(Document doc, XmlSchemaInclude includeObj, XmlSchema schema, boolean serializeIncluded) throws XmlSchemaSerializerException {
        XmlSchema includedSchemaObj;
        Element includeEl = this.createNewElement(doc, "include", schema.schema_ns_prefix, xsdNamespace);
        if (includeObj.schemaLocation != null) {
            includeEl.setAttribute("schemaLocation", includeObj.schemaLocation);
        }
        if (includeObj.id != null) {
            includeEl.setAttribute("id", includeObj.id);
        }
        if (includeObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, includeObj.annotation, schema);
            includeEl.appendChild(annotation);
        }
        if ((includedSchemaObj = includeObj.getSchema()) != null && serializeIncluded) {
            XmlSchemaSerializer includeSeri = new XmlSchemaSerializer();
            includeSeri.serializeSchemaElement(includedSchemaObj, true);
            this.docs.addAll(includeSeri.docs);
        }
        return includeEl;
    }

    Element serializeImport(Document doc, XmlSchemaImport importObj, XmlSchema schema, boolean serializeIncluded) throws XmlSchemaSerializerException {
        Element importEl = this.createNewElement(doc, "import", schema.schema_ns_prefix, xsdNamespace);
        if (importObj.namespace != null) {
            importEl.setAttribute("namespace", importObj.namespace);
        }
        if (importObj.schemaLocation != null && !importObj.schemaLocation.trim().equals("")) {
            importEl.setAttribute("schemaLocation", importObj.schemaLocation);
        }
        if (importObj.id != null) {
            importEl.setAttribute("id", importObj.id);
        }
        if (importObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, importObj.annotation, schema);
            importEl.appendChild(annotation);
        }
        if (importObj.schema != null && serializeIncluded) {
            XmlSchemaSerializer importSeri = new XmlSchemaSerializer();
            importSeri.serializeSchemaElement(importObj.schema, serializeIncluded);
            this.docs.addAll(importSeri.docs);
        }
        return importEl;
    }

    Element serializeRedefine(Document doc, XmlSchemaRedefine redefineObj, XmlSchema schema) throws XmlSchemaSerializerException {
        Element redefine = this.createNewElement(doc, "redefine", schema.schema_ns_prefix, xsdNamespace);
        if (redefineObj.schemaLocation == null) {
            throw new XmlSchemaSerializerException("redefine must have schemaLocation fields fill");
        }
        redefine.setAttribute("schemaLocation", redefineObj.schemaLocation);
        if (redefineObj.id != null) {
            redefine.setAttribute("id", redefineObj.id);
        }
        if (redefineObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, redefineObj.annotation, schema);
            redefine.appendChild(annotation);
        }
        int itemsLength = redefineObj.items.getCount();
        for (int i = 0; i < itemsLength; ++i) {
            XmlSchemaObject obj = redefineObj.items.getItem(i);
            if (obj instanceof XmlSchemaSimpleType) {
                Element simpleType = this.serializeSimpleType(doc, (XmlSchemaSimpleType)obj, schema);
                redefine.appendChild(simpleType);
                continue;
            }
            if (obj instanceof XmlSchemaComplexType) {
                Element complexType = this.serializeComplexType(doc, (XmlSchemaComplexType)obj, schema);
                redefine.appendChild(complexType);
                continue;
            }
            if (obj instanceof XmlSchemaGroupRef) {
                Element groupRef = this.serializeGroupRef(doc, (XmlSchemaGroupRef)obj, schema);
                redefine.appendChild(groupRef);
                continue;
            }
            if (obj instanceof XmlSchemaGroup) {
                Element group = this.serializeGroup(doc, (XmlSchemaGroup)obj, schema);
                redefine.appendChild(group);
                continue;
            }
            if (obj instanceof XmlSchemaAttributeGroup) {
                Element attributeGroup = this.serializeAttributeGroup(doc, (XmlSchemaAttributeGroup)obj, schema);
                redefine.appendChild(attributeGroup);
                continue;
            }
            if (!(obj instanceof XmlSchemaAttributeGroupRef)) continue;
            Element attributeGroupRef = this.serializeAttributeGroupRef(doc, (XmlSchemaAttributeGroupRef)obj, schema);
            redefine.appendChild(attributeGroupRef);
        }
        return redefine;
    }

    Element serializeElement(Document doc, XmlSchemaElement elementObj, XmlSchema schema) throws XmlSchemaSerializerException {
        String formDef;
        String finalDerivation;
        String block;
        Element serializedEl = this.createNewElement(doc, "element", schema.schema_ns_prefix, xsdNamespace);
        if (elementObj.refName != null) {
            String resolvedName = this.resolveQName(elementObj.refName, schema);
            serializedEl.setAttribute("ref", resolvedName);
        } else if (elementObj.name != null && elementObj.name.length() > 0) {
            serializedEl.setAttribute("name", elementObj.name);
        }
        if (elementObj.isAbstract) {
            serializedEl.setAttribute("abstract", "true");
        }
        if (!(block = elementObj.block.getValue()).equals("none")) {
            block = this.convertString(block);
            serializedEl.setAttribute("block", block);
        }
        if (elementObj.defaultValue != null) {
            serializedEl.setAttribute("default", elementObj.defaultValue);
        }
        if (!(finalDerivation = elementObj.finalDerivation.getValue()).equals("none")) {
            finalDerivation = this.convertString(finalDerivation);
            serializedEl.setAttribute("final", finalDerivation);
        }
        if (elementObj.fixedValue != null) {
            serializedEl.setAttribute("fixed", elementObj.fixedValue);
        }
        if (!(formDef = elementObj.form.getValue()).equals("none")) {
            formDef = this.convertString(formDef);
            serializedEl.setAttribute("form", formDef);
        }
        if (elementObj.id != null) {
            serializedEl.setAttribute("id", elementObj.id);
        }
        if (elementObj.maxOccurs < Long.MAX_VALUE && elementObj.maxOccurs > 1L) {
            serializedEl.setAttribute("maxOccurs", elementObj.maxOccurs + "");
        } else if (elementObj.maxOccurs == Long.MAX_VALUE) {
            serializedEl.setAttribute("maxOccurs", "unbounded");
        }
        if (elementObj.minOccurs < Long.MAX_VALUE && elementObj.minOccurs != 1L) {
            serializedEl.setAttribute("minOccurs", elementObj.minOccurs + "");
        } else if (elementObj.minOccurs == Long.MAX_VALUE) {
            serializedEl.setAttribute("minOccurs", "unbounded");
        }
        if (elementObj.substitutionGroup != null) {
            String resolvedQName = this.resolveQName(elementObj.substitutionGroup, schema);
            serializedEl.setAttribute("substitutionGroup", resolvedQName);
        }
        if (elementObj.schemaTypeName != null) {
            String resolvedName = this.resolveQName(elementObj.schemaTypeName, schema);
            serializedEl.setAttribute("type", resolvedName);
        }
        if (elementObj.annotation != null) {
            Element annotationEl = this.serializeAnnotation(doc, elementObj.annotation, schema);
            serializedEl.appendChild(annotationEl);
        }
        if (elementObj.schemaType != null && elementObj.schemaTypeName == null) {
            if (elementObj.schemaType instanceof XmlSchemaComplexType) {
                Element complexType = this.serializeComplexType(doc, (XmlSchemaComplexType)elementObj.schemaType, schema);
                serializedEl.appendChild(complexType);
            } else if (elementObj.schemaType instanceof XmlSchemaSimpleType) {
                Element simpleType = this.serializeSimpleType(doc, (XmlSchemaSimpleType)elementObj.schemaType, schema);
                serializedEl.appendChild(simpleType);
            }
        }
        if (elementObj.constraints.getCount() > 0) {
            for (int i = 0; i < elementObj.constraints.getCount(); ++i) {
                Element constraint = this.serializeIdentityConstraint(doc, (XmlSchemaIdentityConstraint)elementObj.constraints.getItem(i), schema);
                serializedEl.appendChild(constraint);
            }
        }
        if (elementObj.isNillable) {
            serializedEl.setAttribute("nillable", "true");
        }
        return serializedEl;
    }

    Element serializeSimpleType(Document doc, XmlSchemaSimpleType simpleTypeObj, XmlSchema schema) throws XmlSchemaSerializerException {
        Element serializedSimpleType = this.createNewElement(doc, "simpleType", schema.schema_ns_prefix, xsdNamespace);
        String tmp = simpleTypeObj.finalDerivation.getValue();
        if (!tmp.equals("none")) {
            tmp = this.convertString(tmp);
            serializedSimpleType.setAttribute("final", tmp);
        }
        if (simpleTypeObj.id != null) {
            serializedSimpleType.setAttribute("id", simpleTypeObj.id);
        }
        if (simpleTypeObj.name != null && !simpleTypeObj.name.equals("")) {
            serializedSimpleType.setAttribute("name", simpleTypeObj.name);
        }
        if (simpleTypeObj.annotation != null) {
            Element annotationEl = this.serializeAnnotation(doc, simpleTypeObj.annotation, schema);
            serializedSimpleType.appendChild(annotationEl);
        }
        if (simpleTypeObj.content != null) {
            if (simpleTypeObj.content instanceof XmlSchemaSimpleTypeRestriction) {
                Element restEl = this.serializeSimpleTypeRestriction(doc, (XmlSchemaSimpleTypeRestriction)simpleTypeObj.content, schema);
                serializedSimpleType.appendChild(restEl);
            } else if (simpleTypeObj.content instanceof XmlSchemaSimpleTypeList) {
                Element listEl = this.serializeSimpleTypeList(doc, (XmlSchemaSimpleTypeList)simpleTypeObj.content, schema);
                serializedSimpleType.appendChild(listEl);
            } else if (simpleTypeObj.content instanceof XmlSchemaSimpleTypeUnion) {
                Element unionEl = this.serializeSimpleTypeUnion(doc, (XmlSchemaSimpleTypeUnion)simpleTypeObj.content, schema);
                serializedSimpleType.appendChild(unionEl);
            }
        }
        return serializedSimpleType;
    }

    Element serializeSimpleTypeRestriction(Document doc, XmlSchemaSimpleTypeRestriction restrictionObj, XmlSchema schema) throws XmlSchemaSerializerException {
        Element serializedRestriction = this.createNewElement(doc, "restriction", schema.schema_ns_prefix, xsdNamespace);
        if (schema.schema_ns_prefix.length() > 0) {
            serializedRestriction.setPrefix(schema.schema_ns_prefix);
        }
        if (restrictionObj.baseTypeName != null) {
            String baseType = this.resolveQName(restrictionObj.baseTypeName, schema);
            serializedRestriction.setAttribute("base", baseType);
        } else if (restrictionObj.baseType != null && restrictionObj.baseType instanceof XmlSchemaSimpleType) {
            Element inlineSimpleType = this.serializeSimpleType(doc, restrictionObj.baseType, schema);
            serializedRestriction.appendChild(inlineSimpleType);
        } else {
            throw new XmlSchemaSerializerException("restriction must be define with specifying base or inline simpleType");
        }
        if (restrictionObj.id != null) {
            serializedRestriction.setAttribute("id", restrictionObj.id);
        }
        if (restrictionObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, restrictionObj.annotation, schema);
            serializedRestriction.appendChild(annotation);
        }
        if (restrictionObj.facets.getCount() > 0) {
            int facetsNum = restrictionObj.facets.getCount();
            for (int i = 0; i < facetsNum; ++i) {
                Element facetEl = this.serializeFacet(doc, (XmlSchemaFacet)restrictionObj.facets.getItem(i), schema);
                serializedRestriction.appendChild(facetEl);
            }
        }
        return serializedRestriction;
    }

    /*
     * WARNING - void declaration
     */
    Element serializeFacet(Document doc, XmlSchemaFacet facetObj, XmlSchema schema) throws XmlSchemaSerializerException {
        void var4_4;
        Element serializedFacet;
        if (facetObj instanceof XmlSchemaMinExclusiveFacet) {
            serializedFacet = this.constructFacet(facetObj, doc, schema, "minExclusive");
        } else if (facetObj instanceof XmlSchemaMinInclusiveFacet) {
            serializedFacet = this.constructFacet(facetObj, doc, schema, "minInclusive");
        } else if (facetObj instanceof XmlSchemaMaxExclusiveFacet) {
            serializedFacet = this.constructFacet(facetObj, doc, schema, "maxExclusive");
        } else if (facetObj instanceof XmlSchemaMaxInclusiveFacet) {
            serializedFacet = this.constructFacet(facetObj, doc, schema, "maxInclusive");
        } else if (facetObj instanceof XmlSchemaTotalDigitsFacet) {
            serializedFacet = this.constructFacet(facetObj, doc, schema, "totalDigits");
        } else if (facetObj instanceof XmlSchemaFractionDigitsFacet) {
            serializedFacet = this.constructFacet(facetObj, doc, schema, "fractionDigits");
        } else if (facetObj instanceof XmlSchemaLengthFacet) {
            serializedFacet = this.constructFacet(facetObj, doc, schema, "length");
        } else if (facetObj instanceof XmlSchemaMinLengthFacet) {
            serializedFacet = this.constructFacet(facetObj, doc, schema, "minLength");
        } else if (facetObj instanceof XmlSchemaMaxLengthFacet) {
            serializedFacet = this.constructFacet(facetObj, doc, schema, "maxLength");
        } else if (facetObj instanceof XmlSchemaEnumerationFacet) {
            serializedFacet = this.constructFacet(facetObj, doc, schema, "enumeration");
        } else if (facetObj instanceof XmlSchemaWhiteSpaceFacet) {
            serializedFacet = this.constructFacet(facetObj, doc, schema, "whiteSpace");
        } else if (facetObj instanceof XmlSchemaPatternFacet) {
            serializedFacet = this.constructFacet(facetObj, doc, schema, "pattern");
        } else {
            throw new XmlSchemaSerializerException("facet not exist " + facetObj.getClass().getName());
        }
        if (facetObj.id != null) {
            var4_4.setAttribute("id", facetObj.id);
        }
        return var4_4;
    }

    private Element constructFacet(XmlSchemaFacet facetObj, Document doc, XmlSchema schema, String tagName) {
        Element facetEl = this.createNewElement(doc, tagName, schema.schema_ns_prefix, xsdNamespace);
        facetEl.setAttribute("value", facetObj.value.toString());
        if (facetObj.fixed) {
            facetEl.setAttribute("fixed", "true");
        }
        if (facetObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, facetObj.annotation, schema);
            facetEl.appendChild(annotation);
        }
        return facetEl;
    }

    Element serializeComplexType(Document doc, XmlSchemaComplexType complexTypeObj, XmlSchema schema) throws XmlSchemaSerializerException {
        XmlSchemaObjectCollection attrColl;
        String finalDerivation;
        Element serializedComplexType = this.createNewElement(doc, "complexType", schema.schema_ns_prefix, xsdNamespace);
        if (complexTypeObj.name != null && !complexTypeObj.name.equals("")) {
            serializedComplexType.setAttribute("name", complexTypeObj.name);
        }
        if (complexTypeObj.isMixed) {
            serializedComplexType.setAttribute("mixed", "true");
        }
        if (complexTypeObj.isAbstract) {
            serializedComplexType.setAttribute("abstract", "true");
        }
        if (complexTypeObj.id != null) {
            serializedComplexType.setAttribute("id", complexTypeObj.id);
        }
        if (complexTypeObj.contentModel instanceof XmlSchemaSimpleContent) {
            Element simpleContent = this.serializeSimpleContent(doc, (XmlSchemaSimpleContent)complexTypeObj.contentModel, schema);
            serializedComplexType.appendChild(simpleContent);
        } else if (complexTypeObj.contentModel instanceof XmlSchemaComplexContent) {
            Element complexContent = this.serializeComplexContent(doc, (XmlSchemaComplexContent)complexTypeObj.contentModel, schema);
            serializedComplexType.appendChild(complexContent);
        }
        if (complexTypeObj.particle instanceof XmlSchemaSequence) {
            Element sequence = this.serializeSequence(doc, (XmlSchemaSequence)complexTypeObj.particle, schema);
            serializedComplexType.appendChild(sequence);
        } else if (complexTypeObj.particle instanceof XmlSchemaChoice) {
            Element choice = this.serializeChoice(doc, (XmlSchemaChoice)complexTypeObj.particle, schema);
            serializedComplexType.appendChild(choice);
        } else if (complexTypeObj.particle instanceof XmlSchemaAll) {
            Element all = this.serializeAll(doc, (XmlSchemaAll)complexTypeObj.particle, schema);
            serializedComplexType.appendChild(all);
        } else if (complexTypeObj.particle instanceof XmlSchemaGroupRef) {
            Element group = this.serializeGroupRef(doc, (XmlSchemaGroupRef)complexTypeObj.particle, schema);
            serializedComplexType.appendChild(group);
        }
        String block = complexTypeObj.block.getValue();
        if (!block.equals("none")) {
            block = this.convertString(block);
            serializedComplexType.setAttribute("block", block);
        }
        if (!(finalDerivation = complexTypeObj.finalDerivation.getValue()).equals("none")) {
            finalDerivation = this.convertString(finalDerivation);
            serializedComplexType.setAttribute("final", finalDerivation);
        }
        if ((attrColl = complexTypeObj.attributes).getCount() > 0) {
            this.setupAttr(doc, attrColl, schema, serializedComplexType);
        }
        return serializedComplexType;
    }

    Element serializeSequence(Document doc, XmlSchemaSequence sequenceObj, XmlSchema schema) throws XmlSchemaSerializerException {
        Element sequence = this.createNewElement(doc, "sequence", schema.schema_ns_prefix, xsdNamespace);
        if (sequenceObj.id != null) {
            sequence.setAttribute("id", sequenceObj.id);
        }
        if (sequenceObj.maxOccurs < Long.MAX_VALUE && sequenceObj.maxOccurs > 1L) {
            sequence.setAttribute("maxOccurs", sequenceObj.maxOccurs + "");
        } else if (sequenceObj.maxOccurs == Long.MAX_VALUE) {
            sequence.setAttribute("maxOccurs", "unbounded");
        }
        if (sequenceObj.minOccurs > 1L) {
            sequence.setAttribute("minOccurs", sequenceObj.minOccurs + "");
        }
        XmlSchemaObjectCollection seqColl = sequenceObj.items;
        int containLength = seqColl.getCount();
        for (int i = 0; i < containLength; ++i) {
            XmlSchemaObject obj = seqColl.getItem(i);
            if (obj instanceof XmlSchemaElement) {
                Element el = this.serializeElement(doc, (XmlSchemaElement)obj, schema);
                sequence.appendChild(el);
                continue;
            }
            if (obj instanceof XmlSchemaGroupRef) {
                Element group = this.serializeGroupRef(doc, (XmlSchemaGroupRef)obj, schema);
                sequence.appendChild(group);
                continue;
            }
            if (obj instanceof XmlSchemaChoice) {
                Element choice = this.serializeChoice(doc, (XmlSchemaChoice)obj, schema);
                sequence.appendChild(choice);
                continue;
            }
            if (obj instanceof XmlSchemaSequence) {
                Element sequenceChild = this.serializeSequence(doc, (XmlSchemaSequence)obj, schema);
                sequence.appendChild(sequenceChild);
                continue;
            }
            if (!(obj instanceof XmlSchemaAny)) continue;
            Element any = this.serializeAny(doc, (XmlSchemaAny)obj, schema);
            sequence.appendChild(any);
        }
        return sequence;
    }

    Element serializeAttribute(Document doc, XmlSchemaAttribute attributeObj, XmlSchema schema) throws XmlSchemaSerializerException {
        String useType;
        String formType;
        Element attribute = this.createNewElement(doc, "attribute", schema.schema_ns_prefix, xsdNamespace);
        if (attributeObj.refName != null) {
            String refName = this.resolveQName(attributeObj.refName, schema);
            attribute.setAttribute("ref", refName);
        } else if (attributeObj.name != null) {
            attribute.setAttribute("name", attributeObj.name);
        }
        if (attributeObj.schemaTypeName != null) {
            String typeName = this.resolveQName(attributeObj.schemaTypeName, schema);
            attribute.setAttribute("type", typeName);
        }
        if (attributeObj.defaultValue != null) {
            attribute.setAttribute("default", attributeObj.defaultValue);
        }
        if (attributeObj.fixedValue != null) {
            attribute.setAttribute("fixed", attributeObj.fixedValue);
        }
        if (!(formType = attributeObj.form.getValue()).equals("none")) {
            formType = this.convertString(formType);
            attribute.setAttribute("form", formType);
        }
        if (attributeObj.id != null) {
            attribute.setAttribute("id", attributeObj.id);
        }
        if (!(useType = attributeObj.use.getValue()).equals("none")) {
            useType = this.convertString(useType);
            attribute.setAttribute("use", useType);
        }
        if (attributeObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, attributeObj.annotation, schema);
            attribute.appendChild(annotation);
        }
        if (attributeObj.schemaType != null) {
            try {
                XmlSchemaSimpleType simpleType = attributeObj.schemaType;
                Element simpleTypeEl = this.serializeSimpleType(doc, simpleType, schema);
                attribute.appendChild(simpleTypeEl);
            }
            catch (ClassCastException e) {
                throw new XmlSchemaSerializerException("only inline simple type allow as attribute's inline type");
            }
        }
        Attr[] unhandled = attributeObj.getUnhandledAttributes();
        Hashtable<String, String> namespaces = new Hashtable<String, String>();
        if (unhandled != null) {
            int i;
            for (i = 0; i < unhandled.length; ++i) {
                String name = unhandled[i].getNodeName();
                String value = unhandled[i].getNodeValue();
                if (name.equals("xmlns")) {
                    namespaces.put("", value);
                    continue;
                }
                if (!name.startsWith("xmlns")) continue;
                namespaces.put(name.substring(name.indexOf(":") + 1), value);
            }
            for (i = 0; i < unhandled.length; ++i) {
                String prefix;
                String oldNamespace;
                String value = unhandled[i].getNodeValue();
                String nodeName = unhandled[i].getNodeName();
                if (value.indexOf(":") > -1 && !nodeName.startsWith("xmlns") && (oldNamespace = (String)namespaces.get(prefix = value.substring(0, value.indexOf(":")))) != null) {
                    value = value.substring(value.indexOf(":") + 1);
                    NamespacePrefixList ctx = schema.getNamespaceContext();
                    String[] prefixes = ctx.getDeclaredPrefixes();
                    for (int j = 0; j < prefixes.length; ++j) {
                        String pref = prefixes[j];
                        String uri = ctx.getNamespaceURI(pref);
                        if (!uri.equals(oldNamespace)) continue;
                        value = prefix + ":" + value;
                    }
                }
                if (unhandled[i].getNamespaceURI() != null) {
                    attribute.setAttributeNS(unhandled[i].getNamespaceURI(), nodeName, value);
                    continue;
                }
                attribute.setAttribute(nodeName, value);
            }
        }
        return attribute;
    }

    Element serializeChoice(Document doc, XmlSchemaChoice choiceObj, XmlSchema schema) throws XmlSchemaSerializerException {
        XmlSchemaObjectCollection itemColl;
        Element choice = this.createNewElement(doc, "choice", schema.schema_ns_prefix, xsdNamespace);
        if (choiceObj.id != null && choiceObj.id.length() > 0) {
            choice.setAttribute("id", choiceObj.id);
        }
        if (choiceObj.maxOccurs < Long.MAX_VALUE && choiceObj.maxOccurs != 1L) {
            choice.setAttribute("maxOccurs", choiceObj.maxOccurs + "");
        } else if (choiceObj.maxOccurs == Long.MAX_VALUE) {
            choice.setAttribute("maxOccurs", "unbounded");
        }
        if (choiceObj.minOccurs != 1L) {
            choice.setAttribute("minOccurs", choiceObj.minOccurs + "");
        }
        if (choiceObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, choiceObj.annotation, schema);
            choice.appendChild(annotation);
        }
        if ((itemColl = choiceObj.items) != null) {
            int itemLength = itemColl.getCount();
            for (int i = 0; i < itemLength; ++i) {
                XmlSchemaObject obj = itemColl.getItem(i);
                if (obj instanceof XmlSchemaElement) {
                    Element el = this.serializeElement(doc, (XmlSchemaElement)obj, schema);
                    choice.appendChild(el);
                    continue;
                }
                if (obj instanceof XmlSchemaGroupRef) {
                    Element group = this.serializeGroupRef(doc, (XmlSchemaGroupRef)obj, schema);
                    choice.appendChild(group);
                    continue;
                }
                if (obj instanceof XmlSchemaChoice) {
                    Element inlineChoice = this.serializeChoice(doc, (XmlSchemaChoice)obj, schema);
                    choice.appendChild(inlineChoice);
                    continue;
                }
                if (obj instanceof XmlSchemaSequence) {
                    Element inlineSequence = this.serializeSequence(doc, (XmlSchemaSequence)obj, schema);
                    choice.appendChild(inlineSequence);
                    continue;
                }
                if (!(obj instanceof XmlSchemaAny)) continue;
                Element any = this.serializeAny(doc, (XmlSchemaAny)obj, schema);
                choice.appendChild(any);
            }
        }
        return choice;
    }

    Element serializeAll(Document doc, XmlSchemaAll allObj, XmlSchema schema) throws XmlSchemaSerializerException {
        XmlSchemaObjectCollection itemColl;
        Element allEl = this.createNewElement(doc, "all", schema.schema_ns_prefix, xsdNamespace);
        if (allObj.minOccurs == 0L) {
            allEl.setAttribute("minOccurs", "0");
        }
        if (allObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, allObj.annotation, schema);
            allEl.appendChild(annotation);
        }
        if ((itemColl = allObj.items) != null) {
            int itemLength = itemColl.getCount();
            for (int i = 0; i < itemLength; ++i) {
                XmlSchemaObject obj = itemColl.getItem(i);
                if (!(obj instanceof XmlSchemaElement)) {
                    throw new XmlSchemaSerializerException("Only element allowed as child of all model type");
                }
                Element el = this.serializeElement(doc, (XmlSchemaElement)obj, schema);
                allEl.appendChild(el);
            }
        }
        return allEl;
    }

    Element serializeSimpleTypeList(Document doc, XmlSchemaSimpleTypeList listObj, XmlSchema schema) throws XmlSchemaSerializerException {
        Element list = this.createNewElement(doc, "list", schema.schema_ns_prefix, xsdNamespace);
        if (listObj.itemTypeName != null) {
            String listItemType = this.resolveQName(listObj.itemTypeName, schema);
            list.setAttribute("itemType", listItemType);
        }
        if (listObj.id != null) {
            list.setAttribute("id", listObj.id);
        } else if (listObj.itemType != null) {
            Element inlineSimpleEl = this.serializeSimpleType(doc, listObj.itemType, schema);
            list.appendChild(inlineSimpleEl);
        }
        if (listObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, listObj.annotation, schema);
            list.appendChild(annotation);
        }
        return list;
    }

    Element serializeSimpleTypeUnion(Document doc, XmlSchemaSimpleTypeUnion unionObj, XmlSchema schema) throws XmlSchemaSerializerException {
        Element union = this.createNewElement(doc, "union", schema.schema_ns_prefix, xsdNamespace);
        if (unionObj.id != null) {
            union.setAttribute("id", unionObj.id);
        }
        if (unionObj.memberTypesSource != null) {
            union.setAttribute("memberTypes", unionObj.memberTypesSource);
        }
        if (unionObj.baseTypes.getCount() > 0) {
            int baseTypesLength = unionObj.baseTypes.getCount();
            for (int i = 0; i < baseTypesLength; ++i) {
                try {
                    Element baseType = this.serializeSimpleType(doc, (XmlSchemaSimpleType)unionObj.baseTypes.getItem(i), schema);
                    union.appendChild(baseType);
                    continue;
                }
                catch (ClassCastException e) {
                    throw new XmlSchemaSerializerException("only inline simple type allow as attribute's inline type");
                }
            }
        }
        if (unionObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, unionObj.annotation, schema);
            union.appendChild(annotation);
        }
        return union;
    }

    Element serializeAny(Document doc, XmlSchemaAny anyObj, XmlSchema schema) {
        String value;
        Element anyEl = this.createNewElement(doc, "any", schema.schema_ns_prefix, xsdNamespace);
        if (anyObj.id != null && anyObj.id.length() > 0) {
            anyEl.setAttribute("id", anyObj.id);
        }
        if (anyObj.maxOccurs < Long.MAX_VALUE && anyObj.maxOccurs > 1L) {
            anyEl.setAttribute("maxOccurs", anyObj.maxOccurs + "");
        } else if (anyObj.maxOccurs == Long.MAX_VALUE) {
            anyEl.setAttribute("maxOccurs", "unbounded");
        }
        if (anyObj.minOccurs > 1L) {
            anyEl.setAttribute("minOccurs", anyObj.minOccurs + "");
        }
        if (anyObj.namespace != null) {
            anyEl.setAttribute("namespace", anyObj.namespace);
        }
        if (anyObj.processContent != null && !(value = anyObj.processContent.getValue()).equals("none")) {
            String processContent = this.convertString(value);
            anyEl.setAttribute("processContents", processContent);
        }
        if (anyObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, anyObj.annotation, schema);
            anyEl.appendChild(annotation);
        }
        return anyEl;
    }

    Element serializeGroup(Document doc, XmlSchemaGroup groupObj, XmlSchema schema) throws XmlSchemaSerializerException {
        Element group = this.createNewElement(doc, "group", schema.schema_ns_prefix, xsdNamespace);
        if (groupObj.name != null) {
            if (groupObj.name.length() > 0) {
                group.setAttribute("name", groupObj.name);
            }
        } else {
            throw new XmlSchemaSerializerException("Group must have name or ref");
        }
        if (groupObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, groupObj.annotation, schema);
            group.appendChild(annotation);
        }
        if (groupObj.particle instanceof XmlSchemaSequence) {
            Element sequence = this.serializeSequence(doc, (XmlSchemaSequence)groupObj.particle, schema);
            group.appendChild(sequence);
        } else if (groupObj.particle instanceof XmlSchemaChoice) {
            Element choice = this.serializeChoice(doc, (XmlSchemaChoice)groupObj.particle, schema);
            group.appendChild(choice);
        } else if (groupObj.particle instanceof XmlSchemaAll) {
            Element all = this.serializeAll(doc, (XmlSchemaAll)groupObj.particle, schema);
            group.appendChild(all);
        }
        return group;
    }

    Element serializeGroupRef(Document doc, XmlSchemaGroupRef groupRefObj, XmlSchema schema) throws XmlSchemaSerializerException {
        Element groupRef = this.createNewElement(doc, "group", schema.schema_ns_prefix, xsdNamespace);
        if (groupRefObj.refName == null) {
            throw new XmlSchemaSerializerException("Group must have name or ref");
        }
        String groupRefName = this.resolveQName(groupRefObj.refName, schema);
        groupRef.setAttribute("ref", groupRefName);
        if (groupRefObj.maxOccurs < Long.MAX_VALUE && groupRefObj.maxOccurs > 1L) {
            groupRef.setAttribute("maxOccurs", groupRefObj.maxOccurs + "");
        } else if (groupRefObj.maxOccurs == Long.MAX_VALUE) {
            groupRef.setAttribute("maxOccurs", "unbounded");
        }
        if (groupRefObj.minOccurs > 1L) {
            groupRef.setAttribute("minOccurs", groupRefObj.minOccurs + "");
        }
        if (groupRefObj.particle != null) {
            if (groupRefObj.particle instanceof XmlSchemaChoice) {
                this.serializeChoice(doc, (XmlSchemaChoice)groupRefObj.particle, schema);
            } else if (groupRefObj.particle instanceof XmlSchemaSequence) {
                this.serializeSequence(doc, (XmlSchemaSequence)groupRefObj.particle, schema);
            } else if (groupRefObj.particle instanceof XmlSchemaAll) {
                this.serializeAll(doc, (XmlSchemaAll)groupRefObj.particle, schema);
            } else {
                throw new XmlSchemaSerializerException("The content of group ref particle should be sequence, choice or all reference:  www.w3.org/TR/xmlschema-1#element-group-3.7.2");
            }
        }
        if (groupRefObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, groupRefObj.annotation, schema);
            groupRef.appendChild(annotation);
        }
        return groupRef;
    }

    /*
     * WARNING - void declaration
     */
    Element serializeSimpleContent(Document doc, XmlSchemaSimpleContent simpleContentObj, XmlSchema schema) throws XmlSchemaSerializerException {
        void var5_6;
        Element content;
        Element simpleContent = this.createNewElement(doc, "simpleContent", schema.schema_ns_prefix, xsdNamespace);
        if (simpleContentObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, simpleContentObj.annotation, schema);
            simpleContent.appendChild(annotation);
        }
        if (simpleContentObj.content instanceof XmlSchemaSimpleContentRestriction) {
            content = this.serializeSimpleContentRestriction(doc, (XmlSchemaSimpleContentRestriction)simpleContentObj.content, schema);
        } else if (simpleContentObj.content instanceof XmlSchemaSimpleContentExtension) {
            content = this.serializeSimpleContentExtension(doc, (XmlSchemaSimpleContentExtension)simpleContentObj.content, schema);
        } else {
            throw new XmlSchemaSerializerException("content of simple content must be restriction or extension");
        }
        simpleContent.appendChild((Node)var5_6);
        return simpleContent;
    }

    /*
     * WARNING - void declaration
     */
    Element serializeComplexContent(Document doc, XmlSchemaComplexContent complexContentObj, XmlSchema schema) throws XmlSchemaSerializerException {
        void var5_5;
        Element content;
        Element complexContent = this.createNewElement(doc, "complexContent", schema.schema_ns_prefix, xsdNamespace);
        if (complexContentObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, complexContentObj.annotation, schema);
            complexContent.appendChild(annotation);
        }
        if (complexContentObj.mixed) {
            complexContent.setAttribute("mixed", "true");
        }
        if (complexContentObj.id != null) {
            complexContent.setAttribute("id", complexContentObj.id);
        }
        if (complexContentObj.content instanceof XmlSchemaComplexContentRestriction) {
            content = this.serializeComplexContentRestriction(doc, (XmlSchemaComplexContentRestriction)complexContentObj.content, schema);
        } else if (complexContentObj.content instanceof XmlSchemaComplexContentExtension) {
            content = this.serializeComplexContentExtension(doc, (XmlSchemaComplexContentExtension)complexContentObj.content, schema);
        } else {
            throw new XmlSchemaSerializerException("content of complexContent must be restriction or extension");
        }
        complexContent.appendChild((Node)var5_5);
        return complexContent;
    }

    /*
     * WARNING - void declaration
     */
    Element serializeIdentityConstraint(Document doc, XmlSchemaIdentityConstraint constraintObj, XmlSchema schema) throws XmlSchemaSerializerException {
        XmlSchemaObjectCollection fieldColl;
        void var4_4;
        Element constraint;
        if (constraintObj instanceof XmlSchemaUnique) {
            constraint = this.createNewElement(doc, "unique", schema.schema_ns_prefix, xsdNamespace);
        } else if (constraintObj instanceof XmlSchemaKey) {
            constraint = this.createNewElement(doc, "key", schema.schema_ns_prefix, xsdNamespace);
        } else if (constraintObj instanceof XmlSchemaKeyref) {
            constraint = this.createNewElement(doc, "keyref", schema.schema_ns_prefix, xsdNamespace);
            XmlSchemaKeyref keyref = (XmlSchemaKeyref)constraintObj;
            if (keyref.refer != null) {
                String keyrefStr = this.resolveQName(keyref.refer, schema);
                constraint.setAttribute("refer", keyrefStr);
            }
        } else {
            throw new XmlSchemaSerializerException("not valid identity constraint");
        }
        if (constraintObj.name != null) {
            var4_4.setAttribute("name", constraintObj.name);
        }
        if (constraintObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, constraintObj.annotation, schema);
            var4_4.appendChild(annotation);
        }
        if (constraintObj.selector != null) {
            Element selector = this.serializeSelector(doc, constraintObj.selector, schema);
            var4_4.appendChild(selector);
        }
        if ((fieldColl = constraintObj.fields) != null) {
            int fieldLength = fieldColl.getCount();
            for (int i = 0; i < fieldLength; ++i) {
                Element field = this.serializeField(doc, (XmlSchemaXPath)fieldColl.getItem(i), schema);
                var4_4.appendChild(field);
            }
        }
        return var4_4;
    }

    Element serializeSelector(Document doc, XmlSchemaXPath selectorObj, XmlSchema schema) throws XmlSchemaSerializerException {
        Element selector = this.createNewElement(doc, "selector", schema.schema_ns_prefix, xsdNamespace);
        if (selectorObj.xpath == null) {
            throw new XmlSchemaSerializerException("xpath can't be null");
        }
        selector.setAttribute("xpath", selectorObj.xpath);
        if (selectorObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, selectorObj.annotation, schema);
            selector.appendChild(annotation);
        }
        return selector;
    }

    Element serializeField(Document doc, XmlSchemaXPath fieldObj, XmlSchema schema) throws XmlSchemaSerializerException {
        Element field = this.createNewElement(doc, "field", schema.schema_ns_prefix, xsdNamespace);
        if (fieldObj.xpath == null) {
            throw new XmlSchemaSerializerException("xpath can't be null");
        }
        field.setAttribute("xpath", fieldObj.xpath);
        if (fieldObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, fieldObj.annotation, schema);
            field.appendChild(annotation);
        }
        return field;
    }

    Element serializeAnnotation(Document doc, XmlSchemaAnnotation annotationObj, XmlSchema schema) {
        Element annotation = this.createNewElement(doc, "annotation", schema.schema_ns_prefix, xsdNamespace);
        XmlSchemaObjectCollection contents = annotationObj.items;
        int contentLength = contents.getCount();
        for (int i = 0; i < contentLength; ++i) {
            XmlSchemaObject obj = contents.getItem(i);
            if (obj instanceof XmlSchemaAppInfo) {
                XmlSchemaAppInfo appinfo = (XmlSchemaAppInfo)obj;
                Element appInfoEl = this.serializeAppInfo(doc, appinfo, schema);
                annotation.appendChild(appInfoEl);
                continue;
            }
            if (!(obj instanceof XmlSchemaDocumentation)) continue;
            XmlSchemaDocumentation documentation = (XmlSchemaDocumentation)obj;
            Element documentationEl = this.serializeDocumentation(doc, documentation, schema);
            annotation.appendChild(documentationEl);
        }
        return annotation;
    }

    Element serializeAppInfo(Document doc, XmlSchemaAppInfo appInfoObj, XmlSchema schema) {
        Element appInfoEl = this.createNewElement(doc, "appinfo", schema.schema_ns_prefix, xsdNamespace);
        if (appInfoObj.source != null) {
            appInfoEl.setAttribute("source", appInfoObj.source);
        }
        if (appInfoObj.markup != null) {
            int markupLength = appInfoObj.markup.getLength();
            block4: for (int j = 0; j < markupLength; ++j) {
                Node n = appInfoObj.markup.item(j);
                switch (n.getNodeType()) {
                    case 1: {
                        this.appendElement(doc, appInfoEl, n, schema);
                        continue block4;
                    }
                    case 3: {
                        Text t = doc.createTextNode(n.getNodeValue());
                        appInfoEl.appendChild(t);
                        continue block4;
                    }
                }
            }
        }
        return appInfoEl;
    }

    Element serializeDocumentation(Document doc, XmlSchemaDocumentation documentationObj, XmlSchema schema) {
        Element documentationEl = this.createNewElement(doc, "documentation", schema.schema_ns_prefix, xsdNamespace);
        if (documentationObj.source != null) {
            documentationEl.setAttribute("source", documentationObj.source);
        }
        if (documentationObj.language != null) {
            documentationEl.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", documentationObj.language);
        }
        if (documentationObj.markup != null) {
            int markupLength = documentationObj.markup.getLength();
            block4: for (int j = 0; j < markupLength; ++j) {
                Node n = documentationObj.markup.item(j);
                switch (n.getNodeType()) {
                    case 1: {
                        this.appendElement(doc, documentationEl, n, schema);
                        continue block4;
                    }
                    case 3: {
                        Text t = doc.createTextNode(n.getNodeValue());
                        documentationEl.appendChild(t);
                        continue block4;
                    }
                }
            }
        }
        return documentationEl;
    }

    Element serializeSimpleContentRestriction(Document doc, XmlSchemaSimpleContentRestriction restrictionObj, XmlSchema schema) throws XmlSchemaSerializerException {
        Element restriction = this.createNewElement(doc, "restriction", schema.schema_ns_prefix, xsdNamespace);
        if (restrictionObj.baseTypeName != null) {
            String baseTypeName = this.resolveQName(restrictionObj.baseTypeName, schema);
            restriction.setAttribute("base", baseTypeName);
        }
        if (restrictionObj.id != null) {
            restriction.setAttribute("id", restrictionObj.id);
        }
        if (restrictionObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, restrictionObj.annotation, schema);
            restriction.appendChild(annotation);
        }
        int attrCollLength = restrictionObj.attributes.getCount();
        for (int i = 0; i < attrCollLength; ++i) {
            XmlSchemaObject obj = restrictionObj.attributes.getItem(i);
            if (obj instanceof XmlSchemaAttribute) {
                Element attribute = this.serializeAttribute(doc, (XmlSchemaAttribute)obj, schema);
                restriction.appendChild(attribute);
                continue;
            }
            if (!(obj instanceof XmlSchemaAttributeGroupRef)) continue;
            Element attributeGroup = this.serializeAttributeGroupRef(doc, (XmlSchemaAttributeGroupRef)obj, schema);
            restriction.appendChild(attributeGroup);
        }
        if (restrictionObj.baseType != null) {
            Element inlineSimpleType = this.serializeSimpleType(doc, restrictionObj.baseType, schema);
            restriction.appendChild(inlineSimpleType);
        }
        if (restrictionObj.anyAttribute != null) {
            Element anyAttribute = this.serializeAnyAttribute(doc, restrictionObj.anyAttribute, schema);
            restriction.appendChild(anyAttribute);
        }
        XmlSchemaObjectCollection facets = restrictionObj.facets;
        int facetLength = facets.getCount();
        for (int i = 0; i < facetLength; ++i) {
            Element facet = this.serializeFacet(doc, (XmlSchemaFacet)facets.getItem(i), schema);
            restriction.appendChild(facet);
        }
        return restriction;
    }

    Element serializeSimpleContentExtension(Document doc, XmlSchemaSimpleContentExtension extensionObj, XmlSchema schema) throws XmlSchemaSerializerException {
        Element extension = this.createNewElement(doc, "extension", schema.schema_ns_prefix, xsdNamespace);
        if (extensionObj.baseTypeName != null) {
            String baseTypeName = this.resolveQName(extensionObj.baseTypeName, schema);
            extension.setAttribute("base", baseTypeName);
        }
        if (extensionObj.id != null) {
            extension.setAttribute("id", extensionObj.id);
        }
        if (extensionObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, extensionObj.annotation, schema);
            extension.appendChild(annotation);
        }
        XmlSchemaObjectCollection attributes = extensionObj.attributes;
        int attributeLength = attributes.getCount();
        for (int i = 0; i < attributeLength; ++i) {
            XmlSchemaObject obj = attributes.getItem(i);
            if (obj instanceof XmlSchemaAttribute) {
                Element attribute = this.serializeAttribute(doc, (XmlSchemaAttribute)obj, schema);
                extension.appendChild(attribute);
                continue;
            }
            if (!(obj instanceof XmlSchemaAttributeGroupRef)) continue;
            Element attributeGroupRef = this.serializeAttributeGroupRef(doc, (XmlSchemaAttributeGroupRef)obj, schema);
            extension.appendChild(attributeGroupRef);
        }
        if (extensionObj.anyAttribute != null) {
            Element anyAttribute = this.serializeAnyAttribute(doc, extensionObj.anyAttribute, schema);
            extension.appendChild(anyAttribute);
        }
        return extension;
    }

    Element serializeComplexContentRestriction(Document doc, XmlSchemaComplexContentRestriction restrictionObj, XmlSchema schema) throws XmlSchemaSerializerException {
        Element restriction = this.createNewElement(doc, "restriction", schema.schema_ns_prefix, xsdNamespace);
        if (restrictionObj.baseTypeName != null) {
            String baseTypeName = this.resolveQName(restrictionObj.baseTypeName, schema);
            restriction.setAttribute("base", baseTypeName);
        }
        if (restrictionObj.id != null) {
            restriction.setAttribute("id", restrictionObj.id);
        }
        if (restrictionObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, restrictionObj.annotation, schema);
            restriction.appendChild(annotation);
        }
        if (restrictionObj.particle instanceof XmlSchemaSequence) {
            Element sequenceParticle = this.serializeSequence(doc, (XmlSchemaSequence)restrictionObj.particle, schema);
            restriction.appendChild(sequenceParticle);
        } else if (restrictionObj.particle instanceof XmlSchemaChoice) {
            Element choiceParticle = this.serializeChoice(doc, (XmlSchemaChoice)restrictionObj.particle, schema);
            restriction.appendChild(choiceParticle);
        } else if (restrictionObj.particle instanceof XmlSchemaAll) {
            Element allParticle = this.serializeAll(doc, (XmlSchemaAll)restrictionObj.particle, schema);
            restriction.appendChild(allParticle);
        } else if (restrictionObj.particle instanceof XmlSchemaGroupRef) {
            Element groupRefParticle = this.serializeGroupRef(doc, (XmlSchemaGroupRef)restrictionObj.particle, schema);
            restriction.appendChild(groupRefParticle);
        }
        int attributesLength = restrictionObj.attributes.getCount();
        for (int i = 0; i < attributesLength; ++i) {
            XmlSchemaObject obj = restrictionObj.attributes.getItem(i);
            if (obj instanceof XmlSchemaAttribute) {
                Element attr = this.serializeAttribute(doc, (XmlSchemaAttribute)obj, schema);
                restriction.appendChild(attr);
                continue;
            }
            if (!(obj instanceof XmlSchemaAttributeGroupRef)) continue;
            Element attrGroup = this.serializeAttributeGroupRef(doc, (XmlSchemaAttributeGroupRef)obj, schema);
            restriction.appendChild(attrGroup);
        }
        if (restrictionObj.anyAttribute != null) {
            Element anyAttribute = this.serializeAnyAttribute(doc, restrictionObj.anyAttribute, schema);
            restriction.appendChild(anyAttribute);
        }
        return restriction;
    }

    Element serializeComplexContentExtension(Document doc, XmlSchemaComplexContentExtension extensionObj, XmlSchema schema) throws XmlSchemaSerializerException {
        Element extension = this.createNewElement(doc, "extension", schema.schema_ns_prefix, xsdNamespace);
        if (extensionObj.baseTypeName != null) {
            String baseType = this.resolveQName(extensionObj.baseTypeName, schema);
            extension.setAttribute("base", baseType);
        }
        if (extensionObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, extensionObj.annotation, schema);
            extension.appendChild(annotation);
        }
        if (extensionObj.particle instanceof XmlSchemaSequence) {
            Element sequenceParticle = this.serializeSequence(doc, (XmlSchemaSequence)extensionObj.particle, schema);
            extension.appendChild(sequenceParticle);
        } else if (extensionObj.particle instanceof XmlSchemaChoice) {
            Element choiceParticle = this.serializeChoice(doc, (XmlSchemaChoice)extensionObj.particle, schema);
            extension.appendChild(choiceParticle);
        } else if (extensionObj.particle instanceof XmlSchemaAll) {
            Element allParticle = this.serializeAll(doc, (XmlSchemaAll)extensionObj.particle, schema);
            extension.appendChild(allParticle);
        } else if (extensionObj.particle instanceof XmlSchemaGroupRef) {
            Element groupRefParticle = this.serializeGroupRef(doc, (XmlSchemaGroupRef)extensionObj.particle, schema);
            extension.appendChild(groupRefParticle);
        }
        int attributesLength = extensionObj.attributes.getCount();
        for (int i = 0; i < attributesLength; ++i) {
            XmlSchemaObject obj = extensionObj.attributes.getItem(i);
            if (obj instanceof XmlSchemaAttribute) {
                Element attr = this.serializeAttribute(doc, (XmlSchemaAttribute)obj, schema);
                extension.appendChild(attr);
                continue;
            }
            if (!(obj instanceof XmlSchemaAttributeGroupRef)) continue;
            Element attrGroup = this.serializeAttributeGroupRef(doc, (XmlSchemaAttributeGroupRef)obj, schema);
            extension.appendChild(attrGroup);
        }
        if (extensionObj.anyAttribute != null) {
            Element anyAttribute = this.serializeAnyAttribute(doc, extensionObj.anyAttribute, schema);
            extension.appendChild(anyAttribute);
        }
        return extension;
    }

    Element serializeAnyAttribute(Document doc, XmlSchemaAnyAttribute anyAttributeObj, XmlSchema schema) {
        Element anyAttribute = this.createNewElement(doc, "anyAttribute", schema.schema_ns_prefix, xsdNamespace);
        if (anyAttributeObj.namespace != null) {
            anyAttribute.setAttribute("namespace", anyAttributeObj.namespace);
        }
        if (anyAttributeObj.id != null) {
            anyAttribute.setAttribute("id", anyAttributeObj.id);
        }
        if (anyAttributeObj.processContent != null) {
            String processContent = anyAttributeObj.processContent.getValue();
            processContent = this.convertString(processContent);
            anyAttribute.setAttribute("processContents", processContent);
        }
        if (anyAttributeObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, anyAttributeObj.annotation, schema);
            anyAttribute.appendChild(annotation);
        }
        return anyAttribute;
    }

    Element serializeAttributeGroupRef(Document doc, XmlSchemaAttributeGroupRef attributeGroupObj, XmlSchema schema) throws XmlSchemaSerializerException {
        Element attributeGroupRef = this.createNewElement(doc, "attributeGroup", schema.schema_ns_prefix, xsdNamespace);
        if (attributeGroupObj.refName == null) {
            throw new XmlSchemaSerializerException("Attribute group must have ref name set");
        }
        String refName = this.resolveQName(attributeGroupObj.refName, schema);
        attributeGroupRef.setAttribute("ref", refName);
        if (attributeGroupObj.id != null) {
            attributeGroupRef.setAttribute("id", attributeGroupObj.id);
        }
        if (attributeGroupObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, attributeGroupObj.annotation, schema);
            attributeGroupRef.appendChild(annotation);
        }
        return attributeGroupRef;
    }

    Element serializeAttributeGroup(Document doc, XmlSchemaAttributeGroup attributeGroupObj, XmlSchema schema) throws XmlSchemaSerializerException {
        Element attributeGroup = this.createNewElement(doc, "attributeGroup", schema.schema_ns_prefix, xsdNamespace);
        if (attributeGroupObj.name == null) {
            throw new XmlSchemaSerializerException("Attribute group musthave name");
        }
        attributeGroup.setAttribute("name", attributeGroupObj.name);
        if (attributeGroupObj.id != null) {
            attributeGroup.setAttribute("id", attributeGroupObj.id);
        }
        if (attributeGroupObj.annotation != null) {
            Element annotation = this.serializeAnnotation(doc, attributeGroupObj.annotation, schema);
            attributeGroup.appendChild(annotation);
        }
        int attributesLength = attributeGroupObj.attributes.getCount();
        for (int i = 0; i < attributesLength; ++i) {
            XmlSchemaObject obj = attributeGroupObj.attributes.getItem(i);
            if (obj instanceof XmlSchemaAttribute) {
                Element attr = this.serializeAttribute(doc, (XmlSchemaAttribute)obj, schema);
                attributeGroup.appendChild(attr);
                continue;
            }
            if (!(obj instanceof XmlSchemaAttributeGroupRef)) continue;
            Element attrGroup = this.serializeAttributeGroupRef(doc, (XmlSchemaAttributeGroupRef)obj, schema);
            attributeGroup.appendChild(attrGroup);
        }
        if (attributeGroupObj.anyAttribute != null) {
            Element anyAttribute = this.serializeAnyAttribute(doc, attributeGroupObj.anyAttribute, schema);
            attributeGroup.appendChild(anyAttribute);
        }
        return attributeGroup;
    }

    private void appendElement(Document doc, Element parent, Node children, XmlSchema schema) {
        Element elTmp = (Element)children;
        Element el = this.createNewElement(doc, elTmp.getLocalName(), schema.schema_ns_prefix, xsdNamespace);
        NamedNodeMap attributes = el.getAttributes();
        int attributeLength = attributes.getLength();
        for (int i = 0; i < attributeLength; ++i) {
            Node n = attributes.item(i);
            el.setAttribute(n.getNodeName(), n.getNodeValue());
        }
        NodeList decendants = el.getChildNodes();
        int decendantLength = decendants.getLength();
        for (int i = 0; i < decendantLength; ++i) {
            Node n = decendants.item(i);
            short nodeType = n.getNodeType();
            if (nodeType == 3) {
                String nValue = n.getNodeValue();
                Text t = doc.createTextNode(nValue);
                el.appendChild(t);
                continue;
            }
            if (nodeType != 1) continue;
            this.appendElement(doc, el, n, schema);
        }
    }

    private static String[] getParts(String name) {
        String[] parts = new String[2];
        int index = name.indexOf(":");
        if (index > -1) {
            parts[0] = name.substring(0, index);
            parts[1] = name.substring(index + 1);
        } else {
            parts[0] = "";
            parts[1] = name;
        }
        return parts;
    }

    private String convertString(String convert) {
        String input = convert.trim();
        if (input.equals("all")) {
            return "#all";
        }
        return input.toLowerCase();
    }

    private Element createNewElement(Document docs, String localName, String prefix, String namespace) {
        String elementName = (prefix.length() > 0 ? (prefix = prefix + ":") : "") + localName;
        return docs.createElementNS(namespace, elementName);
    }

    private String resolveQName(QName names, XmlSchema schemaObj) {
        String prefixStr;
        String prefix;
        String namespace = names.getNamespaceURI();
        String[] type = XmlSchemaSerializer.getParts(names.getLocalPart());
        String typeName = type.length > 1 ? type[1] : type[0];
        String string = prefix = "".equals(namespace) ? "" : this.schema_ns.get(namespace);
        if (prefix == null) {
            int magicNumber = new Random().nextInt(999);
            prefix = "gen" + magicNumber;
            this.schema_ns.put(namespace, prefix);
            this.schemaElement.setAttributeNS(XMLNS_NAMESPACE_URI, "xmlns:" + prefix.toString(), namespace);
        }
        prefixStr = (prefixStr = prefix.toString()).trim().length() > 0 ? prefixStr + ":" : "";
        return prefixStr + typeName;
    }

    void setupAttr(Document doc, XmlSchemaObjectCollection collectionObj, XmlSchema schema, Element container) throws XmlSchemaSerializerException {
        int collectionLength = collectionObj.getCount();
        for (int i = 0; i < collectionLength; ++i) {
            Element attrEl;
            XmlSchemaAnnotated attr;
            XmlSchemaObject obj = collectionObj.getItem(i);
            if (obj instanceof XmlSchemaAttribute) {
                attr = (XmlSchemaAttribute)obj;
                attrEl = this.serializeAttribute(doc, (XmlSchemaAttribute)attr, schema);
                container.appendChild(attrEl);
                continue;
            }
            if (!(obj instanceof XmlSchemaAttributeGroupRef)) continue;
            attr = (XmlSchemaAttributeGroupRef)obj;
            attrEl = this.serializeAttributeGroupRef(doc, (XmlSchemaAttributeGroupRef)attr, schema);
            container.appendChild(attrEl);
        }
    }

    public static class XmlSchemaSerializerException
    extends Exception {
        public XmlSchemaSerializerException(String msg) {
            super(msg);
        }
    }
}

