/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cvd.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JFileChooser;
import org.apache.uima.cas.impl.XCASSerializer;
import org.apache.uima.tools.cvd.MainFrame;
import org.apache.uima.util.XMLSerializer;
import org.xml.sax.SAXException;

public class XCASSaveHandler
implements ActionListener {
    private final MainFrame main;

    public XCASSaveHandler(MainFrame frame) {
        this.main = frame;
    }

    public void actionPerformed(ActionEvent event) {
        int rc;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Save XCAS file");
        if (this.main.getXcasFileOpenDir() != null) {
            fileChooser.setCurrentDirectory(this.main.getXcasFileOpenDir());
        }
        if ((rc = fileChooser.showSaveDialog(this.main)) == 0) {
            File xcasFile = fileChooser.getSelectedFile();
            this.main.setXcasFileOpenDir(xcasFile.getParentFile());
            try {
                BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(xcasFile));
                XMLSerializer xmlSerializer = new XMLSerializer((OutputStream)outStream);
                XCASSerializer xcasSerializer = new XCASSerializer(this.main.getCas().getTypeSystem());
                xcasSerializer.serialize(this.main.getCas(), xmlSerializer.getContentHandler());
                ((OutputStream)outStream).close();
            }
            catch (IOException e) {
                this.main.handleException(e);
            }
            catch (SAXException e) {
                this.main.handleException(e);
            }
        }
    }
}

