/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.test.junit_extension;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileCompare {
    private static final String EMPTY_TAG_REGEX = "(<([\\w]+)>[\\s]*</[\\w]+>)";
    private static Pattern emptyTagPattern = Pattern.compile("(<([\\w]+)>[\\s]*</[\\w]+>)");
    private static Pattern crnlPattern = Pattern.compile("\\r(?=\\n)");
    private static final Pattern multipleWhiteSpace = Pattern.compile("[ \\t]{2,}");
    private static final Pattern emptyLinePattern = Pattern.compile("(?m)^ $");
    private static final Pattern multipleNlPattern = Pattern.compile("\\n{2,}");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compare(String filename1, String filename2) throws IOException {
        InputStream file1 = null;
        InputStream file2 = null;
        try {
            file1 = new FileInputStream(filename1);
            file2 = new FileInputStream(filename2);
            boolean bl = FileCompare.compare(file1, file2);
            return bl;
        }
        finally {
            file1.close();
            file2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compare(File file1, File file2) throws IOException {
        InputStream inputStream1 = null;
        InputStream inputStream2 = null;
        try {
            inputStream1 = new FileInputStream(file1);
            inputStream2 = new FileInputStream(file2);
            boolean bl = FileCompare.compare(inputStream1, inputStream2);
            return bl;
        }
        finally {
            inputStream1.close();
            inputStream2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compare(String filename1, InputStream in) throws IOException {
        InputStream file1 = null;
        try {
            file1 = new FileInputStream(filename1);
            boolean bl = FileCompare.compare(file1, in);
            return bl;
        }
        finally {
            file1.close();
        }
    }

    public static boolean compare(InputStream in1, InputStream in2) throws IOException {
        int byteBufferSize = 10000;
        in1 = new BufferedInputStream(in1, 10000);
        in2 = new BufferedInputStream(in2, 10000);
        int in1byte = 0;
        while (in1byte != -1) {
            in1byte = in1.read();
            if (Character.isWhitespace((char)in1byte) || in1byte == 32 || in1byte == 10 || in1byte == 13) continue;
            int in2byte = in2.read();
            while (Character.isWhitespace((char)in2byte) || in2byte == 32 || in2byte == 10 || in2byte == 13) {
                in2byte = in2.read();
            }
            if (in1byte == in2byte) continue;
            return false;
        }
        return true;
    }

    public static boolean compareStrings(String in1, String in2) {
        int i1 = 0;
        int i2 = 0;
        while (i1 < in1.length()) {
            char c2;
            char c1;
            if (Character.isWhitespace(c1 = in1.charAt(i1++))) continue;
            do {
                if (i2 < in2.length()) continue;
                return false;
            } while (Character.isWhitespace(c2 = in2.charAt(i2++)));
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compareXML(String filename1, String filename2) throws IOException {
        File file1 = null;
        File file2 = null;
        String s1 = null;
        String s2 = null;
        ByteArrayInputStream bais1 = null;
        ByteArrayInputStream bais2 = null;
        try {
            file1 = new File(filename1);
            file2 = new File(filename2);
            s1 = FileCompare.file2String(file1);
            s2 = FileCompare.file2String(file2);
            s1 = FileCompare.shortenEmptyTags(s1, filename1);
            s2 = FileCompare.shortenEmptyTags(s2, filename2);
            bais1 = new ByteArrayInputStream(s1.getBytes());
            bais2 = new ByteArrayInputStream(s2.getBytes());
            boolean bl = FileCompare.compare(bais1, (InputStream)bais2);
            return bl;
        }
        finally {
            bais1.close();
            bais2.close();
        }
    }

    public static boolean compareWithFilter(String filename1, String filename2, Pattern pattern) throws IOException {
        File file1 = null;
        File file2 = null;
        String s1 = null;
        String s2 = null;
        file1 = new File(filename1);
        file2 = new File(filename2);
        s1 = FileCompare.file2String(file1);
        s2 = FileCompare.file2String(file2);
        return FileCompare.compareStringsWithFilter(s1, s2, pattern);
    }

    public static boolean compareStringsWithFilter(String s1, String s2, Pattern pattern) {
        s1 = crnlPattern.matcher(s1).replaceAll("");
        s2 = crnlPattern.matcher(s2).replaceAll("");
        s1 = emptyTagPattern.matcher(s1).replaceAll("<$2/>");
        s2 = emptyTagPattern.matcher(s2).replaceAll("<$2/>");
        s1 = pattern.matcher(s1).replaceAll("");
        s2 = pattern.matcher(s2).replaceAll("");
        s1 = multipleWhiteSpace.matcher(s1).replaceAll(" ");
        s2 = multipleWhiteSpace.matcher(s2).replaceAll(" ");
        s1 = emptyLinePattern.matcher(s1).replaceAll("");
        s2 = emptyLinePattern.matcher(s2).replaceAll("");
        s1 = multipleNlPattern.matcher(s1).replaceAll("\n");
        s2 = multipleNlPattern.matcher(s2).replaceAll("\n");
        s1 = FileCompare.removeTrailingNl(s1);
        s2 = FileCompare.removeTrailingNl(s2);
        return FileCompare.compareStringsWithMsg(s1, s2);
    }

    private static String removeTrailingNl(String s) {
        int i = s.length() - 1;
        if (i >= 0 && s.charAt(i) == '\n') {
            return s.substring(0, i);
        }
        return s;
    }

    public static boolean compareStringsWithMsg(String s1, String s2) {
        int maxI = Math.min(s1.length(), s2.length());
        for (int i = 0; i < maxI; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            System.out.println("Error: strings differ starting at char: " + i);
            System.out.println("Error:   string 1 = " + s1.substring(Math.max(0, i - 100), Math.min(s1.length(), i + 100)));
            System.out.println("Error:   string 2 = " + s2.substring(Math.max(0, i - 100), Math.min(s2.length(), i + 100)));
            return false;
        }
        if (s1.length() != s2.length()) {
            System.out.println("Error: strings are different length");
            System.out.println("  s1 length = " + s1.length() + "; s2 length = " + s2.length());
            return false;
        }
        return true;
    }

    private static String shortenEmptyTags(String xml, String filename) {
        Matcher matcher = emptyTagPattern.matcher(xml);
        StringBuffer result = new StringBuffer();
        StringBuffer sb = null;
        String replacement = null;
        boolean replaced = false;
        while (matcher.find()) {
            sb = new StringBuffer();
            sb.append("<").append(matcher.group(2)).append("/>");
            replacement = sb.toString();
            matcher.appendReplacement(result, replacement);
            replaced = true;
        }
        matcher.appendTail(result);
        if (replaced) {
            System.out.println("In file \"" + filename + "\" empty tags have been transformed from long to short notation in memory!");
        }
        return result.toString();
    }

    public static String file2String(File file) throws IOException {
        return FileCompare.reader2String(new FileReader(file), (int)file.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String reader2String(Reader reader, int bufSize) throws IOException {
        int read_so_far;
        char[] buf = new char[bufSize];
        try {
            int count;
            for (read_so_far = 0; read_so_far < bufSize; read_so_far += count) {
                count = reader.read(buf, read_so_far, bufSize - read_so_far);
                if (0 <= count) continue;
                break;
            }
        }
        finally {
            reader.close();
        }
        return new String(buf, 0, read_so_far);
    }
}

