/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples;

import java.io.IOException;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.util.XMLInputSource;

public class SofaExampleApplication {
    public static void main(String[] args) throws UIMAException, IOException {
        XMLInputSource input = new XMLInputSource("descriptors/analysis_engine/SofaExampleAnnotator.xml");
        AnalysisEngineDescription desc = UIMAFramework.getXMLParser().parseAnalysisEngineDescription(input);
        AnalysisEngine seAnnotator = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)desc);
        CAS cas = seAnnotator.newCAS();
        CAS englishView = cas.createView("EnglishDocument");
        englishView.setDocumentText("this beer is good");
        seAnnotator.process(cas);
        System.out.println("---Printing all annotations for English Sofa---");
        englishView.select(Annotation.class).forEach(annot -> System.out.println(" " + annot.getType().getName() + ": " + annot.getCoveredText()));
        System.out.println();
        CAS germanView = cas.getView("GermanDocument");
        Type cross = germanView.getTypeSystem().getType("sofa.test.CrossAnnotation");
        Feature other = cross.getFeatureByBaseName("otherAnnotation");
        System.out.println("---Printing all annotations for German Sofa---");
        germanView.select(Annotation.class).forEach(annot -> {
            System.out.println(" " + annot.getType().getName() + ": " + annot.getCoveredText());
            if (annot.getType() == cross) {
                Annotation crossAnnot = (Annotation)annot.getFeatureValue(other);
                System.out.println("   other annotation feature: " + crossAnnot.getCoveredText());
            }
        });
        seAnnotator.destroy();
    }
}

