/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.xmi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;
import org.xml.sax.SAXException;

public class XmiCollectionReader
extends CollectionReader_ImplBase {
    public static final String PARAM_INPUTDIR = "InputDirectory";
    public static final String PARAM_FAILUNKNOWN = "FailOnUnknownType";
    private Boolean mFailOnUnknownType;
    private ArrayList mFiles;
    private int mCurrentIndex;

    public void initialize() throws ResourceInitializationException {
        this.mFailOnUnknownType = (Boolean)this.getConfigParameterValue(PARAM_FAILUNKNOWN);
        if (null == this.mFailOnUnknownType) {
            this.mFailOnUnknownType = true;
        }
        File directory = new File(((String)this.getConfigParameterValue(PARAM_INPUTDIR)).trim());
        this.mCurrentIndex = 0;
        if (!directory.exists() || !directory.isDirectory()) {
            throw new ResourceInitializationException("directory_not_found", new Object[]{PARAM_INPUTDIR, this.getMetaData().getName(), directory.getPath()});
        }
        this.mFiles = new ArrayList();
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory() || !files[i].getName().endsWith(".xmi")) continue;
            this.mFiles.add(files[i]);
        }
    }

    public boolean hasNext() {
        return this.mCurrentIndex < this.mFiles.size();
    }

    public void getNext(CAS aCAS) throws IOException, CollectionException {
        File currentFile = (File)this.mFiles.get(this.mCurrentIndex++);
        FileInputStream inputStream = new FileInputStream(currentFile);
        try {
            XmiCasDeserializer.deserialize((InputStream)inputStream, (CAS)aCAS, (this.mFailOnUnknownType == false ? 1 : 0) != 0);
        }
        catch (SAXException e) {
            throw new CollectionException((Throwable)e);
        }
        finally {
            inputStream.close();
        }
    }

    public void close() throws IOException {
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.mCurrentIndex, this.mFiles.size(), "entities")};
    }
}

