/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.vinci.debug.Debug;
import org.apache.vinci.transport.Attributes;
import org.apache.vinci.transport.FrameComponent;
import org.apache.vinci.transport.FrameLeaf;
import org.apache.vinci.transport.FrameTransporter;
import org.apache.vinci.transport.KeyValuePair;
import org.apache.vinci.transport.Transportable;
import org.apache.vinci.transport.XTalkTransporter;
import org.apache.vinci.transport.util.XMLConverter;

public abstract class Frame
extends FrameComponent
implements Transportable {
    private static final String XML_INDENT = "   ";
    private static FrameTransporter parser = new XTalkTransporter();

    protected Frame() {
    }

    public static void setFrameTransporter(FrameTransporter transporter) {
        parser = transporter;
    }

    public static FrameTransporter getFrameTransporter() {
        return parser;
    }

    public void add(String tag, FrameComponent val) {
        throw new UnsupportedOperationException("not implemented");
    }

    public KeyValuePair getKeyValuePair(int which) {
        throw new UnsupportedOperationException("not implemented");
    }

    public int getKeyValuePairCount() {
        throw new UnsupportedOperationException("not implemented");
    }

    public KeyValuePair fromStream(InputStream is) throws IOException, EOFException {
        return parser.fromStream(is, this);
    }

    public void toStream(OutputStream os) throws IOException {
        parser.toStream(os, this);
    }

    public String toString() {
        return this.toXML();
    }

    public String toXML() {
        return this.toXML(new StringBuffer()).toString();
    }

    public String toRawXML() {
        return this.toRawXML(new StringBuffer()).toString();
    }

    public StringBuffer toRawXML(StringBuffer buf) {
        buf.append("<vinci:FRAME").append(this.attributeString(this));
        if (this.getAttributes() == null || this.getAttributes().fgetFirst("xmlns:vinci") == null) {
            buf.append(" xmlns:vinci=\"").append("http://uima.apache.org/vinci/FrameSpec/").append('\"');
        }
        buf.append(">");
        this.toRawXMLWork(buf);
        buf.append("</vinci:FRAME>");
        return buf;
    }

    public void toRawXMLWork(StringBuffer rval) {
        KeyValuePair keyVal = null;
        int total = this.getKeyValuePairCount();
        for (int i = 0; i < total; ++i) {
            keyVal = this.getKeyValuePair(i);
            boolean pcdata = "".equals(keyVal.key);
            if (!pcdata) {
                rval.append('<').append(keyVal.key).append(this.attributeString(keyVal.value));
                if (keyVal.value instanceof Frame && ((Frame)keyVal.value).getKeyValuePairCount() == 0) {
                    rval.append("/>");
                    continue;
                }
                rval.append('>');
            }
            if (keyVal.value instanceof FrameLeaf) {
                XMLConverter.convertStringToXMLString(((FrameLeaf)keyVal.value).toString(), rval);
            } else {
                ((Frame)keyVal.value).toRawXMLWork(rval);
            }
            if (pcdata) continue;
            rval.append("</").append(keyVal.key).append('>');
        }
    }

    public StringBuffer toXML(StringBuffer buf) {
        buf.append("<vinci:FRAME").append(this.attributeString(this));
        if (this.getAttributes() == null || this.getAttributes().fgetFirst("xmlns:vinci") == null) {
            buf.append(" xmlns:vinci=\"").append("http://uima.apache.org/vinci/FrameSpec/").append('\"');
        }
        buf.append(">\n");
        this.toXML(buf, 0);
        buf.append("</vinci:FRAME>\n");
        return buf;
    }

    public FrameLeaf createFrameLeaf(byte[] array) {
        return new FrameLeaf(array, false);
    }

    public Frame createSubFrame(String tag_name, int initialCapacity) {
        try {
            return (Frame)this.getClass().newInstance();
        }
        catch (Exception e) {
            Debug.reportException(e);
            throw new UnsupportedOperationException("createSubFrame() failed: " + e);
        }
    }

    private String attributeString(FrameComponent c) {
        Attributes attributes = c.getAttributes();
        if (attributes == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(80);
        for (int i = 0; i < attributes.getKeyValuePairCount(); ++i) {
            KeyValuePair k = attributes.getKeyValuePair(i);
            buf.append(" ");
            buf.append(k.key);
            buf.append("=\"");
            XMLConverter.simpleConvertStringToXMLString(k.value.toString(), buf);
            buf.append('\"');
        }
        return buf.toString();
    }

    protected void toXML(StringBuffer rval, int offset) {
        KeyValuePair keyVal = null;
        int total = this.getKeyValuePairCount();
        for (int i = 0; i < total; ++i) {
            keyVal = this.getKeyValuePair(i);
            for (int j = 0; j <= offset; ++j) {
                rval.append(XML_INDENT);
            }
            boolean pcdata = "".equals(keyVal.key);
            if (!pcdata) {
                rval.append('<').append(keyVal.key).append(this.attributeString(keyVal.value));
                if (keyVal.value instanceof Frame && ((Frame)keyVal.value).getKeyValuePairCount() == 0) {
                    rval.append("/>\n");
                    continue;
                }
                rval.append('>');
            }
            if (keyVal.value instanceof FrameLeaf) {
                XMLConverter.convertStringToXMLString(((FrameLeaf)keyVal.value).toString(), rval);
            } else {
                rval.append('\n');
                ((Frame)keyVal.value).toXML(rval, offset + 1);
                for (int j = 0; j <= offset; ++j) {
                    rval.append(XML_INDENT);
                }
            }
            if (!pcdata) {
                rval.append("</").append(keyVal.key).append('>');
            }
            rval.append('\n');
        }
    }

    public Frame fadd(String key, float val) {
        this.add(key, new FrameLeaf(val));
        return this;
    }

    public Frame fadd(String key, float[] val) {
        if (val != null) {
            this.add(key, new FrameLeaf(val));
        }
        return this;
    }

    public Frame fadd(String key, double val) {
        this.add(key, new FrameLeaf(val));
        return this;
    }

    public Frame fadd(String key, double[] val) {
        if (val != null) {
            this.add(key, new FrameLeaf(val));
        }
        return this;
    }

    public Frame fadd(String key, int val) {
        this.add(key, new FrameLeaf(val));
        return this;
    }

    public Frame fadd(String key, int[] val) {
        if (val != null) {
            this.add(key, new FrameLeaf(val));
        }
        return this;
    }

    public Frame fadd(String key, long val) {
        this.add(key, new FrameLeaf(val));
        return this;
    }

    public Frame fadd(String key, long[] val) {
        if (val != null) {
            this.add(key, new FrameLeaf(val));
        }
        return this;
    }

    public Frame fadd(String key, String val) {
        if (val != null) {
            this.add(key, new FrameLeaf(val));
        }
        return this;
    }

    public Frame fadd(String key, String[] val) {
        if (val != null) {
            this.add(key, new FrameLeaf(val));
        }
        return this;
    }

    public Frame fadd(String key, byte[] val) {
        if (val != null) {
            this.add(key, new FrameLeaf(val, true));
        }
        return this;
    }

    public Frame fadd(String key, boolean val) {
        this.add(key, new FrameLeaf(val));
        return this;
    }

    public Frame fadd(String key, Frame val) {
        if (val != null) {
            this.add(key, val);
        }
        return this;
    }

    public Frame fadd(String key) {
        this.add(key, this.createSubFrame(key, 0));
        return this;
    }

    public Frame faddTrueBinary(String key, byte[] val) {
        if (val != null) {
            this.add(key, new FrameLeaf(val, false));
        }
        return this;
    }
}

