/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.container.deployer;

import java.net.URL;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CasConsumer;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.collection.base_cpm.CasProcessor;
import org.apache.uima.collection.impl.base_cpm.container.CasProcessorConfiguration;
import org.apache.uima.collection.impl.base_cpm.container.ProcessingContainer;
import org.apache.uima.collection.impl.base_cpm.container.deployer.CasProcessorDeployer;
import org.apache.uima.collection.impl.base_cpm.container.deployer.CasProcessorDeploymentException;
import org.apache.uima.collection.impl.cpm.container.CPEFactory;
import org.apache.uima.collection.impl.cpm.container.CasProcessorConfigurationJAXBImpl;
import org.apache.uima.collection.impl.cpm.container.ProcessingContainer_Impl;
import org.apache.uima.collection.impl.cpm.container.ServiceProxyPool;
import org.apache.uima.collection.impl.cpm.engine.CPMEngine;
import org.apache.uima.collection.impl.cpm.utils.CpmLocalizedMessage;
import org.apache.uima.collection.metadata.CpeCasProcessor;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.util.Level;

public class CPEDeployerDefaultImpl
implements CasProcessorDeployer {
    private ServiceProxyPool casProcessorPool = null;
    private CPEFactory cpeFactory = null;
    private CPMEngine engine;

    public CPEDeployerDefaultImpl(CPEFactory aCpeFactory) {
        this.cpeFactory = aCpeFactory;
    }

    public ProcessingContainer deployCasProcessor(List aCasProcessorList, CPMEngine aEngine, boolean redeploy) throws ResourceConfigurationException {
        this.engine = aEngine;
        return this.deployCasProcessor(aCasProcessorList, redeploy);
    }

    public ProcessingContainer deployCasProcessor(List aCasProcessorList, boolean redeploy) throws ResourceConfigurationException {
        String name = null;
        CasProcessor casProcessor = null;
        CasProcessorConfiguration casProcessorConfig = null;
        ProcessingContainer processingContainer = null;
        String deployModel = null;
        try {
            for (int i = 0; i < aCasProcessorList.size(); ++i) {
                casProcessor = (CasProcessor)aCasProcessorList.get(i);
                if (processingContainer == null) {
                    ProcessingResourceMetaData metaData = casProcessor.getProcessingResourceMetaData();
                    CpeCasProcessor cpeCasProcessor = (CpeCasProcessor)this.cpeFactory.casProcessorConfigMap.get(metaData.getName());
                    if (this.engine != null) {
                        boolean parallelizable = this.engine.isParallizable(casProcessor, metaData.getName());
                        cpeCasProcessor.setIsParallelizable(parallelizable);
                    }
                    this.casProcessorPool = new ServiceProxyPool();
                    casProcessorConfig = new CasProcessorConfigurationJAXBImpl(cpeCasProcessor, this.cpeFactory.getResourceManager());
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_cp_checkpoint__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(casProcessorConfig.getBatchSize())});
                    }
                    processingContainer = new ProcessingContainer_Impl(casProcessorConfig, metaData, this.casProcessorPool);
                    deployModel = casProcessorConfig.getDeploymentType();
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_cp_deployment__FINEST", new Object[]{Thread.currentThread().getName(), deployModel});
                    }
                    if ((name = casProcessorConfig.getName()) == null) {
                        if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_cp_no_name__SEVERE", new Object[]{Thread.currentThread().getName()});
                        }
                        throw new ResourceConfigurationException("required_attribute_missing", new Object[]{"name", "casProcessor"}, new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_attribute_from_xml_element__WARNING", new Object[]{Thread.currentThread().getName(), "n/a", "name", "casProcessor"})));
                    }
                } else {
                    casProcessorConfig = processingContainer.getCasProcessorConfiguration();
                    if (casProcessorConfig == null) {
                        throw new ResourceConfigurationException("element_not_found", new Object[]{"<casProcessor>", "<casProcessors>"}, new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_bad_cpe_descriptor_no_cp__WARNING", new Object[]{Thread.currentThread().getName()})));
                    }
                }
                this.casProcessorPool.addCasProcessor(casProcessor);
                if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_deploying_cp__FINEST", new Object[]{Thread.currentThread().getName(), name});
            }
        }
        catch (ResourceConfigurationException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ResourceConfigurationException("resource_unavailable", new Object[0], e);
        }
        return processingContainer;
    }

    public void deployCasProcessor(ProcessingContainer aProcessingContainer) throws ResourceConfigurationException {
        try {
            CasProcessorConfiguration casProcessorConfig = aProcessingContainer.getCasProcessorConfiguration();
            String name = casProcessorConfig.getName();
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_redeploying_cp__FINEST", new Object[]{Thread.currentThread().getName(), name});
            }
            URL descriptorUrl = casProcessorConfig.getDescriptorUrl();
            CasProcessor casProcessor = this.produceIntegratedCasProcessor(descriptorUrl);
            this.casProcessorPool.addCasProcessor(casProcessor);
        }
        catch (ResourceConfigurationException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ResourceConfigurationException("resource_unavailable", new Object[0], e);
        }
    }

    private CasProcessor produceIntegratedCasProcessor(URL aDescriptor) throws ResourceConfigurationException {
        CasProcessor casProcessor = null;
        try {
            if (aDescriptor != null) {
                ResourceSpecifier resourceSpecifier = this.cpeFactory.getSpecifier(aDescriptor);
                if (resourceSpecifier instanceof AnalysisEngineDescription) {
                    casProcessor = UIMAFramework.produceAnalysisEngine(resourceSpecifier, this.cpeFactory.getResourceManager(), null);
                } else if (resourceSpecifier instanceof CasConsumerDescription) {
                    if (this.cpeFactory.isDefinitionInstanceOf(CasConsumer.class, resourceSpecifier, aDescriptor.toString())) {
                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_producing_cas_consumer__FINEST", new Object[]{Thread.currentThread().getName()});
                        }
                        casProcessor = UIMAFramework.produceCasConsumer(resourceSpecifier, this.cpeFactory.getResourceManager(), null);
                    } else if (this.cpeFactory.isDefinitionInstanceOf(CasProcessor.class, resourceSpecifier, aDescriptor.toString())) {
                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_producing_cas_data_consumer__FINEST", new Object[]{Thread.currentThread().getName()});
                        }
                        casProcessor = this.cpeFactory.produceCasDataConsumer(CasProcessor.class, resourceSpecifier, null);
                    }
                }
                if (casProcessor == null) {
                    throw new ResourceConfigurationException("resource_unavailable", new Object[0], new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_instantiation_exception__WARNING", new Object[]{Thread.currentThread().getName(), "Integrated Cas Processor"})));
                }
            }
        }
        catch (ResourceConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ResourceConfigurationException("resource_unavailable", new Object[0], new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_instantiation_exception__WARNING", new Object[]{Thread.currentThread().getName(), "Integrated Cas Processor"})));
        }
        return casProcessor;
    }

    public void undeploy() throws CasProcessorDeploymentException {
    }

    public void undeploy(URL aURL) throws CasProcessorDeploymentException {
    }
}

