/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas_data.impl.vinci;

import java.io.IOException;
import org.apache.uima.adapter.vinci.util.SaxVinciFrameBuilder;
import org.apache.uima.adapter.vinci.util.VinciSaxParser;
import org.apache.uima.cas_data.CasData;
import org.apache.uima.cas_data.impl.CasDataImpl;
import org.apache.uima.cas_data.impl.CasDataToXCas;
import org.apache.uima.cas_data.impl.CasDataUtils;
import org.apache.uima.cas_data.impl.XCasToCasDataSaxHandler;
import org.apache.vinci.transport.document.AFrame;
import org.xml.sax.SAXException;

public class VinciCasDataConverter {
    private String mUeidType;
    private String mUeidFeature;
    private String mCasDataDocTextType;
    private String mCasDataDocTextFeature;
    private String mXCasDocTextTag;
    private boolean mIncludeAnnotationSpannedText;

    public VinciCasDataConverter(String aUeidType, String aUeidFeature, String aCasDataDocTextType, String aCasDataDocTextFeature, String aXCasDocTextTag, boolean aIncludeAnnotationSpannedText) {
        this.mUeidType = aUeidType;
        this.mUeidFeature = aUeidFeature;
        this.mCasDataDocTextType = aCasDataDocTextType;
        this.mCasDataDocTextFeature = aCasDataDocTextFeature;
        this.mXCasDocTextTag = aXCasDocTextTag;
        this.mIncludeAnnotationSpannedText = aIncludeAnnotationSpannedText;
    }

    public void casDataToVinciFrame(CasData aCasData, AFrame aParentFrame) throws IOException, SAXException {
        String ueid = null;
        if (this.mUeidType != null && this.mUeidFeature != null) {
            ueid = CasDataUtils.getFeatureValueByType(aCasData, this.mUeidType, this.mUeidFeature);
        }
        AFrame xcasHolder = new AFrame();
        SaxVinciFrameBuilder vinciFrameBuilder = new SaxVinciFrameBuilder();
        vinciFrameBuilder.setParentFrame(xcasHolder);
        CasDataToXCas xcasGenerator = new CasDataToXCas();
        xcasGenerator.setDocumentTextTypeName(this.mCasDataDocTextType);
        xcasGenerator.setDocumentTextFeatureName(this.mCasDataDocTextFeature);
        xcasGenerator.setXCasDocumentTextTagName(this.mXCasDocTextTag);
        xcasGenerator.setIncludeAnnotationSpannedText(this.mIncludeAnnotationSpannedText);
        xcasGenerator.setContentHandler(vinciFrameBuilder);
        xcasGenerator.generateXCas(aCasData, ueid);
        AFrame xcasFrame = xcasHolder.fgetAFrame("CAS");
        aParentFrame.aadd("KEYS", xcasFrame);
    }

    @Deprecated
    public void vinciFrameToCasData(AFrame aCasFrame, CasData aCasData) throws SAXException {
        this.appendVinciFrameToCasData(aCasFrame, aCasData);
    }

    public CasData vinciFrameToCasData(AFrame aCasFrame) throws SAXException {
        CasDataImpl casData = new CasDataImpl();
        this.appendVinciFrameToCasData(aCasFrame, casData);
        return casData;
    }

    public void appendVinciFrameToCasData(AFrame aCasFrame, CasData aCasData) throws SAXException {
        VinciSaxParser vinciSaxParser = new VinciSaxParser();
        XCasToCasDataSaxHandler handler = new XCasToCasDataSaxHandler(aCasData);
        handler.startDocument();
        handler.startElement("", "CAS", "CAS", null);
        vinciSaxParser.setContentHandler(handler);
        vinciSaxParser.parse(aCasFrame, false);
        handler.endElement("", "CAS", "CAS");
        handler.endDocument();
    }
}

