/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cvd.tsview;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;

public class FeatureTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -6010925680514336742L;
    static final String[] columnHeaders = new String[]{"Feature", "Value Type", "Defined On"};
    private Type type = null;

    public FeatureTableModel() {
    }

    public FeatureTableModel(Type type) {
        this.type = type;
    }

    public void setType(Type type) {
        this.type = type;
        this.fireTableDataChanged();
    }

    public String getColumnName(int i) {
        if (i < 0 || i >= columnHeaders.length) {
            return "";
        }
        return columnHeaders[i];
    }

    public int getRowCount() {
        if (this.type == null) {
            return 0;
        }
        return this.type.getNumberOfFeatures();
    }

    public int getColumnCount() {
        return 3;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.type == null) {
            return null;
        }
        List<Feature> feats = this.type.getFeatures();
        if (rowIndex < 0 || rowIndex >= feats.size()) {
            return null;
        }
        Feature feat = feats.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return feat.getShortName();
            }
            case 1: {
                return feat.getRange().getName();
            }
            case 2: {
                return feat.getDomain().getName();
            }
        }
        return null;
    }
}

