/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cvd;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.uima.internal.util.CommandLineParser;
import org.apache.uima.tools.cvd.MainFrame;
import org.apache.uima.tools.images.Images;

public class CVD {
    public static final String MAN_PATH_PROPERTY = "uima.tools.cvd.manpath";
    private static final String TEXT_FILE_PARAM = "-text";
    private static final String DESC_FILE_PARAM = "-desc";
    private static final String EXECUTE_SWITCH = "-exec";
    private static final String DATA_PATH_PARAM = "-datapath";
    private static final String INI_FILE_PARAM = "-ini";
    private static final String LOOK_AND_FEEL_PARAM = "-lookandfeel";
    private static final String XMI_FILE_PARAM = "-xmi";

    private CVD() {
    }

    public static MainFrame createMainFrame() {
        return CVD.createMainFrame(null);
    }

    public static MainFrame createMainFrame(File iniFile) {
        final MainFrame frame = new MainFrame(iniFile);
        ImageIcon icon = Images.getImageIcon("/org/apache/uima/tools/images/Micro_16.gif");
        if (icon != null) {
            frame.setIconImage(icon.getImage());
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    frame.pack();
                    frame.setVisible(true);
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return frame;
    }

    private static final CommandLineParser createCmdLineParser() {
        CommandLineParser parser = new CommandLineParser();
        parser.addParameter(TEXT_FILE_PARAM, true);
        parser.addParameter(DESC_FILE_PARAM, true);
        parser.addParameter(DATA_PATH_PARAM, true);
        parser.addParameter(LOOK_AND_FEEL_PARAM, true);
        parser.addParameter(EXECUTE_SWITCH);
        parser.addParameter(XMI_FILE_PARAM, true);
        parser.addParameter(INI_FILE_PARAM, true);
        return parser;
    }

    private static final void printUsage() {
        System.out.println("Usage: java org.apache.uima.cvd.CVD [-text <TextFile>] [-desc <XmlDescriptor>] [-datapath <DataPath>] [-exec]");
        System.out.println("Additional optional parameters:");
        System.out.println("  -lookandfeel <LookAndFeelClassName>");
    }

    private static final boolean checkCmdLineSyntax(CommandLineParser clp) {
        if (clp.getRestArgs().length > 0) {
            System.err.println("Error parsing CVD command line: unknown argument(s):");
            String[] args = clp.getRestArgs();
            for (int i = 0; i < args.length; ++i) {
                System.err.print(" ");
                System.err.print(args[i]);
            }
            System.err.println();
            return false;
        }
        if (clp.isInArgsList(EXECUTE_SWITCH) && !clp.isInArgsList(DESC_FILE_PARAM)) {
            System.err.println("Error parsing CVD command line: -exec switch requires -desc parameter.");
            return false;
        }
        if (clp.isInArgsList(XMI_FILE_PARAM) && !clp.isInArgsList(DESC_FILE_PARAM)) {
            System.err.println("Error parsing CVD command line: -xmi switch requires -desc parameter.");
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            CommandLineParser clp = CVD.createCmdLineParser();
            clp.parseCmdLine(args);
            if (!CVD.checkCmdLineSyntax(clp)) {
                CVD.printUsage();
                System.exit(2);
            }
            String lookAndFeel = null;
            if (clp.isInArgsList(LOOK_AND_FEEL_PARAM)) {
                lookAndFeel = clp.getParamArgument(LOOK_AND_FEEL_PARAM);
                try {
                    UIManager.setLookAndFeel(lookAndFeel);
                }
                catch (UnsupportedLookAndFeelException e) {
                    System.err.println(e.getMessage());
                }
            }
            File iniFile = null;
            if (clp.isInArgsList(INI_FILE_PARAM)) {
                String iniFileName = clp.getParamArgument(INI_FILE_PARAM);
                iniFile = new File(iniFileName);
            }
            MainFrame frame = CVD.createMainFrame(iniFile);
            if (clp.isInArgsList(TEXT_FILE_PARAM)) {
                frame.loadTextFile(new File(clp.getParamArgument(TEXT_FILE_PARAM)));
            }
            if (clp.isInArgsList(DATA_PATH_PARAM)) {
                frame.setDataPath(clp.getParamArgument(DATA_PATH_PARAM));
            } else {
                String dataProp = System.getProperty("uima.datapath");
                if (dataProp != null) {
                    frame.setDataPath(dataProp);
                }
            }
            if (clp.isInArgsList(DESC_FILE_PARAM)) {
                frame.loadAEDescriptor(new File(clp.getParamArgument(DESC_FILE_PARAM)));
            }
            if (clp.isInArgsList(TEXT_FILE_PARAM)) {
                frame.loadTextFile(new File(clp.getParamArgument(TEXT_FILE_PARAM)));
            } else if (clp.isInArgsList(XMI_FILE_PARAM)) {
                frame.loadXmiFile(new File(clp.getParamArgument(XMI_FILE_PARAM)));
            }
            if (clp.isInArgsList(EXECUTE_SWITCH)) {
                frame.runAE(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

