/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.components;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.impl.XCASSerializer;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLSerializer;
import org.xml.sax.SAXException;

public class XCasWriterCasConsumer
extends CasConsumer_ImplBase {
    public static final String PARAM_OUTPUTDIR = "OutputDirectory";
    private File mOutputDir;
    private int mDocNum;

    public void initialize() throws ResourceInitializationException {
        this.mDocNum = 0;
        this.mOutputDir = new File(((String)this.getConfigParameterValue(PARAM_OUTPUTDIR)).trim());
        if (!this.mOutputDir.exists()) {
            this.mOutputDir.mkdirs();
        }
    }

    public void processCas(CAS aCAS) throws ResourceProcessException {
        JCas jcas;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new ResourceProcessException(e);
        }
        FSIterator it = jcas.getAnnotationIndex(SourceDocumentInformation.type).iterator();
        File outFile = null;
        if (it.hasNext()) {
            SourceDocumentInformation fileLoc = (SourceDocumentInformation)it.next();
            try {
                URI uri = new URI(fileLoc.getUri());
                File inFile = new File(uri);
                String outFileName = inFile.getName();
                if (fileLoc.getOffsetInSource() > 0) {
                    outFileName = outFileName + fileLoc.getOffsetInSource();
                }
                outFile = new File(this.mOutputDir, outFileName);
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        if (outFile == null) {
            outFile = new File(this.mOutputDir, "doc" + this.mDocNum++);
        }
        try {
            this.writeXCas(jcas.getCas(), outFile);
        }
        catch (IOException e) {
            throw new ResourceProcessException(e);
        }
        catch (SAXException e) {
            throw new ResourceProcessException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXCas(CAS aCas, File name) throws IOException, SAXException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(name);
            XCASSerializer ser = new XCASSerializer(aCas.getTypeSystem());
            XMLSerializer sax2xml = new XMLSerializer(out, false);
            ser.serialize(aCas, sax2xml.getContentHandler());
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static CasConsumerDescription getDescription() throws InvalidXMLException {
        InputStream descStream = XCasWriterCasConsumer.class.getResourceAsStream("XCasWriterCasConsumer.xml");
        return UIMAFramework.getXMLParser().parseCasConsumerDescription(new XMLInputSource(descStream, null));
    }

    public static URL getDescriptorURL() {
        return XCasWriterCasConsumer.class.getResource("XCasWriterCasConsumer.xml");
    }
}

