/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools;

import java.io.File;
import java.util.Iterator;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.collection.CollectionProcessingEngine;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.collection.StatusCallbackListener;
import org.apache.uima.collection.impl.metadata.cpe.CpeDescriptorFactory;
import org.apache.uima.collection.metadata.CasProcessorConfigurationParameterSettings;
import org.apache.uima.collection.metadata.CpeCollectionReader;
import org.apache.uima.collection.metadata.CpeComponentDescriptor;
import org.apache.uima.collection.metadata.CpeDescription;
import org.apache.uima.collection.metadata.CpeIntegratedCasProcessor;
import org.apache.uima.collection.metadata.CpeSofaMapping;
import org.apache.uima.collection.metadata.CpeSofaMappings;
import org.apache.uima.tools.components.FileSystemCollectionReader;
import org.apache.uima.tools.components.InlineXmlCasConsumer;
import org.apache.uima.tools.components.XmlDetagger;
import org.apache.uima.util.AnalysisEnginePerformanceReports;

public class RunAE
implements StatusCallbackListener {
    private File aeSpecifierFile = null;
    private File inputDir = null;
    private File outputDir = null;
    private String xmlTagName = null;
    private String language;
    private String encoding;
    private boolean genProgressMessages = true;
    private int statsLevel = 1;
    private boolean xcasInput = false;
    private boolean xmiInput = false;
    private boolean xLenient = false;
    int docsProcessed;
    private CollectionProcessingEngine mCPE;

    public RunAE(String[] args) {
        try {
            if (!this.processCmdLineArgs(args)) {
                this.printUsageMessage();
                return;
            }
            CpeDescription cpeDesc = CpeDescriptorFactory.produceDescriptor();
            cpeDesc.addCollectionReader(FileSystemCollectionReader.getDescriptorURL().toString());
            CasProcessorConfigurationParameterSettings crSettings = CpeDescriptorFactory.produceCasProcessorConfigurationParameterSettings();
            CpeCollectionReader cpeCollRdr = cpeDesc.getAllCollectionCollectionReaders()[0];
            cpeCollRdr.setConfigurationParameterSettings(crSettings);
            crSettings.setParameterValue("InputDirectory", this.inputDir.getAbsolutePath());
            crSettings.setParameterValue("Encoding", this.encoding);
            crSettings.setParameterValue("Language", this.language);
            if (this.xcasInput) {
                crSettings.setParameterValue("XCAS", "XCAS");
            } else if (this.xmiInput) {
                crSettings.setParameterValue("XCAS", "XMI");
            }
            if (this.xLenient) {
                crSettings.setParameterValue("LENIENT", "true");
            }
            CpeIntegratedCasProcessor xmlDetaggerCasProc = null;
            if (this.xmlTagName != null && this.xmlTagName.length() > 0) {
                xmlDetaggerCasProc = CpeDescriptorFactory.produceCasProcessor("XmlDetagger");
                CpeComponentDescriptor cpeComponentDescriptor = CpeDescriptorFactory.produceComponentDescriptor(XmlDetagger.getDescriptorURL().toString());
                xmlDetaggerCasProc.setCpeComponentDescriptor(cpeComponentDescriptor);
                CasProcessorConfigurationParameterSettings detaggerSettings = CpeDescriptorFactory.produceCasProcessorConfigurationParameterSettings();
                xmlDetaggerCasProc.setConfigurationParameterSettings(detaggerSettings);
                detaggerSettings.setParameterValue("XmlTagContainingText", this.xmlTagName);
                xmlDetaggerCasProc.setMaxErrorCount(0);
                cpeDesc.addCasProcessor(xmlDetaggerCasProc);
            }
            CpeIntegratedCasProcessor casProc = CpeDescriptorFactory.produceCasProcessor("UserAE");
            CpeComponentDescriptor cpeComponentDescriptor = CpeDescriptorFactory.produceComponentDescriptor(this.aeSpecifierFile.getAbsolutePath());
            casProc.setCpeComponentDescriptor(cpeComponentDescriptor);
            casProc.setMaxErrorCount(0);
            cpeDesc.addCasProcessor(casProc);
            CpeIntegratedCasProcessor casCon = null;
            if (this.outputDir != null) {
                casCon = CpeDescriptorFactory.produceCasProcessor("CasConsumer");
                cpeComponentDescriptor = CpeDescriptorFactory.produceComponentDescriptor(InlineXmlCasConsumer.getDescriptorURL().toString());
                casCon.setCpeComponentDescriptor(cpeComponentDescriptor);
                CasProcessorConfigurationParameterSettings consumerSettings = CpeDescriptorFactory.produceCasProcessorConfigurationParameterSettings();
                casCon.setConfigurationParameterSettings(consumerSettings);
                consumerSettings.setParameterValue("OutputDirectory", this.outputDir.getAbsolutePath());
                if (this.xcasInput) {
                    consumerSettings.setParameterValue("XCAS", "XCAS");
                } else if (this.xmiInput) {
                    consumerSettings.setParameterValue("XCAS", "XMI");
                }
                casCon.setMaxErrorCount(0);
                cpeDesc.addCasProcessor(casCon);
            }
            if (xmlDetaggerCasProc != null) {
                CpeSofaMapping sofaMapping = CpeDescriptorFactory.produceSofaMapping();
                sofaMapping.setComponentSofaName("xmlDocument");
                sofaMapping.setCpeSofaName("_InitialView");
                CpeSofaMappings xmlDetaggerSofaMappings = CpeDescriptorFactory.produceSofaMappings();
                xmlDetaggerSofaMappings.setSofaNameMappings(new CpeSofaMapping[]{sofaMapping});
                xmlDetaggerCasProc.setSofaNameMappings(xmlDetaggerSofaMappings);
                CpeSofaMapping aeSofaMapping = CpeDescriptorFactory.produceSofaMapping();
                aeSofaMapping.setCpeSofaName("plainTextDocument");
                CpeSofaMappings userAeSofaMappings = CpeDescriptorFactory.produceSofaMappings();
                userAeSofaMappings.setSofaNameMappings(new CpeSofaMapping[]{aeSofaMapping});
                casProc.setSofaNameMappings(userAeSofaMappings);
                if (casCon != null) {
                    CpeSofaMapping casConSofaMapping = CpeDescriptorFactory.produceSofaMapping();
                    casConSofaMapping.setCpeSofaName("plainTextDocument");
                    CpeSofaMappings consumerSofaMappings = CpeDescriptorFactory.produceSofaMappings();
                    consumerSofaMappings.setSofaNameMappings(new CpeSofaMapping[]{casConSofaMapping});
                    casCon.setSofaNameMappings(consumerSofaMappings);
                }
            }
            this.mCPE = UIMAFramework.produceCollectionProcessingEngine(cpeDesc);
            this.mCPE.addStatusCallbackListener(this);
            this.docsProcessed = 0;
            this.mCPE.process();
        }
        catch (Exception e) {
            if (this.xmlTagName != null && this.xmlTagName.length() > 0 && e instanceof UIMAException && ((UIMAException)e).hasMessageKey("sofa_mapping_not_supported_for_remote")) {
                System.err.println("The XML detagging feature (-t) is not supported for remote Analysis Engines or for Aggregates containing remotes.");
            }
            e.printStackTrace();
        }
    }

    public void initializationComplete() {
    }

    public void entityProcessComplete(CAS aCas, EntityProcessStatus aStatus) {
        if (aStatus.isException()) {
            Iterator<Exception> iter = aStatus.getExceptions().iterator();
            while (iter.hasNext()) {
                ((Throwable)iter.next()).printStackTrace();
            }
        } else if (this.genProgressMessages) {
            if (!this.xcasInput && !this.xmiInput) {
                Type fileLocType = aCas.getTypeSystem().getType("org.apache.uima.examples.SourceDocumentInformation");
                Feature fileNameFeat = fileLocType.getFeatureByBaseName("uri");
                FSIterator it = aCas.getAnnotationIndex(fileLocType).iterator();
                Object fileLoc = it.get();
                File inFile = new File(fileLoc.getStringValue(fileNameFeat));
                System.out.println("Processed Document " + inFile.getName());
            } else {
                System.out.println("doc" + this.docsProcessed++ + " processed successfully");
            }
        }
    }

    public void aborted() {
        System.out.println("Processing Aborted");
    }

    public void batchProcessComplete() {
    }

    public void collectionProcessComplete() {
        if (this.statsLevel > 0) {
            AnalysisEnginePerformanceReports performanceReports = new AnalysisEnginePerformanceReports(this.mCPE.getPerformanceReport());
            System.out.println("\n\nPERFORMANCE STATS\n-----------------\n\n");
            if (this.statsLevel > 1) {
                System.out.println(performanceReports.getFullReport());
                System.out.println();
            }
            System.out.println(performanceReports);
        }
    }

    public void paused() {
    }

    public void resumed() {
    }

    private void printUsageMessage() {
        System.err.println("\nUsage: java " + this.getClass().getName() + " [OPTIONS] <AE descriptor filename> <input dir> [<output dir>] ");
        System.err.println("\nIf <output dir> is not specified, the analysis results will not be output.  This can be useful when only interested in performance statistics.");
        System.err.println("\nOPTIONS\n-------");
        System.err.println("-t <TagName> (XML Text Tag) - specifies the name of an XML tag, found within the input documents, that contains the text to be analyzed.  The text will also be detagged. If this option is not specified, the entire document will be processed.");
        System.err.println("-q (Quiet) - supresses progress messages that are normally printed as each document is processed.");
        System.err.println("-s<x> (Stats level) - determines the verboseness of performance statistics.  s0=none, s1=brief, s2=full.  The default is brief.");
        System.err.println("-x - process input files as XCAS files.");
        System.err.println("-xmi - process input files as XmiCas files.");
        System.err.println("-lenient - ignore out-of-typesystem content when deserializing XML files.");
        System.err.println("-l <ISO language> - specify the ISO Language code to set.");
        System.err.println("-e <encoding> - specify the character encoding to use.");
    }

    private boolean processCmdLineArgs(String[] args) {
        this.encoding = "UTF-8";
        int index = 0;
        while (index < args.length) {
            String arg;
            if ((arg = args[index++]).equals("-q")) {
                this.genProgressMessages = false;
                continue;
            }
            if (arg.equals("-s0")) {
                this.statsLevel = 0;
                continue;
            }
            if (arg.equals("-s2")) {
                this.statsLevel = 2;
                continue;
            }
            if (arg.equals("-t")) {
                if (index >= args.length) {
                    return false;
                }
                this.xmlTagName = args[index++];
                continue;
            }
            if (arg.equals("-l")) {
                if (index >= args.length) {
                    return false;
                }
                this.language = args[index++];
                continue;
            }
            if (arg.equals("-e")) {
                if (index >= args.length) {
                    return false;
                }
                this.encoding = args[index++];
                continue;
            }
            if (arg.equals("-x")) {
                this.xcasInput = true;
                continue;
            }
            if (arg.equals("-xmi")) {
                this.xmiInput = true;
                continue;
            }
            if (arg.equals("-lenient")) {
                this.xLenient = true;
                continue;
            }
            if (arg.startsWith("-")) {
                System.err.println(arg + " is not a valid option");
                return false;
            }
            if (this.aeSpecifierFile == null) {
                this.aeSpecifierFile = new File(arg);
                if (this.aeSpecifierFile.exists() && !this.aeSpecifierFile.isDirectory()) continue;
                System.err.println(arg + " does not exist");
                System.exit(1);
                continue;
            }
            if (this.inputDir == null) {
                this.inputDir = new File(arg);
                if (this.inputDir.exists() && this.inputDir.isDirectory()) continue;
                System.err.println(arg + " does not exist or is not a directory");
                System.exit(1);
                continue;
            }
            if (this.outputDir != null) continue;
            this.outputDir = new File(arg);
            if (this.outputDir.exists() || this.outputDir.mkdirs()) continue;
            System.err.println(arg + " does not exist and could not be created");
            System.exit(1);
        }
        return this.aeSpecifierFile != null && this.inputDir != null;
    }

    public static void main(String[] args) {
        new RunAE(args);
    }
}

