/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.container;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.TypeOrFeature;
import org.apache.uima.cas_data.CasData;
import org.apache.uima.collection.base_cpm.AbortCPMException;
import org.apache.uima.collection.base_cpm.AbortCasProcessorException;
import org.apache.uima.collection.base_cpm.CasProcessor;
import org.apache.uima.collection.base_cpm.SkipCasException;
import org.apache.uima.collection.impl.CasConsumerDescription_impl;
import org.apache.uima.collection.impl.base_cpm.container.CasProcessorConfiguration;
import org.apache.uima.collection.impl.base_cpm.container.KillPipelineException;
import org.apache.uima.collection.impl.base_cpm.container.ProcessingContainer;
import org.apache.uima.collection.impl.base_cpm.container.RunnableContainer;
import org.apache.uima.collection.impl.base_cpm.container.ServiceConnectionException;
import org.apache.uima.collection.impl.base_cpm.container.deployer.CasProcessorDeployer;
import org.apache.uima.collection.impl.cpm.container.ServiceProxyPool;
import org.apache.uima.collection.impl.cpm.utils.CpmLocalizedMessage;
import org.apache.uima.collection.impl.cpm.utils.Filter;
import org.apache.uima.collection.impl.cpm.vinci.DATACasUtils;
import org.apache.uima.internal.util.StringUtils;
import org.apache.uima.resource.Resource;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.resource.metadata.impl.ConfigurationParameterSettings_impl;
import org.apache.uima.util.Level;
import org.apache.uima.util.impl.ProcessTrace_impl;

public class ProcessingContainer_Impl
extends ProcessingContainer
implements RunnableContainer {
    private static final int CONTAINER_SLEEP_TIME = 100;
    private int casProcessorStatus = 0;
    private ConfigurationParameterSettings configParams = null;
    private boolean isLocal = false;
    private boolean isRemote = false;
    private boolean isIntegrated = false;
    private long batchCounter = 0L;
    private int errorCounter = 0;
    private long sampleCounter = 0L;
    private long failureThresholdSample = 0L;
    private int configuredErrorRate = 0;
    private int batchSize = 1;
    private long processed = 0L;
    private int restartCount = 0;
    private CasProcessorConfiguration casProcessorCPEConfiguration = null;
    private long bytesIn = 0L;
    private long bytesOut = 0L;
    private int retryCount = 0;
    private int abortCount = 0;
    private int filteredCount = 0;
    private long remaining = -1L;
    private Stack processedEntityIds = new Stack();
    private long totalTime = 0L;
    private LinkedList filterList = null;
    private String logPath = null;
    private Logger logger = null;
    private boolean initialized = false;
    private Object lastCas = null;
    public ServiceProxyPool casProcessorPool;
    private CasProcessorDeployer casPDeployer = null;
    private ProcessingResourceMetaData metadata = null;
    private HashMap statMap = new HashMap();
    private boolean isPaused = false;
    private boolean singleFencedInstance = false;
    private final Object lockForIsPaused = new Object();
    private String processorName = null;
    private long fetchTime = 0L;
    public LinkedList failedCasProcessorList = new LinkedList();

    public ProcessingContainer_Impl(CasProcessorConfiguration aCasProcessorConfig, ProcessingResourceMetaData aMetaData, ServiceProxyPool aCasProcessorPool) throws ResourceConfigurationException {
        this.isRemote = "remote".equals(aCasProcessorConfig.getDeploymentType());
        this.casProcessorPool = aCasProcessorPool;
        this.casProcessorCPEConfiguration = aCasProcessorConfig;
        this.configParams = new ConfigurationParameterSettings_impl();
        this.setMetadata(aMetaData);
        this.batchSize = this.casProcessorCPEConfiguration.getBatchSize();
        this.failureThresholdSample = this.casProcessorCPEConfiguration.getErrorSampleSize();
        this.configuredErrorRate = this.casProcessorCPEConfiguration.getErrorRate();
        this.filterList = this.casProcessorCPEConfiguration.getFilter();
    }

    public ProcessingResourceMetaData getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ProcessingResourceMetaData aMetadata) {
        this.metadata = aMetadata;
        Capability[] capabilities = this.metadata.getCapabilities();
        for (int j = 0; capabilities != null && j < capabilities.length; ++j) {
            Capability capability = capabilities[j];
            TypeOrFeature[] tORf = capability.getInputs();
            if (tORf == null) continue;
            boolean modified = false;
            for (int i = 0; i < tORf.length; ++i) {
                String newKey = tORf[i].getName();
                if (tORf[i].getName().indexOf("-") > -1) {
                    newKey = StringUtils.replaceAll(tORf[i].getName(), "-", "_dash_");
                    modified = true;
                }
                if (tORf[i].getName().indexOf(":") > -1) {
                    newKey = StringUtils.replaceAll(tORf[i].getName(), ":", "_colon_");
                    modified = true;
                }
                if (!modified) continue;
                tORf[i].setName(newKey);
                modified = false;
            }
        }
    }

    public void setCasProcessorDeployer(CasProcessorDeployer aDeployer) {
        this.casPDeployer = aDeployer;
    }

    public CasProcessorDeployer getDeployer() {
        return this.casPDeployer;
    }

    private void deployLogger() {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_deploy_logger__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
        }
        this.logPath = this.casProcessorCPEConfiguration.getDeploymentParameter("containerLogPath");
        if (this.logPath != null && this.logPath.trim().length() > 0) {
            this.logger = Logger.getLogger("cpm.container." + this.getName(), null);
            try {
                if (this.logPath.indexOf("\\") > -1) {
                    char[] tmp = new char[this.logPath.length()];
                    for (int i = 0; i < this.logPath.length(); ++i) {
                        tmp[i] = this.logPath.charAt(i) == '\\' ? new Character(System.getProperty("file.separator").charAt(0)).charValue() : this.logPath.charAt(i);
                    }
                    this.logPath = new String(tmp);
                }
                if (this.logPath.lastIndexOf(System.getProperty("file.separator")) != this.logPath.length()) {
                    this.logPath = this.logPath + System.getProperty("file.separator");
                }
                FileHandler fh = new FileHandler(this.logPath + this.getName().replace(' ', '_') + ".log");
                Logger.getLogger("").addHandler(fh);
            }
            catch (Exception e) {
                this.logger = null;
                e.printStackTrace();
            }
        } else if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_logpath_not_defined__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
        }
    }

    public void logAbortedCases(Object[] abortedCasList) {
        if (!this.initialized) {
            this.initialized = true;
            this.deployLogger();
        }
        if (this.logger != null) {
            for (int i = 0; i < abortedCasList.length; ++i) {
                if (abortedCasList[i] == null || !(abortedCasList[i] instanceof CasData)) continue;
                String value = DATACasUtils.getFeatureValueByType((CasData)abortedCasList[i], "uima.cpm.DocumentMetadata", "ID");
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_log_docid__FINEST", new Object[]{Thread.currentThread().getName(), this.getName(), value});
                }
                this.logger.info(value);
            }
        }
    }

    private void resetSampleCounter() {
        this.sampleCounter = 0L;
    }

    private void resetBatchCounter() {
        this.batchCounter = 0L;
    }

    public long getBytesIn() {
        return this.bytesIn;
    }

    public void addBytesIn(long aBytesIn) {
        this.bytesIn += aBytesIn;
    }

    public long getBytesOut() {
        return this.bytesOut;
    }

    public void addBytesOut(long aBytesOut) {
        this.bytesOut += aBytesOut;
    }

    public void incrementRestartCount(int aCount) {
        this.restartCount += aCount;
    }

    public int getRestartCount() {
        return this.restartCount;
    }

    public void incrementRetryCount(int aCount) {
        this.retryCount += aCount;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void incrementAbortCount(int aCount) {
        this.abortCount += aCount;
    }

    public int getAbortCount() {
        return this.abortCount;
    }

    public void incrementFilteredCount(int aCount) {
        this.filteredCount += aCount;
    }

    public int getFilteredCount() {
        return this.filteredCount;
    }

    public synchronized long getRemaining() {
        return this.remaining;
    }

    public synchronized void setRemaining(long aRemainingCount) {
        this.remaining = aRemainingCount;
    }

    public void setLastProcessedEntityId(String aEntityId) {
        this.processedEntityIds.push(aEntityId);
    }

    public String getLastProcessedEntityId() {
        if (this.processedEntityIds.isEmpty()) {
            return "";
        }
        return (String)this.processedEntityIds.lastElement();
    }

    @Deprecated
    public void setLastCas(Object aCasObject) {
        this.lastCas = aCasObject;
    }

    @Deprecated
    public Object getLastCas() {
        return this.lastCas;
    }

    public void incrementProcessed(int aIncrement) {
        this.processed += (long)aIncrement;
    }

    public void setProcessed(long aProcessedCount) {
        this.processed = aProcessedCount;
    }

    public long getProcessed() {
        return this.processed;
    }

    private void resetErrorCounter() {
        this.errorCounter = 0;
    }

    public void resetRestartCount() {
        this.restartCount = 0;
    }

    public void incrementTotalTime(long aTime) {
        this.totalTime += aTime;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public boolean abortCPMOnError() {
        String action = this.casProcessorCPEConfiguration.getActionOnError();
        if (action == null) {
            return false;
        }
        return "terminate".equals(action.toLowerCase());
    }

    private boolean isTimeout(Throwable aThrowable) {
        Throwable cause = aThrowable.getCause().getCause();
        return cause != null && cause instanceof SocketTimeoutException;
    }

    public synchronized void incrementCasProcessorErrors(Throwable aThrowable) throws Exception {
        ++this.errorCounter;
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_increment_cp_errors__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
        }
        if (System.getProperty("DEBUG_EXCEPTIONS") != null && UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_cp_error_count__FINEST", new Object[]{Thread.currentThread().getName(), this.getName(), String.valueOf(this.errorCounter), aThrowable.getCause().getMessage()});
        }
        if (aThrowable instanceof ResourceProcessException) {
            if (aThrowable.getCause() instanceof AbortCPMException) {
                if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_abort_cpm__SEVERE", new Object[]{Thread.currentThread().getName(), this.getName()});
                }
                throw (AbortCPMException)aThrowable.getCause();
            }
            if (aThrowable.getCause() instanceof AbortCasProcessorException) {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_disable_cp__SEVERE", new Object[]{Thread.currentThread().getName(), this.getName()});
                }
                throw (AbortCasProcessorException)aThrowable.getCause();
            }
            if (this.errorCounter < this.configuredErrorRate && aThrowable.getCause() instanceof ServiceConnectionException && !this.isTimeout(aThrowable)) {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_service_connection_exception__SEVERE", new Object[]{Thread.currentThread().getName(), this.getName()});
                }
                ++this.restartCount;
                int rC = this.casProcessorCPEConfiguration.getMaxRetryCount();
                if (this.restartCount > rC) {
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_max_restart_reached__FINEST", new Object[]{Thread.currentThread().getName(), this.getName(), String.valueOf(rC)});
                    }
                    String actionOnMaxRestarts = this.casProcessorCPEConfiguration.getActionOnMaxRestart();
                    this.restartCount = 0;
                    if ("terminate".equals(actionOnMaxRestarts)) {
                        if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_terminate_due_to_action__SEVERE", new Object[]{Thread.currentThread().getName(), this.getName()});
                        }
                        throw new AbortCPMException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_configured_to_abort__WARNING", new Object[]{Thread.currentThread().getName(), this.getName()}));
                    }
                    if ("disable".equals(actionOnMaxRestarts)) {
                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_disable_due_to_action__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
                        }
                        throw new AbortCasProcessorException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_configured_to_disable__WARNING", new Object[]{Thread.currentThread().getName(), this.getName()}));
                    }
                    if ("kill-pipeline".equals(actionOnMaxRestarts)) {
                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_kill_pipeline__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
                        }
                        throw new KillPipelineException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_configured_to_kill_pipeline__WARNING", new Object[]{Thread.currentThread().getName(), this.getName()}));
                    }
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_skip_CAS__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
                    }
                    throw new SkipCasException("");
                }
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_force_reconnect__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
                }
                throw (ServiceConnectionException)aThrowable.getCause();
            }
            if (aThrowable.getCause() != null && UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_other_exception__FINEST", new Object[]{Thread.currentThread().getName(), this.getName(), aThrowable.getCause().getClass().getName()});
            }
        } else if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_no_resource_exception__FINEST", new Object[]{Thread.currentThread().getName(), this.getName(), aThrowable});
        }
        if (this.errorCounter > this.configuredErrorRate) {
            if (this.abortCPMOnError()) {
                if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_abort_exceeded_error_threshold__SEVERE", new Object[]{Thread.currentThread().getName(), this.getName(), String.valueOf(this.configuredErrorRate)});
                }
                throw new AbortCPMException("");
            }
            if (this.isAbortable()) {
                if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_disable_exceeded_error_threshold__SEVERE", new Object[]{Thread.currentThread().getName(), this.getName(), String.valueOf(this.configuredErrorRate)});
                }
                throw new AbortCasProcessorException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_configured_to_disable__WARNING", new Object[]{Thread.currentThread().getName(), this.getName()}));
            }
            this.resetErrorCounter();
            if (this.continueOnError()) {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_skipping_cas__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
                }
                throw new SkipCasException("");
            }
        }
    }

    public synchronized boolean isEndOfBatch(CasProcessor aCasProcessor, int aProcessedSize) throws ResourceProcessException, IOException {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_cp_batch_size__FINEST", new Object[]{Thread.currentThread().getName(), this.getName(), String.valueOf(this.batchSize)});
        }
        boolean eob = false;
        this.batchCounter += (long)aProcessedSize;
        this.sampleCounter += (long)aProcessedSize;
        if (this.sampleCounter > this.failureThresholdSample || this.sampleCounter % this.failureThresholdSample == 0L) {
            this.resetSampleCounter();
            this.resetErrorCounter();
        }
        if (this.remaining > 0L) {
            this.remaining -= (long)aProcessedSize;
        }
        this.processed += (long)aProcessedSize;
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_cp_doc_count__FINEST", new Object[]{Thread.currentThread().getName(), this.getName(), String.valueOf(this.processed)});
        }
        if (this.batchCounter > (long)this.batchSize || this.batchCounter % (long)this.batchSize == 0L) {
            if (aCasProcessor == null) {
                if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_cp_is_null__SEVERE", new Object[]{Thread.currentThread().getName(), this.getName()});
                }
                throw new ResourceProcessException(new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_invalid_reference__WARNING", new Object[]{Thread.currentThread().getName(), "NULL"})));
            }
            aCasProcessor.batchProcessComplete(new ProcessTrace_impl());
            this.resetBatchCounter();
            if (!this.processedEntityIds.isEmpty()) {
                String lastEntityId = (String)this.processedEntityIds.lastElement();
                this.processedEntityIds.clear();
                this.processedEntityIds.push(lastEntityId);
            }
            eob = true;
        }
        return eob;
    }

    public boolean processCas(Object[] aCasList) {
        if (aCasList == null) {
            return false;
        }
        boolean doProcess = false;
        for (int i = 0; i < aCasList.length; ++i) {
            if (!this.processCas(aCasList[i])) continue;
            doProcess = true;
            break;
        }
        return doProcess;
    }

    private boolean hasFeature(CasData aCas) {
        if (System.getProperty("DEBUG_FILTER") != null) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_check_filter__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
            }
            if (this.filterList == null) {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_filtering_disabled__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
                }
            } else if (this.filterList.size() == 0 && UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_filter_empty__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
            }
        }
        for (int i = 0; this.filterList != null && i < this.filterList.size(); ++i) {
            if (System.getProperty("DEBUG_FILTER") != null && UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_filter_enabled__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
            }
            Filter.Expression filterExpression = (Filter.Expression)this.filterList.get(i);
            String featureValue = DATACasUtils.getFeatureValueByType(aCas, filterExpression.getLeftPart().get());
            if (filterExpression.getRightPart() == null) {
                if (System.getProperty("DEBUG_FILTER") != null) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_filter_enabled_no_right_operand__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
                }
                boolean exists = DATACasUtils.hasFeatureStructure(aCas, filterExpression.getLeftPart().get());
                if (System.getProperty("DEBUG_FILTER") != null) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_filter_enabled_left_part__FINEST", new Object[]{Thread.currentThread().getName(), this.getName(), filterExpression.getLeftPart().get(), String.valueOf(exists)});
                }
                if ((filterExpression.getOperand() != null || filterExpression.getOperand().getOperand() != null || exists) && (!"!".equals(filterExpression.getOperand().getOperand()) || !exists)) continue;
                if (System.getProperty("DEBUG_FILTER") != null) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_filter_false__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
                }
                return false;
            }
            if (!("=".equals(filterExpression.getOperand().getOperand()) ? !filterExpression.getRightPart().get().equals(featureValue) : "!=".equals(filterExpression.getOperand().getOperand()) && filterExpression.getRightPart().get().equals(featureValue))) continue;
            return false;
        }
        return true;
    }

    private boolean processCas(Object aCas) {
        if (!(aCas instanceof CasData)) {
            return false;
        }
        if (DATACasUtils.isCasEmpty((CasData)aCas)) {
            return false;
        }
        return this.hasFeature((CasData)aCas);
    }

    public CasProcessorConfiguration getCasProcessorConfiguration() {
        return this.casProcessorCPEConfiguration;
    }

    @Deprecated
    public void start() {
        new Thread(this);
    }

    @Deprecated
    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CasProcessor getCasProcessor() {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, Thread.currentThread().getName());
        }
        Object object = this.lockForIsPaused;
        synchronized (object) {
            while (this.isPaused) {
                try {
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_container_paused__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
                    }
                    this.lockForIsPaused.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.isPaused || !UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_resuming_container__FINEST", new Object[]{Thread.currentThread().getName(), this.getName(), String.valueOf(100)});
            }
        }
        try {
            while (true) {
                long t = System.currentTimeMillis();
                ServiceProxyPool serviceProxyPool = this.casProcessorPool;
                synchronized (serviceProxyPool) {
                    CasProcessor processor = this.casProcessorPool.checkOut();
                    this.fetchTime += System.currentTimeMillis() - t;
                    if (processor != null) {
                        return processor;
                    }
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_wait_no_processor__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
                    }
                    this.casProcessorPool.wait();
                }
            }
        }
        catch (Exception e) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_failed_waiting_for_processor__SEVERE", new Object[]{Thread.currentThread().getName(), this.getName(), e.getMessage()});
            return null;
        }
    }

    public synchronized void releaseCasProcessor(CasProcessor aCasProcessor) {
        try {
            this.casProcessorPool.checkIn(aCasProcessor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getStatus() {
        return this.casProcessorStatus;
    }

    public void setStatus(int aStatus) {
        this.casProcessorStatus = aStatus;
    }

    @Deprecated
    public boolean isLocal() {
        return this.isLocal;
    }

    @Deprecated
    public boolean isRemote() {
        return this.isRemote;
    }

    @Deprecated
    public boolean isIntegrated() {
        return this.isIntegrated;
    }

    private boolean continueOnError() {
        String action = this.casProcessorCPEConfiguration.getActionOnError();
        return "continue".equals(action.toLowerCase());
    }

    public boolean isAbortable() {
        String anAction = "";
        try {
            anAction = this.casProcessorCPEConfiguration.getActionOnError();
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_cp_action_on_error__FINEST", new Object[]{Thread.currentThread().getName(), this.getName(), this.casProcessorCPEConfiguration.getActionOnError()});
            }
            if (anAction == null && UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_action_on_error_not_defined__SEVERE", new Object[]{Thread.currentThread().getName(), this.getName()});
            }
        }
        catch (Exception e) {
            if (this.casProcessorCPEConfiguration == null) {
                if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_cp_configuration_not_defined__SEVERE", new Object[]{Thread.currentThread().getName(), this.getName()});
                }
            }
            if (this.casProcessorCPEConfiguration.getActionOnError() == null) {
                if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_action_on_error_not_defined__SEVERE", new Object[]{Thread.currentThread().getName(), this.getName()});
                }
            }
            UIMAFramework.getLogger(this.getClass()).log(Level.SEVERE, e.getMessage(), e);
        }
        return anAction != null && "disable".equals(anAction.toLowerCase());
    }

    public boolean initialize(ResourceSpecifier aSpecifier, Map aAdditionalParams) throws ResourceInitializationException {
        try {
            if (aSpecifier instanceof CasConsumerDescription_impl) {
                CasConsumerDescription_impl mDescription = (CasConsumerDescription_impl)aSpecifier;
                this.configParams = mDescription.getMetaData().getConfigurationParameterSettings();
                if (aAdditionalParams != null) {
                    Set aKeySet = aAdditionalParams.keySet();
                    for (String aKey : aKeySet) {
                        this.setConfigParameterValue(aKey, aAdditionalParams.get(aKey));
                    }
                }
            }
        }
        catch (Exception fnfe) {
            fnfe.printStackTrace();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        block9: {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_cp_proxy_pool_size__FINEST", new Object[]{Thread.currentThread().getName(), this.getName(), String.valueOf(this.casProcessorPool.getSize())});
            }
            try {
                ServiceProxyPool serviceProxyPool = this.casProcessorPool;
                synchronized (serviceProxyPool) {
                    while (this.casProcessorPool.getSize() > 0) {
                        CasProcessor cp = this.casProcessorPool.checkOut(50L);
                        if (cp == null) {
                            if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) break;
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_wait_no_processor__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
                            break;
                        }
                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_destroy_processor__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
                        }
                        ProcessTrace_impl pt = new ProcessTrace_impl();
                        cp.collectionProcessComplete(pt);
                        if (!(cp instanceof Resource)) continue;
                        ((Resource)((Object)cp)).destroy();
                    }
                }
            }
            catch (Exception e) {
                if (!UIMAFramework.getLogger().isLoggable(Level.FINER)) break block9;
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINER, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_exception__FINER", new Object[]{Thread.currentThread().getName(), this.getName()});
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINER, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_exception__FINER", new Object[]{Thread.currentThread().getName(), e.getMessage()});
            }
        }
    }

    public void run() {
    }

    public Object getConfigParameterValue(String aParamName) {
        return this.configParams.getParameterValue(aParamName);
    }

    public Object getConfigParameterValue(String aGroupName, String aParamName) {
        return this.configParams.getParameterValue(aGroupName, aParamName);
    }

    public void setConfigParameterValue(String aParamName, Object aValue) {
        this.configParams.setParameterValue(aParamName, aValue);
    }

    public void setConfigParameterValue(String aGroupName, String aParamName, Object aValue) {
        this.configParams.setParameterValue(aGroupName, aParamName, aValue);
    }

    public void reconfigure() throws ResourceConfigurationException {
    }

    public String getName() {
        if (this.processorName == null) {
            this.processorName = this.metadata != null && "integrated".equalsIgnoreCase(this.casProcessorCPEConfiguration.getDeploymentType()) ? this.metadata.getName().trim() : this.casProcessorCPEConfiguration.getName().trim();
        }
        return this.processorName;
    }

    public ResourceMetaData getMetaData() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementStat(String aStatName, Integer aStat) {
        HashMap hashMap = this.statMap;
        synchronized (hashMap) {
            Object stat;
            if (this.statMap.containsKey(aStatName) && (stat = this.statMap.remove(aStatName)) instanceof Integer) {
                int newValue = aStat + (Integer)stat;
                aStat = newValue;
            }
            this.statMap.put(aStatName, aStat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStat(String aStatName, Object aStat) {
        HashMap hashMap = this.statMap;
        synchronized (hashMap) {
            if (this.statMap.containsKey(aStatName)) {
                this.statMap.remove(aStatName);
            }
            this.statMap.put(aStatName, aStat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getStat(String aStatName) {
        HashMap hashMap = this.statMap;
        synchronized (hashMap) {
            if (this.statMap.containsKey(aStatName)) {
                this.statMap.get(aStatName);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getAllStats() {
        HashMap hashMap = this.statMap;
        synchronized (hashMap) {
            return (HashMap)this.statMap.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_pause_container__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
        }
        Object object = this.lockForIsPaused;
        synchronized (object) {
            this.isPaused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.lockForIsPaused;
        synchronized (object) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_resuming_container__FINEST", new Object[]{Thread.currentThread().getName(), this.getName()});
            }
            this.isPaused = false;
            this.lockForIsPaused.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPaused() {
        Object object = this.lockForIsPaused;
        synchronized (object) {
            return this.isPaused;
        }
    }

    public ServiceProxyPool getPool() {
        return this.casProcessorPool;
    }

    public void setSingleFencedService(boolean aSingleFencedInstance) {
        this.singleFencedInstance = aSingleFencedInstance;
    }

    public boolean isSingleFencedService() {
        return this.singleFencedInstance;
    }

    public long getFetchTime() {
        return this.fetchTime;
    }
}

