/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.uima.analysis_engine.impl.RsFeat;
import org.apache.uima.analysis_engine.impl.RsFeats;
import org.apache.uima.analysis_engine.impl.RsLangs;
import org.apache.uima.analysis_engine.impl.RsType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RsTypesMap
implements Iterable<RsType> {
    private final Map<String, RsType> types;

    RsTypesMap() {
        this.types = new HashMap<String, RsType>();
    }

    RsTypesMap(RsTypesMap src) {
        this.types = new HashMap<String, RsType>(src.types);
        for (Map.Entry<String, RsType> e : this.types.entrySet()) {
            e.setValue(new RsType(e.getValue()));
        }
    }

    void add(String typeName, boolean isAllFeat, String[] languages, boolean replace) {
        RsType t = this.types.get(typeName);
        if (null == t) {
            t = new RsType(typeName);
            this.types.put(typeName, t);
        }
        if (isAllFeat) {
            if (!t.isAllFeatures) {
                replace = true;
            }
            t.isAllFeatures = true;
            t.languagesAllFeat = this.addLanguages(t.languagesAllFeat, languages, replace);
        } else {
            if (!t.isSpecified) {
                replace = true;
            }
            t.isSpecified = true;
            t.languagesNotAllFeat = this.addLanguages(t.languagesNotAllFeat, languages, replace);
        }
    }

    void add(String typeName, boolean isAllFeat, RsLangs rslangs, boolean replace) {
        RsType t = this.types.get(typeName);
        if (null == t) {
            t = new RsType(typeName);
            this.types.put(typeName, t);
        }
        if (isAllFeat) {
            if (!t.isAllFeatures) {
                replace = true;
            }
            t.isAllFeatures = true;
            t.languagesAllFeat = this.addLanguages(t.languagesAllFeat, rslangs, replace);
        } else {
            if (!t.isSpecified) {
                replace = true;
            }
            t.isSpecified = true;
            t.languagesNotAllFeat = this.addLanguages(t.languagesNotAllFeat, rslangs, replace);
        }
    }

    void add(String typeName, String shortFeatName, Object rslangs, boolean replace) {
        RsType t = this.types.get(typeName);
        if (null == t) {
            t = new RsType(typeName);
            this.types.put(typeName, t);
        }
        RsFeats feats = t.features;
        RsFeat feat = null;
        if (null == feats) {
            t.features = feats = new RsFeats();
        } else {
            feat = feats.get(shortFeatName);
        }
        if (null == feat) {
            feats.add(shortFeatName, rslangs);
        } else {
            feat.languages = this.addLanguages(feat.languages, rslangs, replace);
        }
    }

    RsLangs addLanguages(RsLangs existing, Object langs, boolean replace) {
        boolean noLangs;
        String[] saLangs = null;
        RsLangs rsLangs = null;
        if (langs instanceof String[]) {
            saLangs = (String[])langs;
        } else {
            rsLangs = (RsLangs)langs;
        }
        boolean bl = null == langs ? true : (null != saLangs ? 0 == ((String[])langs).length : (noLangs = RsLangs.isEmpty(rsLangs)));
        if (noLangs) {
            if (replace) {
                return null;
            }
            return existing;
        }
        if (null == existing && !replace) {
            return null;
        }
        if (replace) {
            if (saLangs != null) {
                return RsLangs.createOrNull(saLangs);
            }
            rsLangs.setShared();
            return rsLangs;
        }
        existing = null != saLangs ? RsLangs.addAll(existing, saLangs) : RsLangs.addAll(existing, rsLangs);
        return existing;
    }

    RsLangs addLanguages(RsLangs existing, RsLangs rslangs, boolean replace) {
        if (RsLangs.isEmpty(rslangs)) {
            if (replace) {
                return null;
            }
            return existing;
        }
        if (null == existing && !replace) {
            return null;
        }
        if (replace) {
            rslangs.setShared();
            return rslangs;
        }
        existing = RsLangs.addAll(existing, rslangs);
        return existing;
    }

    void remove(String type) {
        RsType t = this.types.get(type);
        if (null != t) {
            if (null == t.features || t.features.size() == 0) {
                this.types.remove(type);
                return;
            }
            t.isAllFeatures = false;
            t.isSpecified = false;
            t.languagesAllFeat = null;
            t.languagesNotAllFeat = null;
        }
    }

    void remove(String type, String feature) {
        RsType t = this.types.get(type);
        if (null != t && null != t.features) {
            t.features.remove(type, feature);
            if (0 == t.features.size()) {
                t.features = null;
                if (!t.isAllFeatures && !t.isSpecified) {
                    this.types.remove(type);
                }
            }
        }
    }

    RsType getRsType(String typeName) {
        return this.types.get(typeName);
    }

    RsFeat get(String typeName, String shortFeatName) {
        RsType t = this.types.get(typeName);
        if (t == null || t.features == null) {
            return null;
        }
        return t.features.get(shortFeatName);
    }

    int nbrOfTypes() {
        return this.types.size();
    }

    @Override
    public Iterator<RsType> iterator() {
        return this.types.values().iterator();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.types == null ? 0 : ((Object)this.types).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RsTypesMap other = (RsTypesMap)obj;
        return !(this.types == null ? other.types != null : !((Object)this.types).equals(other.types));
    }
}

