/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.xml;

import java.lang.reflect.InvocationTargetException;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.xml.ColorManager;
import org.apache.uima.taeconfigurator.editors.xml.XMLConfiguration;
import org.apache.uima.taeconfigurator.editors.xml.XMLDocumentProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class XMLEditor
extends TextEditor {
    MultiPageEditor editor;
    private ColorManager colorManager;
    private EditorsTextListener m_textListener = new EditorsTextListener();
    boolean m_bIgnoreTextEvent = false;

    public XMLEditor(MultiPageEditor editor) {
        this.colorManager = new ColorManager();
        this.setSourceViewerConfiguration(new XMLConfiguration(this.colorManager));
        this.setDocumentProvider((IDocumentProvider)new XMLDocumentProvider());
        this.editor = editor;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getSourceViewer().addTextListener((ITextListener)this.m_textListener);
    }

    public void dispose() {
        this.colorManager.dispose();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSaveAs() {
        IFile original;
        IProgressMonitor progressMonitor = this.getProgressMonitor();
        Shell shell = this.getSite().getShell();
        IEditorInput input = this.getEditorInput();
        SaveAsDialog dialog = new SaveAsDialog(shell);
        IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
        if (original != null) {
            dialog.setOriginalFile(original);
        }
        dialog.create();
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            return;
        }
        if (provider.isDeleted((Object)input) && original != null) {
            String message = "The original file, '" + original.getName() + "' has been deleted";
            dialog.setErrorMessage(null);
            dialog.setMessage(message, 2);
        }
        if (dialog.open() == 1) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            this.editor.setSaveAsStatus(-3);
            return;
        }
        IPath filePath = dialog.getResult();
        if (filePath == null) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            this.editor.setSaveAsStatus(-3);
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile file = workspace.getRoot().getFile(filePath);
        FileEditorInput newInput = new FileEditorInput(file);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation((IEditorInput)newInput){
            final /* synthetic */ IEditorInput val$newInput;
            {
                this.val$newInput = iEditorInput;
            }

            public void execute(IProgressMonitor monitor) throws CoreException {
                XMLEditor.this.getDocumentProvider().saveDocument(monitor, (Object)this.val$newInput, XMLEditor.this.getDocumentProvider().getDocument((Object)XMLEditor.this.getEditorInput()), true);
            }
        };
        boolean success = false;
        try {
            provider.aboutToChange((Object)newInput);
            new ProgressMonitorDialog(shell).run(false, true, (IRunnableWithProgress)op);
            success = true;
        }
        catch (InterruptedException x) {
        }
        catch (InvocationTargetException x) {
            Throwable targetException = x.getTargetException();
            String title = "Error saving";
            String msg = "Error occurred during save operation";
            if (targetException instanceof CoreException) {
                CoreException coreException = (CoreException)targetException;
                IStatus status = coreException.getStatus();
                if (status != null) {
                    switch (status.getSeverity()) {
                        case 1: {
                            MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
                            break;
                        }
                        case 2: {
                            MessageDialog.openWarning((Shell)shell, (String)title, (String)msg);
                            break;
                        }
                        default: {
                            MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                            break;
                        }
                    }
                } else {
                    MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                }
            }
        }
        finally {
            provider.changed((Object)newInput);
            if (success) {
                this.setInput((IEditorInput)newInput);
                this.editor.setSaveAsStatus(-4);
            } else {
                this.editor.setSaveAsStatus(-3);
            }
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    public void setIgnoreTextEvent(boolean bIgnoreTextEvent) {
        this.m_bIgnoreTextEvent = bIgnoreTextEvent;
    }

    public class EditorsTextListener
    implements ITextListener {
        public void textChanged(TextEvent event) {
            if (!XMLEditor.this.m_bIgnoreTextEvent) {
                XMLEditor.this.editor.sourceChanged = true;
                XMLEditor.this.editor.setFileDirty();
            }
        }
    }
}

