/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.files;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import org.apache.uima.taeconfigurator.CDEpropertyPage;
import org.apache.uima.taeconfigurator.InternalErrorCDE;
import org.apache.uima.taeconfigurator.Messages;
import org.apache.uima.taeconfigurator.TAEConfiguratorPlugin;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.ResourcePickerDialog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiResourceSelectionDialog
extends ResourcePickerDialog {
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private Button browseButton;
    private Button importByNameUI;
    private Button importByLocationUI;
    public boolean isImportByName;
    protected MultiPageEditor editor;
    private FilenameFilter onlyXml = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.endsWith(".xml");
        }
    };
    private FileFilter onlyDir = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };
    private static Map<String, Long> sawJar = new TreeMap<String, Long>();
    private static Map<String, List<CandidateAndSource>> cachedCs = new TreeMap<String, List<CandidateAndSource>>();

    public MultiResourceSelectionDialog(Shell parentShell, IAdaptable rootElement, String message, IPath aExcludeDescriptor, MultiPageEditor aEditor) {
        super(parentShell);
        this.editor = aEditor;
        String importByStickySetting = CDEpropertyPage.getImportByDefault(this.editor.getProject());
        this.isImportByName = importByStickySetting.equals("name");
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        FormToolkit factory = new FormToolkit(TAEConfiguratorPlugin.getDefault().getFormColors(parent.getDisplay()));
        Label label = new Label(composite, 64);
        label.setText(Messages.getString("MultiResourceSelectionDialog.Or"));
        this.browseButton = factory.createButton(composite, Messages.getString("MultiResourceSelectionDialog.BrowseFileSys"), 8);
        this.browseButton.setLayoutData((Object)new GridData(2));
        this.browseButton.pack(false);
        this.browseButton.addListener(4, new Listener(){

            public void handleEvent(Event event) {
                FileDialog dialog = new FileDialog(MultiResourceSelectionDialog.this.getShell(), 2);
                String[] extensions = new String[]{Messages.getString("MultiResourceSelectionDialog.starDotXml")};
                dialog.setFilterExtensions(extensions);
                String sStartDir = TAEConfiguratorPlugin.getWorkspace().getRoot().getLocation().toOSString();
                dialog.setFilterPath(sStartDir);
                String file = dialog.open();
                if (file != null && !file.equals("")) {
                    MultiResourceSelectionDialog.this.okPressed();
                    ArrayList<Path> list = new ArrayList<Path>();
                    Path iPath = new Path(file);
                    list.add(iPath);
                    MultiResourceSelectionDialog.this.localSetResult(list);
                }
            }
        });
        new Label(composite, 0).setText("");
        this.importByNameUI = new Button(composite, 16);
        this.importByNameUI.setText("Import by Name");
        this.importByNameUI.setToolTipText("Importing by name looks up the name on the datapath, and if not found there, on the classpath.");
        this.importByLocationUI = new Button(composite, 16);
        this.importByLocationUI.setText("Import By Location");
        this.importByLocationUI.setToolTipText("Importing by location requires a relative or absolute URL");
        String importByStickySetting = CDEpropertyPage.getImportByDefault(this.editor.getProject());
        if (importByStickySetting.equals("location")) {
            this.importByNameUI.setSelection(false);
            this.importByLocationUI.setSelection(true);
            this.isImportByName = false;
        } else {
            this.importByNameUI.setSelection(true);
            this.importByLocationUI.setSelection(false);
            this.isImportByName = true;
        }
        if (this.importByNameUI.getSelection()) {
            this.setupResourcesByName();
        }
        this.importByLocationUI.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (MultiResourceSelectionDialog.this.importByLocationUI.getSelection()) {
                    MultiResourceSelectionDialog.this.isImportByName = false;
                    CDEpropertyPage.setImportByDefault(MultiResourceSelectionDialog.this.editor.getProject(), "location");
                    MultiResourceSelectionDialog.this.setupResourcesByLocation();
                    MultiResourceSelectionDialog.this.browseButton.setEnabled(true);
                }
            }
        });
        this.importByNameUI.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (MultiResourceSelectionDialog.this.importByNameUI.getSelection()) {
                    MultiResourceSelectionDialog.this.isImportByName = true;
                    CDEpropertyPage.setImportByDefault(MultiResourceSelectionDialog.this.editor.getProject(), "name");
                    MultiResourceSelectionDialog.this.setupResourcesByName();
                }
            }
        });
        return composite;
    }

    @Override
    protected void setupResourcesByLocation() {
        if (!this.isImportByName) {
            super.setupResourcesByLocation();
        }
    }

    private void setupResourcesByName() {
        CandidateAndSource[] candidates;
        this.resourcesUI.removeAll();
        this.resourcesUI.removeListener(17, (Listener)this);
        this.resourcesUI.removeListener(13, (Listener)this);
        this.resourcesUI.setHeaderVisible(true);
        this.resourcesUIc1.setWidth(400);
        this.resourcesUIc1.setText("by-name xml resource");
        this.resourcesUIc2.setWidth(400);
        this.resourcesUIc2.setText("source of by-name resource");
        for (CandidateAndSource c : candidates = this.computeByNameCandidates()) {
            TreeItem item = new TreeItem(this.resourcesUI, 0, 0);
            item.setText(new String[]{c.candidate, c.source});
            item.setData((Object)c.candidate);
        }
        this.resourcesUI.addListener(13, (Listener)this);
        this.browseButton.setEnabled(false);
    }

    @Override
    public void copyValuesFromGUI() {
        if (this.resourcesUI.getSelectionCount() > 0) {
            if (this.importByLocationUI.getSelection()) {
                super.copyValuesFromGUI();
                return;
            }
            this.result = new Object[]{this.resourcesUI.getSelection()[0].getData()};
        }
    }

    private CandidateAndSource[] computeByNameCandidates() {
        String cp;
        try {
            cp = this.editor.getFilteredProjectClassPath(false);
        }
        catch (CoreException e) {
            throw new InternalErrorCDE("unhandled CoreException while getting classpaths to populate by-location list", e);
        }
        String[] cps = cp.split(PATH_SEPARATOR);
        ArrayList<CandidateAndSource> candidates = new ArrayList<CandidateAndSource>(100);
        for (String jarOrDir : cps) {
            if (jarOrDir.toLowerCase().endsWith(".jar")) {
                this.addJarCandidates(jarOrDir, candidates, jarOrDir);
                continue;
            }
            this.addClassCandidates(new File(jarOrDir), candidates, "", jarOrDir);
        }
        Object[] result = candidates.toArray(new CandidateAndSource[candidates.size()]);
        Arrays.sort(result);
        return result;
    }

    private void addClassCandidates(File dir, List<CandidateAndSource> candidates, String prefix, String source) {
        if (null == dir) {
            return;
        }
        String[] xmlFileNames = dir.list(this.onlyXml);
        if (null == xmlFileNames) {
            return;
        }
        for (String xmlFileName : xmlFileNames) {
            candidates.add(new CandidateAndSource(prefix + xmlFileName, source));
        }
        File[] subdirs = dir.listFiles(this.onlyDir);
        if (null == subdirs) {
            return;
        }
        for (File subdir : subdirs) {
            String nextPrefix = prefix + subdir.getName() + "/";
            this.addClassCandidates(subdir, candidates, nextPrefix, source);
        }
    }

    private void addJarCandidates(String jarPath, List<CandidateAndSource> candidates, String source) {
        Long fileLastModified = new File(jarPath).lastModified();
        Long lastModified = sawJar.get(jarPath);
        List<CandidateAndSource> css = cachedCs.get(jarPath);
        if (fileLastModified <= 0L || lastModified == null || lastModified.longValue() != fileLastModified.longValue() || null == css) {
            JarInputStream jarIn;
            css = new ArrayList<CandidateAndSource>();
            try {
                jarIn = new JarInputStream(new BufferedInputStream(new FileInputStream(jarPath)));
            }
            catch (FileNotFoundException e) {
                return;
            }
            catch (IOException e) {
                throw new InternalErrorCDE("unhandled IOException while reading Jar in classpath to populate by-location list", e);
            }
            try {
                ZipEntry entry;
                while (null != (entry = jarIn.getNextEntry())) {
                    String name = entry.getName();
                    if (name.startsWith("META-INF") || !name.endsWith(".xml")) continue;
                    css.add(new CandidateAndSource(name, source));
                }
            }
            catch (IOException e) {
                throw new InternalErrorCDE("unhandled IOException while getting next Jar Entry to populate by-location list", e);
            }
            sawJar.put(jarPath, fileLastModified);
            cachedCs.put(jarPath, css);
        }
        candidates.addAll(css);
    }

    protected void localSetResult(ArrayList list) {
        this.setResult(list);
    }

    @Override
    public void enableOK() {
        this.okButton.setEnabled(false);
        if (0 < this.resourcesUI.getSelectionCount()) {
            if (this.importByLocationUI.getSelection()) {
                if (this.resourcesUI.getSelection()[0].getData() instanceof IFile) {
                    this.okButton.setEnabled(true);
                }
            } else {
                this.okButton.setEnabled(true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CandidateAndSource
    implements Comparable<CandidateAndSource> {
        String candidate;
        String source;

        CandidateAndSource(String aCandidate, String aSource) {
            this.candidate = aCandidate;
            this.source = aSource;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.candidate == null ? 0 : this.candidate.hashCode());
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CandidateAndSource other = (CandidateAndSource)obj;
            if (this.candidate == null ? other.candidate != null : !this.candidate.equals(other.candidate)) {
                return false;
            }
            return !(this.source == null ? other.source != null : !this.source.equals(other.source));
        }

        @Override
        public int compareTo(CandidateAndSource o) {
            int r = o.candidate.compareTo(this.candidate);
            if (r == 0) {
                return o.source.compareTo(this.source);
            }
            return r;
        }
    }
}

