/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.uima.analysis_engine.TypeOrFeature;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.taeconfigurator.TAEConfiguratorPlugin;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.FindComponentDialog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.swt.widgets.Display;

public class SearchThread
implements Runnable {
    private Pattern m_fileNameSearch;
    private Pattern m_inputTypeSearch;
    private Pattern m_outputTypeSearch;
    private String m_projectToSearch;
    FindComponentDialog m_dialog;
    private AbstractSection m_aggregateSection;
    private List m_matchingDelegateComponentDescriptors;
    private List m_matchingDelegateComponentDescriptions;
    int m_nWhichStatusMsg;
    String m_statusMsg;
    private String[] m_componentHeaders;
    private boolean m_bDieNow = false;
    private boolean m_bDone = false;
    private static final boolean INPUT = true;
    private static final boolean OUTPUT = false;

    public SearchThread(FindComponentDialog dialog, AbstractSection aggregateSection, String fileNameSearch, String inputTypeSearch, String outputTypeSearch, String projectToSearch, String[] componentHeaders) {
        this.m_dialog = dialog;
        this.m_aggregateSection = aggregateSection;
        this.m_fileNameSearch = null == fileNameSearch ? null : Pattern.compile(fileNameSearch);
        this.m_inputTypeSearch = null == inputTypeSearch ? null : Pattern.compile(inputTypeSearch);
        this.m_outputTypeSearch = null == outputTypeSearch ? null : Pattern.compile(outputTypeSearch);
        this.m_projectToSearch = projectToSearch;
        this.m_componentHeaders = componentHeaders;
    }

    public void setDieNow() {
        this.m_bDieNow = true;
    }

    public boolean getDieNow() {
        return this.m_bDieNow;
    }

    public boolean isDone() {
        return this.m_bDone;
    }

    public void run() {
        this.m_matchingDelegateComponentDescriptors = new ArrayList();
        this.m_matchingDelegateComponentDescriptions = new ArrayList();
        this.getDelegateComponentsByInputOutputTypes(this.m_projectToSearch);
        this.m_bDone = true;
    }

    private void testOneResource(IResource resource) {
        switch (resource.getType()) {
            case 1: {
                if (!resource.getName().toLowerCase().endsWith(".xml") || resource.getName().toLowerCase().endsWith(".txt.xml") || this.m_fileNameSearch != null && !this.m_fileNameSearch.matcher(resource.getName()).find()) break;
                String fileDescriptorRelPath = this.m_aggregateSection.editor.getDescriptorRelativePath(resource.getLocation().toString());
                this.setStatusMsg(2, "Examining " + this.getBriefDisplayVersion(fileDescriptorRelPath));
                ResourceSpecifier rs = MultiPageEditor.getDelegateResourceSpecifier((IFile)resource, this.m_componentHeaders);
                if (null == rs) {
                    return;
                }
                if (!(rs instanceof ResourceCreationSpecifier || this.m_inputTypeSearch == null && this.m_outputTypeSearch == null)) {
                    return;
                }
                if (rs instanceof ResourceCreationSpecifier && !this.delegateComponentMatchesCapabilityReqs((ResourceCreationSpecifier)rs, this.m_inputTypeSearch, this.m_outputTypeSearch)) break;
                this.m_matchingDelegateComponentDescriptors.add(fileDescriptorRelPath);
                this.m_matchingDelegateComponentDescriptions.add(rs);
                break;
            }
            case 2: {
                this.getDelegateComponentsByIOTypesBeginningAt((IFolder)resource);
            }
        }
    }

    private void getDelegateComponentsByInputOutputTypes(String projectToSearch) {
        IWorkspace workspace = TAEConfiguratorPlugin.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        if (projectToSearch.equals("All projects")) {
            this.setStatusMsg(1, "0 of " + projects.length + " projects processed.");
        }
        for (int i = 0; i < projects.length; ++i) {
            try {
                if (!projectToSearch.equals("All projects") && !projects[i].getName().equals(projectToSearch)) continue;
                if (projectToSearch.equals("All projects")) {
                    this.setStatusMsg(2, "Looking in " + projects[i].getName() + "....");
                } else {
                    this.setStatusMsg(2, "Searching " + projects[i].getName() + " for matching TAEs...");
                }
                IResource[] projectContents = projects[i].members();
                for (int j = 0; j < projectContents.length; ++j) {
                    this.testOneResource(projectContents[j]);
                }
                if (!projectToSearch.equals("All projects")) continue;
                this.setStatusMsg(1, i + 1 + " of " + projects.length + " projects processed.");
                continue;
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
        }
    }

    private void getDelegateComponentsByIOTypesBeginningAt(IFolder beginFolder) {
        if (this.m_bDieNow) {
            return;
        }
        try {
            for (int i = 0; i < beginFolder.members().length; ++i) {
                this.testOneResource(beginFolder.members()[i]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean delegateComponentMatchesCapabilityReqs(ResourceCreationSpecifier rs, Pattern inputTypeSearch, Pattern outputTypeSearch) {
        if (inputTypeSearch == null && outputTypeSearch == null) {
            return true;
        }
        Capability[] capabilities = AbstractSection.getCapabilities((ResourceSpecifier)rs);
        if (capabilities == null || capabilities.length == 0) {
            return false;
        }
        boolean inputSatisfied = this.matchCapabilitiesTo(capabilities, inputTypeSearch, true);
        boolean outputSatisfied = this.matchCapabilitiesTo(capabilities, outputTypeSearch, false);
        return inputSatisfied && outputSatisfied;
    }

    private boolean matchCapabilitiesTo(Capability[] capabilities, Pattern search, boolean isInput) {
        if (null == search) {
            return true;
        }
        for (int i = 0; i < capabilities.length; ++i) {
            TypeOrFeature[] typeOrFeatures;
            TypeOrFeature[] typeOrFeatureArray = typeOrFeatures = isInput ? capabilities[i].getInputs() : capabilities[i].getOutputs();
            if (null == typeOrFeatures) continue;
            for (int j = 0; j < typeOrFeatures.length; ++j) {
                if (!search.matcher(typeOrFeatures[j].getName()).find()) continue;
                return true;
            }
        }
        return false;
    }

    public List getMatchingDelegateComponentDescriptors() {
        return this.m_matchingDelegateComponentDescriptors;
    }

    public List getMatchingDelegateComponentDescriptions() {
        return this.m_matchingDelegateComponentDescriptions;
    }

    private void setStatusMsg(int nWhich, String msg) {
        this.m_nWhichStatusMsg = nWhich;
        this.m_statusMsg = msg;
        if (this.m_dialog.getStatusLabel1().isDisposed()) {
            return;
        }
        Display display = this.m_dialog.getStatusLabel1().getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                if (SearchThread.this.m_nWhichStatusMsg == 1) {
                    SearchThread.this.m_dialog.getStatusLabel1().setText(SearchThread.this.m_statusMsg);
                } else {
                    SearchThread.this.m_dialog.getStatusLabel2().setText(SearchThread.this.m_statusMsg);
                }
            }
        });
    }

    private String getBriefDisplayVersion(String filePathName) {
        if (filePathName == null) {
            return null;
        }
        filePathName = AbstractSection.maybeShortenFileName(filePathName);
        return filePathName;
    }
}

