/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import java.util.List;
import org.apache.uima.analysis_engine.TypeOrFeature;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.taeconfigurator.CDEpropertyPage;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class PickTaeForTypesDialog
extends AbstractDialog {
    private List m_DelegateComponentDescriptors;
    private List m_delegateComponentDescriptions;
    private String[] m_selectedDelegateComponentDescriptors;
    private String m_aggregateFileName;
    private Text delegateComponentDescriptionText;
    org.eclipse.swt.widgets.List delegateComponentListGUI;
    private org.eclipse.swt.widgets.List inputTypesList;
    private org.eclipse.swt.widgets.List outputTypesList;
    private DialogSelectionListener dialogSelectionListener = new DialogSelectionListener();
    private Button importByNameUI;
    private Button importByLocationUI;
    public boolean isImportByName;

    public PickTaeForTypesDialog(AbstractSection aSection, String aggregateFileName, List delegateComponentDescriptors, List delegateComponentDescriptions) {
        super(aSection, "Select Delegate Component Descriptor(s)", "Select one or more delegate components to add and press OK");
        this.m_aggregateFileName = aggregateFileName;
        this.m_DelegateComponentDescriptors = delegateComponentDescriptors;
        this.m_delegateComponentDescriptions = delegateComponentDescriptions;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label specialMsgLabel = new Label(composite, 64);
        AbstractSection.spacer(composite);
        this.createWideLabel(composite, "Delegate Components:");
        this.delegateComponentListGUI = new org.eclipse.swt.widgets.List(composite, 2562);
        GridData gridData = new GridData(768);
        gridData.heightHint = 100;
        this.delegateComponentListGUI.setLayoutData((Object)gridData);
        boolean bContainsConstituentsAlreadyInAggregate = false;
        boolean bContainsAggregate = false;
        for (int i = 0; i < this.m_DelegateComponentDescriptors.size(); ++i) {
            String sAdditional = "";
            if (this.m_aggregateFileName.equals(this.m_DelegateComponentDescriptors.get(i))) {
                sAdditional = "**";
                bContainsAggregate = true;
            }
            this.delegateComponentListGUI.add((String)this.m_DelegateComponentDescriptors.get(i) + sAdditional);
        }
        this.delegateComponentListGUI.addSelectionListener((SelectionListener)this.dialogSelectionListener);
        if (bContainsConstituentsAlreadyInAggregate && bContainsAggregate) {
            specialMsgLabel.setText("(* indicates delegate component is already part of aggregate, ** is aggregate currently being configured)");
        } else if (bContainsConstituentsAlreadyInAggregate) {
            specialMsgLabel.setText("(* indicates delegate component is already part of aggregate)");
        } else if (bContainsAggregate) {
            specialMsgLabel.setText("(** is aggregate currently being configured)");
        }
        this.createWideLabel(composite, "Delegate Component Description:");
        this.delegateComponentDescriptionText = new Text(composite, 2626);
        this.delegateComponentDescriptionText.setLayoutData((Object)new GridData(1808));
        GridData dcgd = new GridData(768);
        dcgd.heightHint = 50;
        this.delegateComponentDescriptionText.setLayoutData((Object)dcgd);
        this.delegateComponentDescriptionText.setEditable(false);
        this.createWideLabel(composite, "Input Types:");
        this.inputTypesList = new org.eclipse.swt.widgets.List(composite, 2560);
        this.inputTypesList.setLayoutData((Object)new GridData(768));
        this.createWideLabel(composite, "Output Types:");
        this.outputTypesList = new org.eclipse.swt.widgets.List(composite, 2560);
        this.outputTypesList.setLayoutData((Object)new GridData(768));
        this.importByNameUI = this.newButton(composite, 16, "Import by Name", "Importing by name looks up the name on the classpath and datapath.");
        this.importByLocationUI = this.newButton(composite, 16, "Import by Location", "Importing by location requires a relative or absolute URL");
        String defaultBy = CDEpropertyPage.getImportByDefault(this.editor.getProject());
        if (defaultBy.equals("location")) {
            this.importByNameUI.setSelection(false);
            this.importByLocationUI.setSelection(true);
        } else {
            this.importByNameUI.setSelection(true);
            this.importByLocationUI.setSelection(false);
        }
        return composite;
    }

    public void update() {
        int nSelectedAeIndex = this.delegateComponentListGUI.getSelectionIndices()[0];
        ResourceSpecifier rs = (ResourceSpecifier)this.m_delegateComponentDescriptions.get(nSelectedAeIndex);
        String description = rs instanceof ResourceCreationSpecifier ? ((ResourceCreationSpecifier)rs).getMetaData().getDescription() : "No Description - remote service descriptor";
        this.delegateComponentDescriptionText.setText(PickTaeForTypesDialog.convertNull(description));
        this.inputTypesList.removeAll();
        this.outputTypesList.removeAll();
        Capability[] capabilities = AbstractSection.getCapabilities(rs);
        if (capabilities != null && capabilities.length > 0) {
            TypeOrFeature[] outputs;
            TypeOrFeature[] inputs = capabilities[0].getInputs();
            if (inputs != null) {
                for (int i = 0; i < inputs.length; ++i) {
                    if (!inputs[i].isType()) continue;
                    this.inputTypesList.add(this.section.formatName(inputs[i].getName()));
                }
            }
            if ((outputs = capabilities[0].getOutputs()) != null) {
                for (int i = 0; i < outputs.length; ++i) {
                    if (!outputs[i].isType()) continue;
                    this.outputTypesList.add(this.section.formatName(outputs[i].getName()));
                }
            }
        }
        if (this.okButton != null) {
            this.enableOK();
        }
    }

    public void enableOK() {
        boolean bEnableOk = false;
        String[] selections = this.delegateComponentListGUI.getSelection();
        for (int i = 0; i < selections.length; ++i) {
            if (selections[i].endsWith("*")) continue;
            bEnableOk = true;
            i = selections.length;
        }
        this.okButton.setEnabled(bEnableOk);
    }

    public String[] getSelectedDelegateComponentDescriptors() {
        return (String[])this.m_selectedDelegateComponentDescriptors.clone();
    }

    public void copyValuesFromGUI() {
        int i;
        int[] selIndices = this.delegateComponentListGUI.getSelectionIndices();
        int nRealCount = 0;
        for (i = 0; i < selIndices.length; ++i) {
            if (this.delegateComponentListGUI.getItem(selIndices[i]).endsWith("*")) continue;
            ++nRealCount;
        }
        this.m_selectedDelegateComponentDescriptors = new String[nRealCount];
        int j = 0;
        for (i = 0; i < selIndices.length; ++i) {
            if (this.delegateComponentListGUI.getItem(selIndices[i]).endsWith("*")) continue;
            this.m_selectedDelegateComponentDescriptors[j] = (String)this.m_DelegateComponentDescriptors.get(selIndices[i]);
        }
        this.isImportByName = this.importByNameUI.getSelection();
        CDEpropertyPage.setImportByDefault(this.editor.getProject(), this.isImportByName ? "name" : "location");
    }

    public boolean isValid() {
        return true;
    }

    public class DialogSelectionListener
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            if (e.widget == PickTaeForTypesDialog.this.delegateComponentListGUI) {
                PickTaeForTypesDialog.this.update();
            } else if (PickTaeForTypesDialog.this.okButton != null) {
                PickTaeForTypesDialog.this.enableOK();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

