/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.ParameterSection;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialogKeyVerifyJavaNames;
import org.apache.uima.taeconfigurator.model.ConfigGroup;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class AddParameterDialog
extends AbstractDialogKeyVerifyJavaNames {
    private StyledText parmNameUI;
    private StyledText extParmNameUI;
    public Button multiValueUI;
    private Button mandatoryUI;
    public CCombo parmTypeUI;
    private Text descriptionUI;
    public String parmName;
    public String extParmName;
    public boolean multiValue;
    public boolean mandatory;
    public String parmType;
    public String description;
    private ParameterSection parmSection;
    private ConfigurationParameter existingCP;
    private String originalParmName;
    private ConfigGroup configGroup;

    private AddParameterDialog(AbstractSection aSection) {
        super(aSection, "Add Parameter", "Specify a parameter name && type");
        this.parmSection = (ParameterSection)this.section;
    }

    public AddParameterDialog(AbstractSection aSection, ConfigurationParameter aExistingCP) {
        this(aSection);
        this.existingCP = aExistingCP;
    }

    public AddParameterDialog(AbstractSection aSection, ConfigGroup cg) {
        this(aSection);
        this.configGroup = cg;
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainArea = (Composite)super.createDialogArea(parent, this.existingCP);
        this.createWideLabel(mainArea, "Parameter names must be unique within this descriptor");
        Composite twoCol = this.new2ColumnComposite(mainArea);
        this.parmNameUI = this.newLabeledSingleLineStyledText(twoCol, "Parameter Name", "The unique name of the parameter");
        this.parmTypeUI = this.newLabeledCCombo(twoCol, "Parameter Type", "Select the type of the parameter from the pull-down list");
        this.parmTypeUI.add("String");
        this.parmTypeUI.add("Float");
        this.parmTypeUI.add("Integer");
        this.parmTypeUI.add("Boolean");
        this.descriptionUI = this.newDescription(twoCol, "Description of parameter (optional)");
        this.extParmNameUI = this.newLabeledSingleLineStyledText(twoCol, "External Override", "External overrides allow a parameter's value to be overriden by an entry in\nan external settings file, independent of the descriptor hierarchy (optional)");
        this.multiValueUI = this.newButton(mainArea, 32, "Parameter is multi-valued", "Check the box if the parameter is multi-valued");
        this.mandatoryUI = this.newButton(mainArea, 32, "Parameter is mandatory", "Check the box if the parameter is mandatory");
        if (this.section.isAggregate()) {
            this.multiValueUI.setEnabled(false);
            this.parmTypeUI.setEnabled(false);
        }
        this.newErrorMessage(mainArea);
        if (null != this.existingCP) {
            this.descriptionUI.setText(AddParameterDialog.convertNull(this.existingCP.getDescription()));
            this.multiValueUI.setSelection(this.existingCP.isMultiValued());
            this.mandatoryUI.setSelection(this.existingCP.isMandatory());
            this.parmNameUI.setText(AddParameterDialog.convertNull(this.existingCP.getName()));
            this.parmTypeUI.setText(AddParameterDialog.convertNull(this.existingCP.getType()));
            this.extParmNameUI.setText(AddParameterDialog.convertNull(this.existingCP.getExternalOverrideName()));
        }
        this.originalParmName = this.parmNameUI.getText();
        return mainArea;
    }

    public void copyValuesFromGUI() {
        this.parmName = this.parmNameUI.getText();
        this.multiValue = this.multiValueUI.getSelection();
        this.mandatory = this.mandatoryUI.getSelection();
        this.description = AddParameterDialog.nullIf0lengthString(this.descriptionUI.getText());
        this.parmType = this.parmTypeUI.getText();
        this.extParmName = AddParameterDialog.nullIf0lengthString(this.extParmNameUI.getText());
    }

    public boolean isValid() {
        if (this.parmName.length() == 0) {
            return false;
        }
        if (!this.parmName.equals(this.originalParmName) && this.parmSection.parameterNameAlreadyDefined(this.parmName, this.configGroup)) {
            return false;
        }
        return this.parmType.length() != 0;
    }

    public void enableOK() {
        this.copyValuesFromGUI();
        this.okButton.setEnabled(this.parmName.length() > 0 && this.parmType.length() > 0);
    }
}

