/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import org.apache.uima.cas.Type;
import org.apache.uima.resource.metadata.FeatureDescription;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.TypeSection;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialogKeyVerify;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.TypesWithNameSpaces;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;

public class AddFeatureDialog
extends AbstractDialogKeyVerify {
    private static final int ONLY_NON_PRIMITIVE_TYPES = 0;
    private static final int ALL_TYPES = 1;
    private StyledText featureNameUI;
    private Text featureRangeNameUI;
    private Text descriptionUI;
    public String featureName;
    private String originalFeatureName;
    public String featureRangeName;
    public String description;
    public String elementRangeName;
    public Boolean multiRef;
    private TypeSection typeSection;
    private TypeDescription td;
    private FeatureDescription existingFd;
    private TypesWithNameSpaces allTypesList;
    private Composite multiRefComposite;
    private CCombo multiRefUI;
    private Composite elementTypeComposite;
    private Text elementRangeNameUI;
    private int typeFilter;

    public AddFeatureDialog(AbstractSection aSection, TypeDescription aTd, FeatureDescription aExistingFd) {
        super(aSection, "Add a Feature", "Use this panel to add or edit a feature");
        this.typeSection = (TypeSection)aSection;
        this.td = aTd;
        this.existingFd = aExistingFd;
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainArea = (Composite)super.createDialogArea(parent, this.existingFd);
        this.createWideLabel(mainArea, "The feature name must be unique within this type");
        Composite twoCol = this.new2ColumnComposite(mainArea);
        this.featureNameUI = this.newLabeledSingleLineStyledText(twoCol, "Feature Name", "");
        this.typeFilter = 1;
        this.featureRangeNameUI = this.newLabeledTypeInput(this.section, twoCol, "Range Type:", "The range type specifies the type of value this feature can hold.");
        this.multiRefComposite = this.new2ColumnComposite(twoCol);
        ((GridData)this.multiRefComposite.getLayoutData()).horizontalSpan = 2;
        this.multiRefUI = this.newLabeledCCombo(this.multiRefComposite, "References:", "Specify if this reference is the only reference to the collection object");
        this.multiRefUI.add("Not Specified - defaults to multiple references not allowed");
        this.multiRefUI.add("Multiple references not allowed");
        this.multiRefUI.add("Multiple references allowed");
        this.multiRefUI.select(0);
        this.elementTypeComposite = this.new2ColumnComposite(twoCol);
        ((GridData)this.elementTypeComposite.getLayoutData()).horizontalSpan = 2;
        this.typeFilter = 0;
        this.elementRangeNameUI = this.newLabeledTypeInput(this.section, this.elementTypeComposite, "Element Type:", "The element type of each element in the Array or List object");
        this.descriptionUI = this.newDescription(twoCol, "");
        this.newErrorMessage(twoCol, 2);
        if (null != this.existingFd) {
            this.descriptionUI.setText(AddFeatureDialog.convertNull(this.existingFd.getDescription()));
            this.originalFeatureName = this.existingFd.getName();
            this.featureNameUI.setText(this.originalFeatureName);
            this.featureRangeNameUI.setText(this.existingFd.getRangeTypeName());
            Boolean mra = this.existingFd.getMultipleReferencesAllowed();
            this.multiRefUI.select(null == mra ? 0 : (mra != false ? 2 : 1));
            String ert = this.existingFd.getElementType();
            this.elementRangeNameUI.setText(null == ert ? "" : ert);
        }
        this.manageVisibleFields();
        return mainArea;
    }

    private void manageVisibleFields() {
        String range = this.featureRangeNameUI.getText();
        if (AbstractSection.isArrayOrListType(range)) {
            this.multiRefComposite.setVisible(true);
            if (AbstractSection.isFSArrayOrListType(range)) {
                this.elementTypeComposite.setVisible(true);
            } else {
                this.elementTypeComposite.setVisible(false);
            }
        } else {
            this.multiRefComposite.setVisible(false);
            this.elementTypeComposite.setVisible(false);
        }
    }

    public void handleEvent(Event event) {
        super.handleEvent(event);
        if (event.type == 24 && event.widget == this.featureRangeNameUI) {
            this.manageVisibleFields();
        }
    }

    public TypesWithNameSpaces getTypeSystemInfoList() {
        TypesWithNameSpaces result = super.getTypeSystemInfoList();
        Type[] allTypes = this.editor.allTypes.get().values().toArray(new Type[0]);
        for (int i = 0; i < allTypes.length; ++i) {
            Type type = allTypes[i];
            if (this.typeFilter == 0) {
                if (type.isPrimitive()) continue;
                result.add(type.getName());
                continue;
            }
            result.add(type.getName());
        }
        if (this.typeFilter == 1) {
            this.allTypesList = result;
        }
        return result;
    }

    public void copyValuesFromGUI() {
        this.featureName = this.featureNameUI.getText();
        this.description = AddFeatureDialog.nullIf0lengthString(this.descriptionUI.getText());
        this.featureRangeName = this.featureRangeNameUI.getText();
        Boolean bl = 1 == this.multiRefUI.getSelectionIndex() ? Boolean.FALSE : (this.multiRef = 2 == this.multiRefUI.getSelectionIndex() ? Boolean.TRUE : null);
        if (TypeSection.isFSArrayOrListType(this.featureRangeName)) {
            this.elementRangeName = this.elementRangeNameUI.getText();
            if ("".equals(this.elementRangeName)) {
                this.elementRangeName = null;
            }
        } else {
            this.elementRangeName = null;
        }
    }

    public boolean verifyKeyChecks(VerifyEvent event) {
        if (event.keyCode == 13 || event.keyCode == 9) {
            return true;
        }
        if (Character.isJavaIdentifierPart(event.character)) {
            return true;
        }
        return event.widget == this.featureRangeNameUI && event.character == '.';
    }

    public boolean isValid() {
        String errMsg;
        if (this.featureName.length() == 0 || this.featureRangeName.length() == 0) {
            return false;
        }
        if (!this.featureName.equals(this.originalFeatureName) && null != (errMsg = this.typeSection.checkFeature(this, this.td, this.existingFd))) {
            this.setErrorMessage(errMsg);
            return false;
        }
        if (!this.typeContainedInTypeSystemInfoList(this.featureRangeName, this.allTypesList)) {
            this.setErrorMessage("RangeType '" + this.featureRangeName + "' is unknown. If this is intended, please define it first.");
            return false;
        }
        return true;
    }

    public void textModifyCallback(Event e) {
        this.manageVisibleFields();
    }

    public void enableOK() {
        this.copyValuesFromGUI();
        this.okButton.setEnabled(this.featureName.length() > 0 && this.featureRangeName.length() > 0);
    }
}

