/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import org.apache.uima.resource.metadata.AllowedValue;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialogKeyVerify;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class AddAllowedValueDialog
extends AbstractDialogKeyVerify {
    private StyledText allowedValueUI;
    private Text descriptionUI;
    public String allowedValue;
    public String description;
    private AllowedValue existingAv;

    public AddAllowedValueDialog(AbstractSection aSection, AllowedValue aExistingAv) {
        super(aSection, "Add an Allowed Value for a String subtype", "Use this panel to add or edit an allowed value.  The allowed value is any string.");
        this.existingAv = aExistingAv;
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainArea = (Composite)super.createDialogArea(parent, this.existingAv);
        Composite twoCol = this.new2ColumnComposite(mainArea);
        this.allowedValueUI = this.newLabeledSingleLineStyledText(twoCol, "Allowed Value", "A literal string value which this string is allowed to have");
        this.descriptionUI = this.newDescription(twoCol, "Description of the allowed value");
        this.newErrorMessage(twoCol, 2);
        if (null != this.existingAv) {
            this.descriptionUI.setText(AddAllowedValueDialog.convertNull(this.existingAv.getDescription()));
            this.allowedValueUI.setText(AddAllowedValueDialog.convertNull(this.existingAv.getString()));
        }
        return mainArea;
    }

    public void copyValuesFromGUI() {
        this.allowedValue = this.allowedValueUI.getText();
        this.description = AddAllowedValueDialog.nullIf0lengthString(this.descriptionUI.getText());
    }

    public boolean isValid() {
        return this.allowedValue.length() != 0;
    }

    public void enableOK() {
        this.copyValuesFromGUI();
        this.okButton.setEnabled(this.allowedValue.length() > 0);
    }
}

