/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.FsIndexKeyDescription;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.IndexImportSection;
import org.apache.uima.taeconfigurator.editors.ui.Utility;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AddIndexDialog;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AddIndexKeyDialog;
import org.apache.uima.taeconfigurator.wizards.FsIndexCollectionNewWizard;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.IManagedForm;

public class IndexSection
extends AbstractSection {
    public static final String ANNOTATION_INDEX_BUILT_IN = "Annotation Index (Built-in)";
    public static final int INDEX_NAME_COL = 0;
    public static final int INDEX_TYPE_COL = 1;
    public static final int ASC_DES_COL = 1;
    public static final int INDEX_KIND_COL = 2;
    public TableTree tt;
    private Button addIndexButton;
    private Button addKeyButton;
    private Button editButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    FsIndexDescription m_builtInIndexDescription = null;
    private Button exportButton;
    private IndexImportSection indexImportSection;

    public IndexSection(MultiPageEditor editor, Composite parent) {
        super(editor, parent, "Indexes", "The following indexes are defined on the type system for this engine.");
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        Composite sectionClient = this.new2ColumnComposite((Composite)this.getSection());
        this.enableBorders(sectionClient);
        this.tt = this.newTableTree(sectionClient, 65540);
        Table table = this.tt.getTable();
        table.setHeaderVisible(true);
        this.newTableColumn(table).setText("Name");
        this.newTableColumn(table).setText("Type");
        this.newTableColumn(table).setText("Kind");
        Composite buttonContainer = this.newButtonContainer(sectionClient);
        this.addIndexButton = this.newPushButton(buttonContainer, "Add Index", "Click here to add a new index.");
        this.addKeyButton = this.newPushButton(buttonContainer, "Add Key", "Click here to add a new key for the selected index.");
        this.editButton = this.newPushButton(buttonContainer, "Edit...", "Click here to edit the selected item. You can also double-click the item to edit it.");
        this.removeButton = this.newPushButton(buttonContainer, "Remove", "Click here to remove the selected item.  You can also use the delete key.");
        this.upButton = this.newPushButton(buttonContainer, "Up", "Click here to move the selected item up by one.");
        this.downButton = this.newPushButton(buttonContainer, "Down", "Click here to move the selected item down by one.");
        this.exportButton = this.newPushButton(buttonContainer, "Export...", "Export to an importable part, and substitute an Import for that part here");
        table.addListener(32, (Listener)this);
        this.toolkit.paintBordersFor(sectionClient);
    }

    public void refresh() {
        if (null == this.indexImportSection) {
            this.indexImportSection = this.editor.getIndexesPage().getIndexImportSection();
        }
        super.refresh();
        this.tt.removeAll();
        this.updateIndexSpec(new TableTreeItem(this.tt, 0), this.getBuiltInIndexDescription());
        FsIndexDescription[] fsIndexes = this.getAnalysisEngineMetaData().getFsIndexes();
        if (fsIndexes != null) {
            for (int i = 0; i < fsIndexes.length; ++i) {
                this.updateIndexSpec(new TableTreeItem(this.tt, 0), fsIndexes[i]);
            }
        }
        this.packTable(this.tt.getTable());
        this.enable();
    }

    private void updateIndexSpec(TableTreeItem item, FsIndexDescription ndx) {
        item.setText(0, ndx.getLabel());
        item.setText(1, this.formatName(ndx.getTypeName()));
        item.setText(2, IndexSection.handleDefaultIndexKind(ndx.getKind()));
        item.setData((Object)ndx);
        this.removeChildren(item);
        FsIndexKeyDescription[] keys = ndx.getKeys();
        if (null != keys) {
            for (int i = 0; i < keys.length; ++i) {
                this.updateKeySpec(new TableTreeItem(item, 0), keys[i]);
            }
        }
    }

    private void updateKeySpec(TableTreeItem item, FsIndexKeyDescription key) {
        String name = key.getFeatureName();
        item.setText(0, null == name ? "TYPE PRIORITY" : name);
        item.setText(1, key.getComparator() == 0 ? "Standard" : "Reverse");
        item.setData((Object)key);
    }

    public FsIndexKeyDescription createFsIndexKeyDescription() {
        return UIMAFramework.getResourceSpecifierFactory().createFsIndexKeyDescription();
    }

    public FsIndexDescription getBuiltInIndexDescription() {
        if (this.m_builtInIndexDescription == null) {
            this.m_builtInIndexDescription = UIMAFramework.getResourceSpecifierFactory().createFsIndexDescription();
            this.m_builtInIndexDescription.setLabel(ANNOTATION_INDEX_BUILT_IN);
            this.m_builtInIndexDescription.setTypeName("uima.tcas.Annotation");
            this.m_builtInIndexDescription.setKind("sorted");
            FsIndexKeyDescription[] keys = new FsIndexKeyDescription[]{this.createFsIndexKeyDescription(), this.createFsIndexKeyDescription(), this.createFsIndexKeyDescription()};
            keys[0].setFeatureName("begin");
            keys[0].setComparator(0);
            keys[1].setFeatureName("end");
            keys[1].setComparator(1);
            keys[2].setTypePriority(true);
            this.m_builtInIndexDescription.setKeys(keys);
        }
        return this.m_builtInIndexDescription;
    }

    private boolean notAllowed(String message) {
        if (this.isIndexDescriptor() && !this.editor.getIsContextLoaded()) {
            Utility.popMessage("Not Allowed", "Editing or Adding Indexes can't be done here because the information about the type system is missing.", 2);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        if (event.widget == this.addIndexButton) {
            if (this.notAllowed("Adding an Index")) {
                return;
            }
            AddIndexDialog dialog = new AddIndexDialog(this);
            if (dialog.open() == 1) {
                return;
            }
            FsIndexDescription id = UIMAFramework.getResourceSpecifierFactory().createFsIndexDescription();
            id.setLabel(dialog.indexName);
            id.setTypeName(dialog.indexType);
            id.setKeys(dialog.keys);
            id.setKind(dialog.indexKind);
            this.addFsIndexDescription(id);
            this.updateIndexSpec(new TableTreeItem(this.tt, 0), id);
            this.tt.getTable().setSelection(this.tt.getTable().getItemCount() - 1);
            this.packTable(this.tt.getTable());
            this.setFileDirty();
        } else if (event.widget == this.addKeyButton) {
            if (this.notAllowed("Adding an Index")) {
                return;
            }
            TableTreeItem parent = this.tt.getSelection()[0];
            if (null != parent.getParentItem()) {
                parent = parent.getParentItem();
            }
            if (this.foolingAroundWithAnnotationIndex(parent)) {
                return;
            }
            FsIndexDescription fsid = IndexSection.getFsIndexDescriptionFromTableTreeItem(parent);
            AddIndexKeyDialog dialog = new AddIndexKeyDialog(this, fsid.getTypeName(), IndexSection.handleDefaultIndexKind(fsid.getKind()), this.getAlreadyUsedFeatures(fsid));
            FsIndexKeyDescription newKey = this.addOrEditIndexKey(dialog, null);
            if (null != newKey) {
                this.addFsIndexKeyDescription(fsid, newKey);
                this.updateKeySpec(new TableTreeItem(parent, 0), newKey);
                parent.setExpanded(true);
                this.setFileDirty();
            }
        } else if (event.widget == this.removeButton) {
            TableTreeItem item = this.tt.getSelection()[0];
            if (this.foolingAroundWithAnnotationIndex(item)) {
                return;
            }
            Object o = item.getData();
            if (o instanceof FsIndexDescription) {
                if (1 == Utility.popOkCancel("Confirm Remove", "Do you want to remove this index?", 4)) {
                    return;
                }
                this.removeFsIndexDescription((FsIndexDescription)o);
            } else {
                if (1 == Utility.popOkCancel("Confirm Remove", "Do you want to remove this key?", 4)) {
                    return;
                }
                TableTreeItem parent = item.getParentItem();
                FsIndexDescription fsid = IndexSection.getFsIndexDescriptionFromTableTreeItem(parent);
                this.removeFsIndexKeyDescription(fsid, (FsIndexKeyDescription)o);
            }
            this.tt.getTable().setSelection(this.tt.getTable().getSelectionIndex() - 1);
            item.dispose();
            this.setFileDirty();
        } else if (event.widget == this.editButton || event.type == 8) {
            if (this.notAllowed("Adding an Index")) {
                return;
            }
            if (this.tt.getSelectionCount() != 1) {
                return;
            }
            TableTreeItem item = this.tt.getSelection()[0];
            if (this.foolingAroundWithAnnotationIndex(item)) {
                return;
            }
            Object o = item.getData();
            if (o instanceof FsIndexDescription) {
                FsIndexDescription fsid = (FsIndexDescription)o;
                AddIndexDialog dialog = new AddIndexDialog(this, fsid);
                if (dialog.open() == 1) {
                    return;
                }
                this.valueChanged = false;
                fsid.setLabel(this.setValueChanged(dialog.indexName, fsid.getLabel()));
                fsid.setTypeName(this.setValueChanged(dialog.indexType, fsid.getTypeName()));
                fsid.setKeys(this.setValueChangedKeys(dialog.keys, fsid.getKeys()));
                fsid.setKind(this.setValueChanged(dialog.indexKind, IndexSection.handleDefaultIndexKind(fsid.getKind())));
                this.updateIndexSpec(item, fsid);
                if (this.valueChanged) {
                    this.packTable(this.tt.getTable());
                    this.setFileDirty();
                }
            } else {
                if (this.notAllowed("Adding an Index")) {
                    return;
                }
                FsIndexKeyDescription key = (FsIndexKeyDescription)o;
                TableTreeItem parent = item.getParentItem();
                FsIndexDescription fsid = IndexSection.getFsIndexDescriptionFromTableTreeItem(parent);
                AddIndexKeyDialog dialog = new AddIndexKeyDialog(this, fsid.getTypeName(), IndexSection.handleDefaultIndexKind(fsid.getKind()), this.getAlreadyUsedFeatures(fsid), key);
                this.valueChanged = false;
                this.addOrEditIndexKey(dialog, key);
                if (this.valueChanged) {
                    this.updateKeySpec(item, key);
                    this.packTable(this.tt.getTable());
                    this.setFileDirty();
                }
            }
        } else if (event.widget == this.upButton) {
            int i = IndexSection.getIndex(this.tt.getSelection()[0]);
            IndexSection.swapIndexKeys(this.tt.getSelection()[0], i - 1);
            this.setFileDirty();
        } else if (event.widget == this.downButton) {
            int i = IndexSection.getIndex(this.tt.getSelection()[0]);
            TableTreeItem[] items = this.tt.getSelection()[0].getParentItem().getItems();
            IndexSection.swapIndexKeys(items[i + 1], i + 1);
        } else if (event.widget == this.exportButton) {
            try {
                this.indexImportSection.exportImportablePart("<fsIndexCollection>", FsIndexCollectionNewWizard.FSINDEXCOLLECTION_TEMPLATE);
            }
            finally {
                this.refresh();
            }
        }
        this.enable();
    }

    private boolean foolingAroundWithAnnotationIndex(TableTreeItem item) {
        while (null != item.getParentItem()) {
            item = item.getParentItem();
        }
        if (ANNOTATION_INDEX_BUILT_IN.equals(item.getText(0))) {
            Utility.popMessage("Not Allowed", "You cannot edit or delete the built-in Annotation Index or its keys", 1);
            return true;
        }
        return false;
    }

    public void addFsIndexKeyDescription(FsIndexDescription fsid, FsIndexKeyDescription key) {
        FsIndexKeyDescription[] prevKeys = fsid.getKeys();
        FsIndexKeyDescription[] newKeys = new FsIndexKeyDescription[prevKeys == null ? 1 : prevKeys.length + 1];
        if (null != prevKeys) {
            System.arraycopy(prevKeys, 0, newKeys, 0, prevKeys.length);
        }
        newKeys[newKeys.length - 1] = key;
        fsid.setKeys(newKeys);
    }

    public void addFsIndexDescription(FsIndexDescription fsid) {
        FsIndexDescription[] oldFsIndexes = this.getAnalysisEngineMetaData().getFsIndexes();
        FsIndexDescription[] newFsIndexes = new FsIndexDescription[oldFsIndexes == null ? 1 : oldFsIndexes.length + 1];
        if (null != oldFsIndexes) {
            System.arraycopy(oldFsIndexes, 0, newFsIndexes, 0, oldFsIndexes.length);
        }
        newFsIndexes[newFsIndexes.length - 1] = fsid;
        this.getAnalysisEngineMetaData().setFsIndexes(newFsIndexes);
    }

    public void removeFsIndexDescription(FsIndexDescription fsid) {
        this.getAnalysisEngineMetaData().setFsIndexes((FsIndexDescription[])Utility.removeElementFromArray(this.getAnalysisEngineMetaData().getFsIndexes(), fsid, FsIndexDescription.class));
    }

    public void removeFsIndexKeyDescription(FsIndexDescription fsid, FsIndexKeyDescription key) {
        fsid.setKeys((FsIndexKeyDescription[])Utility.removeElementFromArray(fsid.getKeys(), key, FsIndexKeyDescription.class));
    }

    public List getAlreadyUsedFeatures(FsIndexDescription ndx) {
        ArrayList<String> result = new ArrayList<String>();
        FsIndexKeyDescription[] items = ndx.getKeys();
        if (null == items) {
            return result;
        }
        for (int i = 0; i < items.length; ++i) {
            result.add(items[i].getFeatureName());
        }
        return result;
    }

    public FsIndexKeyDescription addOrEditIndexKey(AddIndexKeyDialog dialog, FsIndexKeyDescription key) {
        if (dialog.open() == 1) {
            return null;
        }
        if (null == key) {
            key = UIMAFramework.getResourceSpecifierFactory().createFsIndexKeyDescription();
        }
        if (dialog.typePriority) {
            key.setTypePriority(this.setValueChangedBoolean(true, key.isTypePriority()));
            key.setFeatureName(null);
        } else {
            key.setFeatureName(this.setValueChanged(dialog.featureName, key.getFeatureName()));
            key.setComparator(this.setValueChangedInt(dialog.direction, key.getComparator()));
            key.setTypePriority(false);
        }
        return key;
    }

    public boolean isDuplicateIndexLabel(String indexLabel) {
        FsIndexDescription[] indexes = this.getAnalysisEngineMetaData().getFsIndexes();
        if (indexes == null) {
            return false;
        }
        for (int i = 0; i < indexes.length; ++i) {
            if (!indexes[i].getLabel().equals(indexLabel)) continue;
            return true;
        }
        return false;
    }

    public void enable() {
        boolean selected = this.tt.getSelectionCount() == 1;
        TableTreeItem item = null;
        TableTreeItem parent = null;
        if (selected) {
            item = this.tt.getSelection()[0];
            parent = item.getParentItem();
        }
        boolean notBuiltInSelected = selected && item != this.tt.getItems()[0];
        boolean bl = null == parent || parent != this.tt.getItems()[0];
        this.addIndexButton.setEnabled(true);
        this.addKeyButton.setEnabled((notBuiltInSelected &= bl) && (null != parent || !"bag".equals(item.getText(2))));
        this.editButton.setEnabled(notBuiltInSelected);
        this.removeButton.setEnabled(notBuiltInSelected);
        this.exportButton.setEnabled(this.tt.getItemCount() > 1);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        if (selected && null != parent && notBuiltInSelected) {
            TableTreeItem firstItem = parent.getItems()[0];
            TableTreeItem lastItem = parent.getItems()[parent.getItems().length - 1];
            this.upButton.setEnabled(item != firstItem);
            this.downButton.setEnabled(item != lastItem);
        }
    }
}

