/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import java.text.MessageFormat;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.metadata.FlowConstraints;
import org.apache.uima.analysis_engine.metadata.FlowControllerDeclaration;
import org.apache.uima.analysis_engine.metadata.impl.CapabilityLanguageFlow_impl;
import org.apache.uima.analysis_engine.metadata.impl.FixedFlow_impl;
import org.apache.uima.analysis_engine.metadata.impl.FlowControllerDeclaration_impl;
import org.apache.uima.flow.FlowControllerDescription;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.taeconfigurator.Messages;
import org.apache.uima.taeconfigurator.TAEConfiguratorPlugin;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.FileAndShortName;
import org.apache.uima.taeconfigurator.editors.ui.Utility;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.FindComponentDialog;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.PickTaeForTypesDialog;
import org.apache.uima.taeconfigurator.files.MultiResourceSelectionDialog;
import org.apache.uima.taeconfigurator.model.FlowNodes;
import org.apache.uima.util.XMLizable;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.IManagedForm;

public class FlowSection
extends AbstractSection {
    public static final String FIXED_FLOW = "Fixed Flow";
    public static final String CAPABILITY_LANGUAGE_FLOW = "Capability Language Flow";
    public static final String USER_DEFINED_FLOW = "User-defined Flow";
    private CCombo flowControllerChoice;
    Table flowList;
    private Button upButton;
    private Button downButton;
    private Label flowControllerGUI;
    private Button specifyFlowControllerImportButton;
    private Button findFlowControllerDescriptorButton;
    private Label flowControllerLabel;
    private Label flowControllerKeyLabel;
    private Label flowControllerKeyGUI;
    private Label flowChoiceLabel;
    private boolean bDisableToolTipHelp;
    private static final String[] flowControllerHeadersLC = new String[]{"<flowcontrollerdescription"};

    public FlowSection(MultiPageEditor aEditor, Composite parent) {
        super(aEditor, parent, Messages.getString("FlowSection.ComponentEngineFlowTitle"), Messages.getString("FlowSection.ComponentEngineFlowDescription"));
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        Composite sectionClient = this.new2ColumnComposite((Composite)this.getSection());
        ((GridData)sectionClient.getLayoutData()).grabExcessHorizontalSpace = false;
        this.flowChoiceLabel = this.newLabelWithTip(sectionClient, Messages.getString("FlowSection.FlowKind"), Messages.getString("FlowSection.FlowKindTip"));
        this.flowControllerChoice = this.newCComboWithTip(sectionClient, Messages.getString("FlowSection.FlowKindTip"));
        this.flowControllerChoice.add(FIXED_FLOW);
        this.flowControllerChoice.add(CAPABILITY_LANGUAGE_FLOW);
        this.flowControllerChoice.add(USER_DEFINED_FLOW);
        Composite comp2 = this.new2ColumnComposite(sectionClient);
        ((GridData)comp2.getLayoutData()).horizontalSpan = 2;
        ((GridData)comp2.getLayoutData()).grabExcessVerticalSpace = false;
        Composite comp2a = this.new2ColumnComposite(comp2);
        Composite fcButtonContainer = this.newButtonContainer(comp2, 1, 0);
        this.flowControllerLabel = this.newLabelWithTip(comp2a, "Flow Controller:", "The XML descriptor for the Custom Flow Controller");
        this.flowControllerGUI = this.newUnUpdatableTextWithTip(comp2a, "", "The XML descriptor for the Custom Flow Controller");
        this.flowControllerGUI.addListener(3, (Listener)this);
        this.flowControllerGUI.addListener(32, (Listener)this);
        this.flowControllerKeyLabel = this.newLabelWithTip(comp2a, "Key Name:", "A unique key name for this Flow Controller");
        this.flowControllerKeyGUI = this.newUnUpdatableTextWithTip(comp2a, "", "A unique key name for this Flow Controller");
        this.specifyFlowControllerImportButton = this.newPushButton(fcButtonContainer, "Browse...", "Click here to specify a locally defined Flow Controller", true);
        this.findFlowControllerDescriptorButton = this.newPushButton(fcButtonContainer, "Search", "Click here to search for a Flow Controller", true);
        Composite flowComposite = this.new2ColumnComposite(sectionClient);
        ((GridData)flowComposite.getLayoutData()).horizontalSpan = 2;
        this.enableBorders(flowComposite);
        this.toolkit.paintBordersFor(flowComposite);
        this.flowList = this.newTable(flowComposite, 65536, 0);
        Composite buttonContainer = this.newButtonContainer(flowComposite, 1, 70);
        this.upButton = this.newPushButton(buttonContainer, "Up", Messages.getString("FlowSection.upTip"), false);
        this.downButton = this.newPushButton(buttonContainer, "Down", Messages.getString("FlowSection.downTip"), false);
        this.enableBorders(sectionClient);
        this.toolkit.paintBordersFor(sectionClient);
    }

    public void refresh() {
        super.refresh();
        this.flowList.removeAll();
        if (!this.isAggregate()) {
            this.getSection().setText(Messages.getString("FlowSection.notUsed"));
            this.getSection().setDescription(Messages.getString("FlowSection.onlyForAggregates"));
        } else {
            this.getSection().setText(Messages.getString("FlowSection.ComponentEngineFlowTitle"));
            this.getSection().setDescription(Messages.getString("FlowSection.ComponentEngineFlowDescription"));
            FlowControllerDeclaration fcd = this.getFlowControllerDeclaration();
            this.flowList.setEnabled(true);
            FlowConstraints flowConstraints = this.getModelFlow();
            FlowNodes nodesModel = new FlowNodes(flowConstraints);
            String[] nodes = nodesModel.getFlow();
            if (null == nodes) {
                nodes = stringArray0;
                nodesModel.setFlow(stringArray0);
            }
            for (int i = 0; i < nodes.length; ++i) {
                TableItem item = new TableItem(this.flowList, 0);
                item.setImage(TAEConfiguratorPlugin.getImage("annotator.gif"));
                item.setText(0, nodes[i]);
            }
            this.packTable(this.flowList);
            if (null == fcd) {
                String modelFlowType;
                if (null == flowConstraints) {
                    FixedFlow_impl ff = new FixedFlow_impl();
                    flowConstraints = ff;
                    this.getAnalysisEngineMetaData().setFlowConstraints((FlowConstraints)ff);
                    ff.setFixedFlow(stringArray0);
                }
                this.flowControllerChoice.setText((modelFlowType = flowConstraints.getFlowConstraintsType()).equals("CAPABILITY_LANGUAGE") ? CAPABILITY_LANGUAGE_FLOW : FIXED_FLOW);
                this.enableFlowControllerGUI(false);
            } else {
                this.refreshFcd(fcd);
            }
        }
        this.enable();
    }

    private void refreshFcd(FlowControllerDeclaration fcd) {
        String keyName;
        this.enableFlowControllerGUI(true);
        if (null == fcd.getKey() || "".equals(fcd.getKey())) {
            keyName = "Warning: no key name is specified";
            this.flowControllerKeyGUI.setToolTipText("Use Source tab below to specify a key name in the <flowController> element, or the imported <flowController>");
        } else {
            keyName = fcd.getKey();
        }
        this.flowControllerKeyGUI.setText(keyName);
        Import fcdImport = fcd.getImport();
        String fileName = null;
        if (null != fcdImport && (null == (fileName = fcdImport.getLocation()) || 0 == fileName.length())) {
            fileName = fcdImport.getName();
        }
        this.flowControllerGUI.setText(null == fileName ? "Warning: no <import> in <flowController>" : fileName);
        this.flowControllerChoice.setText(USER_DEFINED_FLOW);
        this.flowControllerGUI.getParent().redraw();
    }

    private void enableFlowControllerGUI(boolean enableState) {
        this.flowControllerLabel.setEnabled(enableState);
        this.flowControllerGUI.setEnabled(enableState);
        this.specifyFlowControllerImportButton.setEnabled(enableState);
        this.findFlowControllerDescriptorButton.setEnabled(enableState);
        this.flowControllerKeyLabel.setEnabled(enableState);
        this.flowControllerKeyGUI.setEnabled(enableState);
    }

    private FlowConstraints getModelFlow() {
        return this.getAnalysisEngineMetaData().getFlowConstraints();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.flowControllerChoice) {
            String prevFlowType;
            String flowTypeGUI = this.flowControllerChoice.getText();
            if (null == flowTypeGUI || flowTypeGUI.equals("")) {
                return;
            }
            FlowControllerDeclaration fcd = this.getFlowControllerDeclaration();
            FlowConstraints modelFlow = this.getModelFlow();
            String prevFlowTypeGUI = null != fcd ? USER_DEFINED_FLOW : (null == modelFlow ? "" : ("CAPABILITY_LANGUAGE".equals(prevFlowType = modelFlow.getFlowConstraintsType()) ? CAPABILITY_LANGUAGE_FLOW : FIXED_FLOW));
            if (prevFlowTypeGUI.equals(flowTypeGUI)) {
                return;
            }
            CapabilityLanguageFlow_impl clf = null;
            FixedFlow_impl ff = null;
            String[] nodes = new FlowNodes(modelFlow).getFlow();
            if (flowTypeGUI.equals(CAPABILITY_LANGUAGE_FLOW)) {
                this.setFlowControllerDeclaration(null);
                clf = new CapabilityLanguageFlow_impl();
                this.getAnalysisEngineMetaData().setFlowConstraints((FlowConstraints)clf);
                clf.setCapabilityLanguageFlow(nodes);
            } else if (flowTypeGUI.equals(FIXED_FLOW)) {
                this.setFlowControllerDeclaration(null);
                ff = new FixedFlow_impl();
                this.getAnalysisEngineMetaData().setFlowConstraints((FlowConstraints)ff);
                ff.setFixedFlow(nodes);
            } else if (flowTypeGUI.equals(USER_DEFINED_FLOW)) {
                FlowControllerDeclaration_impl newFcd = new FlowControllerDeclaration_impl();
                this.setFlowControllerDeclaration((FlowControllerDeclaration)newFcd);
                this.refreshFcd((FlowControllerDeclaration)newFcd);
                ff = new FixedFlow_impl();
                this.getAnalysisEngineMetaData().setFlowConstraints((FlowConstraints)ff);
                ff.setFixedFlow(nodes);
            }
            this.enable();
            this.setFileDirty();
        } else if (event.widget == this.upButton) {
            String[] nodes = new FlowNodes(this.getModelFlow()).getFlow();
            int selection = this.flowList.getSelectionIndex();
            if (selection == 0) {
                return;
            }
            String temp = nodes[selection - 1];
            nodes[selection - 1] = nodes[selection];
            nodes[selection] = temp;
            this.finishFlowAction();
            this.flowList.setSelection(selection - 1);
            this.enable();
        } else if (event.widget == this.downButton) {
            String[] nodes = new FlowNodes(this.getModelFlow()).getFlow();
            int selection = this.flowList.getSelectionIndex();
            if (selection == this.flowList.getItemCount() - 1) {
                return;
            }
            String temp = nodes[selection + 1];
            nodes[selection + 1] = nodes[selection];
            nodes[selection] = temp;
            this.finishFlowAction();
            this.flowList.setSelection(selection + 1);
            this.enable();
        } else if (event.widget == this.specifyFlowControllerImportButton) {
            this.handleSpecifyFlowController();
        } else if (event.widget == this.findFlowControllerDescriptorButton) {
            this.handleFindFlowController();
        } else if (event.widget == this.flowControllerGUI && event.type == 3 && event.button == 3) {
            this.handleContextMenuRequest(event);
        } else if (event.widget == this.flowControllerGUI && event.type == 32 && !this.bDisableToolTipHelp) {
            this.handleHoverHelp(event);
        } else if (event.widget == this.flowList) {
            if (event.type == 13) {
                this.enable();
            }
            if (event.character == '\u007f' && this.flowList.getSelectionIndex() > -1) {
                this.handleRemove();
            }
        }
    }

    private void handleHoverHelp(Event event) {
        String sDesc = "";
        FlowControllerDeclaration fcd = this.editor.getResolvedFlowControllerDeclaration();
        String text = this.flowControllerGUI.getText();
        if (null != fcd && !"".equals(text) && null != fcd.getSpecifier()) {
            sDesc = this.getDescriptionForDescriptor(this.flowControllerGUI.getText(), fcd.getSpecifier());
        }
        this.flowControllerGUI.setToolTipText(sDesc);
    }

    private void handleContextMenuRequest(Event event) {
        Import imp = this.getFlowControllerDeclaration().getImport();
        this.bDisableToolTipHelp = true;
        this.requestPopUpOverImport(imp, (Control)this.flowControllerGUI, event);
        this.bDisableToolTipHelp = false;
    }

    private void finishFlowAction() {
        this.setFileDirty();
        this.refresh();
    }

    public void handleRemove() {
        int removedItemIndex = this.flowList.getSelectionIndex();
        String[] nodes = new FlowNodes(this.getModelFlow()).getFlow();
        int origItemCount = nodes.length;
        for (int i = removedItemIndex + 1; i < origItemCount; ++i) {
            nodes[i - 1] = nodes[i];
        }
        String[] newNodes = new String[origItemCount - 1];
        if (newNodes.length > 0) {
            System.arraycopy(nodes, 0, newNodes, 0, newNodes.length);
        }
        new FlowNodes(this.getModelFlow()).setFlow(newNodes);
        this.finishFlowAction();
        this.flowList.setSelection(removedItemIndex - 1);
        this.enable();
    }

    public void addNode(String node) {
        FlowNodes flowNodes;
        String[] nodes;
        FlowConstraints flowConstraints = this.getModelFlow();
        if (null == flowConstraints) {
            flowConstraints = UIMAFramework.getResourceSpecifierFactory().createFixedFlow();
            this.getAnalysisEngineMetaData().setFlowConstraints(flowConstraints);
        }
        if ((nodes = (flowNodes = new FlowNodes(flowConstraints)).getFlow()) == null) {
            nodes = new String[]{node};
            flowNodes.setFlow(nodes);
        } else {
            String[] newNodes = new String[nodes.length + 1];
            System.arraycopy(nodes, 0, newNodes, 0, nodes.length);
            newNodes[newNodes.length - 1] = node;
            flowNodes.setFlow(newNodes);
        }
        this.finishFlowAction();
    }

    public void enable() {
        if (!this.isAggregate()) {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
            this.flowChoiceLabel.setEnabled(false);
            this.flowControllerChoice.setEnabled(false);
            this.enableFlowControllerGUI(false);
        } else {
            FlowControllerDeclaration fcd = this.getFlowControllerDeclaration();
            this.enableFlowControllerGUI(null != fcd);
            this.flowControllerChoice.setEnabled(true);
            this.flowChoiceLabel.setEnabled(true);
            int items = this.flowList.getItemCount();
            int selection = this.flowList.getSelectionIndex();
            if (items == 0 || selection == -1) {
                this.editor.getAggregatePage().getAggregateSection().getRemoveFromFlowButton().setEnabled(false);
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            } else {
                this.editor.getAggregatePage().getAggregateSection().getRemoveFromFlowButton().setEnabled(true);
                this.upButton.setEnabled(selection != 0);
                this.downButton.setEnabled(selection != items - 1);
            }
        }
    }

    public boolean containsNode(String node) {
        String[] nodes = new FlowNodes(this.getModelFlow()).getFlow();
        if (null == nodes) {
            return false;
        }
        for (int i = 0; i < nodes.length; ++i) {
            if (!node.equals(nodes[i])) continue;
            return true;
        }
        return false;
    }

    public Button getDownButton() {
        return this.downButton;
    }

    public Table getFlowList() {
        return this.flowList;
    }

    public Button getUpButton() {
        return this.upButton;
    }

    public void removeAll() {
        FlowConstraints flow = this.getModelFlow();
        if (flow != null) {
            flow.setAttributeValue("fixedFlow", (Object)new String[0]);
            this.editor.setFileDirty();
            this.editor.getAggregatePage().getAggregateSection().refresh();
        }
    }

    private void handleFindFlowController() {
        FindComponentDialog dialog1 = new FindComponentDialog(this, "Find a Flow Controller", "Specify a name pattern and/or other constraints, and then push the Search button", flowControllerHeadersLC);
        if (1 == dialog1.open()) {
            return;
        }
        List matchingDelegateComponentDescriptors = dialog1.getMatchingDelegateComponentDescriptors();
        List matchingDelegateComponentDescriptions = dialog1.getMatchingDelegateComponentDescriptions();
        if (matchingDelegateComponentDescriptors.size() == 0) {
            Utility.popMessage("No matching Components", "There are no Components matching your search criteria.", 1);
            return;
        }
        PickTaeForTypesDialog dialog2 = new PickTaeForTypesDialog(this, this.editor.getFile().getName(), matchingDelegateComponentDescriptors, matchingDelegateComponentDescriptions);
        if (1 == dialog2.open()) {
            return;
        }
        String[] selectedDelegateComponentDescriptors = dialog2.getSelectedDelegateComponentDescriptors();
        if (selectedDelegateComponentDescriptors == null || selectedDelegateComponentDescriptors.length == 0) {
            return;
        }
        if (this.checkForOneSelection(selectedDelegateComponentDescriptors.length)) {
            String fileName = selectedDelegateComponentDescriptors[0].replace('\\', '/');
            int nLastSlashLoc = fileName.lastIndexOf(47);
            String shortName = nLastSlashLoc == -1 ? fileName : fileName.substring(nLastSlashLoc + 1);
            this.produceKeyAddFlowController(shortName, this.editor.getFullPathFromDescriptorRelativePath(fileName), dialog2.isImportByName);
        }
    }

    private void produceKeyAddFlowController(String shortName, String fullPathFileName, boolean isImportByName) {
        Import imp = this.createImport(fullPathFileName, isImportByName);
        FlowControllerDeclaration oldFcd = this.getFlowControllerDeclaration();
        this.setFlowControllerDeclaration(null);
        String keyName = this.produceUniqueComponentKey(shortName);
        if (null == keyName) {
            this.setFlowControllerDeclaration(oldFcd);
            return;
        }
        XMLizable inputDescription = this.readImport(imp, fullPathFileName, isImportByName);
        if (null == inputDescription) {
            this.setFlowControllerDeclaration(oldFcd);
            return;
        }
        if (!(inputDescription instanceof FlowControllerDescription)) {
            Utility.popMessage("Invalid kind of descriptor", MessageFormat.format("Operation cancelled: The descriptor ''{0}'' being added is not a FlowController.", FlowSection.maybeShortenFileName(fullPathFileName)), 1);
            this.setFlowControllerDeclaration(oldFcd);
            return;
        }
        FlowControllerDeclaration_impl fcd = new FlowControllerDeclaration_impl();
        fcd.setKey(keyName);
        fcd.setImport(imp);
        this.setFlowControllerDeclaration((FlowControllerDeclaration)fcd);
        if (!this.isValidAggregateChange()) {
            this.setFlowControllerDeclaration(oldFcd);
            return;
        }
        this.finishAggregateChangeAction();
        this.editor.addDirtyTypeName("<Aggregate>");
        this.refresh();
    }

    private void handleSpecifyFlowController() {
        MultiResourceSelectionDialog dialog = new MultiResourceSelectionDialog(this.getSection().getShell(), (IAdaptable)this.editor.getFile().getProject().getParent(), "Flow Controller Selection", this.editor.getFile().getLocation(), this.editor);
        dialog.setTitle("Flow Controller Selection");
        dialog.setMessage("Select a Flow Controller descriptor from the workspace:");
        if (1 == dialog.open()) {
            return;
        }
        Object[] files = dialog.getResult();
        if (files != null && this.checkForOneSelection(files.length)) {
            FileAndShortName fsn = new FileAndShortName(files[0]);
            this.produceKeyAddFlowController(fsn.shortName, fsn.fileName, dialog.isImportByName);
        }
    }

    private boolean checkForOneSelection(int numberSelected) {
        if (numberSelected > 1) {
            Utility.popMessage("Error - Multiple selection", "Only one Flow Controller can be selected. Please try again.", 1);
            return false;
        }
        return true;
    }
}

