/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.wizards;

import org.apache.uima.taeconfigurator.TAEConfiguratorPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public abstract class AbstractNewWizardPage
extends WizardPage {
    protected ISelection selection;
    protected Text containerText;
    protected Text fileText;
    private String defaultNewName;

    public AbstractNewWizardPage(ISelection pSelection, String image, String title, String description, String defaultNewName) {
        super("wizardPage");
        this.setTitle(title);
        this.setDescription(description);
        this.setImageDescriptor(TAEConfiguratorPlugin.getImageDescriptor("big_t_s.gif"));
        this.selection = pSelection;
        this.defaultNewName = defaultNewName;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("Parent &Folder:");
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractNewWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractNewWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText("&File name:");
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractNewWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (!(obj instanceof IResource) && obj instanceof IAdaptable) {
                obj = ((IAdaptable)obj).getAdapter(IResource.class);
            }
            if (obj instanceof IResource) {
                IContainer container = null;
                container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                if (container.isAccessible()) {
                    this.containerText.setText(container.getFullPath().toString());
                }
            }
        }
        this.fileText.setText(this.defaultNewName);
    }

    void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select a containing folder");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toOSString());
        }
    }

    void dialogChanged() {
        String ext;
        String container = this.getContainerName();
        String fileName = this.getFileName();
        if (container.length() == 0) {
            this.updateStatus("Parent folder must be specified");
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus("File name must be specified");
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase("xml")) {
            this.updateStatus("File extension must be \"xml\"");
            return;
        }
        this.updateStatus(null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }
}

