/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.wizards;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import org.apache.uima.taeconfigurator.InternalErrorCDE;
import org.apache.uima.taeconfigurator.TAEConfiguratorPlugin;
import org.apache.uima.taeconfigurator.wizards.AbstractNewWizardPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public abstract class AbstractNewWizard
extends Wizard
implements INewWizard {
    public static final String XMLNS_PART = "xmlns=\"http://uima.apache.org/resourceSpecifier\">\n";
    protected AbstractNewWizardPage page;
    protected ISelection selection;
    private String windowTitle;

    public AbstractNewWizard(String windowTitle) {
        this.setDialogSettings(TAEConfiguratorPlugin.getDefault().getDialogSettings());
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(false);
        this.windowTitle = windowTitle;
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    AbstractNewWizard.this.doFinish(containerName, fileName, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    public abstract String getPrototypeDescriptor(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        IContainer container;
        IFile file;
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        if ((file = (container = (IContainer)resource).getFile((IPath)new Path(fileName))).exists()) {
            this.throwCoreException("New Wizard creating file '" + fileName + "', but it already exists.");
        } else {
            int indexOfXml = file.getName().toLowerCase().indexOf(".xml");
            String name = indexOfXml > 0 ? file.getName().substring(0, indexOfXml) : file.getName();
            String descriptor = this.getPrototypeDescriptor(name);
            PrintWriter printWriter = null;
            FileOutputStream fileOutputStream = null;
            ByteArrayInputStream stream = null;
            try {
                try {
                    fileOutputStream = new FileOutputStream(file.getLocation().toOSString());
                }
                catch (FileNotFoundException e) {
                    throw new InternalErrorCDE("unexpected Exception", e);
                }
                printWriter = new PrintWriter(fileOutputStream);
                printWriter.println(descriptor);
            }
            finally {
                if (null != printWriter) {
                    printWriter.close();
                }
                if (null != fileOutputStream) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException e1) {}
                }
            }
            stream = new ByteArrayInputStream(descriptor.getBytes());
            file.create((InputStream)stream, true, monitor);
            try {
                ((InputStream)stream).close();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        monitor.worked(1);
        monitor.setTaskName("Starting editor for new descriptor...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page1 = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page1.openEditor((IEditorInput)new FileEditorInput(file), "taeconfigurator.editors.MultiPageEditor");
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
        monitor.worked(2);
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "DescEditor", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection pSelection) {
        this.selection = pSelection;
        this.setWindowTitle(this.windowTitle);
    }
}

