/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.files;

import java.util.Map;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.flow.FlowControllerDescription;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ConfigurationGroup;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.ParameterDelegatesSection;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialog;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AddParameterDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class PickOverrideKeysAndParmName
extends AbstractDialog {
    private AddParameterDialog parameterDialog = null;
    private ConfigurationParameter cp;
    private ConfigurationParameterDeclarations cpd;
    private boolean adding;
    private Table paramsUI;
    private Table keysUI;
    private Map delegates;
    public String delegateKeyName;
    public String delegateParameterName;

    public PickOverrideKeysAndParmName(AbstractSection aSection, Map delegateMap, String message, ConfigurationParameter aCp, ConfigurationParameterDeclarations aCpd, boolean aAdding) {
        super(aSection, "Delegate Keys and Parameter Name Selection", message);
        this.delegates = delegateMap;
        this.cp = aCp;
        this.cpd = aCpd;
        this.adding = aAdding;
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainArea = (Composite)super.createDialogArea(parent);
        Composite twoCol = this.new2ColumnComposite(mainArea);
        this.keysUI = this.newTable(twoCol, 4);
        this.paramsUI = this.newTable(twoCol, 4);
        for (Map.Entry entry : this.delegates.entrySet()) {
            TableItem item = new TableItem(this.keysUI, 0);
            item.setText((String)entry.getKey());
            item.setData(entry);
        }
        this.keysUI.addListener(13, (Listener)this);
        if (0 < this.keysUI.getItemCount()) {
            this.keysUI.setSelection(0);
        }
        return mainArea;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.keysUI && event.type == 13) {
            this.fillParameterCandidates();
            super.handleEvent(event);
        } else if (event.widget == this.paramsUI && event.type == 13) {
            this.copyValuesFromGUI();
            super.handleEvent(event);
        }
    }

    private void fillParameterCandidates() {
        this.paramsUI.setRedraw(false);
        this.paramsUI.removeAll();
        TableItem selectedItem = this.keysUI.getSelection()[0];
        Map.Entry entry = (Map.Entry)selectedItem.getData();
        String keyName = (String)entry.getKey();
        ResourceSpecifier rs = (ResourceSpecifier)entry.getValue();
        if (rs instanceof AnalysisEngineDescription || rs instanceof CasConsumerDescription || rs instanceof FlowControllerDescription) {
            ConfigurationParameterDeclarations delegateCpd = ((ResourceCreationSpecifier)rs).getMetaData().getConfigurationParameterDeclarations();
            this.addSelectedParms(delegateCpd.getCommonParameters(), keyName);
            ConfigurationGroup[] groups = delegateCpd.getConfigurationGroups();
            if (null != groups) {
                for (int i = 0; i < groups.length; ++i) {
                    this.addSelectedParms(groups[i].getConfigurationParameters(), keyName);
                }
            }
            this.addSelectedParms(delegateCpd.getConfigurationParameters(), keyName);
        }
        if (0 < this.paramsUI.getItemCount()) {
            this.paramsUI.setSelection(0);
        }
        this.paramsUI.setRedraw(true);
    }

    private void addSelectedParms(ConfigurationParameter[] parms, String keyName) {
        String type;
        boolean isMultiValued = null != this.parameterDialog ? this.parameterDialog.multiValueUI.getSelection() : this.cp.isMultiValued();
        String string = type = null != this.parameterDialog ? this.parameterDialog.parmTypeUI.getText() : this.cp.getType();
        if (null != parms) {
            for (int i = 0; i < parms.length; ++i) {
                if (isMultiValued != parms[i].isMultiValued() || null != type && !"".equals(type) && !type.equals(parms[i].getType())) continue;
                String override = keyName + '/' + parms[i].getName();
                if (this.adding && null != ParameterDelegatesSection.getOverridingParmName(override, this.cpd)) continue;
                TableItem tableItem = new TableItem(this.paramsUI, 0);
                tableItem.setText(parms[i].getName());
                tableItem.setData((Object)parms[i]);
            }
        }
    }

    public void copyValuesFromGUI() {
        this.delegateKeyName = this.keysUI.getSelection()[0].getText();
        this.delegateParameterName = this.paramsUI.getSelection()[0].getText();
    }

    public void enableOK() {
        this.okButton.setEnabled(0 < this.keysUI.getSelectionCount() && 0 < this.paramsUI.getSelectionCount());
    }

    public boolean isValid() {
        return true;
    }
}

