/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.files;

import java.text.MessageFormat;
import org.apache.uima.resource.metadata.FsIndexCollection;
import org.apache.uima.resource.metadata.ResourceManagerConfiguration;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.ResourcePickerDialog;
import org.apache.uima.util.XMLizable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ContextForPartDialog
extends ResourcePickerDialog {
    private Text contextPathGUI;
    public String contextPath;
    private String initialPath;
    private XMLizable tbe;

    public ContextForPartDialog(Shell parentShell, IAdaptable rootElement, XMLizable thingBeingEdited, IPath aExcludeDescriptor, MultiPageEditor aEditor, String aInitialPath) {
        super(parentShell);
        this.initialPath = aInitialPath;
        this.setTitle("Context for importable part");
        this.tbe = thingBeingEdited;
    }

    protected Control createDialogArea(Composite parent) {
        parent = new Composite(parent, 0);
        parent.setLayout((Layout)new GridLayout(1, true));
        parent.setLayoutData((Object)new GridData(16384, 1, true, false));
        ((GridLayout)parent.getLayout()).marginWidth = 15;
        AbstractSection.spacer(parent);
        Label instructions = new Label(parent, 64);
        Object[] objectArray = new Object[2];
        Object object = this.tbe instanceof FsIndexCollection ? "Index Definition" : (this.tbe instanceof TypePriorities ? "Type Priority Definition" : (objectArray[0] = this.tbe instanceof ResourceManagerConfiguration ? "Resource Manager Configuration" : "unhandled - error"));
        objectArray[1] = this.tbe instanceof FsIndexCollection ? "A Type System or any descriptor containing or importing the type system associated with this Index Definition,\n    other than a Collection Processing Engine" : (this.tbe instanceof TypePriorities ? "A Type System or any descriptor containing or importing the type system associated with this TypePriority Definition,\n    other than a Collection Processing Engine" : (this.tbe instanceof ResourceManagerConfiguration ? "A descriptor (such as an Analysis Engine) containing (directly or via aggregate delegates)\n    the External Resource Dependencies referenced by this Resource Manager Configuration" : "unhandled - error"));
        instructions.setText(MessageFormat.format("You are about to edit a UIMA {0} descriptor.  \nIn order to do this, you need to specify another UIMA descriptor, which will supply the needed context for this file.\nIt can be any of the following kinds of descriptors:\n\n    {1}\n\nThe file below is a suggested context.  \n\n     >>>  If it is correct, just push OK.  <<<\n\nOtherwise you can change it by overtyping it,\nor use the project explorer window below to pick the context file to use.", objectArray));
        AbstractSection.spacer(parent);
        this.contextPathGUI = new Text(parent, 2048);
        this.contextPathGUI.setLayoutData((Object)new GridData(768));
        this.contextPathGUI.setText(null == this.initialPath ? "" : this.initialPath);
        Composite composite = (Composite)super.createDialogArea(parent);
        return composite;
    }

    public void handleEvent(Event event) {
        super.handleEvent(event);
        if (event.widget == this.resourcesUI && event.type == 13 && null != this.pickedResource) {
            IFile f = (IFile)this.getResult()[0];
            this.contextPathGUI.setText(f.getLocation().toOSString());
        }
    }

    protected void okPressed() {
        this.contextPath = this.contextPathGUI.getText();
        super.okPressed();
    }

    public void enableOK() {
        super.enableOK();
        String path = this.contextPathGUI.getText();
        if (null != path && !"".equals(path)) {
            this.okButton.setEnabled(true);
        }
    }
}

