/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;

public class AddTypeToPriorityListDialog
extends AbstractDialog {
    private String[] m_selectedTypeNames;
    private String[] m_availableTypeNames;
    private List typeList;

    public AddTypeToPriorityListDialog(AbstractSection aSection, Set allowableTypeNameHash, String[] typesInList) {
        super(aSection, "Add Types to Priority List", "Select one or more types and press OK");
        this.m_availableTypeNames = this.getAvailableTypeNames(allowableTypeNameHash, typesInList);
    }

    private String[] getAvailableTypeNames(Set allowableTypeNameHash, String[] alreadyUsedTypes) {
        Arrays.sort(alreadyUsedTypes);
        HashSet<String> availableHash = new HashSet<String>();
        for (String sTypeName : allowableTypeNameHash) {
            if (0 <= Arrays.binarySearch(alreadyUsedTypes, sTypeName) || "uima.cas.TOP".equals(sTypeName)) continue;
            availableHash.add(sTypeName);
        }
        Object[] availableTypeNames = availableHash.toArray(stringArray0);
        Arrays.sort(availableTypeNames);
        return availableTypeNames;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.typeList = new List(composite, 2562);
        GridData gridData = new GridData(768);
        gridData.heightHint = 100;
        this.typeList.setLayoutData((Object)gridData);
        for (int i = 0; i < this.m_availableTypeNames.length; ++i) {
            this.typeList.add(this.m_availableTypeNames[i]);
        }
        return composite;
    }

    public String[] getSelectedTypeNames() {
        return (String[])this.m_selectedTypeNames.clone();
    }

    public void copyValuesFromGUI() {
        this.m_selectedTypeNames = new String[this.typeList.getSelectionCount()];
        int j = 0;
        for (int i = 0; i < this.m_availableTypeNames.length; ++i) {
            if (!this.typeList.isSelected(i)) continue;
            this.m_selectedTypeNames[j++] = this.m_availableTypeNames[i];
        }
    }

    public boolean isValid() {
        return true;
    }

    public void enableOK() {
        this.okButton.setEnabled(true);
    }
}

