/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import java.text.MessageFormat;
import org.apache.uima.taeconfigurator.CDEpropertyPage;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class AddRemoteServiceDialog
extends AbstractDialog {
    private String m_selectedServiceTypeName = null;
    private String m_selectedUri = null;
    private String m_selectedKey = null;
    private boolean m_bAutoAddToFlow;
    public String vnsPort;
    public String vnsHost;
    public String timeout;
    public String aeOrCc;
    private CCombo serviceTypeCombo;
    private Text uriText;
    private Text keyText;
    private Text timeoutText;
    private Button autoAddToFlowButton;
    private Button importByNameUI;
    private Button importByLocationUI;
    public boolean isImportByName;
    private String rootPath;
    private DialogModifyListener m_dialogModifyListener = new DialogModifyListener();
    private Text genFilePathUI;
    public String genFilePath;
    private String keyTextPrev;
    private Label vnsHostLabel;
    private Text vnsHostUI;
    private Label vnsPortLabel;
    private Text vnsPortUI;
    private boolean portNumberWasBad;
    private boolean portNumberIsOK;
    private CCombo aeOrCcCombo;

    public AddRemoteServiceDialog(AbstractSection aSection, String aRootPath) {
        super(aSection, "Add Remote Service", "Fill in the information about the remote service and press OK");
        this.rootPath = aRootPath;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createWideLabel(composite, "Service kind: Analysis Engine or Cas Consumer:");
        this.aeOrCcCombo = this.newCCombo(composite, "Specify whether the Service is an Analysis Engine or a Cas Consumer");
        this.aeOrCcCombo.add("AnalysisEngine");
        this.aeOrCcCombo.add("CasConsumer");
        this.aeOrCcCombo.select(0);
        this.createWideLabel(composite, "Protocol Service Type:");
        this.serviceTypeCombo = this.newCCombo(composite, "");
        this.serviceTypeCombo.add("SOAP");
        this.serviceTypeCombo.add("Vinci");
        this.serviceTypeCombo.select(0);
        this.createWideLabel(composite, "URI:");
        this.uriText = new Text(composite, 2048);
        this.uriText.setLayoutData((Object)new GridData(768));
        this.uriText.addModifyListener((ModifyListener)this.m_dialogModifyListener);
        this.createWideLabel(composite, "Key (a short mnemonic for this service):");
        this.keyText = new Text(composite, 2048);
        this.keyText.setLayoutData((Object)new GridData(768));
        this.keyText.addModifyListener((ModifyListener)this.m_dialogModifyListener);
        this.keyText.addVerifyListener((VerifyListener)new DialogVerifyListener());
        this.keyTextPrev = ".xml";
        this.createWideLabel(composite, "Where the generated remote descriptor file will be stored:");
        this.genFilePathUI = new Text(composite, 2304);
        this.genFilePathUI.setLayoutData((Object)new GridData(768));
        this.genFilePathUI.setText(this.rootPath + ".xml");
        this.createWideLabel(composite, "Timeout, in milliseconds.  This is ignored for the Vinci protocol.  Specify 0 to wait forever. If not specified, a default timeout is used.");
        this.timeoutText = new Text(composite, 2048);
        this.timeoutText.setEnabled(false);
        this.createWideLabel(composite, "For the Vinci protocol, you can optionally specify the Host/Port for the Vinci Name Service");
        Composite tc = this.new2ColumnComposite(composite);
        this.vnsHostLabel = new Label(tc, 0);
        this.setTextAndTip(this.vnsHostLabel, "VNS HOST", "An IP name or address, e.g. localhost");
        this.vnsHostUI = this.newText(tc, 0, "An IP name or address, e.g. localhost");
        this.vnsPortLabel = new Label(tc, 0);
        this.setTextAndTip(this.vnsPortLabel, "VNS PORT", "A port number, e.g. 9000");
        this.vnsPortUI = this.newText(tc, 0, "A port number, e.g. 9000");
        this.newErrorMessage(composite);
        this.autoAddToFlowButton = new Button(composite, 32);
        this.autoAddToFlowButton.setText("Add to end of flow");
        this.autoAddToFlowButton.setSelection(true);
        new Label(composite, 0).setText("");
        this.importByNameUI = new Button(composite, 16);
        this.importByNameUI.setText("Import by Name");
        this.importByNameUI.setToolTipText("Importing by name looks up the name on the classpath and datapath.");
        this.importByNameUI.setSelection(true);
        this.importByLocationUI = new Button(composite, 16);
        this.importByLocationUI.setText("Import By Location");
        this.importByLocationUI.setToolTipText("Importing by location requires a relative or absolute URL");
        String defaultBy = CDEpropertyPage.getImportByDefault(this.editor.getProject());
        if (defaultBy.equals("location")) {
            this.importByNameUI.setSelection(false);
            this.importByLocationUI.setSelection(true);
        } else {
            this.importByNameUI.setSelection(true);
            this.importByLocationUI.setSelection(false);
        }
        return composite;
    }

    public void enableOK() {
        boolean isVinci = this.serviceTypeCombo.getSelectionIndex() == 1;
        this.vnsHostLabel.setEnabled(isVinci);
        this.vnsHostUI.setEnabled(isVinci);
        this.vnsPortLabel.setEnabled(isVinci);
        this.vnsPortUI.setEnabled(isVinci);
        this.timeoutText.setEnabled(!isVinci);
        boolean bEnableOk = this.serviceTypeCombo.getText() != null && !this.serviceTypeCombo.getText().equals("") && this.uriText != null && !this.uriText.getText().trim().equals("") && this.keyText != null && !this.keyText.getText().trim().equals("");
        this.portNumberIsOK = true;
        if (isVinci && this.vnsPortUI.getText().length() > 0) {
            try {
                Integer.parseInt(this.vnsPortUI.getText());
            }
            catch (NumberFormatException e) {
                bEnableOk = false;
                this.portNumberWasBad = true;
                this.portNumberIsOK = false;
                this.setErrorMessage("Invalid number, please correct.");
            }
        }
        this.okButton.setEnabled(bEnableOk);
        if (this.portNumberWasBad && this.portNumberIsOK) {
            this.setErrorMessage("");
            this.portNumberWasBad = false;
        }
    }

    public String getSelectedServiceTypeName() {
        return this.m_selectedServiceTypeName;
    }

    public String getSelectedUri() {
        return this.m_selectedUri;
    }

    public String getSelectedKey() {
        return this.m_selectedKey;
    }

    public boolean getAutoAddToFlow() {
        return this.m_bAutoAddToFlow;
    }

    public void copyValuesFromGUI() {
        this.genFilePath = this.genFilePathUI.getText();
        this.isImportByName = this.importByNameUI.getSelection();
        this.m_selectedServiceTypeName = this.serviceTypeCombo.getText();
        this.aeOrCc = this.aeOrCcCombo.getText();
        this.m_selectedUri = this.uriText.getText();
        this.m_selectedKey = this.keyText.getText();
        this.m_bAutoAddToFlow = this.autoAddToFlowButton.getSelection();
        this.timeout = this.timeoutText.getText();
        this.vnsHost = this.vnsHostUI.getText();
        this.vnsPort = this.vnsPortUI.getText();
        CDEpropertyPage.setImportByDefault(this.editor.getProject(), this.isImportByName ? "name" : "location");
    }

    public boolean isValid() {
        return true;
    }

    private class DialogVerifyListener
    implements VerifyListener {
        private DialogVerifyListener() {
        }

        public void verifyText(VerifyEvent e) {
            if (0 <= e.text.indexOf(46)) {
                AddRemoteServiceDialog.this.setErrorMessage(MessageFormat.format("invalid character(s): ''{0}''", e.text));
                e.doit = false;
            } else {
                AddRemoteServiceDialog.this.setErrorMessage("");
            }
        }
    }

    private class DialogModifyListener
    implements ModifyListener {
        private DialogModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String text = AddRemoteServiceDialog.this.genFilePathUI.getText();
            int pos = text.lastIndexOf(AddRemoteServiceDialog.this.keyTextPrev);
            if (pos == -1) {
                pos = text.length();
            }
            AddRemoteServiceDialog.this.keyTextPrev = AddRemoteServiceDialog.this.keyText.getText() + ".xml";
            AddRemoteServiceDialog.this.genFilePathUI.setText(text.substring(0, pos) + AddRemoteServiceDialog.this.keyTextPrev);
            if (AddRemoteServiceDialog.this.okButton != null) {
                AddRemoteServiceDialog.this.enableOK();
            }
        }
    }
}

