/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.resource.metadata.FsIndexKeyDescription;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

public class AddIndexKeyDialog
extends AbstractDialog {
    private static final String ASCENDING = "Ascending (Standard)";
    private static final String DESCENDING = "Descending (Reverse)";
    private static final String TYPE_PRIORITY = "Type Priority";
    public boolean typePriority;
    public String featureName;
    public int direction;
    private String[] features;
    private FsIndexKeyDescription existingKey = null;
    private List alreadyUsedKeys;
    private String indexKind;
    private CCombo featureUI;
    private CCombo kindUI;
    private Label featureLabel;

    public AddIndexKeyDialog(AbstractSection aSection, String typeName, String indexKind, List alreadyUsedKeys) {
        super(aSection, "Add index key", "Add or edit an index key for a type");
        this.indexKind = indexKind;
        this.alreadyUsedKeys = alreadyUsedKeys;
        this.features = this.getSortableFeatureNames(typeName);
    }

    public AddIndexKeyDialog(AbstractSection aSection, String typeName, String indexKind, List alreadyUsedKeys, FsIndexKeyDescription existingKey) {
        this(aSection, typeName, indexKind, alreadyUsedKeys);
        this.existingKey = existingKey;
    }

    private String[] getSortableFeatureNames(String selectedTypeName) {
        Type selectedType = this.section.editor.getCurrentView().getTypeSystem().getType(selectedTypeName);
        List feats = selectedType.getFeatures();
        ArrayList<String> sortableFeatureNames = new ArrayList<String>();
        for (int i = 0; i < feats.size(); ++i) {
            Feature feature = (Feature)feats.get(i);
            Type rangeType = feature.getRange();
            if (!AbstractSection.isIndexableRange(rangeType.getName()) || this.alreadyUsedKeys.contains(feature.getShortName())) continue;
            sortableFeatureNames.add(feature.getShortName());
        }
        Object[] result = sortableFeatureNames.toArray(stringArray0);
        Arrays.sort(result);
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainComposite = (Composite)super.createDialogArea(parent, this.existingKey);
        Composite twoCol = this.new2ColumnComposite(mainComposite);
        if ("sorted".equals(this.indexKind)) {
            this.kindUI = this.newLabeledCCombo(twoCol, "Sort order, or Type Priority", "Specify the sort direction, or specify Type Priorities");
            this.kindUI.add(ASCENDING);
            this.kindUI.add(DESCENDING);
            this.kindUI.add(TYPE_PRIORITY);
        }
        this.featureLabel = new Label(twoCol, 0);
        this.featureLabel.setText("Feature Name");
        this.featureUI = this.newCCombo(twoCol, "Pick a feature to use as a key from the available features");
        for (int i = 0; i < this.features.length; ++i) {
            this.featureUI.add(this.features[i]);
        }
        if (null == this.existingKey) {
            if ("sorted".equals(this.indexKind)) {
                this.kindUI.setText(this.kindUI.getItem(0));
            }
        } else if ("sorted".equals(this.indexKind)) {
            this.kindUI.setText(this.existingKey.isTypePriority() ? TYPE_PRIORITY : (this.existingKey.getComparator() == 0 ? ASCENDING : DESCENDING));
            if (!this.existingKey.isTypePriority()) {
                this.featureUI.setText(this.existingKey.getFeatureName());
            }
        } else {
            this.featureUI.setText(this.existingKey.getFeatureName());
        }
        boolean makeFeatureVisible = "set".equals(this.indexKind) || !TYPE_PRIORITY.equals(this.kindUI.getText());
        this.featureUI.setVisible(makeFeatureVisible);
        this.featureLabel.setVisible(makeFeatureVisible);
        if ("sorted".equals(this.indexKind)) {
            this.kindUI.addListener(24, (Listener)this);
        }
        return mainComposite;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.kindUI) {
            boolean makeFeatureVisible = "set".equals(this.indexKind) || !TYPE_PRIORITY.equals(this.kindUI.getText());
            this.featureUI.setVisible(makeFeatureVisible);
            this.featureLabel.setVisible(makeFeatureVisible);
        }
        super.handleEvent(event);
    }

    public void enableOK() {
        this.copyValuesFromGUI();
        this.okButton.setEnabled(this.typePriority || null == this.featureName || !"".equals(this.featureName));
    }

    public void copyValuesFromGUI() {
        if ("sorted".equals(this.indexKind) && TYPE_PRIORITY.equals(this.kindUI.getText())) {
            this.typePriority = true;
            this.featureName = "";
        } else {
            this.typePriority = false;
            this.direction = "sorted".equals(this.indexKind) ? (ASCENDING.equals(this.kindUI.getText()) ? 0 : 1) : 0;
            this.featureName = this.featureUI.getText();
        }
    }

    public boolean isValid() {
        return true;
    }
}

