/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import org.apache.uima.resource.ExternalResourceDependency;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.ResourceDependencySection;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialogKeyVerifyJavaNames;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class AddExternalResourceDependencyDialog
extends AbstractDialogKeyVerifyJavaNames {
    private StyledText keyNameUI;
    public Button optionalUI;
    private StyledText interfaceNameUI;
    private Text descriptionUI;
    public String keyName;
    private String originalKeyName;
    public boolean optional;
    public String interfaceName;
    public String description;
    private ResourceDependencySection rdSection;
    private ExternalResourceDependency existingXRD;

    public AddExternalResourceDependencyDialog(AbstractSection aSection) {
        super(aSection, "Add External Resource Dependency", "Add an External Resource Dependency");
        this.rdSection = (ResourceDependencySection)aSection;
    }

    public AddExternalResourceDependencyDialog(AbstractSection aSection, ExternalResourceDependency aExistingXRD) {
        this(aSection);
        this.existingXRD = aExistingXRD;
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainArea = (Composite)super.createDialogArea(parent, this.existingXRD);
        this.createWideLabel(mainArea, "The only required field is the key name,\nwhich must be unique within this primitive Analysis Engine descriptor.");
        Composite twoCol = this.new2ColumnComposite(mainArea);
        this.keyNameUI = this.newLabeledSingleLineStyledText(twoCol, "Key", "Name used by the Primitive Analysis Engine to refer to the resource");
        this.descriptionUI = this.newDescription(twoCol, "(Optional)Describes this resource dependency");
        this.interfaceNameUI = this.newLabeledSingleLineStyledText(twoCol, "Interface", "The fully qualified name of the Java Interface class used by the Analysis Engine to refer to the External Resource");
        this.newErrorMessage(twoCol, 2);
        this.optionalUI = this.newButton(mainArea, 32, "Check this box if this resource is optional", "Uncheck if this resource is required");
        if (null != this.existingXRD) {
            this.descriptionUI.setText(AddExternalResourceDependencyDialog.convertNull(this.existingXRD.getDescription()));
            this.optionalUI.setSelection(this.existingXRD.isOptional());
            this.originalKeyName = this.existingXRD.getKey();
            this.keyNameUI.setText(this.originalKeyName);
            this.interfaceNameUI.setText(AddExternalResourceDependencyDialog.convertNull(this.existingXRD.getInterfaceName()));
        }
        return mainArea;
    }

    public void copyValuesFromGUI() {
        this.keyName = this.keyNameUI.getText();
        this.optional = this.optionalUI.getSelection();
        this.description = AddExternalResourceDependencyDialog.nullIf0lengthString(this.descriptionUI.getText());
        this.interfaceName = AddExternalResourceDependencyDialog.nullIf0lengthString(this.interfaceNameUI.getText());
    }

    public boolean isValid() {
        if (this.keyName.length() == 0) {
            return false;
        }
        return this.keyName.equals(this.originalKeyName) || !this.rdSection.keyNameAlreadyDefined(this.keyName);
    }

    public void enableOK() {
        this.copyValuesFromGUI();
        this.okButton.setEnabled(this.keyName.length() > 0);
    }
}

