/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import java.lang.reflect.Array;
import java.util.Comparator;
import org.apache.uima.taeconfigurator.InternalErrorCDE;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class Utility
extends MessageDialog {
    private static final String[] OK_CANCEL = new String[]{"OK", "Cancel"};
    private static final String[] OKstring = new String[]{"OK"};

    public Utility(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
    }

    public static int popOkCancel(String title, String message, int type) {
        return Utility.popMessage(title, message, type, OK_CANCEL);
    }

    public static void popMessage(String title, String message, int type) {
        Utility.popMessage(title, message, type, OKstring);
    }

    public static int popMessage(String title, String message, int type, String[] buttons) {
        Utility dialog = new Utility(new Shell(), title, null, message, type, buttons, 0);
        dialog.setShellStyle(67696);
        int returnCode = dialog.open();
        if (returnCode == -1) {
            returnCode = 1;
        }
        return returnCode;
    }

    public static Object[] removeElementFromArray(Object[] source, Object element, Class componentClass) {
        Object[] result = (Object[])Array.newInstance(componentClass, source.length - 1);
        int j = 0;
        for (int i = 0; i < source.length; ++i) {
            if (element == source[i]) continue;
            result[j++] = source[i];
        }
        return result;
    }

    public static Object[] removeEqualElementFromArray(Object[] source, Object element, Class componentClass) {
        Object[] result = (Object[])Array.newInstance(componentClass, source.length - 1);
        int j = 0;
        for (int i = 0; i < source.length; ++i) {
            if (element == null && source[i] == null || null != element && element.equals(source[i])) continue;
            result[j++] = source[i];
        }
        return result;
    }

    public static Object[] removeElementsFromArray(Object[] source, Object element, Class componentClass) {
        if (null == source) {
            return null;
        }
        int count = 0;
        for (int i = 0; i < source.length; ++i) {
            if (element.equals(source[i])) continue;
            ++count;
        }
        if (count == source.length) {
            return source;
        }
        Object[] result = (Object[])Array.newInstance(componentClass, count);
        int j = 0;
        for (int i = 0; i < source.length; ++i) {
            if (element.equals(source[i])) continue;
            result[j++] = source[i];
        }
        return result;
    }

    public static Object[] removeElementsFromArray(Object[] source, Object element, Class componentClass, Comparator comp) {
        if (null == source) {
            return null;
        }
        int count = 0;
        for (int i = 0; i < source.length; ++i) {
            if (0 == comp.compare(element, source[i])) continue;
            ++count;
        }
        if (count == source.length) {
            return source;
        }
        Object[] result = (Object[])Array.newInstance(componentClass, count);
        int j = 0;
        for (int i = 0; i < source.length; ++i) {
            if (0 == comp.compare(element, source[i])) continue;
            result[j++] = source[i];
        }
        return result;
    }

    public static Object[] addElementToArray(Object[] source, Object element, Class componentClass) {
        int newLength = null == source ? 1 : source.length + 1;
        Object[] result = (Object[])Array.newInstance(componentClass, newLength);
        System.arraycopy(source, 0, result, 0, newLength - 1);
        result[newLength - 1] = element;
        return result;
    }

    public static boolean arrayContains(Object[] array, Object element) {
        if (null == element) {
            throw new InternalErrorCDE("null not allowed as an argument");
        }
        if (null == array) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (null == array[i] || !array[i].equals(element)) continue;
            return true;
        }
        return false;
    }
}

