/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import java.io.IOException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.ImportSection;
import org.apache.uima.taeconfigurator.editors.ui.Utility;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.eclipse.swt.widgets.Composite;

public class TypeImportSection
extends ImportSection {
    private CAS savedCAS;
    private boolean importWasRemoved;

    public TypeImportSection(MultiPageEditor editor, Composite parent) {
        super(editor, parent, "Imported Type Systems", "The following type systems are included as part of this one.");
    }

    protected boolean isAppropriate() {
        if (this.isAggregate()) {
            this.getSection().setText("Not Used");
            this.getSection().setDescription("Types can't be imported in an Aggregate Descriptor");
            return false;
        }
        this.getSection().setText("Imported Type Systems");
        this.getSection().setDescription("The following type systems are included as part of this one.");
        return true;
    }

    protected String getDescriptionFromImport(String source) throws InvalidXMLException, IOException {
        TypeSystemDescription parsedImportItem = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(source));
        return parsedImportItem.getDescription();
    }

    protected Import[] getModelImportArray() {
        return this.getTypeSystemDescription().getImports();
    }

    protected void setModelImportArray(Import[] imports) {
        this.savedCAS = this.editor.getCurrentView();
        Import[] oldImports = this.getTypeSystemDescription().getImports();
        this.importWasRemoved = null != oldImports && oldImports.length > imports.length;
        this.getTypeSystemDescription().setImports(imports);
    }

    protected void clearModelBaseValue() {
        this.getTypeSystemDescription().setTypes(typeDescription0);
    }

    protected boolean isValidImport(String title, String msg) {
        TypeSystemDescription savedTSD = this.getMergedTypeSystemDescription();
        TypeSystemDescription savedITSD = this.editor.getImportedTypeSystemDesription();
        try {
            this.editor.setMergedTypeSystemDescription();
            this.editor.descriptorCAS.validate();
        }
        catch (ResourceInitializationException e1) {
            this.revertMsg(title, msg, this.editor.getMessagesToRootCause(e1));
            this.editor.setMergedTypeSystemDescription(savedTSD);
            this.editor.setImportedTypeSystemDescription(savedITSD);
            this.editor.descriptorCAS.set(this.savedCAS);
            return false;
        }
        if (this.importWasRemoved && 1 == Utility.popOkCancel("May need to remove dependencies", "A type import is being removed.  If this would removed some types or features in the merged type system, which are referenced in the Capabilities or Indexes section, you will need to update those sections as appropriate.", 2)) {
            this.revertMsg(title, msg, "Cancelled by user.");
            this.editor.setMergedTypeSystemDescription(savedTSD);
            this.editor.setImportedTypeSystemDescription(savedITSD);
            this.editor.descriptorCAS.set(this.savedCAS);
            return false;
        }
        return true;
    }

    protected void finishImportChangeAction() {
        this.editor.getTypePage().getTypeSection().refresh();
        this.editor.addDirtyTypeName("<import>");
    }
}

