/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import java.text.MessageFormat;
import java.util.Map;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.metadata.FlowControllerDeclaration;
import org.apache.uima.resource.ExternalResourceDependency;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.impl.ExternalResourceDependency_impl;
import org.apache.uima.resource.metadata.ExternalResourceBinding;
import org.apache.uima.resource.metadata.ResourceManagerConfiguration;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.Utility;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AddExternalResourceDependencyDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.IManagedForm;

public class ResourceDependencySection
extends AbstractSection {
    public static final int KEY_COL = 2;
    public static final int OPT_COL = 1;
    private static final String BOUND = "Bound";
    public Table table;
    private Button addButton;
    private Button editButton;
    private Button removeButton;

    public ResourceDependencySection(MultiPageEditor editor, Composite parent) {
        super(editor, parent, "Resource Dependencies", "Primitives declare what resources they need. A primitive can only bind to one external resource.");
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        Composite sectionClient = this.new2ColumnComposite((Composite)this.getSection());
        this.enableBorders(sectionClient);
        this.table = this.newTable(sectionClient, 65540, 50, 0);
        this.table.setHeaderVisible(true);
        this.newTableColumn(this.table).setText(BOUND);
        this.newTableColumn(this.table).setText("Optional?");
        this.newTableColumn(this.table).setText("Keys");
        this.newTableColumn(this.table).setText("Interface Name");
        if (this.isPrimitive()) {
            Composite buttonContainer = this.newButtonContainer(sectionClient);
            this.addButton = this.newPushButton(buttonContainer, "Add...", "Click here to add a dependency.");
            this.editButton = this.newPushButton(buttonContainer, "Edit...", "Click here to edit the selected item. You can also double-click the item to edit it.");
            this.removeButton = this.newPushButton(buttonContainer, "Remove", "Click here to remove the selected item.  You can also use the delete key.");
        }
        this.table.addListener(32, (Listener)this);
        if (this.isPrimitive()) {
            this.table.addListener(8, (Listener)this);
        }
        this.toolkit.paintBordersFor(sectionClient);
    }

    public void refresh() {
        super.refresh();
        this.table.getParent().setRedraw(false);
        this.table.removeAll();
        if (this.isPrimitive()) {
            this.addPrimitiveToGUI("", (ResourceCreationSpecifier)this.editor.getAeDescription());
        } else {
            for (Map.Entry item : this.editor.getResolvedDelegates().entrySet()) {
                this.addDelegateToGUI("", (String)item.getKey(), (ResourceSpecifier)item.getValue());
            }
            FlowControllerDeclaration fcd = this.editor.getResolvedFlowControllerDeclaration();
            if (null != fcd) {
                this.addDelegateToGUI("", fcd.getKey(), fcd.getSpecifier());
            }
        }
        this.enable();
        this.table.getParent().setRedraw(true);
    }

    private void addDelegateToGUI(String keys, String newKey, ResourceSpecifier o) {
        if (o instanceof AnalysisEngineDescription) {
            AnalysisEngineDescription aeDescription = (AnalysisEngineDescription)o;
            if (aeDescription.isPrimitive()) {
                this.addPrimitiveToGUI(keys + newKey + "/", (ResourceCreationSpecifier)aeDescription);
            } else {
                for (Map.Entry item : this.editor.getDelegateAEdescriptions(aeDescription).entrySet()) {
                    this.addDelegateToGUI(keys + newKey + "/", (String)item.getKey(), (ResourceSpecifier)item.getValue());
                }
                FlowControllerDeclaration fcd = this.getFlowControllerDeclaration();
                if (null != fcd) {
                    this.addPrimitiveToGUI(keys + fcd.getKey() + "/", (ResourceCreationSpecifier)this.editor.getResolvedFlowControllerDeclaration().getSpecifier());
                }
            }
        }
    }

    private void addPrimitiveToGUI(String keys, ResourceCreationSpecifier aeDescription) {
        ExternalResourceDependency[] xrd = aeDescription.getExternalResourceDependencies();
        if (null != xrd) {
            for (int i = 0; i < xrd.length; ++i) {
                this.addXrdToGUI(keys, xrd[i]);
            }
        }
    }

    private void updateXrdToGUI(TableItem item, ExternalResourceDependency xrd, String keys) {
        String key = keys + xrd.getKey();
        item.setText(0, this.isBound(key) ? BOUND : "");
        item.setText(2, key);
        item.setText(1, xrd.isOptional() ? "optional" : "required");
        item.setText(3, ResourceDependencySection.convertNull(xrd.getInterfaceName()));
        item.setData((Object)xrd);
    }

    private boolean isBound(String key) {
        ResourceManagerConfiguration rmc = this.editor.getResolvedExternalResourcesAndBindings();
        if (null == rmc) {
            return false;
        }
        ExternalResourceBinding[] xrb = rmc.getExternalResourceBindings();
        if (null != xrb) {
            for (int i = 0; i < xrb.length; ++i) {
                if (!key.equals(xrb[i].getKey())) continue;
                return true;
            }
        }
        return false;
    }

    private void propagateKeyChange(String newKey, String oldKey) {
        ExternalResourceBinding[] xrb = this.getExternalResourceBindings();
        if (null != xrb) {
            for (int i = 0; i < xrb.length; ++i) {
                if (!oldKey.equals(xrb[i].getKey())) continue;
                xrb[i].setKey(newKey);
                this.editor.getResourcesPage().getResourceBindingsSection().markStale();
                return;
            }
        }
    }

    private void addXrdToGUI(String keys, ExternalResourceDependency xrd) {
        TableItem item = new TableItem(this.table, 0);
        this.updateXrdToGUI(item, xrd, keys);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.addButton) {
            this.handleAdd();
        } else if (event.widget == this.removeButton || event.type == 2 && event.character == '\u007f') {
            this.handleRemove();
        } else if (event.widget == this.editButton || event.type == 8) {
            this.handleEdit();
        } else if (event.type == 32) {
            this.handleTableHoverHelp(event);
        } else if (event.type == 13) {
            this.editor.getResourcesPage().getResourceBindingsSection().enable();
        }
        this.enable();
    }

    public ExternalResourceDependency getXRDependencyFromTableItem(TableItem item) {
        return (ExternalResourceDependency)item.getData();
    }

    private void handleTableHoverHelp(Event event) {
        TableItem item = this.table.getItem(new Point(event.x, event.y));
        if (null != item) {
            ExternalResourceDependency xrd = this.getXRDependencyFromTableItem(item);
            ResourceDependencySection.setToolTipText((Control)this.table, xrd.getDescription());
        } else {
            this.table.setToolTipText("");
        }
    }

    private void handleEdit() {
        TableItem item = this.table.getSelection()[0];
        ExternalResourceDependency xrd = this.getXRDependencyFromTableItem(item);
        AddExternalResourceDependencyDialog dialog = new AddExternalResourceDependencyDialog(this, xrd);
        if (dialog.open() == 1) {
            return;
        }
        this.alterExistingExternalResourceDependency(xrd, dialog);
        this.updateXrdToGUI(item, xrd, "");
    }

    private void finishAction() {
        this.packChangingColumns();
        this.setFileDirty();
    }

    private void packChangingColumns() {
        this.table.getColumn(2).pack();
        this.table.getColumn(3).pack();
    }

    private void handleRemove() {
        TableItem item = this.table.getSelection()[0];
        this.editor.getAeDescription().setExternalResourceDependencies((ExternalResourceDependency[])Utility.removeElementFromArray(this.getExternalResourceDependencies(), this.getXRDependencyFromTableItem(item), ExternalResourceDependency.class));
        this.table.setSelection(this.table.getSelectionIndices()[0] - 1);
        item.dispose();
        this.finishAction();
    }

    private void handleAdd() {
        AddExternalResourceDependencyDialog dialog = new AddExternalResourceDependencyDialog(this);
        if (dialog.open() == 1) {
            return;
        }
        ExternalResourceDependency xrd = this.addNewExternalResourceDependency(dialog);
        this.addXrdToGUI("", xrd);
    }

    private void alterExistingExternalResourceDependency(ExternalResourceDependency xrd, AddExternalResourceDependencyDialog dialog) {
        this.valueChanged = false;
        String oldKey = xrd.getKey();
        xrd.setKey(this.setValueChanged(dialog.keyName, xrd.getKey()));
        if (this.valueChanged) {
            this.propagateKeyChange(dialog.keyName, oldKey);
        }
        xrd.setDescription(this.setValueChanged(this.multiLineFix(dialog.description), xrd.getDescription()));
        xrd.setInterfaceName(this.setValueChanged(dialog.interfaceName, xrd.getInterfaceName()));
        if (dialog.optional != xrd.isOptional()) {
            xrd.setOptional(dialog.optional);
            this.valueChanged = true;
        }
        if (this.valueChanged) {
            this.finishAction();
        }
    }

    private ExternalResourceDependency addNewExternalResourceDependency(AddExternalResourceDependencyDialog dialog) {
        ExternalResourceDependency[] xrds = this.getExternalResourceDependencies();
        ExternalResourceDependency_impl xrd = new ExternalResourceDependency_impl();
        this.alterExistingExternalResourceDependency((ExternalResourceDependency)xrd, dialog);
        if (null == xrds) {
            this.editor.getAeDescription().setExternalResourceDependencies(new ExternalResourceDependency[]{xrd});
        } else {
            ExternalResourceDependency[] newXrds = new ExternalResourceDependency[xrds.length + 1];
            System.arraycopy(xrds, 0, newXrds, 0, xrds.length);
            newXrds[newXrds.length - 1] = xrd;
            this.editor.getAeDescription().setExternalResourceDependencies(newXrds);
        }
        return xrd;
    }

    public void enable() {
        this.packTable(this.table);
        if (this.isPrimitive()) {
            this.addButton.setEnabled(true);
            this.editButton.setEnabled(this.table.getSelectionCount() == 1);
            this.removeButton.setEnabled(this.table.getSelectionCount() > 0);
        }
    }

    public boolean keyNameAlreadyDefined(String key) {
        ExternalResourceDependency[] xrds = this.getExternalResourceDependencies();
        if (null != xrds) {
            for (int i = 0; i < xrds.length; ++i) {
                if (!key.equals(xrds[i].getKey())) continue;
                Utility.popMessage("Key Already Defined", MessageFormat.format("The key name you specified, ''{0}'', is already defined.  Please pick a different key name.", key), 1);
                return true;
            }
        }
        return false;
    }

    public Table getTable() {
        return this.table;
    }
}

