/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.metadata.FlowControllerDeclaration;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.flow.FlowControllerDescription;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ConfigurationGroup;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.taeconfigurator.InternalErrorCDE;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSectionParm;
import org.apache.uima.taeconfigurator.editors.ui.ParameterSection;
import org.apache.uima.taeconfigurator.editors.ui.Utility;
import org.apache.uima.taeconfigurator.model.ConfigGroup;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.IManagedForm;

public class ParameterDelegatesSection
extends AbstractSectionParm {
    private Composite sectionClient;
    private ParameterSection parmSection;
    private boolean createNonSharedOverride;
    private Button createOverrideButton;
    private Button createNonSharedOverrideButton;

    public ParameterDelegatesSection(MultiPageEditor editor, Composite parent) {
        super(editor, parent, "Delegate Component Parameters", "This section shows all delegate components by their Key names, and what parameters they have.\nDouble-click a parameter or a group if you want to specify overrides for these parameters in this aggregate; this will add a default Configuration Parameter in this Aggregate for that parameter, and set the overrides.");
    }

    public void initialize(IManagedForm form) {
        this.parmSection = this.editor.getParameterPage().getParameterSection();
        super.initialize(form);
        this.sectionClient = this.newComposite((Composite)this.getSection());
        this.tree = this.newTree(this.sectionClient);
        Composite buttonContainer = this.new2ColumnComposite(this.sectionClient);
        ((GridData)buttonContainer.getLayoutData()).grabExcessVerticalSpace = false;
        this.createOverrideButton = this.newPushButton(buttonContainer, "Create Override", "Click here to create a new override for this parameter");
        this.createNonSharedOverrideButton = this.newPushButton(buttonContainer, "Create non-shared Override", "Click here to create a non-shared override for this parameter");
        this.tree.addListener(8, (Listener)this);
        this.tree.addListener(32, (Listener)this);
        this.enableBorders(this.sectionClient);
        this.toolkit.paintBordersFor(this.sectionClient);
    }

    public void refresh() {
        super.refresh();
        this.parmSection = this.editor.getParameterPage().getParameterSection();
        this.tree.removeAll();
        if (!this.isAggregate()) {
            this.getSection().setText("Not Used");
            this.getSection().setDescription("This part is only used for Aggregate Descriptors");
        } else {
            TreeItem[] items;
            this.getSection().setText("Delegate Component Parameters");
            this.getSection().setDescription("This section shows all delegate components by their Key names, and what parameters they have.\nDouble-click a parameter or a group if you want to specify overrides for these parameters in this aggregate; this will add a default Configuration Parameter in this Aggregate for that parameter, and set the overrides.");
            this.cpd = this.getAnalysisEngineMetaData().getConfigurationParameterDeclarations();
            Iterator it = this.editor.getResolvedDelegates().entrySet().iterator();
            while (it.hasNext()) {
                this.addDelegateToGUI(it.next());
            }
            FlowControllerDeclaration fcd = this.editor.getResolvedFlowControllerDeclaration();
            if (null != fcd) {
                this.addDelegateToGUI(fcd.getKey(), fcd.getSpecifier());
            }
            if ((items = this.tree.getItems()).length > 0) {
                this.tree.setSelection(new TreeItem[]{items[0]});
            }
        }
        this.enable();
    }

    private void addDelegateToGUI(Map.Entry entry) {
        this.addDelegateToGUI((String)entry.getKey(), (ResourceSpecifier)entry.getValue());
    }

    private void addDelegateToGUI(String key, ResourceSpecifier delegate) {
        if (delegate instanceof AnalysisEngineDescription || delegate instanceof CasConsumerDescription || delegate instanceof FlowControllerDescription) {
            TreeItem d = new TreeItem(this.tree, 0);
            d.setText((delegate instanceof FlowControllerDescription ? "Flow Controller Key Name: " : DELEGATE_HEADER) + key);
            d.setData((Object)key);
            this.addDelegateGroupsToGUI(d, (ResourceCreationSpecifier)delegate);
            d.setExpanded(true);
        }
    }

    private void addDelegateGroupsToGUI(TreeItem parent, ResourceCreationSpecifier delegate) {
        ConfigurationParameterDeclarations cpd1 = delegate.getMetaData().getConfigurationParameterDeclarations();
        ConfigGroup noGroup = new ConfigGroup(cpd1, 1);
        ConfigGroup commonGroup = new ConfigGroup(cpd1, 2);
        this.addDelegateGroupToGUI(parent, noGroup);
        this.addDelegateGroupToGUI(parent, commonGroup);
        ConfigurationGroup[] cgs = cpd1.getConfigurationGroups();
        if (cgs != null) {
            for (int i = 0; i < cgs.length; ++i) {
                this.addDelegateGroupToGUI(parent, new ConfigGroup(cpd1, cgs[i]));
            }
        }
    }

    private void addDelegateGroupToGUI(TreeItem parent, ConfigGroup cg) {
        ConfigurationParameter[] cps = cg.getConfigParms();
        if (null != cps && cps.length > 0) {
            TreeItem d = new TreeItem(parent, 0);
            d.setData((Object)cg);
            this.setGroupText(d, cg.getName());
            this.addDelegateParmsToGUI(d, cps);
            d.setExpanded(true);
        }
    }

    private void addDelegateParmsToGUI(TreeItem parent, ConfigurationParameter[] cps) {
        if (null != cps) {
            for (int i = 0; i < cps.length; ++i) {
                TreeItem d = new TreeItem(parent, 0);
                d.setData((Object)cps[i]);
                d.setText(this.parmGuiString(cps[i]));
                String[] overrides = cps[i].getOverrides();
                if (null == overrides || overrides.length <= 0) continue;
                this.addDelegateParmOverridesToGUI(d, overrides);
                d.setExpanded(true);
            }
        }
    }

    private void addDelegateParmOverridesToGUI(TreeItem parent, String[] overrides) {
        for (int i = 0; i < overrides.length; ++i) {
            TreeItem d = new TreeItem(parent, 0);
            d.setText(this.OVERRIDE_HEADER + overrides[i]);
        }
    }

    public void handleEvent(Event event) {
        if (event.type == 32) {
            this.showDescriptionAsToolTip(event);
        } else if (event.type == 8) {
            this.addOverrides(0 != (event.stateMask & 0x20000));
        } else if (event.widget == this.createOverrideButton) {
            this.addOverrides(false);
        } else if (event.widget == this.createNonSharedOverrideButton) {
            this.addOverrides(true);
        }
    }

    private void addOverrides(boolean nonShared) {
        TreeItem item = this.tree.getSelection()[0];
        this.createNonSharedOverride = nonShared;
        if (this.isParameter(item)) {
            this.addNewParameter(item);
        } else if (this.isGroup(item)) {
            this.addAllParameters(item.getItems());
        } else if (this.isDelegate(item)) {
            this.addAllGroups(item.getItems());
        }
    }

    public ConfigurationParameter getConfigurationParameterFromTreeItem(TreeItem item) {
        return (ConfigurationParameter)item.getData();
    }

    public ConfigGroup getConfigGroupFromTreeItem(TreeItem item) {
        return (ConfigGroup)item.getData();
    }

    private String getKeyNameFromTreeItem(TreeItem item) {
        return (String)item.getData();
    }

    private void addNewParameter(TreeItem item) {
        this.addNewParameter(this.getConfigurationParameterFromTreeItem(item), this.getConfigGroupFromTreeItem(item.getParentItem()), this.getKeyNameFromTreeItem(item.getParentItem().getParentItem()));
    }

    private void addAllParameters(TreeItem[] items) {
        for (int i = 0; i < items.length; ++i) {
            this.addNewParameter(items[i]);
        }
    }

    private void addAllGroups(TreeItem[] items) {
        for (int i = 0; i < items.length; ++i) {
            this.addAllParameters(items[i].getItems());
        }
    }

    private void addNewParameter(ConfigurationParameter parm, ConfigGroup delegateGroup, String key) {
        String override;
        String overrideParmName;
        ConfigGroup group = this.getCorrespondingModelGroup(delegateGroup);
        if (null == group) {
            group = this.parmSection.addGroup(delegateGroup);
        }
        if (null != (overrideParmName = ParameterDelegatesSection.getOverridingParmName(override = key + "/" + parm.getName(), this.cpd))) {
            Utility.popMessage("Only one override allowed", "This delegate parameter already is being overridden by '" + overrideParmName + "'.  To override " + "with a different parameter, first remove this override", 1);
            return;
        }
        ConfigurationParameter parmInGroup = this.getSameNamedParmInGroup(parm, group);
        if (null != parmInGroup) {
            if (!this.createNonSharedOverride && this.parmSpecMatches(parm, parmInGroup)) {
                if (0 <= this.getOverrideIndex(parmInGroup, override)) {
                    return;
                }
                this.parmSection.addOverride(parmInGroup, override);
            } else {
                String newName = this.generateUniqueName(parm.getName());
                this.parmSection.addParm(newName, parm, group, override);
            }
        } else if (ParameterSection.parameterNameAlreadyDefinedNoMsg(parm.getName(), this.getConfigurationParameterDeclarations())) {
            String newName = this.generateUniqueName(parm.getName());
            this.parmSection.addParm(newName, parm, group, override);
        } else {
            this.parmSection.addParm(parm.getName(), parm, group, override);
        }
    }

    public static String getOverridingParmName(String override, ConfigurationParameterDeclarations cpd) {
        String result = ParameterDelegatesSection.getOverridingParmName(override, cpd.getConfigurationParameters());
        if (null != result) {
            return result;
        }
        result = ParameterDelegatesSection.getOverridingParmName(override, cpd.getCommonParameters());
        if (null != result) {
            return result;
        }
        ConfigurationGroup[] groups = cpd.getConfigurationGroups();
        if (null != groups) {
            for (int i = 0; i < groups.length; ++i) {
                result = ParameterDelegatesSection.getOverridingParmName(override, groups[i].getConfigurationParameters());
                if (null == result) continue;
                return result;
            }
        }
        return null;
    }

    private static String getOverridingParmName(String override, ConfigurationParameter[] cps) {
        if (null != cps) {
            for (int i = 0; i < cps.length; ++i) {
                String[] overrides = cps[i].getOverrides();
                if (null == overrides) continue;
                for (int j = 0; j < overrides.length; ++j) {
                    if (!override.equals(overrides[j])) continue;
                    return cps[i].getName();
                }
            }
        }
        return null;
    }

    private String generateUniqueName(String name) {
        ArrayList allNames = new ArrayList();
        this.addParmNames(allNames, this.cpd.getConfigurationParameters());
        this.addParmNames(allNames, this.cpd.getCommonParameters());
        ConfigurationGroup[] cgs = this.cpd.getConfigurationGroups();
        if (null != cgs) {
            for (int i = 0; i < cgs.length; ++i) {
                this.addParmNames(allNames, cgs[i].getConfigurationParameters());
            }
        }
        int suffix = 1;
        String nameTry = name + suffix;
        while (allNames.contains(nameTry)) {
            nameTry = name + ++suffix;
        }
        return nameTry;
    }

    private void addParmNames(List list, ConfigurationParameter[] parms) {
        if (null != parms) {
            for (int i = 0; i < parms.length; ++i) {
                list.add(parms[i].getName());
            }
        }
    }

    private int getOverrideIndex(ConfigurationParameter parm, String override) {
        String[] overrides = parm.getOverrides();
        if (null == overrides) {
            return -1;
        }
        for (int i = 0; i < overrides.length; ++i) {
            if (!overrides[i].equals(override)) continue;
            return i;
        }
        return -1;
    }

    private ConfigurationParameter getSameNamedParmInGroup(ConfigurationParameter parm, ConfigGroup group) {
        ConfigurationParameter[] cps = group.getConfigParms();
        String parmName = parm.getName();
        for (int i = 0; i < cps.length; ++i) {
            if (!cps[i].getName().equals(parmName)) continue;
            return cps[i];
        }
        return null;
    }

    private boolean parmSpecMatches(ConfigurationParameter p, ConfigurationParameter q) {
        if (!p.getType().equals(q.getType())) {
            return false;
        }
        if (p.isMandatory() != q.isMandatory()) {
            return false;
        }
        return p.isMultiValued() == q.isMultiValued();
    }

    private ConfigGroup getCorrespondingModelGroup(ConfigGroup delegateGroup) {
        switch (delegateGroup.getKind()) {
            case 1: {
                return new ConfigGroup(this.cpd, 1);
            }
            case 2: {
                return this.getCorrespondingModelGroup(this.getAllGroupNames(delegateGroup.getCPD()));
            }
            case 4: {
                return this.getCorrespondingModelGroup(delegateGroup.getNameArray());
            }
        }
        throw new InternalErrorCDE("invalid state");
    }

    private ConfigGroup getCorrespondingModelGroup(String[] nameArray) {
        ConfigurationGroup[] cgs = this.cpd.getConfigurationGroups();
        for (int i = 0; i < cgs.length; ++i) {
            if (!this.setEquals(cgs[i].getNames(), nameArray)) continue;
            return new ConfigGroup(this.cpd, cgs[i]);
        }
        return null;
    }

    private boolean setEquals(Object[] a, Object[] b) {
        if (null == a && null == b) {
            return true;
        }
        if (null == a || null == b) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            boolean foundB = false;
            for (int j = 0; j < b.length; ++j) {
                if (!a[i].equals(b[j])) continue;
                foundB = true;
                break;
            }
            if (foundB) continue;
            return false;
        }
        return true;
    }

    public void enable() {
        this.createOverrideButton.setEnabled(this.tree.getSelectionCount() == 1);
        this.createNonSharedOverrideButton.setEnabled(this.tree.getSelectionCount() == 1);
    }
}

