/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.model.DescriptorMetaData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;

public class MetaDataSection
extends AbstractSection {
    private Text nameText;
    private Text descriptionText;
    private Text versionText;
    private Text vendorText;
    private DescriptorMetaData dmd = null;

    public void enable() {
    }

    public MetaDataSection(MultiPageEditor editor, Composite parent) {
        super(editor, parent, "Overall Identification Information", "This section specifies the basic identification information for this descriptor");
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        Composite sectionClient = this.new2ColumnComposite((Composite)this.getSection());
        this.nameText = this.newLabeledTextField(sectionClient, "Name", "NameTextToolTip", 0);
        this.versionText = this.newLabeledTextField(sectionClient, "Version", "VersionTextToolTip", 0);
        this.vendorText = this.newLabeledTextField(sectionClient, "Vendor", "VendorTextToolTip", 0);
        this.descriptionText = this.newDescriptionTextBox(sectionClient, "Enter a description of this component here.");
        this.toolkit.paintBordersFor(sectionClient);
    }

    public void refresh() {
        if (null == this.dmd) {
            this.dmd = new DescriptorMetaData(this.editor);
        }
        super.refresh();
        String name = null;
        String version = null;
        String description = null;
        String vendor = null;
        name = this.dmd.getName();
        version = this.dmd.getVersion();
        description = this.dmd.getDescription();
        vendor = this.dmd.getVendor();
        this.nameText.setText(MetaDataSection.convertNull(name));
        this.versionText.setText(MetaDataSection.convertNull(version));
        this.vendorText.setText(MetaDataSection.convertNull(vendor));
        this.descriptionText.setText(MetaDataSection.convertNull(description));
    }

    public void handleEvent(Event event) {
        this.valueChanged = false;
        this.dmd.setName(this.setValueChanged(this.nameText.getText(), this.dmd.getName()));
        this.dmd.setVersion(this.setValueChanged(this.versionText.getText(), this.dmd.getVersion()));
        this.dmd.setVendor(this.setValueChanged(this.vendorText.getText(), this.dmd.getVendor()));
        this.dmd.setDescription(this.setValueChanged(this.multiLineFix(this.descriptionText.getText()), this.dmd.getDescription()));
        if (this.valueChanged) {
            this.setFileDirty();
        }
    }
}

