/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import java.io.IOException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.FsIndexCollection;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.taeconfigurator.InternalErrorCDE;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.ImportSection;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.eclipse.swt.widgets.Composite;

public class IndexImportSection
extends ImportSection {
    public IndexImportSection(MultiPageEditor editor, Composite parent) {
        super(editor, parent, "Index Imports", "The following index definitions are included as part of this one.");
    }

    protected boolean isAppropriate() {
        return true;
    }

    protected String getDescriptionFromImport(String source) throws InvalidXMLException, IOException {
        FsIndexCollection parsedImportItem = UIMAFramework.getXMLParser().parseFsIndexCollection(new XMLInputSource(source));
        return parsedImportItem.getDescription();
    }

    protected Import[] getModelImportArray() {
        return this.getFsIndexCollection().getImports();
    }

    protected void setModelImportArray(Import[] imports) {
        if (imports == null) {
            throw new InternalErrorCDE("invalid state");
        }
        this.getFsIndexCollection().setImports(imports);
    }

    protected void clearModelBaseValue() {
        this.getAnalysisEngineMetaData().setFsIndexes(fsIndexDescription0);
    }

    protected boolean isValidImport(String title, String message) {
        FsIndexCollection savedIC = this.editor.getMergedFsIndexCollection();
        if (null != savedIC) {
            savedIC = (FsIndexCollection)savedIC.clone();
        }
        CAS savedCAS = this.editor.getCurrentView();
        try {
            this.editor.setMergedFsIndexCollection();
            this.editor.descriptorCAS.validate();
        }
        catch (ResourceInitializationException e) {
            this.revertMsg(title, message, this.editor.getMessagesToRootCause(e));
            this.editor.setMergedFsIndexCollection(savedIC);
            this.editor.descriptorCAS.set(savedCAS);
            return false;
        }
        return true;
    }

    protected void finishImportChangeAction() {
    }
}

