/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import org.apache.uima.resource.ExternalResourceDescription;
import org.apache.uima.resource.FileLanguageResourceSpecifier;
import org.apache.uima.resource.FileResourceSpecifier;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.impl.ExternalResourceDescription_impl;
import org.apache.uima.resource.impl.FileLanguageResourceSpecifier_impl;
import org.apache.uima.resource.impl.FileResourceSpecifier_impl;
import org.apache.uima.resource.metadata.ExternalResourceBinding;
import org.apache.uima.resource.metadata.impl.ExternalResourceBinding_impl;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.ImportResBindSection;
import org.apache.uima.taeconfigurator.editors.ui.ResourceDependencySection;
import org.apache.uima.taeconfigurator.editors.ui.Utility;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AddExternalResourceDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.IManagedForm;

public class ExtnlResBindSection
extends AbstractSection {
    private static final String boundHeader = "Bound to: ";
    private Composite sectionClient;
    private Tree tree;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Button bindButton;
    private Button exportButton;
    private ResourceDependencySection resourceDependencySection;
    private ImportResBindSection resBindImportSection;

    public ExtnlResBindSection(MultiPageEditor aEditor, Composite parent) {
        super(aEditor, parent, "Resources Needs, Definitions and Bindings", "Specify External Resources; Bind them to dependencies on the right panel by selecting the corresponding dependency and clicking Bind.");
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        this.sectionClient = this.new2ColumnComposite((Composite)this.getSection());
        this.tree = this.newTree(this.sectionClient);
        Composite buttonContainer = this.newButtonContainer(this.sectionClient);
        this.addButton = this.newPushButton(buttonContainer, "Add...", "Click to add a new External Resource definition");
        this.editButton = this.newPushButton(buttonContainer, "Edit...", "Click to edit an External Resource definition");
        this.removeButton = this.newPushButton(buttonContainer, "Remove", "Click to remove selected binding or External Resource");
        this.bindButton = this.newPushButton(buttonContainer, "Bind", "Click to bind selected dependency with selected Resource");
        this.exportButton = this.newPushButton(buttonContainer, "Export...", "Export to an importable part, and substitute an Import for that part here");
        buttonContainer.pack();
        this.getSection().getParent().getParent().pack();
        this.getSection().getParent().getParent().layout();
        this.initialFormWidth = this.getSection().getSize().x;
        ((GridData)this.tree.getLayoutData()).widthHint = this.initialFormWidth - buttonContainer.getSize().x;
        this.enableBorders(this.sectionClient);
        this.toolkit.paintBordersFor(this.sectionClient);
        this.tree.addListener(8, (Listener)this);
    }

    public void refresh() {
        if (null == this.resBindImportSection) {
            this.resBindImportSection = this.editor.getResourcesPage().getResBindImportSection();
        }
        super.refresh();
        this.resourceDependencySection = this.editor.getResourcesPage().getResourceDependencySection();
        ExternalResourceDescription[] xrds = this.getExternalResources();
        ExternalResourceBinding[] bindings = this.getExternalResourceBindings();
        this.tree.removeAll();
        if (null != xrds) {
            for (int i = 0; i < xrds.length; ++i) {
                this.addExternalResourceDescriptionToGUI(xrds[i], bindings);
            }
        }
        this.enable();
    }

    private void addExternalResourceDescriptionToGUI(ExternalResourceDescription xrd, ExternalResourceBinding[] bindings) {
        TreeItem item = new TreeItem(this.tree, 0);
        this.fillXrdItem(item, xrd);
        this.fillBindings(item, xrd, bindings);
        item.setExpanded(true);
    }

    private void fillXrdItem(TreeItem item, ExternalResourceDescription xrd) {
        StringBuffer text = new StringBuffer();
        text.append(xrd.getName());
        ResourceSpecifier rs = xrd.getResourceSpecifier();
        if (rs instanceof FileLanguageResourceSpecifier) {
            FileLanguageResourceSpecifier flrs = (FileLanguageResourceSpecifier)rs;
            text.append("  URL_Prefix: ").append(flrs.getFileUrlPrefix()).append("  URL_Suffix: ").append(flrs.getFileUrlSuffix());
        } else if (rs instanceof FileResourceSpecifier) {
            FileResourceSpecifier frs = (FileResourceSpecifier)rs;
            text.append("  URL: ").append(frs.getFileUrl());
        } else {
            text.append("  Custom Resource Specifier");
        }
        String implName = xrd.getImplementationName();
        if (null != implName && !implName.equals("")) {
            text.append("  Implementation: ").append(implName);
        }
        item.setText(text.toString());
        item.setData((Object)xrd);
    }

    private void fillBindings(TreeItem parent, ExternalResourceDescription xrd, ExternalResourceBinding[] bindings) {
        if (null != bindings) {
            for (int i = 0; i < bindings.length; ++i) {
                if (!bindings[i].getResourceName().equals(xrd.getName())) continue;
                this.addBindingToGUI(parent, bindings[i].getKey(), bindings[i]);
            }
        }
    }

    private void addBindingToGUI(TreeItem parent, String key, ExternalResourceBinding xrb) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(boundHeader + key);
        item.setData((Object)xrb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        if (event.widget == this.addButton) {
            this.handleAdd();
        } else if (event.widget == this.editButton || event.type == 8) {
            this.handleEdit();
        } else if (event.widget == this.removeButton || event.widget == this.tree && event.type == 2 && event.character == '\u007f') {
            this.handleRemove();
        } else if (event.widget == this.bindButton) {
            this.handleBind();
        } else if (event.widget == this.exportButton) {
            try {
                this.resBindImportSection.exportImportablePart("<resourceManagerConfiguration>", "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<resourceManagerConfiguration xmlns=\"http://uima.apache.org/resourceSpecifier\">\n<name>{0}</name>\n<description></description>\n<version>1.0</version>\n{1}</resourceManagerConfiguration>\n");
            }
            finally {
                this.refresh();
            }
        }
        this.enable();
    }

    public ExternalResourceDescription getXRDescriptionFromTreeItem(TreeItem item) {
        return (ExternalResourceDescription)item.getData();
    }

    private void handleEdit() {
        TreeItem item = this.tree.getSelection()[0];
        if (this.isBoundSpec(item)) {
            return;
        }
        ExternalResourceDescription xrd = this.getXRDescriptionFromTreeItem(item);
        ResourceSpecifier rs = xrd.getResourceSpecifier();
        if (!(rs instanceof FileResourceSpecifier) && !(rs instanceof FileLanguageResourceSpecifier)) {
            Utility.popMessage("Can''t edit custom resource", "This resource is a '" + rs.getClass().getName() + "', and any edits have to be done directly in the XML in the Source view.", 2);
            return;
        }
        AddExternalResourceDialog dialog = new AddExternalResourceDialog(this, xrd);
        if (dialog.open() == 1) {
            return;
        }
        this.alterExistingXRD(dialog, xrd, item);
    }

    private void handleAdd() {
        AddExternalResourceDialog dialog = new AddExternalResourceDialog(this);
        if (dialog.open() == 1) {
            return;
        }
        ExternalResourceDescription_impl xrd = new ExternalResourceDescription_impl();
        TreeItem item = new TreeItem(this.tree, 0);
        this.alterExistingXRD(dialog, (ExternalResourceDescription)xrd, item);
        this.getResourceManagerConfiguration().addExternalResource((ExternalResourceDescription)xrd);
    }

    private void alterExistingXRD(AddExternalResourceDialog dialog, ExternalResourceDescription xrd, TreeItem item) {
        this.valueChanged = false;
        xrd.setName(this.setValueChanged(dialog.xrName, xrd.getName()));
        xrd.setDescription(this.setValueChanged(dialog.xrDescription, xrd.getDescription()));
        xrd.setImplementationName(this.setValueChanged(dialog.xrImplementation, xrd.getImplementationName()));
        ResourceSpecifier rs = xrd.getResourceSpecifier();
        if (null == dialog.xrUrlSuffix || "".equals(dialog.xrUrlSuffix)) {
            Object frs = null != rs && rs instanceof FileResourceSpecifier ? (FileResourceSpecifier)rs : new FileResourceSpecifier_impl();
            frs.setFileUrl(this.setValueChanged(dialog.xrUrl, frs.getFileUrl()));
            xrd.setResourceSpecifier((ResourceSpecifier)frs);
        } else {
            Object flrs = null != rs && rs instanceof FileLanguageResourceSpecifier ? (FileLanguageResourceSpecifier)rs : new FileLanguageResourceSpecifier_impl();
            flrs.setFileUrlPrefix(this.setValueChanged(dialog.xrUrl, flrs.getFileUrlPrefix()));
            flrs.setFileUrlSuffix(this.setValueChanged(dialog.xrUrlSuffix, flrs.getFileUrlSuffix()));
            xrd.setResourceSpecifier((ResourceSpecifier)flrs);
        }
        this.fillXrdItem(item, xrd);
        if (this.valueChanged) {
            this.setFileDirty();
        }
    }

    private void handleBind() {
        TreeItem xrItem = this.tree.getSelection()[0];
        if (null != xrItem.getParentItem()) {
            xrItem = xrItem.getParentItem();
        }
        ExternalResourceDescription xrd = this.getXRDescriptionFromTreeItem(xrItem);
        TableItem keyItem = this.resourceDependencySection.getTable().getSelection()[0];
        ExternalResourceBinding_impl xrb = new ExternalResourceBinding_impl();
        String key = keyItem.getText(2);
        xrb.setKey(key);
        xrb.setResourceName(xrd.getName());
        this.getResourceManagerConfiguration().addExternalResourceBinding((ExternalResourceBinding)xrb);
        this.addBindingToGUI(xrItem, key, (ExternalResourceBinding)xrb);
        xrItem.setExpanded(true);
        keyItem.setText(0, "Bound");
        keyItem.getParent().getColumn(0).pack();
        this.setFileDirty();
    }

    private void handleRemove() {
        int selectionCount = this.tree.getSelectionCount();
        if (1 != selectionCount) {
            return;
        }
        TreeItem item = this.tree.getSelection()[0];
        if (null == item.getParentItem()) {
            if (1 == Utility.popOkCancel("Removing Resource", "Removing an External Resource and all its bindings. Resource name:" + item.getText(), 4)) {
                return;
            }
            this.removeAllBindings(item);
            this.removeResource(item);
        } else {
            this.removeBinding(item);
        }
    }

    public ExternalResourceBinding getXRBindingFromTreeItem(TreeItem item) {
        return (ExternalResourceBinding)item.getData();
    }

    private void removeBinding(TreeItem item) {
        ExternalResourceBinding xrb = this.getXRBindingFromTreeItem(item);
        this.getResourceManagerConfiguration().removeExternalResourceBinding(xrb);
        this.removeBoundFlagInDependencySection(xrb);
        item.dispose();
        this.setFileDirty();
    }

    private void removeBoundFlagInDependencySection(ExternalResourceBinding xrb) {
        String key = xrb.getKey();
        TableItem[] items = this.resourceDependencySection.getTable().getItems();
        for (int i = 0; i < items.length; ++i) {
            if (!key.equals(items[i].getText(2))) continue;
            items[i].setText(0, "");
        }
    }

    private void removeAllBindings(TreeItem item) {
        TreeItem[] items = item.getItems();
        for (int i = items.length - 1; i >= 0; --i) {
            this.removeBinding(items[i]);
        }
    }

    private void removeResource(TreeItem item) {
        ExternalResourceDescription xrd = this.getXRDescriptionFromTreeItem(item);
        this.getResourceManagerConfiguration().removeExternalResource(xrd);
        item.dispose();
        this.setFileDirty();
    }

    public void enable() {
        this.bindButton.setEnabled(this.tree.getSelectionCount() == 1 && this.resourceDependencySection.getTable().getSelectionCount() == 1 && "".equals(this.resourceDependencySection.getTable().getSelection()[0].getText(0)));
        this.removeButton.setEnabled(this.tree.getSelectionCount() > 0);
        this.editButton.setEnabled(this.tree.getSelectionCount() == 1 && !this.isBoundSpec(this.tree.getSelection()[0]));
        this.exportButton.setEnabled(this.tree.getItemCount() > 0);
    }

    private boolean isBoundSpec(TreeItem item) {
        return item.getText().startsWith(boundHeader);
    }

    public boolean resourceNameAlreadyDefined(String name) {
        ExternalResourceDescription[] xrds = this.getExternalResources();
        if (xrds != null) {
            for (int i = 0; i < xrds.length; ++i) {
                if (!xrds[i].getName().equals(name)) continue;
                Utility.popMessage("Name Already Defined", "The External Resource Name specified is already defined", 1);
                return true;
            }
        }
        return false;
    }
}

