/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ide.wizards;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.uima.cas.SerialFormat;
import org.apache.uima.caseditor.ide.CasEditorIdePlugin;
import org.apache.uima.caseditor.ide.wizards.ContainerElementFilter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

final class ImportDocumentWizardPage
extends WizardPage {
    private static final Set<String> defaultEncodings;
    private IPath importDestinationPath;
    private String importEncoding;
    private String language;
    private SerialFormat documentFormat;
    private TableViewer fileTable;
    private IContainer containerElement;

    protected ImportDocumentWizardPage(String pageName, IStructuredSelection currentResourceSelection) {
        super(pageName);
        this.setTitle("Import Text Files");
        this.setPageComplete(false);
    }

    private void updatePageState() {
        boolean isEncodingSupported = false;
        try {
            isEncodingSupported = Charset.isSupported(this.importEncoding);
        }
        catch (IllegalCharsetNameException e) {
            // empty catch block
        }
        String errorMessage = null;
        if (!isEncodingSupported) {
            errorMessage = "Invalid text import encoding!";
        }
        this.setErrorMessage(errorMessage);
        this.setMessage("Please select the documents to import.");
        this.setPageComplete(this.importDestinationPath != null && this.fileTable.getTable().getItemCount() > 0 && isEncodingSupported);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.fileTable = new TableViewer(composite);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 4).applyTo(this.fileTable.getControl());
        Button addButton = new Button(composite, 8);
        addButton.setLayoutData((Object)new GridData(258));
        addButton.setText("Add");
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(Display.getCurrent().getActiveShell(), 2);
                fd.setText("Choose text files");
                fd.setFilterExtensions(new String[]{"*.txt;*.rtf", "*.*"});
                fd.setFilterNames(new String[]{"Text Files", "All Files (*)"});
                if (fd.open() != null) {
                    for (String fileItem : fd.getFileNames()) {
                        ImportDocumentWizardPage.this.fileTable.add((Object)new File(fd.getFilterPath() + File.separator + fileItem));
                    }
                    ImportDocumentWizardPage.this.updatePageState();
                }
            }
        });
        Button removeButton = new Button(composite, 8);
        removeButton.setLayoutData((Object)new GridData(258));
        removeButton.setText("Remove");
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ImportDocumentWizardPage.this.fileTable.getSelection();
                Iterator seletionIterator = selection.iterator();
                Object[] selectedElements = new Object[selection.size()];
                for (int i = 0; i < selection.size(); ++i) {
                    selectedElements[i] = seletionIterator.next();
                }
                ImportDocumentWizardPage.this.fileTable.remove(selectedElements);
                ImportDocumentWizardPage.this.updatePageState();
            }
        });
        Button selectAllButton = new Button(composite, 8);
        selectAllButton.setLayoutData((Object)new GridData(258));
        selectAllButton.setText("Select All");
        selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ImportDocumentWizardPage.this.fileTable.getTable().selectAll();
                ImportDocumentWizardPage.this.fileTable.setSelection(ImportDocumentWizardPage.this.fileTable.getSelection());
            }
        });
        Button deselectAllButton = new Button(composite, 8);
        deselectAllButton.setLayoutData((Object)new GridData(258));
        deselectAllButton.setText("Deselect All");
        deselectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ImportDocumentWizardPage.this.fileTable.getTable().deselectAll();
                ImportDocumentWizardPage.this.fileTable.setSelection(ImportDocumentWizardPage.this.fileTable.getSelection());
            }
        });
        Label intoFolderLabel = new Label(composite, 0);
        intoFolderLabel.setText("Into folder:");
        final Text corpusText = new Text(composite, 2056);
        corpusText.setLayoutData((Object)new GridData(768));
        if (this.importDestinationPath != null) {
            corpusText.setText(this.importDestinationPath.toString());
        }
        Button browseForFolder = new Button(composite, 0);
        browseForFolder.setLayoutData((Object)new GridData(258));
        browseForFolder.setText("Browse");
        browseForFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog folderSelectionDialog = new ElementTreeSelectionDialog(ImportDocumentWizardPage.this.getShell(), (ILabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()), (ITreeContentProvider)new BaseWorkbenchContentProvider());
                folderSelectionDialog.addFilter((ViewerFilter)new ContainerElementFilter());
                if (ImportDocumentWizardPage.this.containerElement != null) {
                    folderSelectionDialog.setInitialSelection((Object)ImportDocumentWizardPage.this.containerElement);
                }
                folderSelectionDialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                folderSelectionDialog.setTitle("Choose folder");
                folderSelectionDialog.setMessage("Please choose a folder.");
                folderSelectionDialog.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        if (selection.length == 1) {
                            Object resourceElement;
                            Object selectedElement = selection[0];
                            if (selectedElement instanceof IAdaptable && (resourceElement = ((IAdaptable)selectedElement).getAdapter(IResource.class)) != null) {
                                selectedElement = resourceElement;
                            }
                            if (selectedElement instanceof IContainer) {
                                return new Status(0, "org.apache.uima.caseditor", 0, "", null);
                            }
                        }
                        return new Status(4, "org.apache.uima.caseditor", 0, "Please select a folder!", null);
                    }
                });
                folderSelectionDialog.open();
                Object[] results = folderSelectionDialog.getResult();
                if (results != null && results.length > 0) {
                    if (results[0] instanceof IContainer) {
                        ImportDocumentWizardPage.this.containerElement = (IContainer)results[0];
                    } else if (results[0] instanceof IAdaptable) {
                        IAdaptable adaptableElement = (IAdaptable)results[0];
                        ImportDocumentWizardPage.this.containerElement = (IContainer)adaptableElement.getAdapter(IResource.class);
                    } else {
                        throw new IllegalStateException("Unexpected selection!");
                    }
                    ImportDocumentWizardPage.this.importDestinationPath = ImportDocumentWizardPage.this.containerElement.getFullPath();
                    corpusText.setText(ImportDocumentWizardPage.this.importDestinationPath.toString());
                    ImportDocumentWizardPage.this.updatePageState();
                }
            }
        });
        Group importOptions = new Group(composite, 0);
        importOptions.setText("Options");
        GridLayout importOptionsGridLayout = new GridLayout();
        importOptionsGridLayout.numColumns = 2;
        importOptions.setLayout((Layout)importOptionsGridLayout);
        GridData importOptionsGridData = new GridData(4, 2, true, false);
        importOptionsGridData.horizontalSpan = 3;
        importOptions.setLayoutData((Object)importOptionsGridData);
        Label languageLabel = new Label((Composite)importOptions, 0);
        languageLabel.setText("Language:");
        final IPreferenceStore store = CasEditorIdePlugin.getDefault().getPreferenceStore();
        final Text languageText = new Text((Composite)importOptions, 2048);
        languageText.setLayoutData((Object)new GridData(768));
        this.language = store.getString("CAS_IMPORT_WIZARD_LAST_USED_LANG");
        languageText.setText(this.language);
        languageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportDocumentWizardPage.this.language = languageText.getText();
                store.setValue("CAS_IMPORT_WIZARD_LAST_USED_LANG", ImportDocumentWizardPage.this.language);
            }
        });
        Label encodingLabel = new Label((Composite)importOptions, 0);
        encodingLabel.setText("Text Encoding:");
        final Combo encodingCombo = new Combo((Composite)importOptions, 0);
        encodingCombo.setLayoutData((Object)new GridData(768));
        HashSet<String> charsets = new HashSet<String>();
        charsets.addAll(defaultEncodings);
        String lastUsedEncodingsString = store.getString("CAS_IMPORT_WIZARD_ENCODINGS");
        String[] lastUsedEncodings = lastUsedEncodingsString.split(";");
        charsets.addAll(Arrays.asList(lastUsedEncodings));
        this.importEncoding = lastUsedEncodings.length > 0 ? lastUsedEncodings[0] : Charset.defaultCharset().displayName();
        encodingCombo.setItems(charsets.toArray(new String[charsets.size()]));
        encodingCombo.setText(this.importEncoding);
        encodingCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImportDocumentWizardPage.this.importEncoding = encodingCombo.getText();
                ImportDocumentWizardPage.this.updatePageState();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        encodingCombo.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                ImportDocumentWizardPage.this.importEncoding = encodingCombo.getText();
                ImportDocumentWizardPage.this.updatePageState();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        Label casFormatLabel = new Label((Composite)importOptions, 0);
        casFormatLabel.setText("Cas Format:");
        final Combo casFormatCombo = new Combo((Composite)importOptions, 8);
        casFormatCombo.setLayoutData((Object)new GridData(768));
        SerialFormat[] values = SerialFormat.values();
        String[] stringValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            stringValues[i] = values[i].toString();
        }
        casFormatCombo.setItems(stringValues);
        this.documentFormat = SerialFormat.XMI;
        casFormatCombo.select(0);
        casFormatCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImportDocumentWizardPage.this.documentFormat = SerialFormat.valueOf((String)casFormatCombo.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.updatePageState();
        this.setControl((Control)composite);
    }

    IPath getImportDestinationPath() {
        return this.importDestinationPath;
    }

    List<File> getFilesToImport() {
        ArrayList<File> files = new ArrayList<File>(this.fileTable.getTable().getItemCount());
        for (int i = 0; i < this.fileTable.getTable().getItemCount(); ++i) {
            files.add((File)this.fileTable.getElementAt(i));
        }
        return files;
    }

    String getTextEncoding() {
        return this.importEncoding;
    }

    String getLanguage() {
        return this.language;
    }

    SerialFormat getCasFormat() {
        return this.documentFormat;
    }

    static {
        HashSet<String> encodings = new HashSet<String>();
        encodings.add("US-ASCII");
        encodings.add("ISO-8859-1");
        encodings.add("UTF-8");
        encodings.add("UTF-16BE");
        encodings.add("UTF-16LE");
        encodings.add("UTF-16");
        encodings.add(Charset.defaultCharset().displayName());
        defaultEncodings = Collections.unmodifiableSet(encodings);
    }
}

