/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.ide.searchstrategy;

import java.util.Map;
import java.util.TreeMap;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.ide.searchstrategy.ITypeSystemSearchStrategy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSystemSearchStrategyFactory {
    private static final String SEARCH_STRATEGY_EXTENSION = "org.apache.uima.caseditor.ide.searchstrategy";
    private static TypeSystemSearchStrategyFactory instance;
    private Map<Integer, ITypeSystemSearchStrategy> searchStrategies = new TreeMap<Integer, ITypeSystemSearchStrategy>();

    private TypeSystemSearchStrategyFactory() {
        IConfigurationElement[] config;
        for (IConfigurationElement element : config = Platform.getExtensionRegistry().getConfigurationElementsFor(SEARCH_STRATEGY_EXTENSION)) {
            Object searchStrategyObject;
            if (!"searchStrategy".equals(element.getName())) continue;
            String id = element.getAttribute("id");
            String priority = element.getAttribute("priority");
            try {
                searchStrategyObject = element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                CasEditorPlugin.log((String)("Failed to load search strategy with id: " + id), (Throwable)e);
                searchStrategyObject = null;
            }
            if (!(searchStrategyObject instanceof ITypeSystemSearchStrategy)) continue;
            this.searchStrategies.put(Integer.parseInt(priority), (ITypeSystemSearchStrategy)searchStrategyObject);
        }
    }

    public static TypeSystemSearchStrategyFactory instance() {
        if (instance == null) {
            instance = new TypeSystemSearchStrategyFactory();
        }
        return instance;
    }

    public Map<Integer, ITypeSystemSearchStrategy> getSearchStrategies() {
        return this.searchStrategies;
    }
}

