/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.container;

import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.collection.impl.base_cpm.container.CasProcessorConfiguration;
import org.apache.uima.collection.impl.cpm.container.deployer.JavaApplication;
import org.apache.uima.collection.impl.cpm.container.deployer.NonJavaApplication;
import org.apache.uima.collection.impl.cpm.utils.CPMUtils;
import org.apache.uima.collection.impl.cpm.utils.CpmLocalizedMessage;
import org.apache.uima.collection.impl.cpm.utils.Execute;
import org.apache.uima.collection.impl.cpm.utils.Filter;
import org.apache.uima.collection.metadata.CasProcessorDeploymentParam;
import org.apache.uima.collection.metadata.CasProcessorDeploymentParams;
import org.apache.uima.collection.metadata.CasProcessorErrorHandling;
import org.apache.uima.collection.metadata.CasProcessorErrorRateThreshold;
import org.apache.uima.collection.metadata.CasProcessorMaxRestarts;
import org.apache.uima.collection.metadata.CasProcessorRunInSeperateProcess;
import org.apache.uima.collection.metadata.CasProcessorTimeout;
import org.apache.uima.collection.metadata.CpeCasProcessor;
import org.apache.uima.collection.metadata.CpeCheckpoint;
import org.apache.uima.collection.metadata.CpeComponentDescriptor;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.NameValuePair;
import org.apache.uima.resource.metadata.impl.NameValuePair_impl;
import org.apache.uima.util.Level;

public class CasProcessorConfigurationJAXBImpl
implements CasProcessorConfiguration {
    private String actionOnMaxError;
    private String actionOnMaxRestarts;
    private String name;
    private CpeComponentDescriptor descriptor;
    private String deploymentType;
    private String filterString;
    private long errorSampleSize;
    private long timeOut;
    private int errorRate;
    private int maxErrorThreshold;
    private int maxRestartThreshold;
    private int maxRetryThreshold;
    private int batchSize;
    private boolean runInSeparateProcess;
    private boolean isJavaProcess;
    private NonJavaApplication nonJavaApp;
    private JavaApplication javaApp;
    private List<NameValuePair> deploymentParameters = null;
    private int waitTimeBetweenRestarts = 0;
    private boolean parallelizable = true;
    private boolean readOnly = false;
    private ResourceManager resourceManager;

    public CasProcessorConfigurationJAXBImpl(CpeCasProcessor aCasProcessorConfig, ResourceManager aResourceManager) throws ResourceConfigurationException {
        this.resourceManager = aResourceManager;
        if (aCasProcessorConfig == null) {
            throw new ResourceConfigurationException("element_not_found", new Object[]{"<casProcessor>", "<casProcessors>"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_bad_cpe_descriptor__WARNING", new Object[]{Thread.currentThread().getName()})));
        }
        this.name = aCasProcessorConfig.getName();
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_max_restart_action__FINEST", new Object[]{Thread.currentThread().getName(), this.name, aCasProcessorConfig.getErrorHandling().getMaxConsecutiveRestarts().getAction()});
        }
        this.parallelizable = aCasProcessorConfig.getIsParallelizable();
        this.addErrorHandling(aCasProcessorConfig);
        this.addDeploymentParameters(aCasProcessorConfig);
        this.addDeploymentType(aCasProcessorConfig);
        this.addFiltering(aCasProcessorConfig);
        this.addBatchSize(aCasProcessorConfig);
        this.addDescriptor(aCasProcessorConfig);
        this.addRunInSeparateProcess(aCasProcessorConfig);
        this.addIsJavaProcess(aCasProcessorConfig);
        if (!this.isJavaProcess()) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_config_non_java_service__FINEST", new Object[]{Thread.currentThread().getName(), this.name});
            }
            this.nonJavaApp = new NonJavaApplication(this, aCasProcessorConfig);
        } else {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_config_java_service__FINEST", new Object[]{Thread.currentThread().getName(), this.name});
            }
            this.javaApp = new JavaApplication(this, aCasProcessorConfig);
        }
    }

    @Override
    public int getMaxTimeToWaitBetweenRetries() {
        return this.waitTimeBetweenRestarts;
    }

    public boolean isParallelizable() {
        return this.parallelizable;
    }

    public boolean readOnly() {
        return this.readOnly;
    }

    private void addRunInSeparateProcess(CpeCasProcessor aCasProcessorConfig) {
        this.runInSeparateProcess = aCasProcessorConfig.getRunInSeparateProcess() != null;
    }

    private void addIsJavaProcess(CpeCasProcessor aCasProcessorConfig) {
        this.isJavaProcess = false;
        CasProcessorRunInSeperateProcess runInProcessType = aCasProcessorConfig.getRunInSeparateProcess();
        if (runInProcessType != null && runInProcessType.getExecutable() != null && "java".equals(runInProcessType.getExecutable().getExecutable().trim())) {
            this.isJavaProcess = true;
        }
    }

    private void addErrorHandling(CpeCasProcessor aCasProcessorConfig) throws ResourceConfigurationException {
        CasProcessorErrorHandling casProcessorErrorHandling = aCasProcessorConfig.getErrorHandling();
        if (casProcessorErrorHandling == null) {
            throw new ResourceConfigurationException("element_not_found", new Object[]{"errorHandling", "casProcessor"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_xml_element__WARNING", new Object[]{Thread.currentThread().getName(), this.name, "<errorHandling>"})));
        }
        CasProcessorMaxRestarts maxRestarts = casProcessorErrorHandling.getMaxConsecutiveRestarts();
        if (maxRestarts == null) {
            throw new ResourceConfigurationException("mandatory_value_missing", new Object[]{"maxConsecutiveRestarts", "CPE"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_xml_element__WARNING", new Object[]{Thread.currentThread().getName(), this.name, "<maxConsecutiveRestarts>"})));
        }
        this.maxRetryThreshold = maxRestarts.getRestartCount();
        this.waitTimeBetweenRestarts = maxRestarts.getWaitTimeBetweenRetries();
        this.maxRestartThreshold = maxRestarts.getRestartCount();
        if (!this.validActionOnError(maxRestarts.getAction())) {
            throw new ResourceConfigurationException("mandatory_value_missing", new Object[]{"action", "CPE"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_bad_action_string__WARNING", new Object[]{Thread.currentThread().getName(), this.name, "<maxConsecutiveRestarts>", maxRestarts.getAction()})));
        }
        this.actionOnMaxRestarts = maxRestarts.getAction();
        CasProcessorErrorRateThreshold errorRateThresholdType = casProcessorErrorHandling.getErrorRateThreshold();
        if (errorRateThresholdType == null) {
            throw new ResourceConfigurationException("mandatory_value_missing", new Object[]{"errorRateThreshold", "CPE"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_xml_element__WARNING", new Object[]{Thread.currentThread().getName(), this.name, "<errorRateThreshold>"})));
        }
        this.errorRate = errorRateThresholdType.getMaxErrorCount();
        this.errorSampleSize = errorRateThresholdType.getMaxErrorSampleSize();
        if (!this.validActionOnError(errorRateThresholdType.getAction())) {
            throw new ResourceConfigurationException("mandatory_value_missing", new Object[]{"action", "CPE"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_bad_action_string__WARNING", new Object[]{Thread.currentThread().getName(), this.name, "<errorRateThreshold>", maxRestarts.getAction()})));
        }
        this.actionOnMaxError = errorRateThresholdType.getAction();
        CasProcessorTimeout timeoutType = casProcessorErrorHandling.getTimeout();
        this.timeOut = timeoutType.get();
    }

    private void addDeploymentParameters(CpeCasProcessor aCasProcessorConfig) throws ResourceConfigurationException {
        if (aCasProcessorConfig == null) {
            throw new ResourceConfigurationException("element_not_found", new Object[]{"<casProcessor>", "<casProcessors>"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_bad_cpe_descriptor_no_cp__WARNING", new Object[]{Thread.currentThread().getName()})));
        }
        CasProcessorDeploymentParams deployParams = aCasProcessorConfig.getDeploymentParams();
        if (deployParams != null) {
            CasProcessorDeploymentParam[] parameters = deployParams.getAll();
            for (int i = 0; parameters != null && i < parameters.length; ++i) {
                try {
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_cp_deploy_params__FINEST", new Object[]{Thread.currentThread().getName(), this.name, parameters[i].getParameterName(), parameters[i].getParameterValue()});
                    }
                    NameValuePair_impl nvp = new NameValuePair_impl();
                    nvp.setName(parameters[i].getParameterName());
                    String value = CPMUtils.convertToAbsolutePath(System.getProperty("CPM_HOME"), "${CPM_HOME}", parameters[i].getParameterValue());
                    nvp.setValue((Object)value);
                    if (this.deploymentParameters == null) {
                        this.deploymentParameters = new ArrayList<NameValuePair>();
                    }
                    this.deploymentParameters.add((NameValuePair)nvp);
                    continue;
                }
                catch (Exception e) {
                    throw new ResourceConfigurationException((Throwable)e);
                }
            }
        }
        CasProcessorRunInSeperateProcess rsp = null;
        rsp = aCasProcessorConfig.getRunInSeparateProcess();
        if (rsp != null && rsp.getExecutable() != null && this.deploymentParameters == null) {
            this.deploymentParameters = new ArrayList<NameValuePair>();
        }
    }

    private void addDeploymentType(CpeCasProcessor aCasProcessorConfig) throws ResourceConfigurationException {
        if (aCasProcessorConfig == null) {
            throw new ResourceConfigurationException("element_not_found", new Object[]{"<casProcessor>", "<casProcessors>"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_bad_cpe_descriptor_no_cp__WARNING", new Object[]{Thread.currentThread().getName()})));
        }
        String deployType = aCasProcessorConfig.getDeployment();
        if (deployType == null || deployType.trim().length() == 0) {
            throw new ResourceConfigurationException("required_attribute_missing", new Object[]{"deployment", "casProcessor"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_attribute_from_xml_element__WARNING", new Object[]{Thread.currentThread().getName(), aCasProcessorConfig.getName(), "deployment", "<casProcessor>"})));
        }
        this.deploymentType = deployType;
    }

    private void addFiltering(CpeCasProcessor aCasProcessorConfig) throws ResourceConfigurationException {
        if (aCasProcessorConfig == null) {
            throw new ResourceConfigurationException("element_not_found", new Object[]{"<casProcessor>", "<casProcessors>"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_bad_cpe_descriptor_no_cp__WARNING", new Object[]{Thread.currentThread().getName()})));
        }
        this.filterString = aCasProcessorConfig.getCasProcessorFilter();
    }

    private void addBatchSize(CpeCasProcessor aCasProcessorConfig) throws ResourceConfigurationException {
        if (aCasProcessorConfig == null) {
            throw new ResourceConfigurationException("element_not_found", new Object[]{"<casProcessor>", "<casProcessors>"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_bad_cpe_descriptor_no_cp__WARNING", new Object[]{Thread.currentThread().getName()})));
        }
        CpeCheckpoint checkpoint = aCasProcessorConfig.getCheckpoint();
        if (checkpoint == null) {
            throw new ResourceConfigurationException("element_not_found", new Object[]{"<checkpoint>", "<casProcessor>"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_xml_element__WARNING", new Object[]{Thread.currentThread().getName(), aCasProcessorConfig.getName(), "<checkpoint>"})));
        }
        try {
            if (checkpoint.getBatchSize() > 0) {
                this.batchSize = checkpoint.getBatchSize();
            }
        }
        catch (NumberFormatException e) {
            throw new ResourceConfigurationException("required_attribute_missing", new Object[]{"batch", "<checkpoint>"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_attribute_from_xml_element__WARNING", new Object[]{Thread.currentThread().getName(), aCasProcessorConfig.getName(), "batch", "<checkpoint>"})));
        }
    }

    private void addDescriptor(CpeCasProcessor aCasProcessorConfig) throws ResourceConfigurationException {
        String descPath;
        if (aCasProcessorConfig == null) {
            throw new ResourceConfigurationException("element_not_found", new Object[]{"<casProcessor>", "<casProcessors>"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_bad_cpe_descriptor_no_cp__WARNING", new Object[]{Thread.currentThread().getName()})));
        }
        this.descriptor = aCasProcessorConfig.getCpeComponentDescriptor();
        if (this.descriptor.getInclude() != null && ((descPath = this.descriptor.getInclude().get()) == null || descPath.trim().length() == 0)) {
            throw new ResourceConfigurationException("element_not_found", new Object[]{"href", "include"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_attribute_from_xml_element__WARNING", new Object[]{Thread.currentThread().getName(), aCasProcessorConfig.getName(), "href", "<include>"})));
        }
    }

    private boolean validActionOnError(String aActionOnError) {
        return "continue".equals(aActionOnError.toLowerCase()) || "disable".equals(aActionOnError.toLowerCase()) || "terminate".equals(aActionOnError.toLowerCase()) || "kill-pipeline".equals(aActionOnError.toLowerCase());
    }

    @Override
    public String getActionOnError() {
        return this.actionOnMaxError;
    }

    @Override
    public String getActionOnMaxRestart() {
        return this.actionOnMaxRestarts;
    }

    @Override
    public int getErrorRate() {
        return this.errorRate;
    }

    @Override
    public long getErrorSampleSize() {
        return this.errorSampleSize;
    }

    @Override
    public int getMaxErrorCount() {
        return this.maxErrorThreshold;
    }

    @Override
    public int getMaxRestartCount() {
        return this.maxRestartThreshold;
    }

    @Override
    public int getMaxRetryCount() {
        return this.maxRetryThreshold;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getTimeout() {
        return this.timeOut;
    }

    @Override
    public List<NameValuePair> getDeploymentParameters() {
        return this.deploymentParameters;
    }

    @Override
    public String getDeploymentType() {
        return this.deploymentType;
    }

    @Override
    public String getFilterString() {
        return this.filterString;
    }

    @Override
    public LinkedList getFilter() throws ResourceConfigurationException {
        String filterExpression = null;
        try {
            filterExpression = this.getFilterString();
            if (filterExpression != null) {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_cp_filter__FINEST", new Object[]{Thread.currentThread().getName(), this.name, filterExpression});
                }
                Filter filter = new Filter();
                return filter.parse(filterExpression);
            }
        }
        catch (Exception e) {
            throw new ResourceConfigurationException("invalid_element_text", new Object[]{"filter"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_xml_element__WARNING", new Object[]{Thread.currentThread().getName(), this.name, "filer"})));
        }
        return null;
    }

    @Override
    public String[] getKeysToDrop() throws ResourceConfigurationException {
        try {
            String dropFeatureFile = this.getDeploymentParameter("filterKeyMap");
            String[] keysToDrop = null;
            if (dropFeatureFile != null && dropFeatureFile.trim().length() > 0) {
                String descriptorPath = CPMUtils.convertToAbsolutePath(System.getProperty("CPM_HOME"), "${CPM_HOME}", dropFeatureFile);
                try {
                    keysToDrop = CPMUtils.getKeys2Drop(descriptorPath);
                    return keysToDrop;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            throw new ResourceConfigurationException("element_not_found", new Object[]{"parameter"}, (Throwable)new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_xml_element__WARNING", new Object[]{Thread.currentThread().getName(), this.name, "parameter"})));
        }
        return null;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public URL getDescriptorUrl() throws ResourceConfigurationException {
        return this.descriptor.findAbsoluteUrl(this.resourceManager);
    }

    @Override
    public String getDeploymentParameter(String aDeployParameter) {
        String desc = null;
        if (aDeployParameter == null || this.deploymentParameters == null) {
            return null;
        }
        for (int i = 0; i < this.deploymentParameters.size(); ++i) {
            NameValuePair nvp = this.deploymentParameters.get(i);
            if (!aDeployParameter.equals(nvp.getName().trim())) continue;
            desc = (String)nvp.getValue();
            break;
        }
        return desc;
    }

    @Override
    public boolean runInSeparateProcess() {
        return this.runInSeparateProcess;
    }

    @Override
    public boolean isJavaProcess() {
        return this.isJavaProcess;
    }

    @Override
    public Execute getExecSpec() {
        if (!this.isJavaProcess()) {
            return this.nonJavaApp.getExecSpec();
        }
        return this.javaApp.getExecSpec();
    }
}

