/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.engine;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.uima.UIMAFramework;
import org.apache.uima.adapter.vinci.util.Descriptor;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.impl.AnalysisEngineImplBase;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.collection.CasConsumer;
import org.apache.uima.collection.CasInitializer;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.collection.StatusCallbackListener;
import org.apache.uima.collection.base_cpm.AbortCPMException;
import org.apache.uima.collection.base_cpm.BaseCollectionReader;
import org.apache.uima.collection.base_cpm.BaseStatusCallbackListener;
import org.apache.uima.collection.base_cpm.CasDataCollectionReader;
import org.apache.uima.collection.base_cpm.CasDataConsumer;
import org.apache.uima.collection.base_cpm.CasObjectProcessor;
import org.apache.uima.collection.base_cpm.CasProcessor;
import org.apache.uima.collection.base_cpm.RecoverableCollectionReader;
import org.apache.uima.collection.base_cpm.SkipCasException;
import org.apache.uima.collection.impl.EntityProcessStatusImpl;
import org.apache.uima.collection.impl.base_cpm.container.ProcessingContainer;
import org.apache.uima.collection.impl.base_cpm.container.deployer.CasProcessorDeployer;
import org.apache.uima.collection.impl.base_cpm.container.deployer.CasProcessorDeploymentException;
import org.apache.uima.collection.impl.cpm.CheckpointData;
import org.apache.uima.collection.impl.cpm.container.CPEFactory;
import org.apache.uima.collection.impl.cpm.container.deployer.DeployFactory;
import org.apache.uima.collection.impl.cpm.container.deployer.socket.ProcessControllerAdapter;
import org.apache.uima.collection.impl.cpm.engine.ArtifactProducer;
import org.apache.uima.collection.impl.cpm.engine.BoundedWorkQueue;
import org.apache.uima.collection.impl.cpm.engine.CPECasPool;
import org.apache.uima.collection.impl.cpm.engine.CPMThreadGroup;
import org.apache.uima.collection.impl.cpm.engine.DebugControlThread;
import org.apache.uima.collection.impl.cpm.engine.EOFToken;
import org.apache.uima.collection.impl.cpm.engine.NonThreadedProcessingUnit;
import org.apache.uima.collection.impl.cpm.engine.ProcessingUnit;
import org.apache.uima.collection.impl.cpm.utils.CPMUtils;
import org.apache.uima.collection.impl.cpm.utils.ChunkMetadata;
import org.apache.uima.collection.impl.cpm.utils.CpmLocalizedMessage;
import org.apache.uima.collection.impl.cpm.utils.TimerFactory;
import org.apache.uima.collection.metadata.CpeCasProcessor;
import org.apache.uima.collection.metadata.CpeCasProcessors;
import org.apache.uima.collection.metadata.CpeConfiguration;
import org.apache.uima.collection.metadata.CpeDescription;
import org.apache.uima.internal.util.JavaTimer;
import org.apache.uima.resource.CasManager;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.resource.metadata.OperationalProperties;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.util.Level;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.ProcessTraceEvent;
import org.apache.uima.util.Progress;
import org.apache.uima.util.UimaTimer;
import org.apache.uima.util.impl.ProcessTrace_impl;

public class CPMEngine
extends Thread {
    private static final int MAX_WAIT_ON_QUEUE = 400;
    private static final int CAS_PROCESSED_MSG = 1000;
    private static final String SINGLE_THREADED_MODE = "single-threaded";
    public CPECasPool casPool;
    public final Object lockForPause = new Object();
    private BaseCollectionReader collectionReader = null;
    protected boolean pause = false;
    protected volatile boolean isRunning = false;
    protected volatile boolean stopped = false;
    protected volatile boolean killed = false;
    private boolean pauseOnException = false;
    private LinkedList annotatorList = new LinkedList();
    private LinkedList annotatorDeployList = new LinkedList();
    private LinkedList consumerList = new LinkedList();
    private LinkedList consumerDeployList = new LinkedList();
    private long numToProcess = -1L;
    private int poolSize = 0;
    private ProcessTrace procTr = null;
    private Map stats = new HashMap();
    private ArrayList statusCbL = new ArrayList();
    private int readerFetchSize = 1;
    private int inputQueueSize = 1;
    private int outputQueueSize = 1;
    private int concurrentThreadCount = 1;
    private Hashtable analysisEngines = new Hashtable();
    private Hashtable consumers = new Hashtable();
    private CasProcessor[] casprocessorList;
    private ArtifactProducer producer = null;
    private CPEFactory cpeFactory = null;
    protected ProcessingUnit[] processingUnits = null;
    private ProcessingUnit casConsumerPU = null;
    protected BoundedWorkQueue outputQueue = null;
    protected BoundedWorkQueue workQueue = null;
    private CheckpointData checkpointData = null;
    private boolean mixedCasProcessorTypeSupport = false;
    private Properties mPerformanceTuningSettings = UIMAFramework.getDefaultPerformanceTuningProperties();
    private DebugControlThread dbgCtrlThread = null;
    private ProcessControllerAdapter pca = null;
    private int activeProcessingUnits = 1;
    private boolean hardKill = false;
    private Hashtable skippedDocs = new Hashtable();
    private Capability[] definedCapabilities = null;
    private boolean needsTCas = true;
    private long crFetchTime = 0L;
    private int readerState = 0;
    private boolean dropCasOnExceptionPolicy = false;
    private boolean singleThreadedCPE = false;
    private NonThreadedProcessingUnit nonThreadedProcessingUnit = null;
    private NonThreadedProcessingUnit nonThreadedCasConsumerProcessingUnit = null;
    private LinkedList initial_cp_list = new LinkedList();
    private boolean casProcessorsDeployed = false;
    private boolean consumerThreadStarted = false;
    private boolean readerThreadStarted = false;
    private int[] processingThreadsState = null;

    public CPMEngine(CPMThreadGroup aThreadGroup, CPEFactory aCpeFactory, ProcessTrace aProcTr, CheckpointData aCheckpointData) throws Exception {
        super((ThreadGroup)aThreadGroup, "CPMEngine Thread");
        CpeCasProcessors proc;
        CpeDescription desc;
        this.cpeFactory = aCpeFactory;
        this.procTr = aProcTr;
        if (this.cpeFactory.getCPEConfig() != null && this.cpeFactory.getCPEConfig().getDeployment().equalsIgnoreCase(SINGLE_THREADED_MODE)) {
            if (UIMAFramework.getLogger().isLoggable(Level.CONFIG)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_single_threaded_mode__CONFIG", new Object[]{Thread.currentThread().getName()});
            }
            this.singleThreadedCPE = true;
        } else if (UIMAFramework.getLogger().isLoggable(Level.CONFIG)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_multi_threaded_mode__CONFIG", new Object[]{Thread.currentThread().getName()});
        }
        this.checkpointData = aCheckpointData;
        CPEFactory factory = this.cpeFactory;
        if (factory != null && (desc = factory.getCpeDescriptor()) != null && (proc = desc.getCpeCasProcessors()) != null) {
            this.dropCasOnExceptionPolicy = proc.getDropCasOnException();
        }
    }

    public LinkedList getProcessingContainers() {
        return this.annotatorList;
    }

    public LinkedList getAllProcessingContainers() {
        LinkedList all = new LinkedList();
        all.addAll(this.annotatorList);
        all.addAll(this.consumerList);
        return all;
    }

    public int getThreadCount() throws ResourceConfigurationException {
        return this.cpeFactory.getProcessingUnitThreadCount();
    }

    public void setStats(Map aMap) {
        this.stats = aMap;
    }

    public Map getStats() {
        return this.stats;
    }

    public void setPauseOnException(boolean aPause) {
        this.pauseOnException = aPause;
    }

    public boolean isPauseOnException() {
        return this.pauseOnException;
    }

    public void setInputQueueSize(int aInputQueueSize) {
        this.inputQueueSize = aInputQueueSize;
    }

    public void setOutputQueueSize(int aOutputQueueSize) {
        this.outputQueueSize = aOutputQueueSize;
    }

    public void setPoolSize(int aPoolSize) {
        this.poolSize = aPoolSize;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setConcurrentThreadSize(int aConcurrentThreadSize) {
        this.concurrentThreadCount = aConcurrentThreadSize;
    }

    public void addStatusCallbackListener(BaseStatusCallbackListener aListener) {
        if (aListener != null) {
            this.statusCbL.add(aListener);
        }
    }

    public ArrayList getCallbackListeners() {
        return this.statusCbL;
    }

    public void removeStatusCallbackListener(BaseStatusCallbackListener aListener) {
        this.statusCbL.remove(aListener);
    }

    public boolean isKilled() {
        return this.killed;
    }

    private void dumpState() {
        try {
            if (this.cpeFactory.getCPEConfig() != null && this.cpeFactory.getCPEConfig().getDeployment().equalsIgnoreCase(SINGLE_THREADED_MODE)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_cr_state__INFO", new Object[]{Thread.currentThread().getName(), String.valueOf(this.readerState)});
                for (int i = 0; this.processingUnits != null && i < this.processingUnits.length; ++i) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_pu_state__INFO", new Object[]{Thread.currentThread().getName(), String.valueOf(i), String.valueOf(this.processingUnits[i].threadState)});
                }
                if (this.casConsumerPU != null) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_cc_state__INFO", new Object[]{Thread.currentThread().getName(), String.valueOf(this.casConsumerPU.threadState)});
                }
            } else {
                if (this.producer != null) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_cr_state__INFO", new Object[]{Thread.currentThread().getName(), String.valueOf(this.producer.threadState)});
                }
                for (int i = 0; this.processingUnits != null && i < this.processingUnits.length; ++i) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_pu_state__INFO", new Object[]{Thread.currentThread().getName(), String.valueOf(i), String.valueOf(this.processingUnits[i].threadState)});
                }
                if (this.casConsumerPU != null) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_cc_state__INFO", new Object[]{Thread.currentThread().getName(), String.valueOf(this.casConsumerPU.threadState)});
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killIt() {
        this.isRunning = false;
        this.killed = true;
        this.hardKill = true;
        this.dumpState();
        if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_killing_cpm__INFO", new Object[]{Thread.currentThread().getName()});
        }
        if (this.workQueue != null) {
            while (this.workQueue.getCurrentSize() > 0) {
                this.workQueue.dequeue();
            }
        }
        if (this.outputQueue != null) {
            while (this.outputQueue.getCurrentSize() > 0) {
                this.outputQueue.dequeue();
            }
        }
        if (this.casPool != null) {
            CPECasPool cPECasPool = this.casPool;
            synchronized (cPECasPool) {
                this.casPool.notifyAll();
            }
        }
        if (this.workQueue != null) {
            Object[] eofToken = new Object[]{new EOFToken()};
            this.workQueue.enqueue(eofToken);
            UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_terminate_pipelines__INFO", new Object[]{Thread.currentThread().getName(), String.valueOf(this.killed)});
        }
    }

    public boolean isHardKilled() {
        return this.hardKill;
    }

    @Deprecated
    public void asynchStop() {
        if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_terminate_pipelines__INFO", new Object[]{Thread.currentThread().getName(), String.valueOf(this.killed)});
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object[] eofToken = new Object[]{new EOFToken()};
                CPMEngine.this.workQueue.enqueue(eofToken);
                CPMEngine.this.stopped = true;
                CPMEngine.this.killed = true;
                if (!CPMEngine.this.isRunning) {
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_already_stopped__FINEST", new Object[]{Thread.currentThread().getName()});
                    }
                    return;
                }
                try {
                    CPMEngine.this.isRunning = false;
                    Object object = CPMEngine.this.lockForPause;
                    synchronized (object) {
                        if (CPMEngine.this.pause) {
                            CPMEngine.this.pause = false;
                            CPMEngine.this.lockForPause.notifyAll();
                        }
                    }
                    int cc = CPMEngine.this.workQueue.getCurrentSize();
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_consuming_queue__FINEST", new Object[]{Thread.currentThread().getName(), CPMEngine.this.workQueue.getName(), String.valueOf(cc)});
                    }
                    while (CPMEngine.this.workQueue.getCurrentSize() > 0) {
                        1.sleep(400L);
                        if (System.getProperty("DEBUG") == null || cc >= CPMEngine.this.workQueue.getCurrentSize()) continue;
                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_wait_consuming_queue__FINEST", new Object[]{Thread.currentThread().getName(), CPMEngine.this.workQueue.getName(), String.valueOf(CPMEngine.this.workQueue.getCurrentSize())});
                        }
                        cc = CPMEngine.this.workQueue.getCurrentSize();
                    }
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_consuming_queue__FINEST", new Object[]{Thread.currentThread().getName(), CPMEngine.this.workQueue.getName(), String.valueOf(CPMEngine.this.outputQueue.getCurrentSize())});
                    }
                    while (CPMEngine.this.outputQueue.getCurrentSize() > 0) {
                        1.sleep(400L);
                        if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_wait_consuming_queue__FINEST", new Object[]{Thread.currentThread().getName(), CPMEngine.this.workQueue.getName(), String.valueOf(CPMEngine.this.outputQueue.getCurrentSize())});
                    }
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_done_consuming_queue__FINEST", new Object[]{Thread.currentThread().getName()});
                    }
                    for (int i = 0; CPMEngine.this.processingUnits != null && i < CPMEngine.this.processingUnits.length; ++i) {
                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_stop_processors__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(i)});
                        }
                        CPMEngine.this.processingUnits[i].stopCasProcessors(false);
                    }
                }
                catch (Exception e) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINER, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_exception__FINER", new Object[]{Thread.currentThread().getName(), e.getMessage()});
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopIt() {
        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_stop_cpm__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(this.killed)});
        this.dumpState();
        this.stopped = true;
        this.killed = true;
        if (!this.isRunning) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_already_stopped__FINEST", new Object[]{Thread.currentThread().getName()});
            return;
        }
        this.isRunning = false;
        Object object = this.lockForPause;
        synchronized (object) {
            if (this.pause) {
                this.pause = false;
                this.lockForPause.notifyAll();
            }
        }
    }

    private int getIndexInList(List aDeployList, String aName) {
        for (int i = 0; i < aDeployList.size(); ++i) {
            ArrayList innerList = (ArrayList)aDeployList.get(i);
            String currentCPName = ((CasProcessor)innerList.get(0)).getProcessingResourceMetaData().getName();
            if (aName == null || !aName.trim().equals(currentCPName.trim())) continue;
            return i;
        }
        return 0;
    }

    private int getPositionInListIfExists(String aName, List aList) {
        for (int i = 0; i < aList.size(); ++i) {
            ArrayList innerList = (ArrayList)aList.get(i);
            String currentCPName = ((CasProcessor)innerList.get(0)).getProcessingResourceMetaData().getName();
            if (aName == null || !aName.trim().equals(currentCPName.trim())) continue;
            return i;
        }
        return -1;
    }

    private boolean isMultipleDeploymentAllowed(String aDescPath, String aCpName, boolean isConsumer) throws Exception {
        ResourceMetaData md;
        OperationalProperties op = null;
        ResourceSpecifier resourceSpecifier = this.cpeFactory.getSpecifier(new File(aDescPath).toURL());
        if (resourceSpecifier != null && resourceSpecifier instanceof ResourceCreationSpecifier && (md = ((ResourceCreationSpecifier)resourceSpecifier).getMetaData()) instanceof ProcessingResourceMetaData) {
            op = ((ProcessingResourceMetaData)md).getOperationalProperties();
            if (op == null) {
                return !isConsumer;
            }
            return op.isMultipleDeploymentAllowed();
        }
        throw new ResourceConfigurationException("not_a_cas_processor", new Object[]{aCpName, "<unknown>", aDescPath});
    }

    public boolean isParallizable(CasProcessor aProcessor, String aCpName) throws Exception {
        boolean isConsumer = false;
        if (aProcessor instanceof CasConsumer || aProcessor instanceof CasDataConsumer) {
            isConsumer = true;
        }
        if (!this.cpeFactory.casProcessorConfigMap.containsKey(aCpName)) {
            OperationalProperties op = aProcessor.getProcessingResourceMetaData().getOperationalProperties();
            if (op != null) {
                return op.isMultipleDeploymentAllowed();
            }
            if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_invalid_processor_configuration__SEVERE", new Object[]{Thread.currentThread().getName(), aCpName});
            }
            return !isConsumer;
        }
        CpeCasProcessor casProcessorCPEConfig = (CpeCasProcessor)this.cpeFactory.casProcessorConfigMap.get(aCpName);
        if ("local".equalsIgnoreCase(casProcessorCPEConfig.getDeployment())) {
            URL descriptorUrl = this.cpeFactory.getDescriptorURL(casProcessorCPEConfig);
            Descriptor descriptor = new Descriptor(descriptorUrl.toString());
            String aResourceSpecifierPath = descriptor.getResourceSpecifierPath();
            boolean is = this.isMultipleDeploymentAllowed(aResourceSpecifierPath, casProcessorCPEConfig.getName(), isConsumer);
            return is;
        }
        if ("integrated".equalsIgnoreCase(casProcessorCPEConfig.getDeployment())) {
            if (aProcessor.getProcessingResourceMetaData().getOperationalProperties() == null) {
                return !isConsumer;
            }
            return aProcessor.getProcessingResourceMetaData().getOperationalProperties().isMultipleDeploymentAllowed();
        }
        return true;
    }

    private void addCasConsumer(CasProcessor aProcessor, String aCpName) throws Exception {
        if (this.consumers.containsKey(aCpName)) {
            if (UIMAFramework.getLogger().isLoggable(Level.CONFIG)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_add_consumer_to_list__CONFIG", new Object[]{Thread.currentThread().getName(), aCpName});
            }
            int listIndex = this.getIndexInList(this.consumerDeployList, aCpName);
            ((List)this.consumerDeployList.get(listIndex)).add(aProcessor);
        } else {
            ArrayList<CasProcessor> newList = new ArrayList<CasProcessor>();
            newList.add(aProcessor);
            this.consumers.put(aCpName, newList);
            this.consumerDeployList.add(newList);
            if (UIMAFramework.getLogger().isLoggable(Level.CONFIG)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_add_consumer_to_new_list__CONFIG", new Object[]{Thread.currentThread().getName(), aCpName});
            }
            if (this.cpeFactory.isDefault()) {
                this.cpeFactory.addCasProcessor(aProcessor);
            }
        }
    }

    private void addParallizableCasProcessor(CasProcessor aProcessor, String aCpName) throws Exception {
        UIMAFramework.getLogger(this.getClass()).log(Level.CONFIG, " Adding New Annotator:" + aCpName);
        if (this.analysisEngines.containsKey(aCpName)) {
            if (UIMAFramework.getLogger().isLoggable(Level.CONFIG)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_add_pcp_to_existing_list__CONFIG", new Object[]{Thread.currentThread().getName(), aCpName});
            }
            int listIndex = this.getIndexInList(this.annotatorDeployList, aCpName);
            ((List)this.annotatorDeployList.get(listIndex)).add(aProcessor);
        } else {
            ArrayList<CasProcessor> newList = new ArrayList<CasProcessor>();
            newList.add(0, aProcessor);
            this.analysisEngines.put(aCpName, newList);
            this.annotatorDeployList.add(0, newList);
            if (UIMAFramework.getLogger().isLoggable(Level.CONFIG)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_add_pcp_to_new_list__CONFIG", new Object[]{Thread.currentThread().getName(), aCpName});
            }
            if (this.cpeFactory.isDefault()) {
                this.cpeFactory.addCasProcessor(aProcessor);
            }
        }
    }

    private void classifyCasProcessors() throws Exception {
        boolean allowReorder = true;
        for (int i = this.initial_cp_list.size(); i > 0; --i) {
            ArrayList cp_instance_list = (ArrayList)this.initial_cp_list.get(i - 1);
            String previous = "";
            for (int j = 0; j < cp_instance_list.size(); ++j) {
                String name;
                CasProcessor cp = (CasProcessor)cp_instance_list.get(j);
                boolean parallizable = this.isParallizable(cp, name = cp.getProcessingResourceMetaData().getName());
                if (!parallizable && allowReorder) {
                    if (!previous.equals(name)) {
                        this.addCasConsumer(cp, name);
                    }
                } else {
                    allowReorder = false;
                    if (parallizable || !previous.equals(name)) {
                        this.addParallizableCasProcessor(cp, name);
                    }
                }
                if (!parallizable) {
                    cp_instance_list.remove(0);
                }
                previous = name;
            }
        }
    }

    public void addCasProcessor(CasProcessor aCasProcessor) throws ResourceConfigurationException {
        String name = aCasProcessor.getProcessingResourceMetaData().getName();
        if (aCasProcessor instanceof CasObjectProcessor || aCasProcessor instanceof CasConsumer) {
            this.mixedCasProcessorTypeSupport = true;
        }
        ArrayList newList = null;
        int indexPos = this.getPositionInListIfExists(name, this.initial_cp_list);
        if (indexPos == -1) {
            newList = new ArrayList();
            newList.add(aCasProcessor);
            this.initial_cp_list.add(newList);
        } else {
            newList = (ArrayList)this.initial_cp_list.get(indexPos);
            newList.add(aCasProcessor);
        }
    }

    public void addCasProcessor(CasProcessor aCasProcessor, int aIndex) throws ResourceConfigurationException {
        this.addCasProcessor(aCasProcessor);
    }

    public void removeCasProcessor(int aCasProcessorIndex) {
        if (aCasProcessorIndex < 0 || aCasProcessorIndex >= this.annotatorList.size()) {
            return;
        }
        this.annotatorList.remove(aCasProcessorIndex);
    }

    public void disableCasProcessor(int aCasProcessorIndex) {
        if (aCasProcessorIndex < 0 || aCasProcessorIndex > this.annotatorList.size()) {
            return;
        }
        ProcessingContainer pc = (ProcessingContainer)this.annotatorList.get(aCasProcessorIndex);
        if (pc != null) {
            pc.setStatus(3);
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_diabled_cp__FINEST", new Object[]{Thread.currentThread().getName(), pc.getName()});
            }
        }
    }

    public void disableCasProcessor(String aCasProcessorName) {
        for (int i = 0; i < this.annotatorList.size(); ++i) {
            ProcessingContainer pc = (ProcessingContainer)this.annotatorList.get(i);
            if (!pc.getName().equals(aCasProcessorName)) continue;
            pc.setStatus(3);
            if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_diabled_cp__FINEST", new Object[]{Thread.currentThread().getName(), pc.getName()});
        }
    }

    public void enableCasProcessor(String aCasProcessorName) {
        for (int i = 0; i < this.annotatorList.size(); ++i) {
            ProcessingContainer pc = (ProcessingContainer)this.annotatorList.get(i);
            if (!pc.getName().equals(aCasProcessorName)) continue;
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_enabled_cp__FINEST", new Object[]{Thread.currentThread().getName(), aCasProcessorName});
            }
            pc.setStatus(2);
        }
    }

    public CasProcessor[] getCasProcessors() {
        int i;
        List kList;
        if (this.casprocessorList != null) {
            return this.casprocessorList;
        }
        if (!this.casProcessorsDeployed) {
            CasProcessor[] casprocessorList = new CasProcessor[this.initial_cp_list.size()];
            for (int i2 = 0; i2 < this.initial_cp_list.size(); ++i2) {
                ArrayList list = (ArrayList)this.initial_cp_list.get(i2);
                for (int j = 0; j < list.size(); ++j) {
                    casprocessorList[i2] = (CasProcessor)list.get(j);
                }
            }
            return casprocessorList;
        }
        ArrayList aList = new ArrayList();
        for (String keyName : this.analysisEngines.keySet()) {
            kList = (List)this.analysisEngines.get(keyName);
            if (kList == null) continue;
            for (i = 0; i < kList.size(); ++i) {
                aList.add(kList.get(i));
            }
        }
        for (String keyName : this.consumers.keySet()) {
            kList = (List)this.consumers.get(keyName);
            if (kList == null) continue;
            for (i = 0; i < kList.size(); ++i) {
                aList.add(kList.get(i));
            }
        }
        if (aList.size() == 0) {
            return null;
        }
        this.casprocessorList = new CasProcessor[aList.size()];
        for (int j = 0; j < aList.size(); ++j) {
            this.casprocessorList[j] = (CasProcessor)aList.get(j);
        }
        return this.casprocessorList;
    }

    private void deployConsumers() throws AbortCPMException {
        if (this.consumerDeployList == null || this.consumerDeployList.size() == 0) {
            return;
        }
        CasProcessorDeployer deployer = null;
        for (int i = this.consumerDeployList.size(); i > 0; --i) {
            try {
                ArrayList cpList = (ArrayList)this.consumerDeployList.get(i - 1);
                String name = ((CasProcessor)cpList.get(0)).getProcessingResourceMetaData().getName();
                if (cpList.size() <= 0) continue;
                CpeCasProcessor casProcessorType = (CpeCasProcessor)this.cpeFactory.casProcessorConfigMap.get(name);
                deployer = DeployFactory.getDeployer(this.cpeFactory, casProcessorType, this.pca);
                ProcessingContainer container = deployer.deployCasProcessor(cpList, false);
                this.consumerList.add(container);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new AbortCPMException(e.getMessage());
            }
        }
    }

    public void redeployAnalysisEngine(ProcessingContainer aProcessingContainer) throws Exception {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_deploying_cp__FINEST", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName()});
        }
        CasProcessorDeployer deployer = aProcessingContainer.getDeployer();
        deployer.deployCasProcessor(aProcessingContainer);
    }

    private void deployAnalysisEngines() throws AbortCPMException {
        if (this.checkpointData != null) {
            this.restoreFromCheckpoint("CPM", "CPM PROCESSING TIME");
        }
        CasProcessorDeployer deployer = null;
        for (int i = 0; i < this.annotatorDeployList.size(); ++i) {
            try {
                ArrayList cpList = (ArrayList)this.annotatorDeployList.get(i);
                String name = ((CasProcessor)cpList.get(0)).getProcessingResourceMetaData().getName();
                if (UIMAFramework.getLogger().isLoggable(Level.CONFIG)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_deploying_new_cp__CONFIG", new Object[]{Thread.currentThread().getName(), name});
                }
                if (cpList.size() <= 0) continue;
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_lookup_cp__FINEST", new Object[]{Thread.currentThread().getName(), name});
                }
                if (!this.cpeFactory.casProcessorConfigMap.containsKey(name)) {
                    if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_invalid_processor_configuration__SEVERE", new Object[]{Thread.currentThread().getName(), name});
                    }
                    throw new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_cp__WARNING", new Object[]{Thread.currentThread().getName(), name}));
                }
                CpeCasProcessor casProcessorCPEConfig = (CpeCasProcessor)this.cpeFactory.casProcessorConfigMap.get(name);
                if (casProcessorCPEConfig == null) {
                    if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_cp_configuration_not_defined__SEVERE", new Object[]{Thread.currentThread().getName(), name});
                    }
                    throw new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_cp__WARNING", new Object[]{Thread.currentThread().getName(), name}));
                }
                if (casProcessorCPEConfig.getDeployment() == null || casProcessorCPEConfig.getDeployment().trim().length() == 0) {
                    if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_cp_deployment_mode_not_defined__SEVERE", new Object[]{Thread.currentThread().getName(), name});
                    }
                    throw new Exception(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_Exception_invalid_deployment__WARNING", new Object[]{Thread.currentThread().getName(), name, casProcessorCPEConfig.getDeployment()}));
                }
                deployer = DeployFactory.getDeployer(this.cpeFactory, casProcessorCPEConfig, this.pca);
                ProcessingContainer container = deployer.deployCasProcessor(cpList, false);
                this.annotatorList.add(container);
                continue;
            }
            catch (Exception e) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_cp_failed_to_start__SEVERE", new Object[]{Thread.currentThread().getName(), e.getMessage()});
                throw new AbortCPMException(e.getMessage());
            }
        }
    }

    public void deployCasProcessors() throws AbortCPMException {
        try {
            this.classifyCasProcessors();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AbortCPMException(e.getMessage());
        }
        if (UIMAFramework.getLogger().isLoggable(Level.CONFIG)) {
            UIMAFramework.getLogger(this.getClass()).log(Level.CONFIG, "Deploying Analysis Engines");
        }
        this.deployAnalysisEngines();
        if (UIMAFramework.getLogger().isLoggable(Level.CONFIG)) {
            UIMAFramework.getLogger(this.getClass()).log(Level.CONFIG, "Deploying CasConsumers");
        }
        this.deployConsumers();
        this.casProcessorsDeployed = true;
    }

    private void restoreFromCheckpoint(String component, String aEvType) {
        if (this.checkpointData == null) {
            return;
        }
        ProcessTrace restoredProcTr = this.checkpointData.getProcessTrace();
        try {
            List eList = restoredProcTr.getEventsByComponentName(component, true);
            if (!eList.isEmpty()) {
                this.copyComponentEvents(aEvType, eList, this.procTr);
                eList.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void copyComponentEvents(String aEvType, List aList, ProcessTrace aPTr) throws IOException {
        for (int i = 0; i < aList.size(); ++i) {
            ProcessTraceEvent prEvent = (ProcessTraceEvent)aList.get(i);
            String typeS = prEvent.getType();
            if (aEvType == null || !aEvType.equals(typeS)) continue;
            aPTr.addEvent(prEvent);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPaused() {
        Object object = this.lockForPause;
        synchronized (object) {
            return this.pause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseIt() {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_pause_cpe__FINEST", new Object[]{Thread.currentThread().getName()});
        }
        Object object = this.lockForPause;
        synchronized (object) {
            this.pause = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeIt() {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_resume_cpe__FINEST", new Object[]{Thread.currentThread().getName()});
        }
        Object object = this.lockForPause;
        synchronized (object) {
            this.pause = false;
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_notify_engine__FINEST", new Object[]{Thread.currentThread().getName()});
            }
            this.lockForPause.notifyAll();
        }
    }

    public void setCollectionReader(BaseCollectionReader aCollectionReader) {
        this.collectionReader = aCollectionReader;
        if (this.collectionReader != null) {
            if (this.collectionReader.getProcessingResourceMetaData().getConfigurationParameterSettings().getParameterValue("fetchSize") != null) {
                try {
                    this.readerFetchSize = (Integer)this.collectionReader.getProcessingResourceMetaData().getConfigurationParameterSettings().getParameterValue("fetchSize");
                }
                catch (NumberFormatException nfe) {
                    this.readerFetchSize = 1;
                }
            }
            if (this.checkpointData != null && this.checkpointData.getSynchPoint() != null) {
                try {
                    if (this.collectionReader instanceof RecoverableCollectionReader) {
                        ((RecoverableCollectionReader)this.collectionReader).moveTo(this.checkpointData.getSynchPoint());
                        String readerName = this.collectionReader.getProcessingResourceMetaData().getName();
                        if (readerName != null) {
                            this.restoreFromCheckpoint(readerName, "COLLECTION READER PROCESSING TIME");
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setNumToProcess(long aNumToProcess) {
        this.numToProcess = aNumToProcess;
    }

    public String getLastProcessedDocId() {
        return this.producer.getLastDocId();
    }

    public String getLastDocRepository() {
        return "";
    }

    private ProcessingUnit producePU(String aClassName) throws Exception {
        Class<?> currentClass = Class.forName(aClassName);
        ProcessingUnit pu = (ProcessingUnit)currentClass.newInstance();
        return pu;
    }

    private void startDebugControlThread() {
        String dbgCtrlFile = System.getProperty("DEBUG_CONTROL");
        this.dbgCtrlThread = new DebugControlThread(this, dbgCtrlFile, 1000);
        this.dbgCtrlThread.start();
    }

    private BoundedWorkQueue createOutputQueue(int aQueueSize) throws Exception {
        if (this.cpeFactory.getCPEConfig().getOutputQueue() != null && this.cpeFactory.getCPEConfig().getOutputQueue().getClass() != null) {
            String outputQueueClass = this.cpeFactory.getCPEConfig().getOutputQueue().getQueueClass();
            if (outputQueueClass != null) {
                Class[] args = new Class[]{Integer.TYPE, String.class, CPMEngine.class};
                Class<?> cpClass = Class.forName(outputQueueClass);
                Constructor<?> constructor = cpClass.getConstructor(args);
                Object[] oArgs = new Object[]{aQueueSize, "Sequenced Output Queue", this};
                this.outputQueue = (BoundedWorkQueue)constructor.newInstance(oArgs);
            }
        } else {
            this.outputQueue = new BoundedWorkQueue(aQueueSize, "Output Queue", this);
        }
        return this.outputQueue;
    }

    private void notifyListenersWithException(Exception e) {
        UIMAFramework.getLogger(this.getClass()).log(Level.SEVERE, e.getMessage(), (Throwable)e);
        ArrayList statusCbL = this.getCallbackListeners();
        EntityProcessStatusImpl enProcSt = new EntityProcessStatusImpl(this.procTr, true);
        enProcSt.addEventStatus("CPM", "Failed", e);
        for (int j = 0; statusCbL != null && j < statusCbL.size(); ++j) {
            BaseStatusCallbackListener st = (BaseStatusCallbackListener)statusCbL.get(j);
            if (st == null || !(st instanceof StatusCallbackListener)) continue;
            ((StatusCallbackListener)st).entityProcessComplete(null, (EntityProcessStatus)enProcSt);
        }
    }

    public synchronized void pipelineKilled(String aPipelineThreadName) {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_pipeline_terminated__FINEST", new Object[]{Thread.currentThread().getName(), aPipelineThreadName});
        }
        --this.activeProcessingUnits;
        if (this.activeProcessingUnits <= 0) {
            this.isRunning = false;
            while (this.workQueue != null && this.workQueue.getCurrentSize() > 0) {
                try {
                    Object anObject = this.workQueue.dequeue(1L);
                    if (anObject == null || !(anObject instanceof CAS[])) continue;
                    this.notifyListeners(0, (CAS[])anObject, this.procTr, new Exception("CPM Releases CAS before processing it due to premature CPM shutdown."));
                    this.releaseCASes((CAS[])anObject);
                }
                catch (Exception e) {
                    if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_exception_while_consuming_cases__SEVERE", new Object[]{Thread.currentThread().getName(), e.getMessage()});
                    }
                    this.notifyListenersWithException(e);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[TRYBLOCK]], but top level block is 73[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void forcePUShutdown() {
        try {
            Object[] eofToken = new Object[]{new EOFToken()};
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_placed_eof_in_queue__FINEST", new Object[]{Thread.currentThread().getName(), this.workQueue.getName()});
            }
            this.workQueue.enqueue(eofToken);
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_done_placed_eof_in_queue__FINEST", new Object[]{Thread.currentThread().getName(), this.workQueue.getName()});
            }
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_done_notifying_queue__FINEST", new Object[]{Thread.currentThread().getName(), this.workQueue.getName()});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_exception_adding_eof__SEVERE", new Object[]{Thread.currentThread().getName(), e.getMessage()});
            this.notifyListenersWithException(e);
        }
    }

    private UimaTimer getTimer() throws Exception {
        String uimaTimerClass = this.cpeFactory.getCPEConfig().getCpeTimer().get();
        if (uimaTimerClass != null) {
            new TimerFactory(uimaTimerClass);
            return TimerFactory.getTimer();
        }
        return new JavaTimer();
    }

    public void cleanup() {
        try {
            if (this.processingUnits != null) {
                for (int i = 0; i < this.processingUnits.length; ++i) {
                    this.processingUnits[i].cleanup();
                }
            }
            if (this.dbgCtrlThread != null) {
                this.dbgCtrlThread.stop();
            }
            if (this.casConsumerPU != null) {
                this.casConsumerPU.cleanup();
            }
            this.casConsumerPU = null;
            if (this.collectionReader != null) {
                this.collectionReader.close();
            }
            this.collectionReader = null;
            if (this.producer != null) {
                this.producer.cleanup();
            }
            this.producer = null;
            if (this.consumerDeployList != null) {
                this.consumerDeployList.clear();
            }
            this.consumerDeployList = null;
            if (this.analysisEngines != null) {
                this.analysisEngines.clear();
            }
            this.analysisEngines = null;
            if (this.annotatorDeployList != null) {
                this.annotatorDeployList.clear();
            }
            this.annotatorDeployList = null;
            if (this.annotatorList != null) {
                this.annotatorList.clear();
            }
            this.annotatorList = null;
            if (this.consumerList != null) {
                this.consumerList.clear();
            }
            this.consumerList = null;
            if (this.consumers != null) {
                this.consumers.clear();
            }
            this.consumers = null;
            this.processingUnits = null;
            this.casprocessorList = null;
            this.stats = null;
            this.statusCbL = null;
            this.casPool = null;
            this.checkpointData = null;
            this.procTr = null;
            this.cpeFactory = null;
        }
        catch (Exception e) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINER, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_exception__FINER", new Object[]{Thread.currentThread().getName(), e.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerTypeSystemsWithCasManager() throws Exception {
        ProcessingResourceMetaData md;
        CasProcessor processor;
        ProcessingContainer container;
        int i;
        CasInitializer casIni;
        CasManager manager = this.cpeFactory.getResourceManager().getCasManager();
        ProcessingResourceMetaData crMetaData = this.collectionReader.getProcessingResourceMetaData();
        if (crMetaData != null) {
            manager.addMetaData(crMetaData);
        }
        if (this.collectionReader instanceof CollectionReader) {
            casIni = ((CollectionReader)this.collectionReader).getCasInitializer();
            if (casIni != null && casIni.getProcessingResourceMetaData() != null) {
                manager.addMetaData(casIni.getProcessingResourceMetaData());
            }
        } else if (this.collectionReader instanceof CasDataCollectionReader && (casIni = ((CasDataCollectionReader)this.collectionReader).getCasDataInitializer()) != null && casIni.getCasInitializerMetaData() != null) {
            manager.addMetaData(casIni.getCasInitializerMetaData());
        }
        for (i = 0; i < this.annotatorList.size(); ++i) {
            container = (ProcessingContainer)this.annotatorList.get(i);
            if (container.getStatus() == 3) continue;
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_checkout_cp_from_container__FINEST", new Object[]{Thread.currentThread().getName(), container.getName()});
            }
            processor = container.getCasProcessor();
            try {
                if (processor instanceof AnalysisEngineImplBase && ((AnalysisEngine)processor).getResourceManager() == this.cpeFactory.getResourceManager() || (md = processor.getProcessingResourceMetaData()) == null) continue;
                manager.addMetaData(md);
                continue;
            }
            finally {
                container.releaseCasProcessor(processor);
            }
        }
        for (i = 0; i < this.consumerList.size(); ++i) {
            container = (ProcessingContainer)this.consumerList.get(i);
            if (container.getStatus() == 3) continue;
            if (UIMAFramework.getLogger().isLoggable(Level.FINE)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_checkout_cp_from_container__FINEST", new Object[]{Thread.currentThread().getName(), container.getName()});
            }
            processor = container.getCasProcessor();
            try {
                if (processor instanceof AnalysisEngineImplBase && ((AnalysisEngine)processor).getResourceManager() == this.cpeFactory.getResourceManager() || (md = processor.getProcessingResourceMetaData()) == null) continue;
                manager.addMetaData(md);
                continue;
            }
            finally {
                container.releaseCasProcessor(processor);
            }
        }
    }

    private void callTypeSystemInit() throws ResourceInitializationException {
        CAS cas = this.casPool.getCas();
        try {
            CasProcessor processor;
            ProcessingContainer container;
            int i;
            if (this.collectionReader instanceof CollectionReader) {
                ((CollectionReader)this.collectionReader).typeSystemInit(cas.getTypeSystem());
                CasInitializer casIni = ((CollectionReader)this.collectionReader).getCasInitializer();
                if (casIni != null) {
                    casIni.typeSystemInit(cas.getTypeSystem());
                }
            }
            for (i = 0; i < this.annotatorList.size(); ++i) {
                container = (ProcessingContainer)this.annotatorList.get(i);
                if (container.getStatus() == 3) continue;
                processor = container.getCasProcessor();
                if (processor instanceof CasObjectProcessor) {
                    ((CasObjectProcessor)processor).typeSystemInit(cas.getTypeSystem());
                }
                container.releaseCasProcessor(processor);
            }
            for (i = 0; i < this.consumerList.size(); ++i) {
                container = (ProcessingContainer)this.consumerList.get(i);
                if (container.getStatus() == 3) continue;
                processor = container.getCasProcessor();
                if (processor instanceof CasObjectProcessor) {
                    ((CasObjectProcessor)processor).typeSystemInit(cas.getTypeSystem());
                }
                container.releaseCasProcessor(processor);
            }
        }
        catch (ResourceInitializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        finally {
            this.casPool.releaseCas(cas);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCasProcessors(boolean kill) throws CasProcessorDeploymentException {
        ProcessingContainer container;
        int i;
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_stop_containers__FINEST", new Object[]{Thread.currentThread().getName()});
        }
        for (i = 0; this.annotatorList != null && i < this.annotatorList.size(); ++i) {
            container = (ProcessingContainer)this.annotatorList.get(i);
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_container_time__FINEST", new Object[]{Thread.currentThread().getName(), container.getName(), String.valueOf(container.getTotalTime())});
            }
            ProcessingContainer processingContainer = container;
            synchronized (processingContainer) {
                CasProcessorDeployer deployer;
                if (kill || this.stopped && this.isProcessorReady(container.getStatus())) {
                    container.setStatus(5);
                } else if (container.getStatus() != 3) {
                    container.setStatus(4);
                }
                this.saveStat("ProcessorStatus", String.valueOf(container.getStatus()), container);
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_stop_container__FINEST", new Object[]{Thread.currentThread().getName(), container.getName()});
                }
                if ((deployer = container.getDeployer()) != null) {
                    deployer.undeploy();
                }
                container.destroy();
                continue;
            }
        }
        for (i = 0; this.consumerList != null && i < this.consumerList.size(); ++i) {
            container = (ProcessingContainer)this.consumerList.get(i);
            container.destroy();
        }
    }

    public Progress[] getProgress() {
        if (this.collectionReader == null) {
            return null;
        }
        return this.collectionReader.getProgress();
    }

    private HashMap getStatForContainer(ProcessingContainer aContainer) {
        HashMap cpStatMap = null;
        if (this.stats != null && (cpStatMap = (HashMap)this.stats.get(aContainer.getName())) != null) {
            return cpStatMap;
        }
        return null;
    }

    private void saveStat(String aStatLabel, String aStatValue, ProcessingContainer aContainer) {
        HashMap cpStatMap = this.getStatForContainer(aContainer);
        if (cpStatMap != null) {
            cpStatMap.put(aStatLabel, aStatValue);
        }
    }

    private boolean isProcessorReady(int aStatus) {
        return aStatus == 1 || aStatus == 2;
    }

    public void invalidateCASes(CAS[] aCASList) {
        if (this.producer != null) {
            this.producer.invalidate(aCASList);
        } else {
            ChunkMetadata meta = CPMUtils.getChunkMetadata(aCASList[0]);
            if (meta != null && meta.isOneOfMany() && !this.skippedDocs.containsKey(meta.getDocId())) {
                this.skippedDocs.put(meta.getDocId(), meta.getDocId());
            }
        }
        if (this.outputQueue != null) {
            this.outputQueue.invalidate(aCASList);
        }
        this.releaseCASes(aCASList);
    }

    public void releaseCASes(CAS[] aCASList) {
        for (int i = 0; i < aCASList.length; ++i) {
            if (aCASList[i] != null) {
                this.casPool.releaseCas(aCASList[i]);
                continue;
            }
            if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_release_tcas__FINEST", new Object[]{Thread.currentThread().getName()});
        }
    }

    public void setPerformanceTuningSettings(Properties aPerformanceTuningSettings) {
        this.mPerformanceTuningSettings = aPerformanceTuningSettings;
    }

    public Properties getPerformanceTuningSettings() {
        return this.mPerformanceTuningSettings;
    }

    public void setProcessControllerAdapter(ProcessControllerAdapter aPca) {
        this.pca = aPca;
    }

    protected CpeConfiguration getCpeConfig() throws Exception {
        return this.cpeFactory.getCPEConfig();
    }

    synchronized void processingUnitShutdown(ProcessingUnit unit) {
        --this.activeProcessingUnits;
        if (this.activeProcessingUnits == 0 && this.outputQueue != null) {
            Object[] eofToken = new Object[]{new EOFToken()};
            this.outputQueue.enqueue(eofToken);
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_done_placed_eof_in_queue__FINEST", new Object[]{Thread.currentThread().getName(), this.outputQueue.getName()});
            }
        }
    }

    public boolean dropCasOnException() {
        return this.dropCasOnExceptionPolicy;
    }

    private Object getCasWithSOFA(Object entity, ProcessTrace pTrTemp) {
        Object[] casList = new CAS[1];
        try {
            if (this.collectionReader instanceof CollectionReader) {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_call_get_cas__FINEST", new Object[]{Thread.currentThread().getName()});
                }
                if (entity != null && entity instanceof CAS[]) {
                    casList = (CAS[])entity;
                } else {
                    this.readerState = 1001;
                    while (this.isRunning && (casList[0] = this.casPool.getCas(0L)) == null) {
                    }
                    entity = casList;
                }
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_call_get_cas_returns_null_FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(casList[0] == null)});
                }
                if (!this.isRunning()) {
                    this.readerState = 1009;
                    this.casPool.releaseCas((CAS)casList[0]);
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_in_shutdown_state__FINEST", new Object[]{Thread.currentThread().getName()});
                    }
                    this.readerState = 1010;
                    return null;
                }
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_got_cas_from_pool__FINEST", new Object[]{Thread.currentThread().getName()});
                }
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_call_cas_reset__FINEST", new Object[]{Thread.currentThread().getName()});
                }
                casList[0].reset();
                boolean sofaUnaware = this.needsView();
                this.readerState = 1003;
                long st00 = System.currentTimeMillis();
                if (sofaUnaware) {
                    CAS view = casList[0].getView("_InitialView");
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_call_cr_next__FINEST", new Object[]{Thread.currentThread().getName(), "TCAS"});
                    }
                    ((CollectionReader)this.collectionReader).getNext(view);
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_call_cr_next_finished__FINEST", new Object[]{Thread.currentThread().getName(), "TCAS"});
                    }
                } else {
                    CASImpl baseCas = ((CASImpl)casList[0]).getBaseCAS();
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_call_cr_next__FINEST", new Object[]{Thread.currentThread().getName(), "CAS"});
                    }
                    ((CollectionReader)this.collectionReader).getNext((CAS)baseCas);
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_call_cr_next_finished__FINEST", new Object[]{Thread.currentThread().getName(), "CAS"});
                    }
                }
                this.crFetchTime += System.currentTimeMillis() - st00;
            }
            entity = casList;
            return entity;
        }
        catch (Exception e) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINER)) {
                e.printStackTrace();
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINER, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_exception__FINER", new Object[]{Thread.currentThread().getName(), e.getMessage()});
                UIMAFramework.getLogger(this.getClass()).log(Level.WARNING, Thread.currentThread().getName() + "" + e);
            }
            this.handleException(e, casList, pTrTemp);
            this.releaseCASes((CAS[])casList);
            return null;
        }
    }

    private boolean needsView() {
        if (this.definedCapabilities == null) {
            CasInitializer casIni = ((CollectionReader)this.collectionReader).getCasInitializer();
            this.definedCapabilities = casIni != null ? casIni.getProcessingResourceMetaData().getCapabilities() : ((CollectionReader)this.collectionReader).getProcessingResourceMetaData().getCapabilities();
            for (int j = 0; j < this.definedCapabilities.length; ++j) {
                if (this.definedCapabilities[j].getOutputSofas().length <= 0) continue;
                this.needsTCas = false;
                break;
            }
        }
        return this.needsTCas;
    }

    private void bootstrapCPE() throws Exception {
        this.registerTypeSystemsWithCasManager();
        this.casPool = new CPECasPool(this.getPoolSize(), this.cpeFactory.getResourceManager().getCasManager(), this.mPerformanceTuningSettings);
        this.callTypeSystemInit();
        this.setupProcessingPipeline();
        this.setupConsumerPipeline();
    }

    private void setupProcessingPipeline() throws Exception {
        this.nonThreadedProcessingUnit = new NonThreadedProcessingUnit(this);
        for (int i = 0; i < this.annotatorList.size(); ++i) {
            ((ProcessingContainer)this.annotatorList.get(i)).setStatus(2);
        }
        this.nonThreadedProcessingUnit.setContainers(this.annotatorList);
        this.nonThreadedProcessingUnit.setCasPool(this.casPool);
        for (int j = 0; j < this.statusCbL.size(); ++j) {
            BaseStatusCallbackListener statCL = (BaseStatusCallbackListener)this.statusCbL.get(j);
            if (statCL == null) continue;
            this.nonThreadedProcessingUnit.addStatusCallbackListener(statCL);
        }
    }

    private void setupConsumerPipeline() throws Exception {
        if (this.consumerList != null && this.consumerList.size() > 0) {
            this.nonThreadedCasConsumerProcessingUnit = new NonThreadedProcessingUnit(this);
            for (int i = 0; i < this.consumerList.size(); ++i) {
                ((ProcessingContainer)this.consumerList.get(i)).setStatus(2);
            }
            this.nonThreadedCasConsumerProcessingUnit.setContainers(this.consumerList);
            this.nonThreadedCasConsumerProcessingUnit.setCasPool(this.casPool);
            this.nonThreadedCasConsumerProcessingUnit.setReleaseCASFlag(false);
            for (int j = 0; j < this.statusCbL.size(); ++j) {
                BaseStatusCallbackListener statCL = (BaseStatusCallbackListener)this.statusCbL.get(j);
                if (statCL == null) continue;
                this.nonThreadedCasConsumerProcessingUnit.addStatusCallbackListener(statCL);
            }
            this.nonThreadedCasConsumerProcessingUnit.setNotifyListeners(false);
            try {
                this.nonThreadedCasConsumerProcessingUnit.setUimaTimer(this.getTimer());
            }
            catch (Exception e) {
                this.nonThreadedCasConsumerProcessingUnit.setUimaTimer((UimaTimer)new JavaTimer());
            }
        }
    }

    private boolean skipDroppedDocument(Object[] entity) {
        ChunkMetadata meta;
        return entity instanceof CAS[] && (meta = CPMUtils.getChunkMetadata((CAS)entity[0])) != null && this.skippedDocs.containsKey(meta.getDocId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSingleThreaded() throws Exception {
        Object entity = null;
        this.isRunning = true;
        this.bootstrapCPE();
        ProcessTrace pTrTemp = this.getProcessTrace();
        boolean success = true;
        long entityCount = 0L;
        long aggTime = 0L;
        long ppTime = 0L;
        long ccTime = 0L;
        long crTime = 0L;
        for (int j = 0; j < this.statusCbL.size(); ++j) {
            BaseStatusCallbackListener statCL = (BaseStatusCallbackListener)this.statusCbL.get(j);
            if (statCL == null) continue;
            statCL.initializationComplete();
        }
        while (this.isRunning) {
            try {
                if (this.endOfProcessingReached(entityCount)) break;
                this.waitForCpmToResumeIfPaused();
                if (!this.isRunning) break;
                this.readerState = 1000;
                if (!this.collectionReader.hasNext()) break;
                long st0 = System.currentTimeMillis();
                entity = this.getCasWithSOFA(entity, pTrTemp);
                crTime += System.currentTimeMillis() - st0;
                if (entity == null) {
                    success = false;
                    continue;
                }
                if (entity instanceof CAS[] && this.skipDroppedDocument((Object[])entity)) {
                    this.notifyListeners(1000, (Object[])entity, pTrTemp, (Throwable)new SkipCasException("Skipping Document Due To Dropped Cas in a Sequence"));
                    this.releaseCASes((CAS[])entity);
                    continue;
                }
                if (this.skippedDocs.size() > 0) {
                    this.skippedDocs.clear();
                }
                long st1 = System.currentTimeMillis();
                success = this.nonThreadedProcessingUnit.analyze((Object[])entity, pTrTemp);
                ppTime += System.currentTimeMillis() - st1;
                if (!success) continue;
                long st2 = System.currentTimeMillis();
                this.nonThreadedCasConsumerProcessingUnit.analyze((Object[])entity, pTrTemp);
                ccTime += System.currentTimeMillis() - st2;
            }
            catch (Throwable t) {
                this.handleException(t, (Object[])entity, pTrTemp);
                success = false;
            }
            finally {
                ++entityCount;
                if (success) {
                    this.readerState = 2007;
                    if (entity == null) {
                        this.notifyListeners(1000, null, pTrTemp);
                    } else {
                        this.notifyListeners(1000, (Object[])entity, pTrTemp);
                    }
                }
                if (entity != null && entity instanceof CAS[]) {
                    this.releaseCASes((CAS[])entity);
                    entity = null;
                }
                ProcessTrace j = this.procTr;
                synchronized (j) {
                    long st = System.currentTimeMillis();
                    this.procTr.aggregate(pTrTemp);
                    pTrTemp.clear();
                    aggTime += System.currentTimeMillis() - st;
                }
            }
        }
        this.tearDownCPE();
    }

    private boolean endOfProcessingReached(long entityCount) {
        if (this.numToProcess == -1L) {
            return false;
        }
        if (this.numToProcess == 0L) {
            return true;
        }
        return entityCount >= this.numToProcess;
    }

    private void handleException(Throwable t, Object[] entity, ProcessTrace aPTrace) {
        t.printStackTrace();
        if (t instanceof AbortCPMException || t instanceof Error) {
            this.isRunning = false;
            this.killed = true;
        }
        this.notifyListeners(1000, entity, aPTrace, t);
    }

    private void notifyListeners(int aMsgType, Object[] entity, ProcessTrace aPTrace) {
        this.notifyListeners(aMsgType, entity, aPTrace, null);
    }

    private void notifyListeners(int aMsgType, Object[] entity, ProcessTrace aPTrace, Throwable t) {
        for (int j = 0; j < this.statusCbL.size(); ++j) {
            BaseStatusCallbackListener statCL = (BaseStatusCallbackListener)this.statusCbL.get(j);
            if (statCL == null) continue;
            EntityProcessStatusImpl eps = new EntityProcessStatusImpl(aPTrace);
            if (entity == null) {
                if (t != null) {
                    eps.addEventStatus("Process", "Failed", t);
                }
                ((StatusCallbackListener)statCL).entityProcessComplete(null, (EntityProcessStatus)eps);
                continue;
            }
            for (int i = 0; i < entity.length; ++i) {
                if (t != null) {
                    eps.addEventStatus("Process", "Failed", t);
                }
                if (entity[i] != null && entity[i] instanceof CAS) {
                    CPMEngine.callEntityProcessCompleteWithCAS((StatusCallbackListener)statCL, (CAS)entity[i], eps);
                    continue;
                }
                ((StatusCallbackListener)statCL).entityProcessComplete(null, (EntityProcessStatus)eps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void callEntityProcessCompleteWithCAS(StatusCallbackListener statCL, CAS cas, EntityProcessStatus eps) {
        if (statCL != null) {
            try {
                if (null != cas) {
                    ((CASImpl)cas).switchClassLoaderLockCas((Object)statCL);
                }
                statCL.entityProcessComplete(cas, eps);
            }
            finally {
                if (null != cas) {
                    ((CASImpl)cas).restoreClassLoaderUnlockCas();
                }
            }
        }
    }

    private ProcessTrace getProcessTrace() throws Exception {
        ProcessTrace_impl pT = null;
        UimaTimer uTimer = this.getTimer();
        if (uTimer != null) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_use_custom_timer__FINEST", new Object[]{Thread.currentThread().getName(), uTimer.getClass().getName()});
            }
            pT = new ProcessTrace_impl(uTimer, this.getPerformanceTuningSettings());
        } else {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_use_default_timer__FINEST", new Object[]{Thread.currentThread().getName()});
            }
            pT = new ProcessTrace_impl(this.getPerformanceTuningSettings());
        }
        return pT;
    }

    private void tearDownCPE() {
        this.nonThreadedProcessingUnit.stopCasProcessors(false);
        this.nonThreadedCasConsumerProcessingUnit.stopCasProcessors(false);
        this.nonThreadedProcessingUnit.cleanup();
        this.nonThreadedCasConsumerProcessingUnit.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCpmToResumeIfPaused() {
        Object object = this.lockForPause;
        synchronized (object) {
            while (this.pause) {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_pausing_pp__FINEST", new Object[]{Thread.currentThread().getName()});
                }
                try {
                    this.lockForPause.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_resuming_pp__FINEST", new Object[]{Thread.currentThread().getName()});
            }
        }
    }
}

