/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.container.deployer.socket;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.impl.cpm.container.deployer.socket.SocketTransport;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.util.Level;

public class OFSocketTransportImpl
implements SocketTransport {
    public String getName() {
        return null;
    }

    public Socket connect(URL aURI, long aTimeout) throws SocketException {
        try {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, Thread.currentThread().getName() + "-Created Connection to Fenced Service");
            }
            return new Socket(aURI.getHost(), aURI.getPort());
        }
        catch (SocketException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SocketException(e.getMessage());
        }
    }

    public CAS process(Socket aSocket, CAS aCas) throws SocketTimeoutException, SocketException {
        FilterOutputStream os = null;
        FilterInputStream is = null;
        try {
            String responseLine;
            if (aSocket.isClosed()) {
                aSocket = this.connect(new URL("http", aSocket.getInetAddress().getHostName(), aSocket.getPort(), ""), 100000L);
            }
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, Thread.currentThread().getName() + "-Sending Request to Fenced Service.");
            }
            os = new DataOutputStream(aSocket.getOutputStream());
            is = new DataInputStream(aSocket.getInputStream());
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, Thread.currentThread().getName() + "-Processing Response");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            ((DataOutputStream)os).writeBytes("HELLO\n");
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, Thread.currentThread().getName() + "-Showing Response");
            }
            if ((responseLine = reader.readLine()) != null) {
                UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, "Server Response: " + responseLine);
            }
            UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, Thread.currentThread().getName() + "-Done Showing Response");
        }
        catch (SocketException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SocketException(e.getMessage());
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
        }
        return null;
    }

    public ProcessingResourceMetaData getProcessingResourceMetaData(Socket aSocket) throws SocketException {
        return null;
    }
}

