/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.jms.service;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.uima.UIMAFramework;
import org.apache.uima.adapter.jms.service.Dd2springException;
import org.apache.uima.util.Level;

public class Dd2spring {
    private static final Class<Dd2spring> THIS_CLASS = Dd2spring.class;
    private ClassLoader saxonClassLoader;
    private boolean testMode = false;

    public void setTestMode() {
        this.testMode = true;
    }

    public static void main(String[] args) throws Dd2springException {
        new Dd2spring().convertDd2Spring(args[0], args[1], args[2], args[3]);
    }

    public File convertDd2Spring(String ddFilePath, String dd2SpringXsltFilePath, String saxonClasspath, String uimaAsDebug) throws Dd2springException {
        File tempFile;
        URL urlForSaxonClassPath;
        try {
            urlForSaxonClassPath = new URL(saxonClasspath);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            UIMAFramework.getLogger(THIS_CLASS).logrb(Level.CONFIG, THIS_CLASS.getName(), "convertDD2Spring", "jms_adapter_messages", "UIMA_dd2spring_Cannot_convert_saxon_classpath_to_a_URL_SEVERE", new Object[]{saxonClasspath});
            return null;
        }
        try {
            tempFile = File.createTempFile("UIMAdd2springOutput", ".xml");
        }
        catch (IOException e) {
            e.printStackTrace();
            UIMAFramework.getLogger(THIS_CLASS).logrb(Level.CONFIG, THIS_CLASS.getName(), "convertDD2Spring", "jms_adapter_messages", "UIMA_dd2spring_cant_create_temp_output_file_SEVERE");
            return null;
        }
        String errData = this.convertDd2Spring(tempFile, ddFilePath, dd2SpringXsltFilePath, urlForSaxonClassPath);
        System.err.print(errData);
        if (null == uimaAsDebug || uimaAsDebug.equals("")) {
            tempFile.deleteOnExit();
        }
        if (errData.contains("*** ERROR: ")) {
            if (this.testMode) {
                System.out.println("DD2Spring transformation had one or more errors; the tempFile created was" + tempFile.getAbsolutePath());
            } else {
                throw new Dd2springException("DD2spring transformation had one or more errors; the tempFile created was" + tempFile.getAbsolutePath());
            }
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String convertDd2Spring(File tempFile, String ddFilePath, String dd2SpringXsltFilePath, URL saxonClasspathURL) {
        if (null == this.saxonClassLoader) {
            URL[] classLoaderUrls = new URL[]{saxonClasspathURL};
            this.saxonClassLoader = new URLClassLoader(classLoaderUrls, Object.class.getClassLoader());
        }
        Class<?> mainStartClass = null;
        try {
            try {
                mainStartClass = Class.forName("net.sf.saxon.Transform", true, this.saxonClassLoader);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Error - can't load Saxon jar from " + saxonClasspathURL + " for dd2spring transformation.");
                e.printStackTrace();
                UIMAFramework.getLogger(THIS_CLASS).logrb(Level.CONFIG, THIS_CLASS.getName(), "convertDD2Spring", "jms_adapter_messages", "UIMA_dd2spring_saxon_missing_SEVERE");
                return "";
            }
            ArrayList<String> argsForSaxon = new ArrayList<String>();
            String uimaFrameworkClass = System.getProperty("uima.framework_impl");
            if (uimaFrameworkClass != null) {
                String saxonParserClass = uimaFrameworkClass + "_SAXParser";
                try {
                    ClassLoader.getSystemClassLoader().loadClass(saxonParserClass);
                    argsForSaxon.add("-x");
                    argsForSaxon.add(saxonParserClass);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            argsForSaxon.add("-l");
            argsForSaxon.add("-s");
            argsForSaxon.add(ddFilePath);
            argsForSaxon.add("-o");
            argsForSaxon.add(tempFile.getAbsolutePath());
            argsForSaxon.add(dd2SpringXsltFilePath);
            UIMAFramework.getLogger(THIS_CLASS).log(Level.INFO, "Saxon args: " + argsForSaxon);
            Method mainMethod = null;
            try {
                mainMethod = mainStartClass.getMethod("main", String[].class);
            }
            catch (SecurityException e) {
                e.printStackTrace();
                UIMAFramework.getLogger(THIS_CLASS).logrb(Level.CONFIG, THIS_CLASS.getName(), "convertDD2Spring", "jms_adapter_messages", "UIMA_dd2spring_security_exception_calling_saxon");
                return "";
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                UIMAFramework.getLogger(THIS_CLASS).logrb(Level.CONFIG, THIS_CLASS.getName(), "convertDD2Spring", "jms_adapter_messages", "UIMA_dd2spring_internal_error_calling_saxon");
                return "";
            }
            PrintStream savedErr = System.err;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            try {
                System.setErr(ps);
                mainMethod.invoke(null, new Object[]{argsForSaxon.toArray(new String[argsForSaxon.size()])});
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                UIMAFramework.getLogger(THIS_CLASS).logrb(Level.CONFIG, THIS_CLASS.getName(), "convertDD2Spring", "jms_adapter_messages", "UIMA_dd2spring_internal_error_calling_saxon");
                ps.close();
                String string = baos.toString("UTF-8");
                return string;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                UIMAFramework.getLogger(THIS_CLASS).logrb(Level.CONFIG, THIS_CLASS.getName(), "convertDD2Spring", "jms_adapter_messages", "UIMA_dd2spring_internal_error_calling_saxon");
                ps.close();
                String string = baos.toString("UTF-8");
                return string;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                UIMAFramework.getLogger(THIS_CLASS).logrb(Level.CONFIG, THIS_CLASS.getName(), "convertDD2Spring", "jms_adapter_messages", "UIMA_dd2spring_internal_error_calling_saxon");
                ps.close();
                String string = baos.toString("UTF-8");
                return string;
            }
            finally {
                System.setErr(savedErr);
            }
            ps.close();
            return baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }
}

