/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.camel;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.uima.camel.UimaAsComponent;
import org.apache.uima.camel.UimaAsProducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UimaAsEndpoint
extends DefaultEndpoint<Exchange> {
    private String brokerAddress;
    private String queue;
    private Integer casPoolSize;
    private Integer timeout;

    public UimaAsEndpoint(String uri, String brokerAddress, UimaAsComponent component) {
        super(uri, (Component)component);
        this.brokerAddress = brokerAddress;
    }

    private Integer retrieveOptionIntegerParameter(Map options, String name) {
        Integer value = null;
        if (options.containsKey(name)) {
            String parameterValueString = (String)options.remove(name);
            try {
                value = Integer.parseInt(parameterValueString);
            }
            catch (NumberFormatException e) {
                System.out.println("Warning " + name + " is invalid, fallback to default!");
            }
        }
        return value;
    }

    public void configureProperties(Map options) {
        super.configureProperties(options);
        this.queue = (String)options.remove("queue");
        this.casPoolSize = this.retrieveOptionIntegerParameter(options, "CasPoolSize");
        if (this.casPoolSize != null && this.casPoolSize < 1) {
            System.out.println("Warning CasPoolSize must be larger than zero, fallback to default!");
            this.casPoolSize = null;
        }
        this.timeout = this.retrieveOptionIntegerParameter(options, "Timeout");
        if (this.timeout != null && this.timeout < 0) {
            System.out.println("Warning Timeout must be larger than zero, fallback to default!");
            this.timeout = null;
        }
    }

    public Consumer<Exchange> createConsumer(Processor arg0) throws Exception {
        return null;
    }

    public Producer<Exchange> createProducer() throws Exception {
        return new UimaAsProducer(this.brokerAddress, this.queue, this.casPoolSize, this.timeout, (Endpoint<Exchange>)this);
    }

    public boolean isSingleton() {
        return false;
    }
}

