/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.spring.util;

import org.apache.uima.analysis_component.AnalysisComponent;
import org.apache.uima.analysis_engine.impl.PrimitiveAnalysisEngine_impl;
import org.apache.uima.resource.Resource;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;

public class ResourceInitializationUtil {
    public static <T> T initializeBean(AutowireCapableBeanFactory aBeanFactory, T aBean, String aName) {
        Object wrappedBean = aBeanFactory.initializeBean(aBean, aName);
        aBeanFactory.autowireBean(aBean);
        return (T)wrappedBean;
    }

    public static Resource initResource(Resource aResource, ApplicationContext aApplicationContext) {
        AutowireCapableBeanFactory beanFactory = aApplicationContext.getAutowireCapableBeanFactory();
        if (aResource instanceof PrimitiveAnalysisEngine_impl) {
            ConfigurablePropertyAccessor pa = PropertyAccessorFactory.forDirectFieldAccess((Object)aResource);
            AnalysisComponent analysisComponent = (AnalysisComponent)pa.getPropertyValue("mAnalysisComponent");
            ResourceInitializationUtil.initializeBean(beanFactory, analysisComponent, aResource.getMetaData().getName());
            pa.setPropertyValue("mAnalysisComponent", (Object)analysisComponent);
            return aResource;
        }
        return (Resource)beanFactory.initializeBean((Object)aResource, aResource.getMetaData().getName());
    }
}

