/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.maven;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ExternalResource;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.factory.ConfigurationParameterFactory;
import org.apache.uima.fit.factory.ExternalResourceFactory;
import org.apache.uima.fit.factory.ResourceMetaDataFactory;
import org.apache.uima.fit.internal.EnhancedClassFile;
import org.apache.uima.fit.maven.util.Util;
import org.codehaus.plexus.util.FileUtils;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="enhance", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE)
public class EnhanceMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Component
    private BuildContext buildContext;
    private ClassLoader componentLoader;
    @Parameter(defaultValue="false", required=true)
    private boolean overrideComponentDescription;
    @Parameter(defaultValue="false", required=true)
    private boolean overrideComponentVersion;
    @Parameter(defaultValue="${project.version}", required=false)
    private String componentVersion;
    @Parameter(defaultValue="false", required=true)
    private boolean overrideComponentVendor;
    @Parameter(defaultValue="${project.organization.name}", required=false)
    private String componentVendor;
    @Parameter(defaultValue="false", required=true)
    private boolean overrideComponentCopyright;
    @Parameter(required=false)
    private String componentCopyright;
    @Parameter(defaultValue="${project.build.sourceEncoding}", required=true)
    private String encoding;
    @Parameter(defaultValue="true", required=true)
    private boolean generateMissingMetaDataReport;
    @Parameter(defaultValue="false", required=true)
    private boolean failOnMissingMetaData;
    @Parameter(required=false)
    private String[] parameterNameConstantPrefixes = new String[]{"PARAM_"};
    @Parameter(required=false)
    private String[] externalResourceNameConstantPrefixes = new String[]{"KEY_", "RES_"};
    private static final String MARK_CLASS = "Class:";
    private static final String MARK_NO_MISSING_META_DATA = "No missing meta data was found.";

    public void execute() throws MojoExecutionException, MojoFailureException {
        String[] files = FileUtils.getFilesFromExtension((String)this.project.getBuild().getOutputDirectory(), (String[])new String[]{"class"});
        this.componentLoader = Util.getClassloader(this.project, this.getLog());
        ClassPool classPool = new ClassPool(true);
        classPool.appendClassPath((ClassPath)new LoaderClassPath(this.componentLoader));
        LinkedHashMultimap reportData = LinkedHashMultimap.create();
        File reportFile = new File(this.project.getBuild().getDirectory(), "uimafit-missing-meta-data-report.txt");
        if (this.generateMissingMetaDataReport) {
            this.readMissingMetaDataReport(reportFile, (Multimap<String, String>)reportData);
        }
        ArrayList<String> examinedComponents = new ArrayList<String>();
        int countAlreadyEnhanced = 0;
        int countEnhanced = 0;
        for (String file : files) {
            CtClass ctClazz;
            Class<?> clazz;
            String clazzName;
            block16: {
                clazzName = Util.getClassName(this.project, file);
                try {
                    clazz = this.componentLoader.loadClass(clazzName);
                    if (clazz.getAnnotation(EnhancedClassFile.class) != null) {
                        ++countAlreadyEnhanced;
                        this.getLog().debug((CharSequence)("Class [" + clazzName + "] already enhanced"));
                        examinedComponents.add(clazzName);
                        continue;
                    }
                    if (!Util.isComponent(this.componentLoader, clazz)) {
                    }
                    break block16;
                }
                catch (ClassNotFoundException e) {
                    this.getLog().warn((CharSequence)("Cannot analyze class [" + clazzName + "]"), (Throwable)e);
                }
                continue;
            }
            examinedComponents.add(clazzName);
            reportData.removeAll((Object)clazzName);
            try {
                ctClazz = classPool.get(clazzName);
            }
            catch (NotFoundException e) {
                throw new MojoExecutionException("Class [" + clazzName + "] not found in class pool: " + ExceptionUtils.getRootCauseMessage((Throwable)e), (Exception)((Object)e));
            }
            String sourceFile = this.getSourceFile(clazzName);
            if (sourceFile != null) {
                ++countEnhanced;
                this.getLog().debug((CharSequence)("Enhancing class [" + clazzName + "]"));
                JavaSource ast = this.parseSource(sourceFile);
                this.enhanceResourceMetaData(ast, clazz, ctClazz, (Multimap<String, String>)reportData);
                this.enhanceConfigurationParameter(ast, clazz, ctClazz, (Multimap<String, String>)reportData);
                this.markAsEnhanced(ctClazz);
            } else {
                this.getLog().warn((CharSequence)("No source file found for class [" + clazzName + "]"));
            }
            try {
                if (ctClazz.isModified()) {
                    this.getLog().debug((CharSequence)("Writing enhanced class [" + clazzName + "]"));
                    ctClazz.toBytecode();
                    ctClazz.writeFile(this.project.getBuild().getOutputDirectory());
                    continue;
                }
                this.getLog().debug((CharSequence)("No changes to class [" + clazzName + "]"));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Enhanced class [" + clazzName + "] cannot be written: " + ExceptionUtils.getRootCauseMessage((Throwable)e), (Exception)e);
            }
            catch (CannotCompileException e) {
                throw new MojoExecutionException("Enhanced class [" + clazzName + "] cannot be compiled: " + ExceptionUtils.getRootCauseMessage((Throwable)e), (Exception)((Object)e));
            }
        }
        this.getLog().info((CharSequence)("Enhanced " + countEnhanced + " class" + (countEnhanced != 1 ? "es" : "") + " (" + countAlreadyEnhanced + " already enhanced)."));
        if (this.generateMissingMetaDataReport) {
            ArrayList deletedClasses = new ArrayList(reportData.keySet());
            deletedClasses.removeAll(examinedComponents);
            reportData.removeAll(deletedClasses);
            this.writeMissingMetaDataReport(reportFile, (Multimap<String, String>)reportData);
            if (this.failOnMissingMetaData && !reportData.isEmpty()) {
                throw new MojoFailureException("Component meta data missing. A report of the missing meta data can be found in " + reportFile);
            }
        }
    }

    private void markAsEnhanced(CtClass aCtClazz) {
        ClassFile classFile = aCtClazz.getClassFile();
        ConstPool constPool = classFile.getConstPool();
        AnnotationsAttribute annoAttr = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
        if (annoAttr == null) {
            annoAttr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        }
        Annotation a = new Annotation(EnhancedClassFile.class.getName(), constPool);
        annoAttr.addAnnotation(a);
        classFile.addAttribute((AttributeInfo)annoAttr);
    }

    private void enhanceResourceMetaData(JavaSource aAST, Class<?> aClazz, CtClass aCtClazz, Multimap<String, String> aReportData) {
        Annotation a;
        ClassFile classFile = aCtClazz.getClassFile();
        ConstPool constPool = classFile.getConstPool();
        AnnotationsAttribute annoAttr = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
        if (annoAttr == null) {
            annoAttr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        }
        if ((a = annoAttr.getAnnotation(ResourceMetaData.class.getName())) == null) {
            a = new Annotation(ResourceMetaData.class.getName(), constPool);
            a.addMemberValue("name", (MemberValue)new StringMemberValue(ResourceMetaDataFactory.getDefaultName(aClazz), constPool));
        }
        String doc = Util.getComponentDocumentation(aAST, aClazz.getName());
        this.enhanceMemberValue(a, "description", doc, this.overrideComponentDescription, ResourceMetaDataFactory.getDefaultDescription(aClazz), constPool, aReportData, aClazz);
        this.enhanceMemberValue(a, "version", this.componentVersion, this.overrideComponentVersion, ResourceMetaDataFactory.getDefaultVersion(aClazz), constPool, aReportData, aClazz);
        this.enhanceMemberValue(a, "vendor", this.componentVendor, this.overrideComponentVendor, ResourceMetaDataFactory.getDefaultVendor(aClazz), constPool, aReportData, aClazz);
        this.enhanceMemberValue(a, "copyright", this.componentCopyright, this.overrideComponentCopyright, ResourceMetaDataFactory.getDefaultCopyright(aClazz), constPool, aReportData, aClazz);
        annoAttr.addAnnotation(a);
        classFile.addAttribute((AttributeInfo)annoAttr);
    }

    private void enhanceMemberValue(Annotation aAnnotation, String aName, String aNewValue, boolean aOverride, String aDefault, ConstPool aConstPool, Multimap<String, String> aReportData, Class<?> aClazz) {
        String value = this.getStringMemberValue(aAnnotation, aName);
        boolean isEmpty = value.length() == 0;
        boolean isDefault = value.equals(aDefault);
        if (isEmpty || isDefault || aOverride) {
            if (aNewValue != null) {
                aAnnotation.addMemberValue(aName, (MemberValue)new StringMemberValue(aNewValue, aConstPool));
                this.getLog().debug((CharSequence)("Enhanced component meta data [" + aName + "]"));
            } else {
                this.getLog().debug((CharSequence)("No meta data [" + aName + "] found"));
                aReportData.put((Object)aClazz.getName(), (Object)("No meta data [" + aName + "] found"));
            }
        } else {
            this.getLog().debug((CharSequence)("Not overwriting component meta data [" + aName + "]"));
        }
    }

    private String getStringMemberValue(Annotation aAnnotation, String aValue) {
        MemberValue v = aAnnotation.getMemberValue(aValue);
        if (v == null) {
            return "";
        }
        return ((StringMemberValue)v).getValue();
    }

    private void enhanceConfigurationParameter(JavaSource aAST, Class<?> aClazz, CtClass aCtClazz, Multimap<String, String> aReportData) throws MojoExecutionException {
        Map<String, String> parameterNameFields = this.getParameterConstants(aClazz, this.parameterNameConstantPrefixes);
        Map<String, String> resourceNameFields = this.getParameterConstants(aClazz, this.externalResourceNameConstantPrefixes);
        for (Field field : aClazz.getDeclaredFields()) {
            String pdesc;
            String pname;
            String type;
            if (ConfigurationParameterFactory.isConfigurationParameterField((Field)field)) {
                type = "parameter";
                pname = ConfigurationParameterFactory.createPrimitiveParameter((Field)field).getName();
                pdesc = Util.getParameterDocumentation(aAST, field.getName(), parameterNameFields.get(pname));
            } else {
                if (!ExternalResourceFactory.isExternalResourceField((Field)field)) continue;
                type = "external resource";
                pname = ExternalResourceFactory.createExternalResourceDependency((Field)field).getKey();
                pdesc = Util.getParameterDocumentation(aAST, field.getName(), resourceNameFields.get(pname));
            }
            if (pdesc == null) {
                String msg = "No description found for " + type + " [" + pname + "]";
                this.getLog().debug((CharSequence)msg);
                aReportData.put((Object)aClazz.getName(), (Object)msg);
                continue;
            }
            try {
                CtField ctField = aCtClazz.getField(field.getName());
                AnnotationsAttribute annoAttr = (AnnotationsAttribute)ctField.getFieldInfo().getAttribute("RuntimeVisibleAnnotations");
                if (annoAttr != null) {
                    Annotation[] annotations;
                    for (Annotation a : annotations = annoAttr.getAnnotations()) {
                        if (!a.getTypeName().equals(ConfigurationParameter.class.getName()) && !a.getTypeName().equals(ExternalResource.class.getName()) && !a.getTypeName().equals("org.uimafit.descriptor.ConfigurationParameter") && !a.getTypeName().equals("org.uimafit.descriptor.ExternalResource")) continue;
                        if (a.getMemberValue("description") == null) {
                            a.addMemberValue("description", (MemberValue)new StringMemberValue(pdesc, aCtClazz.getClassFile().getConstPool()));
                            this.getLog().debug((CharSequence)("Enhanced description of " + type + " [" + pname + "]"));
                            annoAttr.addAnnotation(a);
                            continue;
                        }
                        this.getLog().debug((CharSequence)("Not overwriting description of " + type + " [" + pname + "] "));
                    }
                }
                ctField.getFieldInfo().addAttribute((AttributeInfo)annoAttr);
            }
            catch (NotFoundException e) {
                throw new MojoExecutionException("Field [" + field.getName() + "] not found in byte code: " + ExceptionUtils.getRootCauseMessage((Throwable)e), (Exception)((Object)e));
            }
        }
    }

    private Map<String, String> getParameterConstants(Class<?> aClazz, String[] aPrefixes) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Field f : aClazz.getFields()) {
            boolean hasPrefix = false;
            for (String prefix : aPrefixes) {
                if (!f.getName().startsWith(prefix)) continue;
                hasPrefix = true;
                break;
            }
            if (!hasPrefix) continue;
            try {
                String parameterName = (String)f.get(null);
                result.put(parameterName, f.getName());
            }
            catch (IllegalAccessException e) {
                this.getLog().warn((CharSequence)("Unable to access name constant field [" + f.getName() + "]: " + ExceptionUtils.getRootCauseMessage((Throwable)e)), (Throwable)e);
            }
        }
        return result;
    }

    private JavaSource parseSource(String aSourceFile) throws MojoExecutionException {
        try {
            return Util.parseSource(aSourceFile, this.encoding);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to parse source file [" + aSourceFile + "]: " + ExceptionUtils.getRootCauseMessage((Throwable)e), (Exception)e);
        }
    }

    private String getSourceFile(String aClassName) {
        String sourceName = aClassName.replace('.', '/') + ".java";
        for (String root : this.project.getCompileSourceRoots()) {
            File f = new File(root, sourceName);
            if (!f.exists()) continue;
            return f.getPath();
        }
        return null;
    }

    private void writeMissingMetaDataReport(File aReportFile, Multimap<String, String> aReportData) throws MojoExecutionException {
        PrintWriter out;
        block9: {
            Object[] classes = aReportData.keySet().toArray(new String[aReportData.keySet().size()]);
            Arrays.sort(classes);
            out = null;
            FileUtils.mkdir((String)aReportFile.getParent());
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(aReportFile), this.encoding));
                if (classes.length > 0) {
                    for (Object clazz : classes) {
                        out.printf("%s %s%n", MARK_CLASS, clazz);
                        Collection messages = aReportData.get(clazz);
                        if (messages.isEmpty()) {
                            out.printf("  No problems", new Object[0]);
                        } else {
                            for (String message : messages) {
                                out.printf("  %s%n", message);
                            }
                        }
                        out.printf("%n", new Object[0]);
                    }
                    break block9;
                }
                out.printf("%s%n", MARK_NO_MISSING_META_DATA);
            }
            catch (IOException e) {
                try {
                    throw new MojoExecutionException("Unable to write missing meta data report to [" + aReportFile + "]" + ExceptionUtils.getRootCauseMessage((Throwable)e), (Exception)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((Writer)out);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readMissingMetaDataReport(File aReportFile, Multimap<String, String> aReportData) throws MojoExecutionException {
        if (!aReportFile.exists()) {
            return;
        }
        LineIterator i = null;
        try {
            String clazz = null;
            i = IOUtils.lineIterator((InputStream)new FileInputStream(aReportFile), (String)this.encoding);
            while (i.hasNext()) {
                String line = i.next();
                if (!line.startsWith(MARK_NO_MISSING_META_DATA)) {
                    if (line.startsWith(MARK_CLASS)) {
                        clazz = line.substring(MARK_CLASS.length()).trim();
                        continue;
                    }
                    if (StringUtils.isBlank((String)line)) continue;
                    if (clazz == null) {
                        throw new MojoExecutionException("Missing meta data report has invalid format.");
                    }
                    aReportData.put((Object)clazz, (Object)line.trim());
                }
            }
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Unable to read missing meta data report: " + ExceptionUtils.getRootCauseMessage((Throwable)e), (Exception)e);
            }
            catch (Throwable throwable) {
                LineIterator.closeQuietly(i);
                throw throwable;
            }
        }
        LineIterator.closeQuietly((LineIterator)i);
        return;
        LineIterator.closeQuietly((LineIterator)i);
    }
}

