/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.maven.util.Util;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.codehaus.plexus.util.FileUtils;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.xml.sax.SAXException;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE)
public class GenerateDescriptorsMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Component
    private BuildContext buildContext;
    private ClassLoader componentLoader;
    @Parameter(defaultValue="${project.build.directory}/classes", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="false", required=true)
    private boolean skipComponentsManifest;
    @Parameter(defaultValue="${project.build.sourceEncoding}", required=true)
    private String encoding;

    public void execute() throws MojoExecutionException {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
            this.buildContext.refresh(this.outputDirectory);
        }
        String[] files = FileUtils.getFilesFromExtension((String)this.project.getBuild().getOutputDirectory(), (String[])new String[]{"class"});
        this.componentLoader = Util.getClassloader(this.project, this.getLog());
        StringBuilder componentsManifest = new StringBuilder();
        int countGenerated = 0;
        for (String file : files) {
            String base = file.substring(0, file.length() - 6);
            String clazzPath = base.substring(this.project.getBuild().getOutputDirectory().length() + 1);
            String clazzName = clazzPath.replace(File.separator, ".");
            try {
                Class<?> clazz = this.componentLoader.loadClass(clazzName);
                if (Modifier.isAbstract(clazz.getModifiers())) continue;
                AnalysisEngineDescription desc = null;
                switch (Util.getType(this.componentLoader, clazz)) {
                    case ANALYSIS_ENGINE: {
                        desc = AnalysisEngineFactory.createEngineDescription(clazz, (Object[])new Object[0]);
                        break;
                    }
                    case COLLECTION_READER: {
                        desc = CollectionReaderFactory.createReaderDescription(clazz, (Object[])new Object[0]);
                    }
                }
                if (desc == null) continue;
                File out = new File(this.outputDirectory, clazzPath + ".xml");
                out.getParentFile().mkdirs();
                this.toXML((ResourceSpecifier)desc, out.getPath());
                ++countGenerated;
                componentsManifest.append("classpath*:").append(clazzPath + ".xml").append('\n');
            }
            catch (SAXException e) {
                this.getLog().warn((CharSequence)("Cannot serialize descriptor for [" + clazzName + "]"), (Throwable)e);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Cannot write descriptor for [" + clazzName + "]"), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                this.getLog().warn((CharSequence)("Cannot analyze class [" + clazzName + "]"), (Throwable)e);
            }
            catch (ResourceInitializationException e) {
                this.getLog().warn((CharSequence)("Cannot generate descriptor for [" + clazzName + "]"), (Throwable)e);
            }
        }
        this.getLog().info((CharSequence)("Generated " + countGenerated + " descriptor" + (countGenerated != 1 ? "s." : ".")));
        if (!this.skipComponentsManifest && componentsManifest.length() > 0) {
            File path = new File(this.outputDirectory, "META-INF/org.apache.uima.fit/components.txt");
            FileUtils.mkdir((String)path.getParent());
            try {
                FileUtils.fileWrite((String)path.getPath(), (String)this.encoding, (String)componentsManifest.toString());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write components manifest to [" + path + "]" + ExceptionUtils.getRootCauseMessage((Throwable)e), (Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toXML(ResourceSpecifier aDesc, String aFilename) throws SAXException, IOException {
        FileOutputStream os = null;
        try {
            File out = new File(aFilename);
            this.getLog().debug((CharSequence)("Writing descriptor to: " + out));
            os = new FileOutputStream(out);
            aDesc.toXML((OutputStream)os);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)os);
    }
}

